/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.EndTag;
import org.jnbt.FloatTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.LongTag;
import org.jnbt.NBTUtils;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;

public final class NBTInputStream
implements Closeable {
    private final DataInput is;

    public NBTInputStream(InputStream is) {
        if (is == null) {
            throw new NullPointerException("is");
        }
        this.is = is instanceof DataInput ? (DataInput)((Object)is) : new DataInputStream(is);
    }

    public NBTInputStream(InputStream is, boolean littleEndian) {
        if (is == null) {
            throw new NullPointerException("is");
        }
        this.is = littleEndian ? new LittleEndianDataInputStream(is) : new DataInputStream(is);
    }

    public Tag readTag() throws IOException {
        return this.readTag(0);
    }

    private Tag readTag(int depth) throws IOException {
        String name;
        int type = this.is.readByte() & 0xFF;
        if (type != 0) {
            int nameLength = this.is.readShort() & 0xFFFF;
            byte[] nameBytes = new byte[nameLength];
            this.is.readFully(nameBytes);
            name = new String(nameBytes, "UTF-8");
        } else {
            name = "";
        }
        return this.readTagPayload(type, name, depth);
    }

    private Tag readTagPayload(int type, String name, int depth) throws IOException {
        switch (type) {
            case 0: {
                return new EndTag();
            }
            case 1: {
                return new ByteTag(name, this.is.readByte());
            }
            case 2: {
                return new ShortTag(name, this.is.readShort());
            }
            case 3: {
                return new IntTag(name, this.is.readInt());
            }
            case 4: {
                return new LongTag(name, this.is.readLong());
            }
            case 5: {
                return new FloatTag(name, this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(name, this.is.readDouble());
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new ByteArrayTag(name, bytes);
            }
            case 8: {
                short length = this.is.readShort();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new StringTag(name, new String(bytes, "UTF-8"));
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.is.readInt();
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                for (int i = 0; i < length; ++i) {
                    Tag tag = this.readTagPayload(childType, "", depth + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    tagList.add(tag);
                }
                return new ListTag<Tag>(name, NBTUtils.getTypeClass(childType), tagList);
            }
            case 10: {
                Tag tag;
                HashMap<String, Tag> tagMap = new HashMap<String, Tag>();
                while (!((tag = this.readTag(depth + 1)) instanceof EndTag)) {
                    tagMap.put(tag.getName(), tag);
                }
                return new CompoundTag(name, tagMap);
            }
            case 11: {
                int length = this.is.readInt();
                int[] values = new int[length];
                for (int i = 0; i < length; ++i) {
                    values[i] = this.is.readInt();
                }
                return new IntArrayTag(name, values);
            }
            case 12: {
                int length = this.is.readInt();
                long[] longs = new long[length];
                for (int i = 0; i < length; ++i) {
                    longs[i] = this.is.readLong();
                }
                return new LongArrayTag(name, longs);
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    @Override
    public void close() throws IOException {
        ((InputStream)((Object)this.is)).close();
    }
}

