/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;

public final class LayoutUtils {
    private LayoutUtils() {
    }

    public static void addRowOfComponents(Container container, GridBagConstraints constraints, Collection<? extends Component> components) {
        Iterator<? extends Component> i = components.iterator();
        while (i.hasNext()) {
            Component component = i.next();
            if (i.hasNext()) {
                constraints.gridwidth = 1;
                constraints.weightx = 0.0;
            } else {
                constraints.gridwidth = 0;
                constraints.weightx = 1.0;
            }
            container.add(component, constraints);
        }
    }

    public static void insertRowOfComponents(Container container, GridBagConstraints constraints, int index, Collection<? extends Component> components) {
        Iterator<? extends Component> i = components.iterator();
        while (i.hasNext()) {
            Component component = i.next();
            if (i.hasNext()) {
                constraints.gridwidth = 1;
                constraints.weightx = 0.0;
            } else {
                constraints.gridwidth = 0;
                constraints.weightx = 1.0;
            }
            container.add(component, constraints, index++);
        }
    }

    public static void setDefaultSizeAndLocation(Window window, int percentageOfScreen) {
        Window parent = window.getOwner();
        if (parent != null) {
            DisplayMode displayMode = parent.getGraphicsConfiguration().getDevice().getDisplayMode();
            window.setSize(Math.max(window.getWidth(), displayMode.getWidth() * percentageOfScreen / 100), Math.max(window.getHeight(), displayMode.getHeight() * percentageOfScreen / 100));
            window.setLocationRelativeTo(parent);
        } else {
            DisplayMode displayMode = window.getGraphicsConfiguration().getDevice().getDisplayMode();
            window.setSize(Math.max(window.getWidth(), displayMode.getWidth() * percentageOfScreen / 100), Math.max(window.getHeight(), displayMode.getHeight() * percentageOfScreen / 100));
            window.setLocationRelativeTo(null);
        }
    }
}

