/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;

public final class Eyedropper
extends MouseOrTabletOperation {
    private final ColourScheme colourScheme;
    private final CustomBiomeManager customBiomeManager;
    private SelectionListener callback;
    private Set<PaintType> paintTypes;
    private JPopupMenu popupMenu;

    public Eyedropper(WorldPainterView view, ColourScheme colourScheme, CustomBiomeManager customBiomeManager) {
        super("Eyedropper", "Select a paint from the map", view, "operation.eyedropper");
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
    }

    public SelectionListener getCallback() {
        return this.callback;
    }

    public void setCallback(SelectionListener callback) {
        this.callback = callback;
    }

    public Set<PaintType> getPaintTypes() {
        return this.paintTypes;
    }

    public void setPaintTypes(Set<PaintType> paintTypes) {
        this.paintTypes = paintTypes;
    }

    @Override
    protected void tick(int x, int y, boolean inverse, boolean first, float dynamicLevel) {
        Map layers;
        if (!first) {
            throw new InternalError("Should never happen");
        }
        Dimension dimension = this.getDimension();
        if (dimension.getBitLayerValueAt((Layer)NotPresent.INSTANCE, x, y)) {
            DesktopUtils.beep();
            return;
        }
        final Terrain terrain = this.paintTypes == null || this.paintTypes.contains((Object)PaintType.TERRAIN) ? dimension.getTerrainAt(x, y) : null;
        Map map = layers = this.paintTypes == null || this.paintTypes.contains((Object)PaintType.LAYER) || this.paintTypes.contains((Object)PaintType.BIOME) || this.paintTypes.contains((Object)PaintType.ANNOTATION) ? dimension.getLayersAt(x, y) : null;
        if (terrain == null && layers == null) {
            DesktopUtils.beep();
        } else {
            this.popupMenu = new JPopupMenu();
            if (terrain != null) {
                this.popupMenu.add(new AbstractAction(terrain.getName(), new ImageIcon(terrain.getScaledIcon(16, this.colourScheme))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Eyedropper.this.callback.terrainSelected(terrain);
                    }
                });
            }
            if (layers != null) {
                BiomeHelper biomeHelper = new BiomeHelper(this.colourScheme, this.customBiomeManager, dimension.getWorld().getPlatform());
                layers.forEach((layer, value) -> {
                    Icon icon;
                    String name;
                    if (layer instanceof Biome) {
                        if (this.paintTypes != null && !this.paintTypes.contains((Object)PaintType.BIOME)) {
                            return;
                        }
                        name = biomeHelper.getBiomeName((int)value);
                        icon = biomeHelper.getBiomeIcon((int)value);
                    } else if (layer instanceof Annotations) {
                        if (this.paintTypes != null && !this.paintTypes.contains((Object)PaintType.ANNOTATION)) {
                            return;
                        }
                        int colourIndex = value - (value < 8 ? 1 : 0);
                        name = org.pepsoft.minecraft.Constants.COLOUR_NAMES[colourIndex] + " Annotations";
                        icon = IconUtils.createScaledColourIcon((int)this.colourScheme.getColour(Material.WOOLS[colourIndex]));
                    } else {
                        if (Constants.SYSTEM_LAYERS.contains(layer)) {
                            return;
                        }
                        if (!layer.discrete || layer instanceof ReadOnly) {
                            if (this.paintTypes != null && !this.paintTypes.contains((Object)PaintType.LAYER)) {
                                return;
                            }
                            name = layer.getName();
                            icon = new ImageIcon(IconUtils.scaleIcon((Image)layer.getIcon(), (int)16));
                        } else {
                            throw new UnsupportedOperationException("Discrete layer " + layer + " not supported");
                        }
                    }
                    this.popupMenu.add(new AbstractAction(name, icon, (Layer)layer, (Integer)value){
                        final /* synthetic */ Layer val$layer;
                        final /* synthetic */ Integer val$value;
                        {
                            this.val$layer = layer;
                            this.val$value = n;
                            super(x0, x1);
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Eyedropper.this.callback.layerSelected(this.val$layer, this.val$value);
                        }
                    });
                });
            }
            if (this.popupMenu.getComponentCount() == 0) {
                DesktopUtils.beep();
                return;
            }
            WorldPainterView view = this.getView();
            Point menuCoords = view.worldToView(x, y);
            this.popupMenu.show((Component)view, menuCoords.x, menuCoords.y);
        }
    }

    @Override
    protected void deactivate() {
        if (this.popupMenu != null && this.popupMenu.isShowing()) {
            this.popupMenu.setVisible(false);
            this.popupMenu = null;
        }
        super.deactivate();
    }

    public static interface SelectionListener {
        public void terrainSelected(Terrain var1);

        public void layerSelected(Layer var1, int var2);

        public void selectionCancelled(boolean var1);
    }

    public static enum PaintType {
        TERRAIN,
        LAYER,
        BIOME,
        ANNOTATION;

    }
}

