/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.HeightFilter;

public class LayerRangesTableModel
implements TableModel {
    private final List<Filter> filters = new ArrayList<Filter>();
    private final List<Layer> layers = new ArrayList<Layer>();
    private final int minHeight;
    private final int maxHeight;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final JButton deleteButton = new JButton("Delete");
    private static final String[] COLUMN_NAMES = new String[]{"From", "To", "Feather", "Layer", "Actions"};
    private static final Class[] COLUMN_TYPES = new Class[]{Integer.class, Integer.class, Boolean.class, Layer.class, JButton.class};
    private static final int COLUMN_FROM = 0;
    private static final int COLUMN_TO = 1;
    private static final int COLUMN_FEATHER = 2;
    private static final int COLUMN_LAYER = 3;
    private static final int COLUMN_ACTIONS = 4;

    public LayerRangesTableModel(int minHeight, int maxHeight, Map<Filter, Layer> layerMap) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        if (layerMap != null) {
            layerMap.forEach((key, value) -> {
                this.filters.add((Filter)key);
                this.layers.add((Layer)value);
            });
        }
    }

    public Map<Filter, Layer> getLayerMap() {
        if (!this.layers.isEmpty()) {
            HashMap<Filter, Layer> layerMap = new HashMap<Filter, Layer>();
            Iterator<Filter> filterIterator = this.filters.iterator();
            for (Layer layer : this.layers) {
                Filter filter = filterIterator.next();
                layerMap.put(filter, layer);
            }
            return layerMap;
        }
        return null;
    }

    public void addRow(Filter filter, Layer layer) {
        this.filters.add(filter);
        this.layers.add(layer);
        int index = this.filters.size() - 1;
        TableModelEvent event = new TableModelEvent(this, index, index, -1, 1);
        this.listeners.forEach(listener -> listener.tableChanged(event));
    }

    public void deleteRow(int row) {
        this.layers.remove(row);
        this.filters.remove(row);
        TableModelEvent event = new TableModelEvent(this, row, row, -1, -1);
        this.listeners.forEach(listener -> listener.tableChanged(event));
    }

    @Override
    public int getRowCount() {
        return this.filters.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((HeightFilter)this.filters.get(rowIndex)).getStartHeight();
            }
            case 1: {
                return ((HeightFilter)this.filters.get(rowIndex)).getStopHeight();
            }
            case 2: {
                return ((HeightFilter)this.filters.get(rowIndex)).isFeather();
            }
            case 3: {
                return this.layers.get(rowIndex);
            }
            case 4: {
                return this.deleteButton;
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                HeightFilter old = (HeightFilter)this.filters.get(rowIndex);
                this.filters.set(rowIndex, (Filter)new HeightFilter(this.minHeight, this.maxHeight, ((Integer)aValue).intValue(), old.getStopHeight(), old.isFeather()));
                break;
            }
            case 1: {
                HeightFilter old = (HeightFilter)this.filters.get(rowIndex);
                this.filters.set(rowIndex, (Filter)new HeightFilter(this.minHeight, this.maxHeight, old.getStartHeight(), ((Integer)aValue).intValue(), old.isFeather()));
                break;
            }
            case 2: {
                HeightFilter old = (HeightFilter)this.filters.get(rowIndex);
                this.filters.set(rowIndex, (Filter)new HeightFilter(this.minHeight, this.maxHeight, old.getStartHeight(), old.getStopHeight(), ((Boolean)aValue).booleanValue()));
                break;
            }
            case 3: {
                throw new IllegalArgumentException("columnIndex " + columnIndex + " not editable");
            }
            case 4: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

