/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.simple;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;

public class AddTerrainRangeDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonOK;
    private JComboBox comboBoxTerrainType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner spinnerLevel;
    private final ColourScheme colourScheme;
    private final boolean allowCustomTerrain;
    private static final long serialVersionUID = 1L;

    public AddTerrainRangeDialog(Window parent, int minHeight, int maxHeight, ColourScheme colourScheme, boolean allowCustomTerrain) {
        super(parent);
        this.colourScheme = colourScheme;
        this.allowCustomTerrain = allowCustomTerrain;
        this.initComponents();
        this.spinnerLevel.setModel(new SpinnerNumberModel((minHeight + maxHeight) / 2, minHeight + 1, maxHeight - 1, 1));
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public int getSelectedLevel() {
        return ((Number)this.spinnerLevel.getValue()).intValue();
    }

    public Terrain getSelectedTerrain() {
        return (Terrain)this.comboBoxTerrainType.getSelectedItem();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.spinnerLevel = new JSpinner();
        this.jLabel3 = new JLabel();
        this.comboBoxTerrainType = new JComboBox();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Add Terrain Mapping");
        this.jLabel1.setText("Select a level and a terrain type to add to the mapping:");
        this.jLabel2.setLabelFor(this.spinnerLevel);
        this.jLabel2.setText("Level:");
        this.jLabel3.setLabelFor(this.comboBoxTerrainType);
        this.jLabel3.setText("Terrain type:");
        this.comboBoxTerrainType.setModel(new DefaultComboBoxModel<Terrain>(this.allowCustomTerrain ? Terrain.getConfiguredValues() : Terrain.PICK_LIST));
        this.comboBoxTerrainType.setSelectedItem(Terrain.DIRT);
        this.comboBoxTerrainType.setRenderer(new TerrainListCellRenderer(this.colourScheme));
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddTerrainRangeDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddTerrainRangeDialog.this.buttonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerLevel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxTerrainType, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.spinnerLevel, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.comboBoxTerrainType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }
}

