/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.panels;

import com.google.common.collect.ImmutableSet;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.GardenCategory;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerTableCellRenderer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.selection.SelectionBlock;
import org.pepsoft.worldpainter.selection.SelectionChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
extends JPanel
implements MouseMotionListener {
    private JCheckBox checkBoxAutomaticBiome;
    private JCheckBox checkBoxInSelection;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JLabel labelBiome;
    private JLabel labelCoords;
    private JLabel labelFluidType;
    private JLabel labelHeight;
    private JLabel labelSlope;
    private JLabel labelTerrain;
    private JLabel labelWaterDepth;
    private JLabel labelWaterLevel;
    private final WorldPainter view;
    private final CustomBiomeManager customBiomeManager;
    private final LayerTableModel tableModel;
    private final NumberFormat heightFormatter;
    private BiomeHelper biomeHelper;
    private Point worldCoords;
    private boolean fieldsClear = true;
    private boolean currentAutomaticBiome;
    private boolean active;
    private Terrain currentTerrain;
    private int currentBiome;
    private static final Set<Layer> HIDDEN_LAYERS = ImmutableSet.builder().addAll((Iterable)Constants.SYSTEM_LAYERS).add((Object)Biome.INSTANCE).build();
    private static final Icon ICON_BLANK = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/transparent.png");
    private static final Logger logger = LoggerFactory.getLogger(InfoPanel.class);

    public InfoPanel(WorldPainter view, CustomBiomeManager customBiomeManager) {
        this.view = view;
        this.customBiomeManager = customBiomeManager;
        this.tableModel = new LayerTableModel();
        this.heightFormatter = NumberFormat.getInstance();
        this.heightFormatter.setMaximumFractionDigits(3);
        this.initComponents();
        this.jTable1.setModel(this.tableModel);
        this.jTable1.setDefaultRenderer(Layer.class, new LayerTableCellRenderer());
        this.jTable1.setDefaultRenderer(LayerTableModel.InfoRow.class, new InfoRowTableCellRenderer(this.biomeHelper));
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(25);
        this.addHierarchyListener(e -> {
            if (this.isShowing()) {
                this.activate();
            } else {
                this.deactivate();
            }
        });
    }

    public void setPlatform(Platform platform) {
        this.biomeHelper = new BiomeHelper(this.view.getColourScheme(), this.customBiomeManager, platform);
        this.updateInfo();
    }

    void updateInfo() {
        Map layerValues;
        if (this.worldCoords == null) {
            return;
        }
        Dimension dim = this.view.getDimension();
        if (dim == null) {
            this.clearFields();
            return;
        }
        float scale = dim.getScale();
        this.setTextIfDifferent(this.labelCoords, App.INT_NUMBER_FORMAT.format(Math.round((float)this.worldCoords.x * scale)) + ", " + App.INT_NUMBER_FORMAT.format(Math.round((float)this.worldCoords.y * scale)));
        Tile tile = dim.getTile(this.worldCoords.x >> 7, this.worldCoords.y >> 7);
        if (tile == null) {
            this.clearFields();
            return;
        }
        int x = this.worldCoords.x & 0x7F;
        int y = this.worldCoords.y & 0x7F;
        if (tile.getBitLayerValue((Layer)NotPresent.INSTANCE, x, y) || tile.getBitLayerValue((Layer)NotPresentBlock.INSTANCE, x, y)) {
            this.clearFields();
            return;
        }
        this.fieldsClear = false;
        float height = tile.getHeight(x, y);
        this.setTextIfDifferent(this.labelHeight, this.heightFormatter.format(height));
        int intHeight = Math.round(height);
        int waterLevel = tile.getWaterLevel(x, y);
        this.setTextIfDifferent(this.labelWaterLevel, Integer.toString(waterLevel));
        if (waterLevel > intHeight) {
            this.setTextIfDifferent(this.labelWaterDepth, Integer.toString(waterLevel - intHeight));
        } else {
            this.setTextIfDifferent(this.labelWaterDepth, null);
        }
        float slope = x > 0 && x < 127 && y > 0 && y < 127 ? tile.getSlope(x, y) : dim.getSlope(this.worldCoords.x, this.worldCoords.y);
        this.setTextIfDifferent(this.labelSlope, (int)Math.round(Math.atan(slope) * 180.0 / Math.PI) + "\u00b0");
        Terrain terrain = tile.getTerrain(x, y);
        if (terrain != this.currentTerrain) {
            this.labelTerrain.setText(terrain.getName());
            this.labelTerrain.setIcon(new ImageIcon(terrain.getScaledIcon(16, this.view.getColourScheme())));
            this.currentTerrain = terrain;
        }
        int biome = tile.getLayerValue((Layer)Biome.INSTANCE, x, y);
        boolean automaticBiome = false;
        if (biome == 255) {
            automaticBiome = true;
            biome = dim.getAutoBiome(tile, x, y);
        }
        if (biome < 0) {
            biome = 1;
        }
        if (automaticBiome != this.currentAutomaticBiome || biome != this.currentBiome) {
            if (this.biomeHelper != null) {
                this.labelBiome.setText(this.biomeHelper.getBiomeName(biome));
                this.labelBiome.setIcon(this.biomeHelper.getBiomeIcon(biome));
            }
            this.checkBoxAutomaticBiome.setSelected(automaticBiome);
            this.currentAutomaticBiome = automaticBiome;
            this.currentBiome = biome;
        }
        if ((layerValues = tile.getLayersAt(x, y)) != null) {
            this.checkBoxInSelection.setSelected(layerValues.containsKey(SelectionChunk.INSTANCE) || layerValues.containsKey(SelectionBlock.INSTANCE));
            layerValues.keySet().removeAll(HIDDEN_LAYERS);
            if (!layerValues.isEmpty()) {
                this.tableModel.update(layerValues);
            } else {
                this.tableModel.clear();
            }
        } else {
            this.checkBoxInSelection.setSelected(false);
            this.tableModel.clear();
        }
    }

    private void activate() {
        if (!this.active) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activating info panel");
            }
            this.view.addMouseMotionListener(this);
            this.active = true;
        }
    }

    private void deactivate() {
        if (this.active) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deactivating info panel");
            }
            this.view.removeMouseMotionListener(this);
            this.active = false;
        }
    }

    private void clearFields() {
        if (!this.fieldsClear) {
            this.labelHeight.setText(null);
            this.labelWaterLevel.setText(null);
            this.labelWaterDepth.setText(null);
            this.labelSlope.setText(null);
            this.tableModel.clear();
            this.labelTerrain.setIcon(ICON_BLANK);
            this.labelTerrain.setText(null);
            this.currentTerrain = null;
            this.labelBiome.setIcon(ICON_BLANK);
            this.labelBiome.setText(null);
            this.checkBoxAutomaticBiome.setSelected(false);
            this.currentAutomaticBiome = false;
            this.currentBiome = -2;
            this.fieldsClear = true;
        }
    }

    private void setTextIfDifferent(JLabel label, String text) {
        if (text == null ? label.getText() != null : !text.equals(label.getText())) {
            label.setText(text);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.worldCoords = this.view.viewToWorld(e.getX(), e.getY());
        this.updateInfo();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.labelSlope = new JLabel();
        this.jLabel5 = new JLabel();
        this.labelCoords = new JLabel();
        this.jLabel7 = new JLabel();
        this.labelHeight = new JLabel();
        this.jLabel10 = new JLabel();
        this.labelFluidType = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.labelWaterLevel = new JLabel();
        this.jLabel15 = new JLabel();
        this.labelWaterDepth = new JLabel();
        this.jLabel17 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel3 = new JLabel();
        this.labelTerrain = new JLabel();
        this.jLabel6 = new JLabel();
        this.labelBiome = new JLabel();
        this.checkBoxAutomaticBiome = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.checkBoxInSelection = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel1.setText("Slope:");
        this.jLabel2.setText("Layers:");
        this.labelSlope.setText(" ");
        this.jLabel5.setText("Coordinates:");
        this.labelCoords.setText(" ");
        this.jLabel7.setText("Height:");
        this.labelHeight.setText(" ");
        this.jLabel10.setText("m");
        this.labelFluidType.setText("Fluid");
        this.jLabel12.setText("level:");
        this.jLabel13.setText("depth:");
        this.labelWaterLevel.setText(" ");
        this.jLabel15.setText("m");
        this.labelWaterDepth.setText(" ");
        this.jLabel17.setText("m");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jLabel3.setText("Terrain:");
        this.labelTerrain.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/transparent.png")));
        this.labelTerrain.setText(" ");
        this.jLabel6.setText("Biome:");
        this.labelBiome.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/transparent.png")));
        this.labelBiome.setText(" ");
        this.checkBoxAutomaticBiome.setText(" ");
        this.checkBoxAutomaticBiome.setEnabled(false);
        this.jLabel9.setText(" ");
        this.checkBoxInSelection.setText(" ");
        this.checkBoxInSelection.setEnabled(false);
        this.checkBoxInSelection.setHorizontalTextPosition(10);
        this.jLabel4.setText("In selection:");
        this.jLabel8.setText("automatic");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelFluidType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel12))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel1).addComponent(this.jLabel7).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelCoords).addComponent(this.labelSlope).addGroup(layout.createSequentialGroup().addComponent(this.labelHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)).addGroup(layout.createSequentialGroup().addComponent(this.labelWaterLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15)).addGroup(layout.createSequentialGroup().addComponent(this.labelWaterDepth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17)))).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9)).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxAutomaticBiome).addGap(0, 0, 0).addComponent(this.jLabel8)).addComponent(this.labelTerrain).addComponent(this.labelBiome).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, 0).addComponent(this.checkBoxInSelection))).addGap(0, 53, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.labelCoords)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.labelHeight).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelSlope)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFluidType).addComponent(this.jLabel12).addComponent(this.labelWaterLevel).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.labelWaterDepth).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelTerrain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelBiome).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxAutomaticBiome).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxInSelection).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 119, Short.MAX_VALUE)));
    }

    static class InfoRowTableCellRenderer
    extends DefaultTableCellRenderer {
        private final BiomeHelper biomeHelper;
        private static final ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");

        InfoRowTableCellRenderer(BiomeHelper biomeHelper) {
            this.biomeHelper = biomeHelper;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            LayerTableModel.InfoRow infoRow = (LayerTableModel.InfoRow)value;
            this.setText(this.getIntensity(infoRow.layer, infoRow.intensity));
            return this;
        }

        private String getIntensity(Layer layer, int intensity) {
            if (layer instanceof Biome) {
                return this.biomeHelper.getBiomeName(intensity);
            }
            if (layer instanceof Annotations) {
                return org.pepsoft.minecraft.Constants.COLOUR_NAMES[intensity - (intensity < 8 ? 1 : 0)];
            }
            if (layer instanceof GardenCategory) {
                return GardenCategory.getLabel((ResourceBundle)strings, (int)intensity);
            }
            return layer.getDataSize().toString(intensity);
        }
    }

    static class LayerTableModel
    implements TableModel {
        private final List<InfoRow> rows = new ArrayList<InfoRow>();
        private final Map<Layer, Integer> layerIndices = new HashMap<Layer, Integer>();
        private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        private static final String[] COLUMN_NAMES = new String[]{"Layer", "Intensity"};

        LayerTableModel() {
        }

        boolean update(Map<Layer, Integer> intensities) {
            boolean changed;
            block10: {
                block9: {
                    changed = false;
                    if (!this.rows.isEmpty()) break block9;
                    int index = 0;
                    for (Map.Entry<Layer, Integer> entry : intensities.entrySet()) {
                        Layer layer = entry.getKey();
                        this.rows.add(new InfoRow(layer, entry.getValue()));
                        this.layerIndices.put(layer, index++);
                        TableModelEvent event = new TableModelEvent(this);
                        for (TableModelListener listener : this.listeners) {
                            listener.tableChanged(event);
                        }
                        changed = true;
                    }
                    break block10;
                }
                if (intensities.isEmpty()) break block10;
                HashSet<Layer> oldLayers = new HashSet<Layer>(this.layerIndices.keySet());
                for (Map.Entry<Layer, Integer> entry : intensities.entrySet()) {
                    int index;
                    Layer layer = entry.getKey();
                    int intensity = entry.getValue();
                    if (this.layerIndices.containsKey(layer)) {
                        index = this.layerIndices.get(layer);
                        InfoRow row = this.rows.get(index);
                        if (intensity == row.intensity) continue;
                        row.intensity = intensity;
                        TableModelEvent event = new TableModelEvent(this, index, index, 1);
                        for (TableModelListener listener : this.listeners) {
                            listener.tableChanged(event);
                        }
                        continue;
                    }
                    index = this.rows.size();
                    this.rows.add(new InfoRow(layer, intensity));
                    this.layerIndices.put(layer, index);
                    TableModelEvent event = new TableModelEvent(this, index, index, -1, 1);
                    for (TableModelListener listener : this.listeners) {
                        listener.tableChanged(event);
                    }
                    changed = true;
                }
                oldLayers.removeAll(intensities.keySet());
                for (Layer oldLayer : oldLayers) {
                    int index = this.layerIndices.remove(oldLayer);
                    for (Map.Entry<Layer, Integer> entry : this.layerIndices.entrySet()) {
                        if (entry.getValue() <= index) continue;
                        entry.setValue(entry.getValue() - 1);
                    }
                    this.rows.remove(index);
                    TableModelEvent event = new TableModelEvent(this, index, index, -1, -1);
                    for (TableModelListener listener : this.listeners) {
                        listener.tableChanged(event);
                    }
                    changed = true;
                }
            }
            return changed;
        }

        boolean clear() {
            if (!this.rows.isEmpty()) {
                this.rows.clear();
                this.layerIndices.clear();
                TableModelEvent event = new TableModelEvent(this);
                for (TableModelListener listener : this.listeners) {
                    listener.tableChanged(event);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Layer.class;
                }
                case 1: {
                    return InfoRow.class;
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(columnIndex));
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            InfoRow row = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.layer;
                }
                case 1: {
                    return row;
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(columnIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        static class InfoRow {
            Layer layer;
            int intensity;

            InfoRow(Layer layer, int intensity) {
                this.layer = layer;
                this.intensity = intensity;
            }
        }
    }
}

