/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.painting.LayerPaint;

public final class DiscreteLayerPaint
extends LayerPaint {
    private final int value;
    private final int defaultValue;

    public DiscreteLayerPaint(Layer layer, int value) {
        super(layer);
        if (layer.getDataSize() != Layer.DataSize.NIBBLE && layer.getDataSize() != Layer.DataSize.BYTE) {
            throw new IllegalArgumentException("Layer " + layer + " not a continuous layer");
        }
        this.value = value;
        this.defaultValue = layer.getDefaultValue();
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String getId() {
        return super.getId() + '/' + this.value;
    }

    @Override
    public void apply(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        if (this.brush.getRadius() == 0) {
            this.applyPixel(dimension, centreX, centreY);
            return;
        }
        int effectiveRadius = this.brush.getEffectiveRadius();
        int x1 = centreX - effectiveRadius;
        int y1 = centreY - effectiveRadius;
        int x2 = centreX + effectiveRadius;
        int y2 = centreY + effectiveRadius;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            if (this.dither) {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                        tile.setLayerValue(this.layer, x, y, this.value);
                    }
                }
            } else {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (!(strength > 0.75f)) continue;
                        tile.setLayerValue(this.layer, x, y, this.value);
                    }
                }
            }
        } else if (this.dither) {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getStrength(centreX, centreY, x, y);
                    if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                    dimension.setLayerValueAt(this.layer, x, y, this.value);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.75f)) continue;
                    dimension.setLayerValueAt(this.layer, x, y, this.value);
                }
            }
        }
    }

    @Override
    public void remove(Dimension dimension, int centreX, int centreY, float dynamicLevel) {
        if (this.brush.getRadius() == 0) {
            this.removePixel(dimension, centreX, centreY);
            return;
        }
        int effectiveRadius = this.brush.getEffectiveRadius();
        int x1 = centreX - effectiveRadius;
        int y1 = centreY - effectiveRadius;
        int x2 = centreX + effectiveRadius;
        int y2 = centreY + effectiveRadius;
        int tileX1 = x1 >> 7;
        int tileY1 = y1 >> 7;
        int tileX2 = x2 >> 7;
        int tileY2 = y2 >> 7;
        if (tileX1 == tileX2 && tileY1 == tileY2) {
            Tile tile = dimension.getTileForEditing(tileX1, tileY1);
            if (tile == null) {
                return;
            }
            int x1InTile = x1 & 0x7F;
            int y1InTile = y1 & 0x7F;
            int x2InTile = x2 & 0x7F;
            int y2InTile = y2 & 0x7F;
            int tileXInWorld = tileX1 << 7;
            int tileYInWorld = tileY1 << 7;
            if (this.dither) {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                        tile.setLayerValue(this.layer, x, y, this.defaultValue);
                    }
                }
            } else {
                for (int y = y1InTile; y <= y2InTile; ++y) {
                    for (int x = x1InTile; x <= x2InTile; ++x) {
                        float strength = dynamicLevel * this.getFullStrength(centreX, centreY, tileXInWorld + x, tileYInWorld + y);
                        if (!(strength > 0.75f)) continue;
                        tile.setLayerValue(this.layer, x, y, this.defaultValue);
                    }
                }
            }
        } else if (this.dither) {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                    dimension.setLayerValueAt(this.layer, x, y, this.defaultValue);
                }
            }
        } else {
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    float strength = dynamicLevel * this.getFullStrength(centreX, centreY, x, y);
                    if (!(strength > 0.75f)) continue;
                    dimension.setLayerValueAt(this.layer, x, y, this.defaultValue);
                }
            }
        }
    }

    @Override
    public void applyPixel(Dimension dimension, int x, int y) {
        dimension.setLayerValueAt(this.layer, x, y, this.value);
    }

    @Override
    public void removePixel(Dimension dimension, int x, int y) {
        dimension.setLayerValueAt(this.layer, x, y, this.defaultValue);
    }
}

