/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.combined;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;

public class CombinedLayerTableModel
implements TableModel {
    private final List<Row> rows;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    public static final int COLUMN_LAYER = 0;
    public static final int COLUMN_FACTOR = 1;
    public static final int COLUMN_HIDE = 2;
    private static final String[] COLUMN_NAMES = new String[]{"Layer", "Factor", "Hidden"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{String.class, Integer.class, Boolean.class};

    public CombinedLayerTableModel(List<Layer> layers, Map<Layer, Float> factors) {
        this.rows = new ArrayList<Row>(layers.size());
        this.rows.addAll(layers.stream().map(layer -> new Row((Layer)layer, Math.round(((Float)factors.get(layer)).floatValue() * 100.0f), layer instanceof CustomLayer ? ((CustomLayer)layer).isHide() : false)).collect(Collectors.toList()));
    }

    void addRow(Row row) {
        if (row == null) {
            throw new NullPointerException("row");
        }
        this.rows.add(row);
        TableModelEvent event = new TableModelEvent(this, this.rows.size() - 1, this.rows.size() - 1, -1, 1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    void deleteRow(int rowIndex) {
        this.rows.remove(rowIndex);
        TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    void saveSettings(CombinedLayer layer) {
        ArrayList<Layer> layers = new ArrayList<Layer>(this.rows.size());
        HashMap<Layer, Float> factors = new HashMap<Layer, Float>();
        for (Row row : this.rows) {
            layers.add(row.layer);
            if (row.layer instanceof CustomLayer) {
                ((CustomLayer)row.layer).setHide(row.hide);
            }
            factors.put(row.layer, Float.valueOf((float)row.factor / 100.0f));
        }
        layer.setLayers(layers);
        layer.setFactors(factors);
    }

    boolean contains(Layer layer) {
        for (Row row : this.rows) {
            if (!row.layer.equals((Object)layer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Row row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.layer;
            }
            case 1: {
                return row.factor;
            }
            case 2: {
                return row.hide;
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Row row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (aValue == null) {
                    throw new NullPointerException("aValue");
                }
                row.layer = (Layer)aValue;
                break;
            }
            case 1: {
                row.factor = (Integer)aValue;
                break;
            }
            case 2: {
                row.hide = (Boolean)aValue;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    static class Row {
        Layer layer;
        int factor;
        boolean hide;

        Row(Layer layer, int factor, boolean hide) {
            if (layer == null) {
                throw new NullPointerException("layer");
            }
            this.layer = layer;
            this.factor = factor;
            this.hide = hide;
        }
    }
}

