/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.dynmap.DynmapPreviewer;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.CustomObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WPObjectPreviewer
extends JPanel
implements PropertyChangeListener {
    private final DynmapPreviewer previewer = new DynmapPreviewer();
    private Dimension dimension;
    private static final Logger logger = LoggerFactory.getLogger(WPObjectPreviewer.class);
    private static final long serialVersionUID = 1L;

    public WPObjectPreviewer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.previewer, "Center");
        this.setPreferredSize(new java.awt.Dimension(200, -1));
        this.setBorder(new BevelBorder(1));
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void setObject(WPObject object) {
        this.previewer.setObject(object, this.dimension);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            File file = (File)evt.getNewValue();
            if (file == null || !file.isFile()) {
                return;
            }
            try {
                this.setObject(CustomObjectManager.getInstance().loadObject(file));
            }
            catch (Throwable t) {
                logger.error("Exception while trying to generate preview for " + file, t);
            }
        }
    }
}

