/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.ColourUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.objects.WPObject;

public class OffsetViewer
extends JComponent {
    private BufferedImage texturePack;
    private WPObject object;
    private Point3i offset;
    private ColourScheme colourScheme;
    private Direction direction = Direction.X_ASC;
    private static final BufferedImage IMAGE_X_ASC = OffsetViewer.loadImage("x_asc.png");
    private static final BufferedImage IMAGE_Y_ASC = OffsetViewer.loadImage("z_asc.png");
    private static final BufferedImage IMAGE_X_DESC = OffsetViewer.loadImage("x_desc.png");
    private static final BufferedImage IMAGE_Y_DESC = OffsetViewer.loadImage("z_desc.png");
    private static final int WHITE = 0xFFFFFF;
    private static final Stroke STROKE = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{3.0f, 4.0f}, 0.0f);
    private static final long serialVersionUID = 1L;

    public OffsetViewer() {
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void rotateLeft() {
        this.direction = Direction.values()[(this.direction.ordinal() + 1) % 4];
        this.repaint();
    }

    public void rotateRight() {
        this.direction = Direction.values()[(this.direction.ordinal() + 3) % 4];
        this.repaint();
    }

    public WPObject getObject() {
        return this.object;
    }

    public void setObject(WPObject object) {
        this.object = object;
        this.repaint();
    }

    public Point3i getOffset() {
        return this.offset;
    }

    public void setOffset(Point3i offset) {
        this.offset = offset;
        this.repaint();
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
    }

    public BufferedImage getTexturePack() {
        return this.texturePack;
    }

    public void setTexturePack(BufferedImage texturePack) {
        this.texturePack = texturePack;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.object == null || this.offset == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int baseLine = this.getHeight() * 3 / 4;
        int middle = this.getWidth() / 2;
        Point3i dim = this.object.getDimensions();
        switch (this.direction) {
            case X_ASC: {
                for (int y = 0; y <= Math.min(-this.offset.y, dim.y - 1); ++y) {
                    for (int x = 0; x < dim.x; ++x) {
                        for (int z = 0; z < dim.z; ++z) {
                            if (!this.object.getMask(x, y, z)) continue;
                            this.paintBlock(g2, baseLine, middle, x + this.offset.x, z + this.offset.z, -this.offset.y - y, this.object.getMaterial(x, y, z));
                        }
                    }
                }
                g2.drawImage((Image)IMAGE_X_ASC, middle + 10, this.getHeight() - IMAGE_X_ASC.getHeight() - 2, null);
                break;
            }
            case Y_ASC: {
                for (int x = 0; x <= Math.min(-this.offset.x, dim.x - 1); ++x) {
                    for (int y = 0; y < dim.y; ++y) {
                        for (int z = 0; z < dim.z; ++z) {
                            if (!this.object.getMask(x, y, z)) continue;
                            this.paintBlock(g2, baseLine, middle, y + this.offset.y, z + this.offset.z, -this.offset.x - x, this.object.getMaterial(x, y, z));
                        }
                    }
                }
                g2.drawImage((Image)IMAGE_Y_ASC, middle + 10, this.getHeight() - IMAGE_Y_ASC.getHeight() - 2, null);
                break;
            }
            case X_DESC: {
                for (int y = dim.y - 1; y >= Math.max(-this.offset.y, 0); --y) {
                    for (int x = 0; x < dim.x; ++x) {
                        for (int z = 0; z < dim.z; ++z) {
                            if (!this.object.getMask(x, y, z)) continue;
                            this.paintBlock(g2, baseLine, middle, -x - this.offset.x, z + this.offset.z, y - -this.offset.y, this.object.getMaterial(x, y, z));
                        }
                    }
                }
                g2.drawImage((Image)IMAGE_X_DESC, middle - IMAGE_X_DESC.getWidth() - 10, this.getHeight() - IMAGE_X_DESC.getHeight() - 2, null);
                break;
            }
            case Y_DESC: {
                for (int x = dim.x - 1; x >= Math.max(-this.offset.x, 0); --x) {
                    for (int y = 0; y < dim.y; ++y) {
                        for (int z = 0; z < dim.z; ++z) {
                            if (!this.object.getMask(x, y, z)) continue;
                            this.paintBlock(g2, baseLine, middle, -y - this.offset.y, z + this.offset.z, x - -this.offset.x, this.object.getMaterial(x, y, z));
                        }
                    }
                }
                g2.drawImage((Image)IMAGE_Y_DESC, middle - IMAGE_Y_DESC.getWidth() - 10, this.getHeight() - IMAGE_Y_DESC.getHeight() - 2, null);
            }
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(STROKE);
        g2.drawRect(middle - 8, baseLine - 8, 16, 16);
        g2.drawLine(middle - 8, baseLine + 8, 0, baseLine + 8);
        g2.drawLine(middle + 7, baseLine + 8, this.getWidth() - 1, baseLine + 8);
    }

    private void paintBlock(Graphics2D g2, int baseLine, int middle, int x, int y, int depth, Material material) {
        if (material.blockType == 0) {
            return;
        }
        if (this.texturePack != null) {
            if (depth > 0) {
                RescaleOp rescaleOp = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)Math.pow(2.0, -depth)}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
                g2.drawImage(this.getImage(material, this.texturePack), rescaleOp, middle + x * 16 - 8, baseLine - y * 16 - 8);
            } else {
                g2.drawImage((Image)this.getImage(material, this.texturePack), middle + x * 16 - 8, baseLine - y * 16 - 8, null);
            }
        } else {
            int colour = this.colourScheme.getColour(material);
            if (depth > 0) {
                colour = ColourUtils.mix((int)colour, (int)0xFFFFFF, (int)((int)Math.round(Math.pow(0.5, depth) * 256.0)));
            }
            g2.setColor(new Color(colour));
            g2.fillRect(middle + x * 16 - 8, baseLine - y * 16 - 8, 16, 16);
        }
    }

    private BufferedImage getImage(Material material, BufferedImage texturePack) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private static BufferedImage loadImage(String name) {
        try {
            return ImageIO.read(OffsetViewer.class.getResourceAsStream("/org/pepsoft/worldpainter/resources/" + name));
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading image " + name, e);
        }
    }

    static enum Direction {
        X_ASC,
        Y_ASC,
        X_DESC,
        Y_DESC;

    }
}

