/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.importing.CustomItemsTreeCellRenderer;
import org.pepsoft.worldpainter.importing.CustomItemsTreeModel;

public class ImportCustomItemsDialog
extends WorldPainterDialog
implements TreeSelectionListener {
    private JButton buttonCancel;
    private JButton buttonOK;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel labelWorld;
    private CheckBoxTree treeCustomItems;
    private final CustomItemsTreeModel treeModel;

    public ImportCustomItemsDialog(Window parent, World2 world, ColourScheme colourScheme, CustomItemsTreeModel.ItemType itemType) {
        super(parent);
        this.initComponents();
        ((CheckBoxTreeCellRenderer)this.treeCustomItems.getCellRenderer()).setActualTreeRenderer((TreeCellRenderer)new CustomItemsTreeCellRenderer(colourScheme));
        this.treeModel = new CustomItemsTreeModel(world, itemType);
        this.treeCustomItems.getCheckBoxTreeSelectionModel().setModel((TreeModel)this.treeModel);
        this.treeCustomItems.setModel((TreeModel)this.treeModel);
        this.expandAll((JTree)this.treeCustomItems);
        CheckBoxTreeSelectionModel checkBoxTreeSelectionModel = this.treeCustomItems.getCheckBoxTreeSelectionModel();
        checkBoxTreeSelectionModel.addSelectionPath(new TreePath(this.treeModel.getRoot()));
        checkBoxTreeSelectionModel.addTreeSelectionListener((TreeSelectionListener)this);
        this.labelWorld.setText(world.getName());
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
    }

    public List<Object> getSelectedItems() {
        return this.treeModel.getSelectedItems(this.treeCustomItems.getCheckBoxTreeSelectionModel().getSelectionPaths());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.setControlStates();
    }

    private void expandAll(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    private void setControlStates() {
        this.buttonOK.setEnabled(this.treeCustomItems.getCheckBoxTreeSelectionModel().getSelectionCount() > 0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.labelWorld = new JLabel();
        this.jLabel3 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.treeCustomItems = new CheckBoxTree();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Custom Items");
        this.jLabel1.setText("Selected world:");
        this.labelWorld.setText("jLabel2");
        this.jLabel3.setText("Select which custom item(s) you want to import:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportCustomItemsDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportCustomItemsDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.treeCustomItems.setSelectionModel(null);
        this.jScrollPane1.setViewportView((Component)this.treeCustomItems);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelWorld)).addComponent(this.jLabel3)).addGap(0, 91, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelWorld)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 178, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }
}

