/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;

public class CustomItemsTreeModel
implements TreeModel {
    private final World2 world;
    private final List<CustomLayer> customLayers = new ArrayList<CustomLayer>();
    private final List<MixedMaterial> customTerrains = new ArrayList<MixedMaterial>();
    private final List<MixedMaterial> customMaterials = new ArrayList<MixedMaterial>();
    private final List<CustomBiome> customBiomes = new ArrayList<CustomBiome>();
    private final List<String> childrenOfRoot = new ArrayList<String>();
    private static final String ROOT = "Custom Items";
    private static final String LAYERS = "Custom Layers";
    private static final String TERRAINS = "Custom Terrain";
    private static final String BIOMES = "Custom Biomes";

    public CustomItemsTreeModel(World2 world, ItemType itemType) {
        this.world = world;
        if (itemType == ItemType.ALL || itemType == ItemType.TERRAIN) {
            for (int i = 0; i < 96; ++i) {
                MixedMaterial material = world.getMixedMaterial(i);
                if (material == null) continue;
                this.customTerrains.add(material);
            }
            if (!this.customTerrains.isEmpty()) {
                this.childrenOfRoot.add(TERRAINS);
            }
        }
        for (Dimension dim : world.getDimensions()) {
            this.processDimension(dim, itemType);
        }
        if (!this.customLayers.isEmpty()) {
            this.childrenOfRoot.add(LAYERS);
        }
        if (!this.customBiomes.isEmpty()) {
            this.childrenOfRoot.add(BIOMES);
        }
    }

    public List<Object> getSelectedItems(TreePath[] selectedTreePaths) {
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (TreePath selectedPath : selectedTreePaths) {
            Object object = selectedPath.getLastPathComponent();
            if (object == ROOT) {
                selectedItems.addAll(this.customTerrains);
                selectedItems.addAll(this.customLayers);
                selectedItems.addAll(this.customBiomes);
                continue;
            }
            if (object == TERRAINS) {
                selectedItems.addAll(this.customTerrains);
                continue;
            }
            if (object == LAYERS) {
                selectedItems.addAll(this.customLayers);
                continue;
            }
            if (object == BIOMES) {
                selectedItems.addAll(this.customBiomes);
                continue;
            }
            if (object instanceof CustomLayer || object instanceof MixedMaterial || object instanceof CustomBiome) {
                selectedItems.add(object);
                continue;
            }
            throw new InternalError("Unknown node type " + object.getClass() + " (\"" + object + "\") encountered");
        }
        return selectedItems;
    }

    public static boolean hasCustomItems(World2 world, ItemType itemType) {
        if (itemType == ItemType.ALL || itemType == ItemType.TERRAIN) {
            for (int i = 0; i < 96; ++i) {
                MixedMaterial material = world.getMixedMaterial(i);
                if (material == null) continue;
                return true;
            }
        }
        for (Dimension dim : world.getDimensions()) {
            if ((itemType == ItemType.ALL || itemType == ItemType.LAYER) && !dim.getCustomLayers().isEmpty() && dim.getCustomLayers().stream().anyMatch(Layer::isExportable)) {
                return true;
            }
            if (itemType != ItemType.ALL && itemType != ItemType.BIOME || dim.getCustomBiomes() == null || dim.getCustomBiomes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == ROOT) {
            return this.childrenOfRoot.get(index);
        }
        if (parent == TERRAINS) {
            return this.customTerrains.get(index);
        }
        if (parent == LAYERS) {
            return this.customLayers.get(index);
        }
        if (parent == BIOMES) {
            return this.customBiomes.get(index);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return this.childrenOfRoot.size();
        }
        if (parent == TERRAINS) {
            return this.customTerrains.size();
        }
        if (parent == LAYERS) {
            return this.customLayers.size();
        }
        if (parent == BIOMES) {
            return this.customBiomes.size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node != ROOT && node != TERRAINS && node != LAYERS && node != BIOMES;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == ROOT) {
            return this.childrenOfRoot.indexOf(child);
        }
        if (parent == TERRAINS) {
            return this.customTerrains.indexOf(child);
        }
        if (parent == LAYERS) {
            return this.customLayers.indexOf(child);
        }
        if (parent == BIOMES) {
            return this.customBiomes.indexOf(child);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    private void processDimension(Dimension dim, ItemType itemType) {
        block5: {
            block4: {
                if (itemType == ItemType.ALL) break block4;
                if (itemType != ItemType.LAYER) break block5;
            }
            dim.getCustomLayers().stream().filter(Layer::isExportable).forEach(this.customLayers::add);
        }
        if ((itemType == ItemType.ALL || itemType == ItemType.BIOME) && dim.getCustomBiomes() != null) {
            this.customBiomes.addAll(dim.getCustomBiomes());
        }
    }

    public static enum ItemType {
        ALL,
        LAYER,
        TERRAIN,
        BIOME;

    }
}

