/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.brushes;

import org.pepsoft.util.ObjectUtils;
import org.pepsoft.worldpainter.brushes.AbstractBrush;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.pepsoft.worldpainter.brushes.RadialBrush;

public abstract class SymmetricBrush
extends AbstractBrush {
    protected final boolean rotationallySymmetric;
    protected final BrushShape brushShape;
    private int radius;
    private int cachedRadius = -1;
    private float[][] strengthCache;
    private float[][] fullStrengthCache;
    private float level = 1.0f;
    private float cachedLevel = -1.0f;
    public static final SymmetricBrush CONSTANT_CIRCLE = new RadialBrush("Constant Circle", BrushShape.CIRCLE, true){

        @Override
        protected float calcStrength(float dr) {
            return 1.0f;
        }
    };
    public static final SymmetricBrush CONSTANT_SQUARE = new RadialBrush("Constant Square", BrushShape.SQUARE, false){

        @Override
        protected float calcStrength(float dr) {
            return 1.0f;
        }
    };
    public static final SymmetricBrush LINEAR_CIRCLE = new RadialBrush("Linear Circle", BrushShape.CIRCLE, true){

        @Override
        protected float calcStrength(float dr) {
            return 1.0f - dr;
        }
    };
    public static final SymmetricBrush LINEAR_SQUARE = new RadialBrush("Linear Square", BrushShape.SQUARE, false){

        @Override
        protected float calcStrength(float dr) {
            return 1.0f - dr;
        }
    };
    public static final SymmetricBrush COSINE_CIRCLE = new RadialBrush("Sine Circle", BrushShape.CIRCLE, true){

        @Override
        protected float calcStrength(float dr) {
            return (float)Math.cos((double)dr * Math.PI) / 2.0f + 0.5f;
        }
    };
    public static final SymmetricBrush COSINE_SQUARE = new RadialBrush("Sine Square", BrushShape.SQUARE, false){

        @Override
        protected float calcStrength(float dr) {
            return (float)Math.cos((double)dr * Math.PI) / 2.0f + 0.5f;
        }
    };
    public static final SymmetricBrush PLATEAU_CIRCLE = new RadialBrush("Plateau Circle", BrushShape.CIRCLE, true){

        @Override
        protected float calcStrength(float dr) {
            if (dr <= 0.5f) {
                return 1.0f;
            }
            return (float)Math.cos((dr - 0.5f) * ((float)Math.PI * 2)) / 2.0f + 0.5f;
        }
    };
    public static final SymmetricBrush PLATEAU_SQUARE = new RadialBrush("Plateau Square", BrushShape.SQUARE, false){

        @Override
        protected float calcStrength(float dr) {
            if (dr <= 0.5f) {
                return 1.0f;
            }
            return (float)Math.cos((dr - 0.5f) * ((float)Math.PI * 2)) / 2.0f + 0.5f;
        }
    };
    public static final SymmetricBrush SPIKE_CIRCLE = new RadialBrush("Spike Circle", BrushShape.CIRCLE, true){

        @Override
        protected float calcStrength(float dr) {
            return (1.0f - dr) * (1.0f - dr);
        }
    };
    public static final SymmetricBrush SPIKE_SQUARE = new RadialBrush("Spike Square", BrushShape.SQUARE, false){

        @Override
        protected float calcStrength(float dr) {
            return (1.0f - dr) * (1.0f - dr);
        }
    };
    public static final SymmetricBrush DOME_CIRCLE = new RadialBrush("Dome Circle", BrushShape.CIRCLE, true){

        @Override
        protected float calcStrength(float dr) {
            return (float)Math.sqrt(1.0f - dr * dr);
        }
    };
    public static final SymmetricBrush DOME_SQUARE = new RadialBrush("Dome Square", BrushShape.SQUARE, false){

        @Override
        protected float calcStrength(float dr) {
            return (float)Math.sqrt(1.0f - dr * dr);
        }
    };
    private static final float TWO_PI = (float)Math.PI * 2;

    public SymmetricBrush(String name, BrushShape brushShape, boolean rotationallySymmetric) {
        super(name);
        this.brushShape = brushShape;
        this.rotationallySymmetric = rotationallySymmetric;
        this.cacheStrengths();
    }

    public BrushShape getBrushShape() {
        return this.brushShape;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        if (radius != this.radius) {
            this.radius = radius;
            this.cacheStrengths();
        }
    }

    public float getLevel() {
        return this.level;
    }

    public void setLevel(float level) {
        if (level != this.level) {
            this.level = level;
            this.cacheStrengths();
        }
    }

    public final boolean isRotationallySymmetric() {
        return this.rotationallySymmetric;
    }

    public final float getStrength(int dx, int dy) {
        return this.strengthCache[Math.abs(dx)][Math.abs(dy)];
    }

    public final float getFullStrength(int dx, int dy) {
        return this.fullStrengthCache[Math.abs(dx)][Math.abs(dy)];
    }

    public String toString() {
        return this.getName() + " (radius=" + this.radius + ", brushShape=" + this.brushShape + ", level=" + this.level + ')';
    }

    @Override
    public SymmetricBrush clone() {
        SymmetricBrush clone = (SymmetricBrush)super.clone();
        if (this.strengthCache != null) {
            clone.strengthCache = ObjectUtils.clone((float[][])this.strengthCache);
        }
        if (this.fullStrengthCache != null) {
            clone.fullStrengthCache = this.fullStrengthCache == this.strengthCache ? clone.strengthCache : ObjectUtils.clone((float[][])this.fullStrengthCache);
        }
        return clone;
    }

    protected abstract float calcStrength(int var1, int var2);

    private void cacheStrengths() {
        if (this.radius != this.cachedRadius || this.level != this.cachedLevel) {
            if (this.strengthCache == null || this.strengthCache.length < this.radius + 1) {
                this.strengthCache = new float[this.radius + 1][this.radius + 1];
            }
            if (this.radius != this.cachedRadius) {
                if (this.fullStrengthCache == null || this.fullStrengthCache.length < this.radius + 1) {
                    this.fullStrengthCache = new float[this.radius + 1][this.radius + 1];
                }
                for (int dx = 0; dx <= this.radius; ++dx) {
                    for (int dy = 0; dy <= this.radius; ++dy) {
                        float strength = this.calcStrength(dx, dy);
                        this.strengthCache[dx][dy] = strength * this.level;
                        this.fullStrengthCache[dx][dy] = strength;
                    }
                }
            } else {
                for (int dx = 0; dx <= this.radius; ++dx) {
                    for (int dy = 0; dy <= this.radius; ++dy) {
                        this.strengthCache[dx][dy] = this.calcStrength(dx, dy) * this.level;
                    }
                }
            }
            this.cachedRadius = this.radius;
            this.cachedLevel = this.level;
        }
    }
}

