/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.brushes;

import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.brushes.BrushShape;
import org.pepsoft.worldpainter.brushes.SymmetricBrush;

public abstract class RadialBrush
extends SymmetricBrush {
    public RadialBrush(String name, BrushShape brushShape, boolean rotationallySymmetric) {
        super(name, brushShape, rotationallySymmetric);
    }

    @Override
    protected final float calcStrength(int dx, int dy) {
        int radius = this.getRadius();
        float distance = MathUtils.getDistance((int)dx, (int)dy);
        float dr = distance / (float)radius;
        switch (this.brushShape) {
            case CIRCLE: {
                if (distance <= (float)radius) {
                    return this.calcStrength(dr);
                }
                return 0.0f;
            }
            case SQUARE: {
                if (dx != 0 && dy != 0) {
                    int v;
                    int u;
                    if (dx < dy) {
                        u = radius * dx / dy;
                        v = radius;
                    } else {
                        u = radius;
                        v = radius * dy / dx;
                    }
                    float d = MathUtils.getDistance((int)u, (int)v);
                    float factor = d / (float)radius;
                    dr /= factor;
                }
                return this.calcStrength(dr);
            }
        }
        throw new InternalError();
    }

    protected abstract float calcStrength(float var1);
}

