/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.pepsoft.worldpainter.ColourEditor;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;

public class CustomBiomeDialog
extends WorldPainterDialog {
    private CustomBiome customBiome;
    private JButton buttonCancel;
    private JButton buttonOK;
    private ColourEditor colourEditor2;
    private JTextField fieldName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSpinner spinnerID;
    private static final long serialVersionUID = 1L;

    public CustomBiomeDialog(Window parent, CustomBiome customBiome, boolean _new, Platform platform) {
        super(parent);
        this.customBiome = customBiome;
        this.initComponents();
        this.spinnerID.setValue(customBiome.getId());
        this.fieldName.setText(customBiome.getName());
        if (platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
            this.remove(this.jLabel2);
            this.remove(this.spinnerID);
            this.jLabel3.setText("ID:");
            if (_new) {
                this.fieldName.requestFocusInWindow();
                this.fieldName.selectAll();
            }
        } else if (!_new) {
            this.spinnerID.setEnabled(false);
        } else {
            ((SpinnerNumberModel)this.spinnerID.getModel()).setMinimum(Integer.valueOf(customBiome.getId()));
        }
        this.colourEditor2.setColour(customBiome.getColour());
        this.rootPane.setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void ok() {
        this.customBiome.setId(((Integer)this.spinnerID.getValue()).intValue());
        this.customBiome.setName(this.fieldName.getText().trim());
        this.customBiome.setColour(this.colourEditor2.getColour());
        super.ok();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.spinnerID = new JSpinner();
        this.jLabel3 = new JLabel();
        this.fieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.colourEditor2 = new ColourEditor();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Configure Custom Biome");
        this.jLabel1.setText("Configure the custom biome here:");
        this.jLabel2.setText("ID:");
        this.spinnerID.setModel(new SpinnerNumberModel(40, 40, 255, 1));
        this.jLabel3.setText("Name:");
        this.fieldName.setColumns(20);
        this.jLabel4.setText("Colour:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomBiomeDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomBiomeDialog.this.buttonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerID, -2, -1, -2).addComponent(this.colourEditor2, -2, -1, -2).addComponent(this.fieldName))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.spinnerID, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fieldName, -2, -1, -2)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.colourEditor2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }
}

