/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.pepsoft.util.swing.TiledImageViewerContainer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.MouseAdapter;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPBorderTileProvider;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.pepsoft.worldpainter.ramps.ColourRamp;
import org.pepsoft.worldpainter.tools.BiomesTileProvider;
import org.pepsoft.worldpainter.tools.WPTileSelectionViewer;

public class TileSelector
extends JPanel {
    private JButton buttonClearSelection;
    private JButton buttonInvertSelection;
    private JButton buttonOrigin;
    private JButton buttonSelectAll;
    private JButton buttonSpawn;
    private JPanel jPanel1;
    private final WPTileSelectionViewer viewer = new WPTileSelectionViewer(false, true);
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final Set<Point> selectableTileCoords = new HashSet<Point>();
    private final TiledImageViewerContainer viewerContainer = new TiledImageViewerContainer((Component)((Object)this.viewer));
    private Dimension dimension;
    private Dimension backgroundDimension;
    private ColourScheme colourScheme;
    private Set<Layer> hiddenLayers;
    private int contourSeparation = 10;
    private int backgroundZoom;
    private boolean contourLines;
    private boolean allowNonExistentTileSelection = false;
    private boolean allowBackgroundTileSelection = true;
    private TileRenderer.LightOrigin lightOrigin;
    private CustomBiomeManager customBiomeManager;
    private ColourRamp colourRamp;
    private static final long serialVersionUID = 1L;

    public TileSelector() {
        this.initComponents();
        this.viewer.setBackground(new Color(VoidRenderer.getColour()));
        this.viewer.setZoom(this.viewer.getZoom() - 2);
        this.viewer.addMouseWheelListener(e -> {
            int rotation = e.getWheelRotation();
            int zoom = this.viewer.getZoom();
            zoom = rotation < 0 ? Math.min(zoom + -rotation, 0) : Math.max(zoom - rotation, -4);
            this.viewer.setZoom(zoom);
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private boolean selecting;
            private Point selectionCorner1;
            private Point selectionCorner2;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                Point tileLocation = this.getTileLocation(e.getX(), e.getY());
                if (TileSelector.this.viewer.isSelectedTile(tileLocation)) {
                    TileSelector.this.viewer.removeSelectedTile(tileLocation);
                } else if (TileSelector.this.allowNonExistentTileSelection || TileSelector.this.dimension != null && TileSelector.this.dimension.isTilePresent(tileLocation.x, tileLocation.y) || TileSelector.this.allowBackgroundTileSelection && TileSelector.this.backgroundDimension != null && TileSelector.this.backgroundDimension.isTilePresent(tileLocation.x >> TileSelector.this.backgroundZoom, tileLocation.y >> TileSelector.this.backgroundZoom)) {
                    TileSelector.this.viewer.addSelectedTile(tileLocation);
                }
                TileSelector.this.viewer.setSelectedRectangleCorner1(null);
                TileSelector.this.viewer.setSelectedRectangleCorner2(null);
                TileSelector.this.setControlStates();
                TileSelector.this.notifyListeners();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                this.selecting = true;
                this.selectionCorner1 = this.getTileLocation(e.getX(), e.getY());
                this.selectionCorner2 = null;
                TileSelector.this.viewer.setSelectedRectangleCorner1(null);
                TileSelector.this.viewer.setSelectedRectangleCorner2(null);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean deselect;
                if (e.getButton() != 1) {
                    return;
                }
                boolean bl = deselect = e.isControlDown() || e.isMetaDown();
                if (this.selectionCorner1 != null && this.selectionCorner2 != null) {
                    int tileX1 = Math.min(this.selectionCorner1.x, this.selectionCorner2.x);
                    int tileX2 = Math.max(this.selectionCorner1.x, this.selectionCorner2.x);
                    int tileY1 = Math.min(this.selectionCorner1.y, this.selectionCorner2.y);
                    int tileY2 = Math.max(this.selectionCorner1.y, this.selectionCorner2.y);
                    for (int x = tileX1; x <= tileX2; ++x) {
                        for (int y = tileY1; y <= tileY2; ++y) {
                            Point tileLocation = new Point(x, y);
                            if (deselect && TileSelector.this.viewer.isSelectedTile(tileLocation)) {
                                TileSelector.this.viewer.removeSelectedTile(tileLocation);
                                continue;
                            }
                            if (deselect || !TileSelector.this.allowNonExistentTileSelection && (TileSelector.this.dimension == null || !TileSelector.this.dimension.isTilePresent(tileLocation.x, tileLocation.y)) && (!TileSelector.this.allowBackgroundTileSelection || TileSelector.this.backgroundDimension == null || !TileSelector.this.backgroundDimension.isTilePresent(tileLocation.x >> TileSelector.this.backgroundZoom, tileLocation.y >> TileSelector.this.backgroundZoom)) || TileSelector.this.viewer.isSelectedTile(tileLocation)) continue;
                            TileSelector.this.viewer.addSelectedTile(tileLocation);
                        }
                    }
                    TileSelector.this.setControlStates();
                    TileSelector.this.notifyListeners();
                }
                TileSelector.this.viewer.setSelectedRectangleCorner1(null);
                TileSelector.this.viewer.setSelectedRectangleCorner2(null);
                this.selecting = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TileSelector.this.viewer.setHighlightedTileLocation(this.getTileLocation(e.getX(), e.getY()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TileSelector.this.viewer.setHighlightedTileLocation(null);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TileSelector.this.viewer.setHighlightedTileLocation(this.getTileLocation(e.getX(), e.getY()));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                TileSelector.this.viewer.setHighlightedTileLocation(this.getTileLocation(e.getX(), e.getY()));
                if (this.selecting) {
                    this.selectionCorner2 = this.getTileLocation(e.getX(), e.getY());
                    TileSelector.this.viewer.setSelectedRectangleCorner1(this.selectionCorner1);
                    TileSelector.this.viewer.setSelectedRectangleCorner2(this.selectionCorner2);
                }
            }

            private Point getTileLocation(int x, int y) {
                Point coords = TileSelector.this.viewer.viewToWorld(x, y);
                return new Point(coords.x >> 7, coords.y >> 7);
            }
        };
        this.viewer.addMouseListener(mouseAdapter);
        this.viewer.addMouseMotionListener(mouseAdapter);
        this.jPanel1.add((Component)this.viewerContainer, "Center");
        this.setControlStates();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("zoomIn", new AbstractAction("zoomIn"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int zoom = TileSelector.this.viewer.getZoom();
                if (zoom < 0) {
                    TileSelector.this.viewer.setZoom(zoom + 1);
                }
            }
        });
        actionMap.put("zoomOut", new AbstractAction("zoomOut"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int zoom = TileSelector.this.viewer.getZoom();
                if (zoom > -4) {
                    TileSelector.this.viewer.setZoom(zoom - 1);
                }
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(109, 0), "zoomOut");
        inputMap.put(KeyStroke.getKeyStroke(45, 0), "zoomOut");
        inputMap.put(KeyStroke.getKeyStroke(107, 0), "zoomIn");
        inputMap.put(KeyStroke.getKeyStroke(61, 64), "zoomIn");
    }

    public ColourScheme getColourScheme() {
        return this.colourScheme;
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
    }

    public boolean isContourLines() {
        return this.contourLines;
    }

    public void setContourLines(boolean contourLines) {
        this.contourLines = contourLines;
    }

    public int getContourSeparation() {
        return this.contourSeparation;
    }

    public void setContourSeparation(int contourSeparation) {
        this.contourSeparation = contourSeparation;
    }

    public TileRenderer.LightOrigin getLightOrigin() {
        return this.lightOrigin;
    }

    public void setLightOrigin(TileRenderer.LightOrigin lightOrigin) {
        this.lightOrigin = lightOrigin;
    }

    public Point getCurrentLocation() {
        return this.viewer.getViewLocation();
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.selectableTileCoords.clear();
        this.dimension = dimension;
        if (dimension != null) {
            World2 world;
            if (!(dimension.getAnchor().dim != 0 || dimension.getBorder() != null && dimension.getBorder().isEndless() || (world = dimension.getWorld()) == null)) {
                int biomeAlgorithm = -1;
                Platform platform = world.getPlatform();
                if (platform == DefaultPlugin.JAVA_MCREGION) {
                    biomeAlgorithm = 4;
                } else if (platform == DefaultPlugin.JAVA_ANVIL) {
                    if (dimension.getGenerator().getType() == Generator.DEFAULT) {
                        biomeAlgorithm = 9;
                    } else if (dimension.getGenerator().getType() == Generator.LARGE_BIOMES) {
                        biomeAlgorithm = 10;
                    }
                }
                if (biomeAlgorithm != -1) {
                    this.viewer.setTileProvider(-2, new BiomesTileProvider(biomeAlgorithm, dimension.getMinecraftSeed(), this.colourScheme, 0, true));
                }
            }
            WPTileProvider tileProvider = new WPTileProvider((TileProvider)dimension, this.colourScheme, this.customBiomeManager, this.hiddenLayers, this.contourLines, this.contourSeparation, this.lightOrigin, this.colourRamp);
            this.viewer.setTileProvider((org.pepsoft.util.swing.TileProvider)tileProvider);
            Dimension.Anchor anchor = dimension.getAnchor();
            if (anchor.role == Dimension.Role.DETAIL) {
                this.backgroundDimension = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.MASTER, anchor.invert, 0));
                this.backgroundZoom = 4;
            } else if (anchor.role == Dimension.Role.CAVE_FLOOR) {
                this.backgroundDimension = dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, anchor.invert, 0));
                this.backgroundZoom = 0;
            } else {
                this.backgroundDimension = null;
                this.backgroundZoom = 0;
            }
            if (this.backgroundDimension != null) {
                WPTileProvider backgroundProvider = new WPTileProvider((TileProvider)this.backgroundDimension, this.colourScheme, this.customBiomeManager, this.hiddenLayers, this.contourLines, this.contourSeparation, this.lightOrigin, false, WPTileProvider.Effect.FADE_TO_FIFTY_PERCENT, true, this.colourRamp);
                this.viewer.setTileProvider(-1, (org.pepsoft.util.swing.TileProvider)backgroundProvider);
                this.viewer.setTileProviderZoom((org.pepsoft.util.swing.TileProvider)backgroundProvider, this.backgroundZoom);
            }
            this.calculateSelectableTiles();
            if (dimension.getBorder() != null) {
                this.viewer.setTileProvider(-2, (org.pepsoft.util.swing.TileProvider)new WPBorderTileProvider(dimension, this.colourScheme));
            }
            this.viewer.setMarkerCoords(dimension.getAnchor().dim == 0 ? dimension.getWorld().getSpawnPoint() : null);
            this.buttonSpawn.setEnabled(true);
        } else {
            this.viewer.removeAllTileProviders();
            this.viewer.setMarkerCoords(null);
            this.buttonSpawn.setEnabled(false);
        }
        this.viewer.clearSelectedTiles();
        this.setControlStates();
    }

    public void refresh() {
        if (this.dimension != null && this.dimension.getAnchor().dim == 0) {
            this.viewer.setMarkerCoords(this.dimension.getWorld().getSpawnPoint());
        }
        this.viewer.refresh();
        this.calculateSelectableTiles();
    }

    public Set<Layer> getHiddenLayers() {
        return this.hiddenLayers;
    }

    public void setHiddenLayers(Set<Layer> hiddenLayers) {
        this.hiddenLayers = hiddenLayers;
    }

    public CustomBiomeManager getCustomBiomeManager() {
        return this.customBiomeManager;
    }

    public void setCustomBiomeManager(CustomBiomeManager customBiomeManager) {
        this.customBiomeManager = customBiomeManager;
    }

    public ColourRamp getColourRamp() {
        return this.colourRamp;
    }

    public void setColourRamp(ColourRamp colourRamp) {
        this.colourRamp = colourRamp;
    }

    public Set<Point> getSelectedTiles() {
        return this.viewer.getSelectedTiles();
    }

    public void setSelectedTiles(Set<Point> selectedTiles) {
        this.viewer.setSelectedTiles(selectedTiles);
        this.setControlStates();
        this.notifyListeners();
    }

    public boolean isAllowNonExistentTileSelection() {
        return this.allowNonExistentTileSelection;
    }

    public void setAllowNonExistentTileSelection(boolean allowNonExistentTileSelection) {
        if (allowNonExistentTileSelection != this.allowNonExistentTileSelection) {
            this.allowNonExistentTileSelection = allowNonExistentTileSelection;
            if (!allowNonExistentTileSelection) {
                this.clearSelection();
            }
        }
    }

    public boolean isAllowBackgroundTileSelection() {
        return this.allowBackgroundTileSelection;
    }

    public void setAllowBackgroundTileSelection(boolean allowBackgroundTileSelection) {
        if (allowBackgroundTileSelection != this.allowBackgroundTileSelection) {
            this.allowBackgroundTileSelection = allowBackgroundTileSelection;
            this.calculateSelectableTiles();
            if (!allowBackgroundTileSelection) {
                this.clearSelection();
            }
        }
    }

    public void selectAllTiles() {
        boolean selectionChanged = false;
        for (Point tileCoords : this.selectableTileCoords) {
            if (this.viewer.isSelectedTile(tileCoords)) continue;
            this.viewer.addSelectedTile(tileCoords);
            selectionChanged = true;
        }
        if (selectionChanged) {
            this.setControlStates();
            this.notifyListeners();
        }
    }

    public void clearSelection() {
        this.viewer.clearSelectedTiles();
        this.setControlStates();
        this.notifyListeners();
    }

    public void invertSelection() {
        Set<Point> allTiles = this.selectableTileCoords;
        for (Point tileCoords2 : allTiles) {
            if (!this.viewer.isSelectedTile(tileCoords2)) {
                this.viewer.addSelectedTile(tileCoords2);
                continue;
            }
            this.viewer.removeSelectedTile(tileCoords2);
        }
        new HashSet<Point>(this.viewer.getSelectedTiles()).stream().filter(tileCoords -> !allTiles.contains(tileCoords)).forEach(this.viewer::removeSelectedTile);
        this.setControlStates();
        this.notifyListeners();
    }

    public void moveToSpawn() {
        this.viewer.moveToMarker();
    }

    public void moveToCentre() {
        this.viewer.moveToOrigin();
    }

    public void moveTo(int x, int y) {
        this.viewer.moveTo(x, y);
    }

    public void moveTo(Point coords) {
        this.viewer.moveTo(coords);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void calculateSelectableTiles() {
        this.selectableTileCoords.clear();
        this.selectableTileCoords.addAll(this.dimension.getTileCoords());
        if (this.allowBackgroundTileSelection && this.backgroundDimension != null) {
            int scale = 1 << this.backgroundZoom;
            for (Point tileCoords : this.backgroundDimension.getTileCoords()) {
                int scaledTileX = tileCoords.x << this.backgroundZoom;
                int scaledTileY = tileCoords.y << this.backgroundZoom;
                for (int dx = 0; dx < scale; ++dx) {
                    for (int dy = 0; dy < scale; ++dy) {
                        this.selectableTileCoords.add(new Point(scaledTileX + dx, scaledTileY + dy));
                    }
                }
            }
        }
    }

    private void setControlStates() {
        boolean allowSelectAll;
        boolean allowInvertSelection;
        Set<Point> selectedTiles = this.viewer.getSelectedTiles();
        if (this.dimension == null) {
            allowInvertSelection = false;
            allowSelectAll = false;
        } else if (selectedTiles.isEmpty()) {
            allowInvertSelection = true;
            allowSelectAll = true;
        } else {
            int existingTileCount = this.dimension.getTileCount();
            int selectedExistingTileCount = 0;
            for (Point selectedTile : selectedTiles) {
                if (!this.selectableTileCoords.contains(selectedTile)) continue;
                ++selectedExistingTileCount;
            }
            allowSelectAll = selectedExistingTileCount < existingTileCount;
            allowInvertSelection = true;
        }
        boolean allowClearSelection = !selectedTiles.isEmpty();
        this.buttonSelectAll.setEnabled(allowSelectAll);
        this.buttonInvertSelection.setEnabled(allowInvertSelection);
        this.buttonClearSelection.setEnabled(allowClearSelection);
    }

    private void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.selectionChanged(this, this.viewer.getSelectedTiles());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.buttonSpawn = new JButton();
        this.buttonOrigin = new JButton();
        this.buttonSelectAll = new JButton();
        this.buttonInvertSelection = new JButton();
        this.buttonClearSelection = new JButton();
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setLayout(new BorderLayout());
        this.buttonSpawn.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/spawn_red.png")));
        this.buttonSpawn.setEnabled(false);
        this.buttonSpawn.addActionListener(this::buttonSpawnActionPerformed);
        this.buttonOrigin.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/arrow_in.png")));
        this.buttonOrigin.addActionListener(this::buttonOriginActionPerformed);
        this.buttonSelectAll.setText("Select all tiles");
        this.buttonSelectAll.setEnabled(false);
        this.buttonSelectAll.addActionListener(this::buttonSelectAllActionPerformed);
        this.buttonInvertSelection.setText("Invert selection");
        this.buttonInvertSelection.setEnabled(false);
        this.buttonInvertSelection.addActionListener(this::buttonInvertSelectionActionPerformed);
        this.buttonClearSelection.setText("Clear selection");
        this.buttonClearSelection.setEnabled(false);
        this.buttonClearSelection.addActionListener(this::buttonClearSelectionActionPerformed);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonSpawn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOrigin).addGap(18, 18, Short.MAX_VALUE).addComponent(this.buttonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonInvertSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClearSelection)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -1, 264, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonSpawn).addComponent(this.buttonOrigin).addComponent(this.buttonSelectAll).addComponent(this.buttonInvertSelection).addComponent(this.buttonClearSelection))));
    }

    private void buttonSpawnActionPerformed(ActionEvent evt) {
        this.moveToSpawn();
    }

    private void buttonOriginActionPerformed(ActionEvent evt) {
        this.moveToCentre();
    }

    private void buttonSelectAllActionPerformed(ActionEvent evt) {
        this.selectAllTiles();
    }

    private void buttonInvertSelectionActionPerformed(ActionEvent evt) {
        this.invertSelection();
    }

    private void buttonClearSelectionActionPerformed(ActionEvent evt) {
        this.clearSelection();
    }

    public static interface Listener {
        public void selectionChanged(TileSelector var1, Set<Point> var2);
    }
}

