/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LayoutStyle;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ExportTileSelectionDialog;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.layers.Layer;

public class TestExportDialog
extends WorldPainterDialog {
    private JCheckBox checkBoxCaves;
    private JCheckBox checkBoxDimension;
    private JCheckBox checkBoxLeaves;
    private JCheckBox checkBoxLighting;
    private JCheckBox checkBoxResources;
    private JCheckBox checkBoxTiles;
    private JCheckBox checkBoxUnderground;
    private JComboBox<Integer> comboBoxDimension;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel labelSelectTiles;
    private int selectedDimension;
    private Set<Point> selectedTiles;
    private final World2 world;
    private final ColourScheme colourScheme;
    private final CustomBiomeManager customBiomeManager;
    private final Set<Layer> hiddenLayers;
    private final boolean contourLines;
    private final int contourSeparation;
    private final TileRenderer.LightOrigin lightOrigin;

    public TestExportDialog(Window parent, World2 world, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin) {
        super(parent);
        Set stepsToSkip;
        WorldExportSettings exportSettings;
        this.world = world;
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.hiddenLayers = hiddenLayers;
        this.contourLines = contourLines;
        this.contourSeparation = contourSeparation;
        this.lightOrigin = lightOrigin;
        if (world.getExportSettings() != null) {
            exportSettings = world.getExportSettings();
        } else {
            exportSettings = new WorldExportSettings();
            exportSettings.setDimensionsToExport(Collections.singleton(0));
        }
        this.selectedTiles = exportSettings.getTilesToExport();
        this.selectedDimension = exportSettings.getDimensionsToExport() != null ? (Integer)exportSettings.getDimensionsToExport().iterator().next() : 0;
        this.initComponents();
        Integer[] dimensions = (Integer[])world.getDimensionsWithRole(Dimension.Role.DETAIL, false, 0).stream().map(d -> d.getAnchor().dim).sorted().toArray(Integer[]::new);
        this.comboBoxDimension.setModel(new DefaultComboBoxModel<Integer>(dimensions));
        this.comboBoxDimension.setSelectedItem(this.selectedDimension);
        this.comboBoxDimension.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                switch ((Integer)value) {
                    case 0: {
                        this.setText("Surface");
                        break;
                    }
                    case 1: {
                        this.setText("Nether");
                        break;
                    }
                    case 2: {
                        this.setText("End");
                    }
                }
                return this;
            }
        });
        this.checkBoxDimension.setEnabled(dimensions.length > 1);
        if (exportSettings.getDimensionsToExport() == null && dimensions.length > 1) {
            this.checkBoxDimension.setSelected(false);
        }
        if (this.selectedTiles != null && !this.selectedTiles.isEmpty()) {
            this.checkBoxTiles.setText("export subset of tiles (" + this.selectedTiles.size() + " tiles selected)");
            this.checkBoxTiles.setSelected(true);
        }
        this.checkBoxCaves.setSelected((stepsToSkip = exportSettings.getStepsToSkip()) == null || stepsToSkip.contains(WorldExportSettings.Step.CAVES));
        this.checkBoxResources.setSelected(stepsToSkip == null || stepsToSkip.contains(WorldExportSettings.Step.RESOURCES));
        this.checkBoxLighting.setSelected(stepsToSkip == null || stepsToSkip.contains(WorldExportSettings.Step.LIGHTING));
        this.checkBoxLeaves.setSelected(stepsToSkip == null || stepsToSkip.contains(WorldExportSettings.Step.LEAVES));
        this.checkBoxUnderground.setSelected(this.checkBoxCaves.isSelected() && this.checkBoxResources.isSelected());
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setControlStates();
    }

    private void setControlStates() {
        if (this.checkBoxTiles.isSelected()) {
            this.labelSelectTiles.setForeground(Color.BLUE);
            this.labelSelectTiles.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.labelSelectTiles.setForeground(null);
            this.labelSelectTiles.setCursor(null);
        }
        this.comboBoxDimension.setEnabled(this.checkBoxDimension.isSelected() && this.comboBoxDimension.getItemCount() > 1);
        this.checkBoxTiles.setEnabled(this.checkBoxDimension.isSelected());
        this.checkBoxCaves.setEnabled(!this.checkBoxUnderground.isSelected());
        this.checkBoxResources.setEnabled(!this.checkBoxUnderground.isSelected());
    }

    private void selectTiles() {
        if (this.checkBoxTiles.isSelected()) {
            ExportTileSelectionDialog dialog = new ExportTileSelectionDialog(this, this.world, this.selectedDimension, this.selectedTiles, this.colourScheme, this.customBiomeManager, this.hiddenLayers, this.contourLines, this.contourSeparation, this.lightOrigin);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.selectedDimension = dialog.getSelectedDimension();
                this.comboBoxDimension.setSelectedItem(this.selectedDimension);
                this.selectedTiles = dialog.getSelectedTiles();
                this.checkBoxTiles.setText("export subset of tiles (" + this.selectedTiles.size() + " tiles selected)");
            }
            if (this.selectedTiles == null || this.selectedTiles.isEmpty()) {
                this.checkBoxTiles.setSelected(false);
            }
            this.setControlStates();
        }
    }

    private void export() {
        if (this.checkBoxTiles.isSelected() && (this.selectedTiles == null || this.selectedTiles.isEmpty())) {
            this.checkBoxTiles.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"No tiles have been selected for export.", (String)"Error");
            return;
        }
        EnumSet<WorldExportSettings.Step> skipSteps = EnumSet.noneOf(WorldExportSettings.Step.class);
        if (this.checkBoxCaves.isSelected()) {
            skipSteps.add(WorldExportSettings.Step.CAVES);
        }
        if (this.checkBoxResources.isSelected()) {
            skipSteps.add(WorldExportSettings.Step.RESOURCES);
        }
        if (this.checkBoxLighting.isSelected()) {
            skipSteps.add(WorldExportSettings.Step.LIGHTING);
        }
        if (this.checkBoxLeaves.isSelected()) {
            skipSteps.add(WorldExportSettings.Step.LEAVES);
        }
        WorldExportSettings exportSettings = this.checkBoxDimension.isSelected() ? (this.checkBoxTiles.isSelected() ? new WorldExportSettings(Collections.singleton(this.selectedDimension), this.selectedTiles, skipSteps.isEmpty() ? null : skipSteps) : (this.comboBoxDimension.getItemCount() > 1 ? new WorldExportSettings(Collections.singleton((Integer)this.comboBoxDimension.getSelectedItem()), null, skipSteps.isEmpty() ? null : skipSteps) : (skipSteps.isEmpty() ? null : new WorldExportSettings(null, null, skipSteps)))) : (skipSteps.isEmpty() ? null : new WorldExportSettings(null, null, skipSteps));
        this.world.setExportSettings(exportSettings);
        this.ok();
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.checkBoxTiles = new JCheckBox();
        this.labelSelectTiles = new JLabel();
        this.checkBoxUnderground = new JCheckBox();
        this.checkBoxCaves = new JCheckBox();
        this.checkBoxResources = new JCheckBox();
        this.checkBoxLighting = new JCheckBox();
        this.checkBoxLeaves = new JCheckBox();
        this.checkBoxDimension = new JCheckBox();
        this.comboBoxDimension = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(2);
        this.setTitle("Test Export");
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestExportDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Export");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestExportDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("<html>Perform a test export with reduced area and/or features<br>for faster export:</html>");
        this.checkBoxTiles.setText("export subset of tiles");
        this.checkBoxTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestExportDialog.this.checkBoxTilesActionPerformed(evt);
            }
        });
        this.labelSelectTiles.setForeground(new Color(0, 0, 255));
        this.labelSelectTiles.setText("<html><u>select tiles</u></html>");
        this.labelSelectTiles.setCursor(new Cursor(12));
        this.labelSelectTiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TestExportDialog.this.labelSelectTilesMouseClicked(evt);
            }
        });
        this.checkBoxUnderground.setSelected(true);
        this.checkBoxUnderground.setText("do not export underground features");
        this.checkBoxUnderground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestExportDialog.this.checkBoxUndergroundActionPerformed(evt);
            }
        });
        this.checkBoxCaves.setSelected(true);
        this.checkBoxCaves.setText("do not export caves, caverns, chasms and custom cave/tunnel layers");
        this.checkBoxCaves.setEnabled(false);
        this.checkBoxResources.setSelected(true);
        this.checkBoxResources.setText("do not export resources and custom underground pockets layers");
        this.checkBoxResources.setEnabled(false);
        this.checkBoxLighting.setSelected(true);
        this.checkBoxLighting.setText("do not perform lighting");
        this.checkBoxLeaves.setSelected(true);
        this.checkBoxLeaves.setText("do not perform leaf decay calculations (no leaf blocks will decay)");
        this.checkBoxDimension.setSelected(true);
        this.checkBoxDimension.setText("export only the");
        this.checkBoxDimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestExportDialog.this.checkBoxDimensionActionPerformed(evt);
            }
        });
        this.comboBoxDimension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestExportDialog.this.comboBoxDimensionActionPerformed(evt);
            }
        });
        this.jLabel3.setText("dimension");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxTiles).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxDimension).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxDimension, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.checkBoxUnderground).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxCaves).addComponent(this.labelSelectTiles, -2, -1, -2).addComponent(this.checkBoxResources))).addComponent(this.checkBoxLighting).addComponent(this.checkBoxLeaves)).addGap(0, 13, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxDimension).addComponent(this.comboBoxDimension, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxTiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelSelectTiles, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxUnderground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCaves).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxResources).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLighting).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLeaves).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton3)).addContainerGap()));
        this.pack();
    }

    private void labelSelectTilesMouseClicked(MouseEvent evt) {
        this.selectTiles();
    }

    private void checkBoxUndergroundActionPerformed(ActionEvent evt) {
        this.checkBoxCaves.setSelected(this.checkBoxUnderground.isSelected());
        this.checkBoxResources.setSelected(this.checkBoxUnderground.isSelected());
        this.setControlStates();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void checkBoxTilesActionPerformed(ActionEvent evt) {
        this.setControlStates();
        if (this.checkBoxTiles.isSelected() && (this.selectedTiles == null || this.selectedTiles.isEmpty())) {
            this.selectTiles();
        }
    }

    private void checkBoxDimensionActionPerformed(ActionEvent evt) {
        if (!this.checkBoxDimension.isSelected()) {
            this.checkBoxTiles.setSelected(false);
        }
        this.setControlStates();
    }

    private void comboBoxDimensionActionPerformed(ActionEvent evt) {
        int newSelectedDimension = (Integer)this.comboBoxDimension.getSelectedItem();
        if (newSelectedDimension != this.selectedDimension) {
            this.selectedDimension = newSelectedDimension;
            this.selectedTiles = null;
            this.checkBoxTiles.setSelected(false);
            this.checkBoxTiles.setText("export subset of tiles");
        }
    }
}

