/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.swing.JideLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.util.LayoutUtils;

public class Palette {
    private final String name;
    private final JPanel panel;
    private final List<CustomLayer> layers = new ArrayList<CustomLayer>();
    private final Map<CustomLayer, List<Component>> layerButtonComponents = new HashMap<CustomLayer, List<Component>>();
    private final DockableFrame dockableFrame;
    private final JCheckBox showCheckBox;
    private final JCheckBox soloCheckBox;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean show = true;
    private boolean solo;
    private static final Icon ICON_LAYERS = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/layers.png");
    private static final Icon ICON_NOT_SHOWN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/cross.png");
    private static final Icon ICON_SOLO = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/tick.png");

    Palette(String name, List<Component> buttonComponents) {
        this.name = name;
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, 1, 1);
        JideLabel label = new JideLabel("Show");
        label.setOrientation(1);
        label.setClockwise(false);
        label.setMinimumSize(label.getPreferredSize());
        constraints.anchor = 15;
        this.panel.add((Component)label, constraints);
        label = new JideLabel("Solo");
        label.setOrientation(1);
        label.setClockwise(false);
        label.setMinimumSize(label.getPreferredSize());
        this.panel.add((Component)label, constraints);
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        this.panel.add((Component)new JLabel(), constraints);
        constraints.anchor = 23;
        constraints.weightx = 0.0;
        this.showCheckBox = new JCheckBox();
        this.showCheckBox.setToolTipText("Uncheck to hide all layer on this palette from view (they will still be exported)");
        this.showCheckBox.setSelected(true);
        this.showCheckBox.addActionListener(e -> this.setShow(this.showCheckBox.isSelected()));
        this.soloCheckBox = new JCheckBox();
        this.soloCheckBox.setToolTipText("<html>Check to show <em>only</em> the layers on this palette (the other layers are still exported)</html>");
        this.soloCheckBox.addActionListener(e -> this.setSolo(this.soloCheckBox.isSelected()));
        LayoutUtils.addRowOfComponents(this.panel, constraints, Arrays.asList(this.showCheckBox, this.soloCheckBox, new JLabel("<html><i>all </i></html>")));
        LayoutUtils.addRowOfComponents(this.panel, constraints, buttonComponents);
        this.dockableFrame = new App.DockableFrameBuilder(this.panel, name, 8, 3).withIcon(ICON_LAYERS).build();
        this.dockableFrame.setKey("customLayerPalette." + name);
    }

    String getName() {
        return this.name;
    }

    List<CustomLayer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    boolean isShow() {
        return this.show;
    }

    void setShow(boolean show) {
        this.show = show;
        this.showCheckBox.setSelected(show);
        this.propertyChangeSupport.firePropertyChange("show", !this.showCheckBox.isSelected(), this.showCheckBox.isSelected());
        this.dockableFrame.setFrameIcon(this.solo ? ICON_SOLO : (show ? ICON_LAYERS : ICON_NOT_SHOWN));
    }

    boolean isSolo() {
        return this.solo;
    }

    void setSolo(boolean solo) {
        this.solo = solo;
        this.soloCheckBox.setSelected(solo);
        this.propertyChangeSupport.firePropertyChange("solo", !this.soloCheckBox.isSelected(), this.soloCheckBox.isSelected());
        this.dockableFrame.setFrameIcon(solo ? ICON_SOLO : (this.show ? ICON_LAYERS : ICON_NOT_SHOWN));
    }

    boolean contains(Layer layer) {
        return this.layers.contains(layer);
    }

    void add(CustomLayer layer, List<Component> buttonComponents) {
        this.layers.add(layer);
        this.layerButtonComponents.put(layer, buttonComponents);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 23;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(1, 1, 1, 1);
        LayoutUtils.insertRowOfComponents(this.panel, constraints, this.panel.getComponentCount() - 3, buttonComponents);
    }

    List<Component> remove(CustomLayer layer) {
        if (this.layerButtonComponents.containsKey(layer)) {
            this.layers.remove(layer);
            List<Component> buttonComponents = this.layerButtonComponents.remove(layer);
            buttonComponents.forEach(this.panel::remove);
            return buttonComponents;
        }
        return null;
    }

    void activate(CustomLayer layer) {
        ((JToggleButton)this.layerButtonComponents.get(layer).get(2)).setSelected(true);
    }

    void deactivate(CustomLayer layer) {
        ((JToggleButton)this.layerButtonComponents.get(layer).get(2)).setSelected(false);
    }

    boolean isEmpty() {
        return this.layers.isEmpty();
    }

    DockableFrame getDockableFrame() {
        return this.dockableFrame;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

