/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.pepsoft.worldpainter.NoiseSettings;

public class NoiseSettingsTableCellRenderer
extends DefaultTableCellRenderer {
    public NoiseSettingsTableCellRenderer() {
        this.setHorizontalAlignment(11);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof NoiseSettings) {
            if (!isSelected) {
                this.setForeground(table.getForeground());
            }
            NoiseSettings noiseSettings = (NoiseSettings)value;
            this.setText(noiseSettings.getRange() + ", " + Math.round(noiseSettings.getScale() * 100.0f) + ", " + noiseSettings.getRoughness());
        } else {
            if (!isSelected) {
                this.setForeground(Color.GRAY);
            }
            this.setText("<html><i>no variation</i></html>");
        }
        return this;
    }
}

