/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.NoiseSettingsEditor;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;

public class NoiseSettingsDialog
extends WorldPainterDialog
implements ChangeListener {
    private JButton buttonCancel;
    private JButton buttonClear;
    private JButton buttonOk;
    private JLabel jLabel1;
    private JLabel labelPreview;
    private NoiseSettingsEditor noiseSettingsEditor1;
    private final int baseValue;

    public NoiseSettingsDialog(Window parent, NoiseSettings noiseSettings, int baseValue) {
        super(parent);
        this.baseValue = baseValue;
        this.initComponents();
        this.noiseSettingsEditor1.setNoiseSettings(noiseSettings);
        this.noiseSettingsEditor1.addChangeListener(this);
        this.labelPreview.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NoiseSettingsDialog.this.updatePreview();
            }
        });
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.updatePreview();
    }

    public NoiseSettings getNoiseSettings() {
        return this.noiseSettingsEditor1.getNoiseSettings();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updatePreview();
    }

    private void clear() {
        this.noiseSettingsEditor1.setNoiseSettings(new NoiseSettings(this.getNoiseSettings().getSeed(), 0, 0, 1.0f));
    }

    private void updatePreview() {
        Insets insets = this.labelPreview.getInsets();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.labelPreview.getWidth() - insets.left - insets.right, this.labelPreview.getHeight() - insets.top - insets.bottom);
        NoiseHeightMap noiseHeightMap = new NoiseHeightMap(this.noiseSettingsEditor1.getNoiseSettings(), 0L);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int value = (int)MathUtils.clamp((long)0L, (long)Math.round(((double)this.baseValue + noiseHeightMap.getValue((double)x, (double)y) - noiseHeightMap.getHeight() / 2.0) * 2.55), (long)255L);
                image.setRGB(x, y, 0xFF000000 | value << 16 | value << 8 | value);
            }
        }
        this.labelPreview.setIcon(new ImageIcon(image));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.noiseSettingsEditor1 = new NoiseSettingsEditor();
        this.labelPreview = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.buttonClear = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Adjust Noise Settings");
        this.setResizable(false);
        this.jLabel1.setText("Adjust the noise settings:");
        this.labelPreview.setBorder(BorderFactory.createBevelBorder(1));
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoiseSettingsDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoiseSettingsDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.buttonClear.setText("Clear");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoiseSettingsDialog.this.buttonClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPreview, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.noiseSettingsEditor1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noiseSettingsEditor1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPreview, -1, 119, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk).addComponent(this.buttonClear)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonClearActionPerformed(ActionEvent evt) {
        this.clear();
    }
}

