/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.beans.PropertyVetoException;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.Operation;
import org.pepsoft.worldpainter.tools.Eyedropper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapSelectionController {
    private final App app;
    private final WorldPainter view;
    private final Eyedropper eyedropper;
    private Eyedropper.SelectionListener paintSelectionListener;
    private boolean paintSelectionDrawBrushWasActive;
    private static final Logger logger = LoggerFactory.getLogger(MapSelectionController.class);

    MapSelectionController(App app, WorldPainter view) {
        this.app = app;
        this.view = view;
        this.eyedropper = new Eyedropper(view, app.getColourScheme(), app.getCustomBiomeManager());
    }

    void selectPaintOnMap(Set<Eyedropper.PaintType> paintTypes, final Eyedropper.SelectionListener paintSelectionListener) {
        String paintTypeDescription;
        if (this.paintSelectionListener != null) {
            throw new IllegalStateException("Paint selection already in progress");
        }
        this.paintSelectionListener = paintSelectionListener;
        if (paintTypes == null) {
            paintTypeDescription = "paint";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Eyedropper.PaintType paintType : paintTypes) {
                switch (paintType) {
                    case LAYER: {
                        if (sb.length() > 0) {
                            sb.append(" or ");
                        }
                        sb.append("layer");
                        break;
                    }
                    case TERRAIN: {
                        if (sb.length() > 0) {
                            sb.append(" or ");
                        }
                        sb.append("terrain type");
                        break;
                    }
                    case BIOME: {
                        if (sb.length() > 0) {
                            sb.append(" or ");
                        }
                        sb.append("biome");
                        break;
                    }
                    case ANNOTATION: {
                        if (paintTypes.contains((Object)Eyedropper.PaintType.LAYER)) break;
                        if (sb.length() > 0) {
                            sb.append(" or ");
                        }
                        sb.append("annotation colour");
                    }
                }
            }
            paintTypeDescription = sb.toString();
        }
        JLabel label = new JLabel("<html><font size='+1'>Click on the map to select a " + paintTypeDescription + ".<br>Press Esc to cancel.</font></html>");
        label.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(5, 5, 5, 5)));
        this.app.setGlassPaneComponent(label);
        Operation activeOperation = this.app.getActiveOperation();
        if (activeOperation != null) {
            try {
                activeOperation.setActive(false);
            }
            catch (PropertyVetoException e) {
                logger.error("Property veto exception while deactivating operation " + activeOperation, (Throwable)e);
            }
        }
        this.paintSelectionDrawBrushWasActive = this.view.isDrawBrush();
        if (this.paintSelectionDrawBrushWasActive) {
            this.view.setDrawBrush(false);
        }
        this.eyedropper.setCallback(new Eyedropper.SelectionListener(){

            @Override
            public void terrainSelected(Terrain terrain) {
                MapSelectionController.this.cancelPaintSelection(false, false);
                paintSelectionListener.terrainSelected(terrain);
            }

            @Override
            public void layerSelected(Layer layer, int value) {
                MapSelectionController.this.cancelPaintSelection(false, false);
                paintSelectionListener.layerSelected(layer, value);
            }

            @Override
            public void selectionCancelled(boolean byUser) {
            }
        });
        this.eyedropper.setPaintTypes(paintTypes);
        try {
            this.eyedropper.setActive(true);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Property veto exception while activating eyedropper", e);
        }
    }

    void cancelPaintSelection(boolean notifyListener, boolean cancelledByUser) {
        if (this.paintSelectionListener != null) {
            Operation activeOperation;
            Eyedropper.SelectionListener paintSelectionListener = this.paintSelectionListener;
            this.paintSelectionListener = null;
            this.app.removeGlassPaneComponent();
            this.eyedropper.setCallback(null);
            this.eyedropper.setPaintTypes(null);
            try {
                this.eyedropper.setActive(false);
            }
            catch (PropertyVetoException e) {
                logger.error("Property veto exception while deactivating eyedropper", (Throwable)e);
            }
            if (this.paintSelectionDrawBrushWasActive) {
                this.view.setDrawBrush(true);
            }
            if ((activeOperation = this.app.getActiveOperation()) != null) {
                try {
                    activeOperation.setActive(true);
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException("Property veto exception while activating " + activeOperation, e);
                }
            }
            if (notifyListener) {
                paintSelectionListener.selectionCancelled(cancelledByUser);
            }
        }
    }

    boolean isSelectionActive() {
        return this.paintSelectionListener != null;
    }
}

