/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.JButton;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.TaskbarProgressReceiver;
import org.pepsoft.util.Version;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.MultiProgressDialog;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldExporter;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.FileInUseException;

public class ExportProgressDialog
extends MultiProgressDialog<Map<Integer, ChunkFactory.Stats>>
implements WindowListener {
    private final World2 world;
    private final String name;
    private final File baseDir;
    private final WorldExportSettings exportSettings;
    private volatile File backupDir;
    private volatile boolean allowRetry = false;
    private static final long serialVersionUID = 1L;

    public ExportProgressDialog(Window parent, World2 world, WorldExportSettings exportSettings, File baseDir, String name) {
        super(parent, "Exporting");
        this.world = world;
        this.baseDir = baseDir;
        this.name = name;
        this.exportSettings = exportSettings;
        this.addWindowListener(this);
        JButton minimiseButton = new JButton("Minimize");
        minimiseButton.addActionListener(e -> App.getInstance().setState(1));
        this.addButton(minimiseButton);
    }

    public boolean isAllowRetry() {
        return this.allowRetry;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        DesktopUtils.setProgressDone((Window)App.getInstance());
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    protected String getVerb() {
        return "Export";
    }

    @Override
    protected String getResultsReport(Map<Integer, ChunkFactory.Stats> result, long duration) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>World exported as ").append(new File(this.baseDir, FileUtils.sanitiseName((String)this.name)));
        int hours = (int)(duration / 3600L);
        int minutes = (int)((duration -= (long)hours * 3600L) / 60L);
        int seconds = (int)(duration - (long)(minutes * 60));
        sb.append("<br>Export took ").append(hours).append(":").append(minutes < 10 ? "0" : "").append(minutes).append(":").append(seconds < 10 ? "0" : "").append(seconds);
        Platform platform = this.world.getPlatform();
        Version mcVersion = (Version)platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION);
        if (platform == DefaultPlugin.JAVA_MCREGION && this.world.getMaxHeight() != 128) {
            sb.append("<br><br>Please note: this map has a <b>non-standard height!</b> You need to have<br>an appropriate height mod installed to play it!");
        } else if (mcVersion.isAtLeast(Constants.V_1_17) && this.world.getMaxHeight() - this.world.getMinHeight() > 384) {
            sb.append("<br><br>Please note: this map is <b>more than 384 blocks</b> high.<br>This may cause performance problems on lower end computers.");
        }
        if (platform == DefaultPlugin.JAVA_ANVIL_1_17 && (this.world.getMinHeight() != 0 || this.world.getMaxHeight() != 256)) {
            sb.append("<br><br>Please note: <b>this map uses a data pack</b> for a deviating build height.<br>This data pack is only compatible with Minecraft 1.17.<br>It is not forward compatible with newer versions of Minecraft.");
        } else if (!(platform != DefaultPlugin.JAVA_ANVIL_1_18 && platform != DefaultPlugin.JAVA_ANVIL_1_19 || this.world.getMinHeight() == -64 && this.world.getMaxHeight() == 320)) {
            sb.append("<br><br>Please note: <b>this map uses a data pack</b> for a deviating build height.<br>This data pack is only compatible with Minecraft 1.18.2 - 1.19.4.<br>It may not be forward compatible with newer versions of Minecraft.");
        }
        if (result.size() == 1) {
            ChunkFactory.Stats stats = result.get(result.keySet().iterator().next());
            sb.append("<br><br>Statistics:<br>");
            this.dumpStats(sb, stats, this.world.getMaxHeight() - this.world.getMinHeight());
        } else {
            for (Map.Entry<Integer, ChunkFactory.Stats> entry : result.entrySet()) {
                int height;
                int dim = entry.getKey();
                ChunkFactory.Stats stats = entry.getValue();
                switch (dim) {
                    case 0: {
                        sb.append("<br><br>Statistics for surface:<br>");
                        height = this.world.getMaxHeight() - this.world.getMinHeight();
                        break;
                    }
                    case 1: {
                        sb.append("<br><br>Statistics for Nether:<br>");
                        height = 256;
                        break;
                    }
                    case 2: {
                        sb.append("<br><br>Statistics for End:<br>");
                        height = 256;
                        break;
                    }
                    default: {
                        sb.append("<br><br>Statistics for dimension " + dim + ":<br>");
                        height = this.world.getMaxHeight() - this.world.getMinHeight();
                    }
                }
                this.dumpStats(sb, stats, height);
            }
        }
        if (this.backupDir.isDirectory()) {
            sb.append("<br>Backup of existing map created in:<br>").append(this.backupDir);
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    protected String getCancellationMessage() {
        return "Export cancelled by user.\n\nThe partially exported map is now probably corrupted!\nYou should delete it, or export the map again." + (this.backupDir.isDirectory() ? "\n\nBackup of existing map created in:\n" + this.backupDir : "");
    }

    @Override
    protected ProgressTask<Map<Integer, ChunkFactory.Stats>> getTask() {
        return new ProgressTask<Map<Integer, ChunkFactory.Stats>>(){

            public String getName() {
                return "Exporting world " + ExportProgressDialog.this.name;
            }

            public Map<Integer, ChunkFactory.Stats> execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                progressReceiver = new TaskbarProgressReceiver((Window)App.getInstance(), progressReceiver);
                progressReceiver.setMessage("Exporting world " + ExportProgressDialog.this.name);
                WorldExporter exporter = PlatformManager.getInstance().getExporter(ExportProgressDialog.this.world, ExportProgressDialog.this.exportSettings);
                try {
                    ExportProgressDialog.this.backupDir = exporter.selectBackupDir(ExportProgressDialog.this.baseDir, ExportProgressDialog.this.name);
                    return exporter.export(ExportProgressDialog.this.baseDir, ExportProgressDialog.this.name, ExportProgressDialog.this.backupDir, progressReceiver);
                }
                catch (IOException e) {
                    throw new RuntimeException("I/O error while exporting world", e);
                }
                catch (RuntimeException e) {
                    if (ExceptionUtils.chainContains((Throwable)e, FileInUseException.class)) {
                        ExportProgressDialog.this.allowRetry = true;
                    }
                    throw e;
                }
            }
        };
    }

    private void dumpStats(StringBuilder sb, ChunkFactory.Stats stats, int height) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        long duration = stats.time / 1000L;
        if (stats.landArea > 0L) {
            sb.append("Land area: " + formatter.format(stats.landArea) + " blocks<br>");
        }
        if (stats.waterArea > 0L) {
            sb.append("Water or lava area: " + formatter.format(stats.waterArea) + " blocks<br>");
            if (stats.landArea > 0L) {
                sb.append("Total surface area: " + formatter.format(stats.landArea + stats.waterArea) + " blocks<br>");
            }
        }
        long totalBlocks = stats.surfaceArea * (long)height;
        if (duration > 0L) {
            sb.append("Generated " + formatter.format(totalBlocks) + " blocks, or " + formatter.format(totalBlocks / duration) + " blocks per second<br>");
            if (stats.size > 0L) {
                long kbPerSecond = stats.size / duration / 1024L;
                sb.append("Map size: " + formatter.format(stats.size / 1024L / 1024L) + " MB, or " + (kbPerSecond < 1024L ? formatter.format(kbPerSecond) + " KB" : formatter.format(kbPerSecond / 1024L) + " MB") + " per second<br>");
            }
        } else {
            sb.append("Generated " + formatter.format(totalBlocks) + " blocks<br>");
            if (stats.size > 0L) {
                sb.append("Map size: " + formatter.format(stats.size / 1024L / 1024L) + " MB<br>");
            }
        }
    }
}

