/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImagingOpException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.util.mdc.MDCWrappingException;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.App;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Main;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.util.ThreadUtils;
import org.pepsoft.worldpainter.vo.AttributeKeyVO;
import org.pepsoft.worldpainter.vo.EventVO;
import org.pepsoft.worldpainter.vo.ExceptionVO;
import org.pepsoft.worldpainter.vo.UsageVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDialog
extends JDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JTextArea jTextArea1;
    private String body;
    private EventVO event;
    private Mode mode = Mode.REPORTING_UNNECESSARY;
    private static final String[] SYSTEM_PROPERTIES = new String[]{"java.version", "java.vendor", "java.vm.version", "java.vm.vendor", "java.vm.name", "os.name", "os.arch", "os.version", "user.home", "user.dir", "user.country", "user.language"};
    private static final Logger logger = LoggerFactory.getLogger(ErrorDialog.class);
    private static final long serialVersionUID = 1L;

    public ErrorDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.init(parent);
    }

    public void setException(Throwable exception) {
        int i;
        boolean ioException;
        TreeMap<String, String> mdcContextMap = new TreeMap<String, String>(MDCUtils.gatherMdcContext((Throwable)exception));
        if (exception instanceof MDCWrappingException || exception instanceof MDCWrappingRuntimeException) {
            exception = exception.getCause();
        }
        UUID uuid = UUID.randomUUID();
        logger.error("[" + uuid + "] " + exception.getClass().getSimpleName() + ": " + exception.getMessage(), exception);
        this.event = new EventVO("exception");
        this.event.addTimestamp();
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_EXCEPTION, (Serializable)new ExceptionVO(exception));
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_UUID, (Serializable)((Object)uuid.toString()));
        HashSet exceptionTypes = new HashSet();
        exceptionTypes.add(exception.getClass());
        Throwable rootCause = exception;
        String ioExceptionMessage = exception instanceof IOException ? exception.getMessage() : null;
        boolean forceEmail = ErrorDialog.forceEmail(exception);
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
            exceptionTypes.add(rootCause.getClass());
            if (rootCause instanceof IOException) {
                ioExceptionMessage = rootCause.getMessage();
            }
            if (!ErrorDialog.forceEmail(rootCause)) continue;
            forceEmail = true;
        }
        boolean bl = ioException = ioExceptionMessage != null;
        if (exceptionTypes.contains(OutOfMemoryError.class)) {
            this.setTitle("Out of Memory");
            Integer threadCount = ThreadUtils.getMostRecentThreadCount();
            if (threadCount != null && threadCount > 1) {
                this.jTextArea1.setText("Not enough memory available for that operation!\n\nIf this happened during an Export or Merge operation,\ntry reducing the maximum thread count to " + (threadCount - 1) + " on the\nPerformance tab of the Preferences screen.");
            } else {
                this.jTextArea1.setText("Not enough memory available for that operation!\n\nWorldPainter is already using the recommended maximum\namount of memory, so it is not recommended to give it\nmore. To be able to perform the operation you should\ninstall more memory (and reinstall WorldPainter).");
            }
            this.jButton1.setEnabled(false);
            this.jButton1.setToolTipText("Not necessary to send details of out of memory errors");
            this.jButton3.setEnabled(false);
        } else {
            String requestedActionLine;
            String message;
            String string = message = ioExceptionMessage != null ? ioExceptionMessage : rootCause.getMessage();
            if (message != null && message.length() > 250) {
                message = message.substring(0, 247) + "...";
            }
            if (Main.privateContext != null && !forceEmail) {
                Configuration config = Configuration.getInstance();
                if (config != null && Boolean.TRUE.equals(config.getPingAllowed()) && !ioException) {
                    this.mode = Mode.SEND_AUTOMATICALLY;
                    requestedActionLine = "The details of this error are being automatically submitted to the creator of this program.";
                } else {
                    this.mode = Mode.SEND_MANUALLY;
                    requestedActionLine = ioException ? "If you think this is a bug then please use the Send Report button below to send the details of this error to the creator of this program." : "Please help debug the problem by using the Send Report button below to send the details of this error to the creator of this program.";
                }
            } else {
                this.jButton1.setText("Email Details...");
                if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                    this.jButton1.setToolTipText("Emailing not supported on this system; please use the \"copy to clipboard\" button and mail the details to worldpainter@pepsoft.org.");
                } else {
                    this.jButton1.setEnabled(true);
                }
                this.mode = Mode.REPORTING_DISABLED;
                requestedActionLine = ioException ? "If you think this is a bug then please use the button below to email the details of this error to the creator of this program." : "Please help debug the problem by using the button below to email the details of this error to the creator of this program.";
            }
            String text = ioException ? "A read or write error has occurred.\n\nMessage: " + message + "\n\n" + requestedActionLine : "An unexpected error has occurred.\n\nType: " + rootCause.getClass().getName() + "\nMessage: " + message + "\n\n" + requestedActionLine + "\n\nThe program may now be in an unstable state. It is recommended to restart it as soon as possible.";
            this.jTextArea1.setText(text);
        }
        this.pack();
        StringBuilder sb = new StringBuilder();
        String eol = System.getProperty("line.separator");
        sb.append(exception.getClass().getName()).append(": ").append(exception.getMessage()).append(eol);
        StackTraceElement[] stackTrace = exception.getStackTrace();
        for (i = 0; i < Math.min(stackTrace.length, 10); ++i) {
            sb.append("\tat " + stackTrace[i].getClassName() + '.' + stackTrace[i].getMethodName() + '(' + stackTrace[i].getFileName() + ':' + stackTrace[i].getLineNumber() + ')' + eol);
        }
        sb.append(eol);
        if (rootCause != exception) {
            sb.append("Root cause:" + eol);
            sb.append(rootCause.getClass().getName() + ": " + rootCause.getMessage() + eol);
            stackTrace = rootCause.getStackTrace();
            for (i = 0; i < Math.min(stackTrace.length, 5); ++i) {
                sb.append("\tat " + stackTrace[i].getClassName() + '.' + stackTrace[i].getMethodName() + '(' + stackTrace[i].getFileName() + ':' + stackTrace[i].getLineNumber() + ')' + eol);
            }
            sb.append(eol);
        }
        if (!mdcContextMap.isEmpty()) {
            sb.append("Diagnostic context:" + eol);
            mdcContextMap.forEach((key, value) -> sb.append("\t" + key + ": " + value + eol));
            sb.append(eol);
            mdcContextMap.forEach((key, value) -> this.event.setAttribute(new AttributeKeyVO("mdc." + key), (Serializable)((Object)value)));
        }
        sb.append("WorldPainter version: " + Version.VERSION + " (" + Version.BUILD + ")" + eol);
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_VERSION, (Serializable)((Object)Version.VERSION));
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_BUILD, (Serializable)((Object)Version.BUILD));
        sb.append(eol);
        for (String propertyName : SYSTEM_PROPERTIES) {
            sb.append(propertyName + ": " + System.getProperty(propertyName) + eol);
            this.event.setAttribute(new AttributeKeyVO("systemProperty." + propertyName), (Serializable)((Object)System.getProperty(propertyName)));
        }
        sb.append(eol);
        Runtime runtime = Runtime.getRuntime();
        sb.append("Free memory: " + runtime.freeMemory() + " bytes" + eol);
        sb.append("Total memory size: " + runtime.totalMemory() + " bytes" + eol);
        sb.append("Max memory size: " + runtime.maxMemory() + " bytes" + eol);
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_FREE_MEMORY, (Serializable)Long.valueOf(runtime.freeMemory()));
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_TOTAL_MEMORY, (Serializable)Long.valueOf(runtime.totalMemory()));
        this.event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_MEMORY, (Serializable)Long.valueOf(runtime.maxMemory()));
        try {
            Dimension dimension;
            App app = App.getInstanceIfExists();
            World2 world = app != null ? app.getWorld() : null;
            Dimension dimension2 = dimension = app != null ? app.getDimension() : null;
            if (world != null && dimension != null) {
                sb.append(eol);
                sb.append("World name: " + world.getName() + eol);
                sb.append("Platform: " + world.getPlatform().displayName + " (" + world.getPlatform().id + ')' + eol);
                sb.append("Seed: " + dimension.getSeed() + eol);
                sb.append("Bounds: " + dimension.getLowestX() + ", " + dimension.getLowestY() + " => " + dimension.getHighestX() + ", " + dimension.getHighestY() + eol);
                sb.append("Height: " + world.getMaxHeight() + eol);
                sb.append("Number of tiles: " + dimension.getTileCount() + eol);
                Set layers = dimension.getAllLayers(false);
                sb.append("Layers in use: ");
                boolean first = true;
                for (Layer layer : layers) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(layer.getName());
                }
                sb.append(eol);
                sb.append("Border: " + dimension.getBorder() + " @ " + dimension.getBorderLevel() + eol);
                sb.append("Sub surface material: " + dimension.getSubsurfaceMaterial() + eol);
                TileFactory tileFactory = dimension.getTileFactory();
                if (tileFactory instanceof HeightMapTileFactory) {
                    HeightMapTileFactory heightMapTileFactory = (HeightMapTileFactory)tileFactory;
                    sb.append("Water height: " + heightMapTileFactory.getWaterHeight() + eol);
                }
                if (world.getImportedFrom() != null) {
                    sb.append("World imported from " + world.getImportedFrom() + eol);
                }
                if (!world.isAllowMerging()) {
                    sb.append("World created in old coordinate system" + eol);
                }
            }
            if (app != null) {
                sb.append(eol);
                sb.append("Operation: " + app.getActiveOperation() + eol);
                sb.append("Radius: " + app.getRadius() + eol);
                sb.append("Brush: " + app.getBrush() + "/" + app.getToolBrush() + eol);
                sb.append("Level: " + app.getLevel() + "/" + app.getToolLevel() + eol);
                sb.append("Zoom: " + app.getZoom() + eol);
                sb.append("Hidden layers: " + app.getHiddenLayers());
            }
        }
        catch (Throwable t) {
            logger.error("Secondary exception occurred while interrogating app for exception report", t);
        }
        this.body = sb.toString();
        if (!"true".equals(System.getProperty("org.pepsoft.worldpainter.devMode"))) {
            logger.error(this.body);
        }
        if (this.mode == Mode.SEND_AUTOMATICALLY) {
            this.submitInBackground();
        }
    }

    private void init(Window parent) {
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButton2);
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.dispose();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        GUIUtils.scaleToUI((Container)this);
        this.setLocationRelativeTo(parent);
    }

    private void close() {
        this.dispose();
    }

    private void email() {
        try {
            URI uri = new URI("mailto", "worldpainter@pepsoft.org?subject=WorldPainter error report&body=" + this.body, null);
            Desktop desktop = Desktop.getDesktop();
            desktop.mail(uri);
            MessageUtils.showInfo((Component)this, (String)"A new email message should have been opened now for you to send.\nIf it did not work, please use the \"copy to clipboard\" button\nand manually mail the information to worldpainter@pepsoft.org.", (String)"Email Created");
        }
        catch (URISyntaxException e) {
            logger.error("URI syntax error while trying to send email", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Could not create email message with error details!\nPlease use the \"copy to clipboard\" button and mail\nthe information to worldpainter@pepsoft.org.", "Could Not Create Email", 0);
        }
        catch (IOException e) {
            logger.error("I/O error while trying to send email", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Could not create email message with error details!\nPlease use the \"copy to clipboard\" button and mail\nthe information to worldpainter@pepsoft.org.", "Could Not Create Email", 0);
        }
    }

    private void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this.body);
        clipboard.setContents(data, data);
        MessageUtils.showInfo((Component)this, (String)"The information has been copied to the clipboard. Please paste\nit in a new email and send it to worldpainter@pepsoft.org.", (String)"Information Copied");
    }

    private void submitInBackground() {
        this.jButton1.setText("Sending...");
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        new Thread("Exception Submitter"){

            @Override
            public void run() {
                try {
                    UsageVO usageVO = new UsageVO();
                    usageVO.setEvents(Collections.singletonList(ErrorDialog.this.event));
                    Configuration config = Configuration.getInstance();
                    usageVO.setLaunchCount(config.getLaunchCount());
                    usageVO.setInstall(config.getUuid());
                    usageVO.setWPVersion(Version.VERSION);
                    Main.privateContext.submitUsageData(usageVO, true);
                    AwtUtils.doOnEventThread(() -> {
                        ErrorDialog.this.jButton1.setText("Report Sent");
                        ErrorDialog.this.jButton2.setEnabled(true);
                    });
                }
                catch (RuntimeException e) {
                    logger.error("{} while trying to submit exception report to server (message: {})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
                    AwtUtils.doOnEventThread(() -> {
                        JOptionPane.showMessageDialog(ErrorDialog.this, "Submitting error report failed.\nPlease use the \"Email Details...\" button below\nto email the report.");
                        ErrorDialog.this.jButton1.setText("Email Details...");
                        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                            ErrorDialog.this.jButton1.setToolTipText("Emailing not supported on this system; please use the \"copy to clipboard\" button and mail the details to worldpainter@pepsoft.org.");
                        } else {
                            ErrorDialog.this.jButton1.setEnabled(true);
                        }
                        ErrorDialog.this.mode = Mode.REPORTING_DISABLED;
                        ErrorDialog.this.jButton2.setEnabled(true);
                    });
                }
            }
        }.start();
    }

    private static boolean forceEmail(Throwable exception) {
        String message = exception.getMessage();
        return message != null && (message.contains("terrainRanges contains null value") || message.contains("terrainRanges may not contain null values") || message.contains("aValue (rowIndex: ") || message.contains("Index -4 out of bounds for length 20") || exception instanceof IllegalArgumentException && message.equals("Comparison method violates its general contract!") || exception instanceof ImagingOpException && message.equals("Unable to transform src image"));
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextArea1 = new JTextArea();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Unexpected Error");
        this.jButton1.setText("Send Report");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Close");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(this.getFont());
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(10);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        this.jButton3.setText("Copy details to clipboard");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextArea1, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTextArea1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        switch (this.mode) {
            case REPORTING_DISABLED: {
                this.email();
                break;
            }
            case SEND_MANUALLY: {
                this.submitInBackground();
                break;
            }
            default: {
                throw new IllegalStateException("mode " + (Object)((Object)this.mode));
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.copyToClipboard();
    }

    static enum Mode {
        REPORTING_UNNECESSARY,
        SEND_AUTOMATICALLY,
        SEND_MANUALLY,
        REPORTING_DISABLED;

    }
}

