/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.Lists;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideLabel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MacUtils;
import org.pepsoft.util.ObservableBoolean;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.util.swing.RemoteJCheckBox;
import org.pepsoft.util.swing.TiledImageViewerContainer;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.AboutDialog;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ChangeHeightDialog;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.ConfigureViewDialog;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.CustomMaterialDialog;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.DeleteLayersDialog;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.DimensionPropertiesDialog;
import org.pepsoft.worldpainter.EventLogger;
import org.pepsoft.worldpainter.ExportWorldDialog;
import org.pepsoft.worldpainter.FillDialog;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.GlassPane;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.ImportHeightMapDialog;
import org.pepsoft.worldpainter.LoadWorldTask;
import org.pepsoft.worldpainter.Main;
import org.pepsoft.worldpainter.MainFrame;
import org.pepsoft.worldpainter.MapDragControl;
import org.pepsoft.worldpainter.MapSelectionController;
import org.pepsoft.worldpainter.MergeWorldDialog;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialHelper;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.MouseAdapter;
import org.pepsoft.worldpainter.NewWorldDialog;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Palette;
import org.pepsoft.worldpainter.PaletteManager;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.PreferencesDialog;
import org.pepsoft.worldpainter.RadiusControl;
import org.pepsoft.worldpainter.RotateWorldDialog;
import org.pepsoft.worldpainter.ScaleWorldDialog;
import org.pepsoft.worldpainter.ShiftWorldDialog;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileEditor;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldIO;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.biomeschemes.BiomeHelper;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.brushes.BitmapBrush;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.brushes.RotatedBrush;
import org.pepsoft.worldpainter.brushes.SymmetricBrush;
import org.pepsoft.worldpainter.dnd.WPTransferHandler;
import org.pepsoft.worldpainter.dynmap.DynmapColourScheme;
import org.pepsoft.worldpainter.exporting.HeightMapExporter;
import org.pepsoft.worldpainter.gardenofeden.GardenOfEdenOperation;
import org.pepsoft.worldpainter.history.WorldHistoryDialog;
import org.pepsoft.worldpainter.importing.CustomItemsTreeModel;
import org.pepsoft.worldpainter.importing.ImportCustomItemsDialog;
import org.pepsoft.worldpainter.importing.ImportMaskDialog;
import org.pepsoft.worldpainter.importing.MapImportDialog;
import org.pepsoft.worldpainter.layers.AbstractEditLayerDialog;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.BiomesPanel;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.CombinedLayer;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.EditLayerDialog;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.GardenCategory;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerContainer;
import org.pepsoft.worldpainter.layers.LayerManager;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.layers.Populate;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.exporters.AnnotationsExporter;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.layers.plants.PlantLayerEditor;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsDialog;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayer;
import org.pepsoft.worldpainter.layers.renderers.VoidRenderer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerDialog;
import org.pepsoft.worldpainter.operations.BrushOperation;
import org.pepsoft.worldpainter.operations.Fill;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.operations.Flatten;
import org.pepsoft.worldpainter.operations.Flood;
import org.pepsoft.worldpainter.operations.Height;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.operations.Operation;
import org.pepsoft.worldpainter.operations.OperationManager;
import org.pepsoft.worldpainter.operations.PaintOperation;
import org.pepsoft.worldpainter.operations.Pencil;
import org.pepsoft.worldpainter.operations.RadiusOperation;
import org.pepsoft.worldpainter.operations.RaiseMountain;
import org.pepsoft.worldpainter.operations.RaisePyramid;
import org.pepsoft.worldpainter.operations.RaiseRotatedPyramid;
import org.pepsoft.worldpainter.operations.SetSpawnPoint;
import org.pepsoft.worldpainter.operations.Smooth;
import org.pepsoft.worldpainter.operations.Sponge;
import org.pepsoft.worldpainter.operations.SprayPaint;
import org.pepsoft.worldpainter.operations.Text;
import org.pepsoft.worldpainter.painting.LayerPaint;
import org.pepsoft.worldpainter.painting.Paint;
import org.pepsoft.worldpainter.painting.PaintFactory;
import org.pepsoft.worldpainter.painting.TerrainPaint;
import org.pepsoft.worldpainter.panels.BrushOptions;
import org.pepsoft.worldpainter.panels.DefaultFilter;
import org.pepsoft.worldpainter.panels.InfoPanel;
import org.pepsoft.worldpainter.plugins.CustomLayerProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.ramps.ColourGradient;
import org.pepsoft.worldpainter.ramps.ColourRamp;
import org.pepsoft.worldpainter.ramps.DefaultColourRamp;
import org.pepsoft.worldpainter.selection.CopySelectionOperation;
import org.pepsoft.worldpainter.selection.EditSelectionOperation;
import org.pepsoft.worldpainter.selection.SelectionBlock;
import org.pepsoft.worldpainter.selection.SelectionChunk;
import org.pepsoft.worldpainter.selection.SelectionHelper;
import org.pepsoft.worldpainter.threedeeview.ThreeDeeFrame;
import org.pepsoft.worldpainter.tools.BiomesViewerFrame;
import org.pepsoft.worldpainter.tools.Eyedropper;
import org.pepsoft.worldpainter.tools.RespawnPlayerDialog;
import org.pepsoft.worldpainter.tools.scripts.ScriptRunner;
import org.pepsoft.worldpainter.util.BackupUtils;
import org.pepsoft.worldpainter.util.BetterAction;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;
import org.pepsoft.worldpainter.util.LayoutUtils;
import org.pepsoft.worldpainter.util.LazyLoadingIconToggleButton;
import org.pepsoft.worldpainter.util.WorldUtils;
import org.pepsoft.worldpainter.vo.AttributeKeyVO;
import org.pepsoft.worldpainter.vo.EventVO;
import org.pepsoft.worldpainter.vo.UsageVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class App
extends JFrame
implements RadiusControl,
BiomesViewerFrame.SeedListener,
BrushOptions.Listener,
CustomBiomeManager.CustomBiomeListener,
PaletteManager.ButtonProvider,
DockableHolder,
PropertyChangeListener,
Dimension.Listener,
Tile.Listener {
    public final IntensityAction ACTION_INTENSITY_10_PERCENT = new IntensityAction(2, 49);
    public final IntensityAction ACTION_INTENSITY_20_PERCENT = new IntensityAction(16, 50);
    public final IntensityAction ACTION_INTENSITY_30_PERCENT = new IntensityAction(23, 51);
    public final IntensityAction ACTION_INTENSITY_40_PERCENT = new IntensityAction(37, 52);
    public final IntensityAction ACTION_INTENSITY_50_PERCENT = new IntensityAction(51, 53);
    public final IntensityAction ACTION_INTENSITY_60_PERCENT = new IntensityAction(58, 54);
    public final IntensityAction ACTION_INTENSITY_70_PERCENT = new IntensityAction(65, 55);
    public final IntensityAction ACTION_INTENSITY_80_PERCENT = new IntensityAction(79, 56);
    public final IntensityAction ACTION_INTENSITY_90_PERCENT = new IntensityAction(86, 57);
    public final IntensityAction ACTION_INTENSITY_100_PERCENT = new IntensityAction(100, 48);
    private final BetterAction ACTION_NEW_WORLD = new BetterAction("newWorld", strings.getString("new.world") + "...", ICON_NEW_WORLD, false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(78, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("create.a.new.world"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.newWorld();
        }
    };
    private final BetterAction ACTION_OPEN_WORLD = new BetterAction("openWorld", strings.getString("open.world") + "...", ICON_OPEN_WORLD, false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(79, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("open.an.existing.worldpainter.world"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.open();
        }
    };
    private final BetterAction ACTION_SAVE_WORLD = new BetterAction("saveWorld", strings.getString("save.world") + "...", ICON_SAVE_WORLD, false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(83, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("save.the.world.as.a.worldpainter.file.to.the.previously.used.file"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.save();
        }
    };
    private final BetterAction ACTION_SAVE_WORLD_AS = new BetterAction("saveWorldAs", strings.getString("save.world.as") + "...", ICON_SAVE_WORLD, false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(83, PLATFORM_COMMAND_MASK | 0x40));
            this.setShortDescription(strings.getString("save.the.world.as.a.worldpainter.file"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.saveAs();
        }
    };
    private final BetterAction ACTION_EXPORT_WORLD = new BetterAction("exportAsMinecraftMap", strings.getString("export.as.minecraft.map") + "...", ICON_EXPORT_WORLD, false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(69, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("export.the.world.to.a.minecraft.map"));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.world == null) {
                DesktopUtils.beep();
                return;
            }
            App.this.pauseAutosave();
            try {
                if (App.this.world.getImportedFrom() != null) {
                    DesktopUtils.beep();
                    if (JOptionPane.showConfirmDialog(App.this, strings.getString("this.is.an.imported.world"), strings.getString("imported"), 0, 2) != 0) {
                        return;
                    }
                }
                App.this.saveCustomBiomes();
                App.this.saveCustomLayers();
                ExportWorldDialog dialog = new ExportWorldDialog(App.this, App.this.world, App.this.selectedColourScheme, App.this.customBiomeManager, App.this.hiddenLayers, false, 10, App.this.view.getLightOrigin(), App.this.view);
                dialog.setVisible(() -> {
                    App.this.view.refreshTiles();
                    if (App.this.threeDeeFrame != null) {
                        App.this.threeDeeFrame.refresh();
                    }
                });
            }
            finally {
                App.this.resumeAutosave();
            }
        }
    };
    private final BetterAction ACTION_IMPORT_MAP = new BetterAction("importMinecraftMap", strings.getString("existing.minecraft.map") + "...", false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(73, PLATFORM_COMMAND_MASK));
            this.setShortDescription("Import the landscape of an existing Minecraft map. Use Merge to merge your changes.");
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.importWorld();
        }
    };
    private final BetterAction ACTION_MERGE_WORLD = new BetterAction("mergeWorld", strings.getString("merge.world") + "...", false){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(82, PLATFORM_COMMAND_MASK));
            this.setShortDescription("Merge the changes in a previously Imported world back to the original Minecraft map.");
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.world == null || App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            App.this.merge();
        }
    };
    private final BetterAction ACTION_EXIT = new BetterAction("exit", strings.getString("exit") + "...", ICON_EXIT){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("shut.down.worldpainter"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.exit();
        }
    };
    private final BetterAction ACTION_ZOOM_IN = new BetterAction("zoomIn", strings.getString("zoom.in"), ICON_ZOOM_IN){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(107, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("zoom.in"));
        }

        @Override
        public void performAction(ActionEvent e) {
            int zoom = App.this.view.getZoom() + 1;
            App.this.view.setZoom(zoom);
            App.this.updateZoomLabel();
            if (zoom == 6) {
                this.setEnabled(false);
            }
            App.this.ACTION_ZOOM_OUT.setEnabled(true);
            App.this.ACTION_ZOOM_RESET.setEnabled(zoom != 0);
        }
    };
    private final BetterAction ACTION_ZOOM_RESET = new BetterAction("resetZoom", strings.getString("reset.zoom"), ICON_ZOOM_RESET){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(48, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("reset.the.zoom.level.to.1.1"));
            this.setEnabled(false);
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.resetZoom();
            App.this.updateZoomLabel();
            App.this.ACTION_ZOOM_IN.setEnabled(true);
            App.this.ACTION_ZOOM_OUT.setEnabled(true);
            this.setEnabled(false);
        }
    };
    private final BetterAction ACTION_ZOOM_OUT = new BetterAction("zoomOut", strings.getString("zoom.out"), ICON_ZOOM_OUT){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(109, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("zoom.out"));
        }

        @Override
        public void performAction(ActionEvent e) {
            int zoom = App.this.view.getZoom() - 1;
            App.this.view.setZoom(zoom);
            App.this.updateZoomLabel();
            if (zoom == -4) {
                this.setEnabled(false);
            }
            App.this.ACTION_ZOOM_IN.setEnabled(true);
            App.this.ACTION_ZOOM_RESET.setEnabled(zoom != 0);
        }
    };
    private final BetterAction ACTION_GRID = new BetterAction("grid", strings.getString("grid"), ICON_GRID){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("enable.or.disable.the.grid"));
            this.setSelected(false);
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            App.this.view.setPaintGrid(!App.this.view.isPaintGrid());
            App.this.dimension.setGridEnabled(App.this.view.isPaintGrid());
            this.setSelected(App.this.view.isPaintGrid());
        }
    };
    private final BetterAction ACTION_CONTOURS = new BetterAction("contours", strings.getString("contours"), ICON_CONTOURS){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("enable.or.disable.height.contours"));
            this.setSelected(false);
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            App.this.view.setDrawContours(!App.this.view.isDrawContours());
            App.this.dimension.setContoursEnabled(App.this.view.isDrawContours());
            this.setSelected(App.this.view.isDrawContours());
        }
    };
    private final BetterAction ACTION_OVERLAYS = new BetterAction("overlay", strings.getString("overlay"), ICON_OVERLAY){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("enable.or.disable.image.overlay"));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            if (App.this.dimension.isOverlaysEnabled()) {
                App.this.dimension.setOverlaysEnabled(false);
                this.setSelected(false);
            } else if (!App.this.dimension.getOverlays().isEmpty() && App.this.dimension.getOverlays().stream().anyMatch(Overlay::isEnabled)) {
                App.this.dimension.setOverlaysEnabled(true);
                this.setSelected(true);
            } else if (App.this.dimension.getOverlays().size() == 1) {
                ((Overlay)App.this.dimension.getOverlays().get(0)).setEnabled(true);
                App.this.dimension.setOverlaysEnabled(true);
                this.setSelected(true);
            } else {
                ConfigureViewDialog dialog = new ConfigureViewDialog((Frame)App.this, App.this.dimension, App.this.view, true);
                dialog.setVisible(true);
                this.setSelected(App.this.dimension.isOverlaysEnabled());
                App.this.ACTION_GRID.setSelected(App.this.view.isPaintGrid());
                App.this.ACTION_CONTOURS.setSelected(App.this.view.isDrawContours());
            }
        }
    };
    private final BetterAction ACTION_UNDO = new BetterAction("undo", strings.getString("undo"), ICON_UNDO){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(90, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("undo.the.most.recent.action"));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.currentUndoManager != null && App.this.currentUndoManager.undo()) {
                App.this.currentUndoManager.armSavePoint();
            } else {
                DesktopUtils.beep();
            }
        }
    };
    private final BetterAction ACTION_REDO = new BetterAction("redo", strings.getString("redo"), ICON_REDO){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(89, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("redo.the.most.recent.action"));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.currentUndoManager != null && App.this.currentUndoManager.redo()) {
                App.this.currentUndoManager.armSavePoint();
            } else {
                DesktopUtils.beep();
            }
        }
    };
    private final BetterAction ACTION_EDIT_TILES = new BetterAction("editTiles", strings.getString("add.remove.tiles") + "...", ICON_EDIT_TILES){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(84, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("add.or.remove.tiles"));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            App.this.addRemoveTiles();
        }
    };
    private final BetterAction ACTION_CHANGE_HEIGHT = new BetterAction("changeHeight", strings.getString("change.height") + "...", ICON_CHANGE_HEIGHT){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("raise.or.lower.the.entire.map"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.changeWorldHeight(App.this);
        }
    };
    private final BetterAction ACTION_ROTATE_WORLD = new BetterAction("rotate", strings.getString("rotate") + "...", ICON_ROTATE_WORLD){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("rotate.the.entire.map.by.quarter.turns"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.rotateWorld(App.this);
        }
    };
    private final BetterAction ACTION_SHIFT_WORLD = new BetterAction("shift", "Shift...", ICON_SHIFT_WORLD){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Shift the entire map horizontally by whole 128-block tiles");
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.shiftWorld(App.this);
        }
    };
    private final BetterAction ACTION_SCALE_WORLD = new BetterAction("scale", "Scale...", ICON_SCALE_WORLD){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription("Scale the entire map up or down by an arbitrary amount");
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.scaleWorld(App.this);
        }
    };
    private final BetterAction ACTION_DIMENSION_PROPERTIES = new BetterAction("dimensionProperties", strings.getString("dimension.properties") + "...", ICON_DIMENSION_PROPERTIES){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(80, PLATFORM_COMMAND_MASK));
            this.setShortDescription(strings.getString("edit.the.properties.of.this.dimension"));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            boolean previousCoverSteepTerrain = App.this.dimension.isCoverSteepTerrain();
            int previousTopLayerMinDepth = App.this.dimension.getTopLayerMinDepth();
            int previousTopLayerVariation = App.this.dimension.getTopLayerVariation();
            Dimension.Border previousBorder = App.this.dimension.getBorder();
            int previousBorderSize = App.this.dimension.getBorderSize();
            long previousMinecraftSeed = App.this.dimension.getMinecraftSeed();
            int previousCeilingHeight = App.this.dimension.getCeilingHeight();
            Dimension.WallType previousWallType = App.this.dimension.getWallType();
            World2.BorderSettings previousBorderSettings = App.this.dimension.getWorld() != null ? App.this.dimension.getWorld().getBorderSettings().clone() : null;
            Dimension.LayerAnchor previousTopLayerAnchor = App.this.dimension.getTopLayerAnchor();
            boolean previousAnnotationsExport = App.this.dimension.getLayerSettings((Layer)Annotations.INSTANCE) != null && ((AnnotationsExporter.AnnotationsSettings)App.this.dimension.getLayerSettings((Layer)Annotations.INSTANCE)).isExport();
            DimensionPropertiesDialog dialog = new DimensionPropertiesDialog((Window)App.this, App.this.dimension, App.this.selectedColourScheme);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                if (App.this.threeDeeFrame != null) {
                    boolean newAnnotationsExport;
                    boolean bl = newAnnotationsExport = App.this.dimension.getLayerSettings((Layer)Annotations.INSTANCE) != null && ((AnnotationsExporter.AnnotationsSettings)App.this.dimension.getLayerSettings((Layer)Annotations.INSTANCE)).isExport();
                    if (App.this.dimension.isCoverSteepTerrain() != previousCoverSteepTerrain || App.this.dimension.getTopLayerMinDepth() != previousTopLayerMinDepth || App.this.dimension.getTopLayerVariation() != previousTopLayerVariation || App.this.dimension.getTopLayerAnchor() != previousTopLayerAnchor || newAnnotationsExport != previousAnnotationsExport) {
                        App.this.threeDeeFrame.refresh();
                    }
                }
                if (App.this.dimension.getBorder() != previousBorder || App.this.dimension.getBorder() != null && App.this.dimension.getBorderSize() != previousBorderSize || App.this.dimension.getMinecraftSeed() != previousMinecraftSeed || App.this.dimension.getCeilingHeight() != previousCeilingHeight || App.this.dimension.getWallType() != previousWallType || App.this.dimension.getTopLayerAnchor() != previousTopLayerAnchor) {
                    App.this.view.refreshTiles();
                }
                if (previousBorderSettings != null && !previousBorderSettings.equals((Object)App.this.dimension.getWorld().getBorderSettings())) {
                    App.this.view.repaint();
                }
            }
        }
    };
    private final BetterAction ACTION_VIEW_DISTANCE = new BetterAction("viewDistance", strings.getString("view.distance"), ICON_VIEW_DISTANCE){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("enable.or.disable.showing.the.maximum.far.view.distance"));
            this.setSelected(false);
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.setDrawViewDistance(!App.this.view.isDrawViewDistance());
            this.setSelected(App.this.view.isDrawViewDistance());
        }
    };
    private final BetterAction ACTION_WALKING_DISTANCE = new BetterAction("walkingDistances", strings.getString("walking.distances"), ICON_WALKING_DISTANCE){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("enable.or.disable.showing.the.walking.distances"));
            this.setSelected(false);
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.setDrawWalkingDistance(!App.this.view.isDrawWalkingDistance());
            this.setSelected(App.this.view.isDrawWalkingDistance());
        }
    };
    private final BetterAction ACTION_ROTATE_LIGHT_RIGHT = new BetterAction("rotateLightClockwise", strings.getString("rotate.light.clockwise"), ICON_ROTATE_LIGHT_RIGHT){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(82, 0));
            this.setShortDescription(strings.getString("rotate.the.direction.the.light.comes.from.clockwise"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.rotateLightRight();
        }
    };
    private final BetterAction ACTION_ROTATE_LIGHT_LEFT = new BetterAction("rotateLightAnticlockwise", strings.getString("rotate.light.anticlockwise"), ICON_ROTATE_LIGHT_LEFT){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(76, 0));
            this.setShortDescription(strings.getString("rotate.the.direction.the.light.comes.from.anticlockwise"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.rotateLightLeft();
        }
    };
    private final BetterAction ACTION_MOVE_TO_SPAWN = new BetterAction("moveToSpawn", strings.getString("move.to.spawn"), ICON_MOVE_TO_SPAWN){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("move.the.view.to.the.spawn.point"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.moveToSpawn();
        }
    };
    private final BetterAction ACTION_MOVE_TO_ORIGIN = new BetterAction("moveToOrigin", strings.getString("move.to.origin"), ICON_MOVE_TO_ORIGIN){
        private static final long serialVersionUID = 1L;
        {
            this.setShortDescription(strings.getString("move.the.view.to.the.origin.coordinates.0.0"));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.view.moveToOrigin();
        }
    };
    private final BetterAction ACTION_OPEN_DOCUMENTATION = new BetterAction("browseDocumentation", strings.getString("browse.documentation")){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(112, 0));
        }

        @Override
        public void performAction(ActionEvent event) {
            try {
                DesktopUtils.open((URL)new URL("https://www.worldpainter.net/doc/"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final BetterAction ACTION_IMPORT_LAYER = new BetterAction("importLayer", "Import custom layer(s)"){
        private static final long serialVersionUID = 1L;

        @Override
        protected void performAction(ActionEvent e) {
            App.this.importLayers(null, App.this.getLayerFilterForCurrentDimension());
        }
    };
    private final BetterAction ACTION_ROTATE_BRUSH_LEFT = new BetterAction("rotateBrushLeft", "Rotate brush counterclockwise fifteen degrees"){

        @Override
        protected void performAction(ActionEvent e) {
            int rotation = App.this.brushRotationSlider.getValue() - 15;
            if (rotation < -180) {
                rotation += 360;
            }
            App.this.brushRotationSlider.setValue(rotation);
            if (App.this.activeOperation instanceof PaintOperation) {
                App.this.brushRotation = rotation;
            } else {
                App.this.toolBrushRotation = rotation;
            }
            App.this.updateBrushRotation();
        }
    };
    private final BetterAction ACTION_ROTATE_BRUSH_RIGHT = new BetterAction("rotateBrushRight", "Rotate brush clockwise fifteen degrees"){

        @Override
        protected void performAction(ActionEvent e) {
            int rotation = App.this.brushRotationSlider.getValue() + 15;
            if (rotation > 180) {
                rotation -= 360;
            }
            App.this.brushRotationSlider.setValue(rotation);
            if (App.this.activeOperation instanceof PaintOperation) {
                App.this.brushRotation = rotation;
            } else {
                App.this.toolBrushRotation = rotation;
            }
            App.this.updateBrushRotation();
        }
    };
    private final BetterAction ACTION_ROTATE_BRUSH_RESET = new BetterAction("rotateBrushReset", "Reset brush rotation to zero degrees"){

        @Override
        protected void performAction(ActionEvent e) {
            if (App.this.brushRotationSlider.getValue() != 0) {
                App.this.brushRotationSlider.setValue(0);
                if (App.this.activeOperation instanceof PaintOperation) {
                    App.this.brushRotation = 0;
                } else {
                    App.this.toolBrushRotation = 0;
                }
                App.this.updateBrushRotation();
            }
        }
    };
    private final BetterAction ACTION_ROTATE_BRUSH_RIGHT_30_DEGREES = new BetterAction("rotateBrushRight30Degrees", "Rotate brush clockwise 30 degrees"){

        @Override
        protected void performAction(ActionEvent e) {
            int rotation = App.this.brushRotationSlider.getValue() + 30;
            if (rotation > 180) {
                rotation -= 360;
            }
            App.this.brushRotationSlider.setValue(rotation);
            if (App.this.activeOperation instanceof PaintOperation) {
                App.this.brushRotation = rotation;
            } else {
                App.this.toolBrushRotation = rotation;
            }
            App.this.updateBrushRotation();
        }
    };
    private final BetterAction ACTION_ROTATE_BRUSH_RIGHT_45_DEGREES = new BetterAction("rotateBrushRight45Degrees", "Rotate brush clockwise 45 degrees"){

        @Override
        protected void performAction(ActionEvent e) {
            int rotation = App.this.brushRotationSlider.getValue() + 45;
            if (rotation > 180) {
                rotation -= 360;
            }
            App.this.brushRotationSlider.setValue(rotation);
            if (App.this.activeOperation instanceof PaintOperation) {
                App.this.brushRotation = rotation;
            } else {
                App.this.toolBrushRotation = rotation;
            }
            App.this.updateBrushRotation();
        }
    };
    private final BetterAction ACTION_ROTATE_BRUSH_RIGHT_90_DEGREES = new BetterAction("rotateBrushRight90Degrees", "Rotate brush clockwise 90 degrees"){

        @Override
        protected void performAction(ActionEvent e) {
            int rotation = App.this.brushRotationSlider.getValue() + 90;
            if (rotation > 180) {
                rotation -= 360;
            }
            App.this.brushRotationSlider.setValue(rotation);
            if (App.this.activeOperation instanceof PaintOperation) {
                App.this.brushRotation = rotation;
            } else {
                App.this.toolBrushRotation = rotation;
            }
            App.this.updateBrushRotation();
        }
    };
    private final BetterAction ACTION_RESET_DOCKS = new BetterAction("resetDockLayout", "Reset current and default"){

        @Override
        protected void performAction(ActionEvent e) {
            DesktopUtils.beep();
            if (JOptionPane.showConfirmDialog(App.this, "Are you sure you want to reset the workspace?", "Confirm Workspace Reset", 0) == 0) {
                App.this.dockingManager.resetToDefault();
                Configuration config = Configuration.getInstance();
                config.setDefaultJideLayoutData(null);
                App.this.ACTION_LOAD_LAYOUT.setEnabled(false);
            }
        }
    };
    private final BetterAction ACTION_RESET_ALL_DOCKS = new BetterAction("resetAllDockLayout", "Reset current, default and all saved worlds"){

        @Override
        protected void performAction(ActionEvent e) {
            DesktopUtils.beep();
            if (JOptionPane.showConfirmDialog(App.this, "Are you sure you want to reset the workspace for all worlds?", "Confirm Workspace Reset", 0) == 0) {
                App.this.dockingManager.resetToDefault();
                Configuration config = Configuration.getInstance();
                config.setDefaultJideLayoutData(null);
                config.setJideLayoutData(null);
                App.this.ACTION_LOAD_LAYOUT.setEnabled(false);
            }
        }
    };
    private final BetterAction ACTION_LOAD_LAYOUT = new BetterAction("loadDockLayout", "Load workspace layout"){

        @Override
        protected void performAction(ActionEvent e) {
            Configuration config = Configuration.getInstance();
            if (config.getDefaultJideLayoutData() != null) {
                App.this.dockingManager.loadLayoutFrom((InputStream)new ByteArrayInputStream(config.getDefaultJideLayoutData()));
            }
        }
    };
    private final BetterAction ACTION_SAVE_LAYOUT = new BetterAction("resetDocks", "Save workspace layout"){

        @Override
        protected void performAction(ActionEvent e) {
            Configuration config = Configuration.getInstance();
            config.setDefaultJideLayoutData(App.this.dockingManager.getLayoutRawData());
            App.this.ACTION_LOAD_LAYOUT.setEnabled(true);
            MessageUtils.showInfo((Component)App.this, (String)"Workspace layout saved", (String)"Workspace layout saved");
        }
    };
    private final BetterAction ACTION_SWITCH_TO_FROM_CEILING = new BetterAction("switchCeiling", "Switch to/from Ceiling"){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(67, PLATFORM_COMMAND_MASK));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension != null && App.this.world != null) {
                Dimension.Anchor anchor = App.this.dimension.getAnchor();
                Dimension oppositeDimension = App.this.world.getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, !anchor.invert, 0));
                if (oppositeDimension != App.this.dimension && oppositeDimension != null) {
                    App.this.setDimension(oppositeDimension);
                    return;
                }
            }
            DesktopUtils.beep();
        }
    };
    private final BetterAction ACTION_SWITCH_TO_FROM_MASTER = new BetterAction("switchMaster", "Switch to/from Master"){
        private static final long serialVersionUID = 1L;
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(77, PLATFORM_COMMAND_MASK));
        }

        @Override
        public void performAction(ActionEvent e) {
            if (App.this.dimension != null && App.this.world != null) {
                Dimension.Anchor anchor = App.this.dimension.getAnchor();
                Dimension oppositeDimension = App.this.world.getDimension(new Dimension.Anchor(anchor.dim, anchor.role == Dimension.Role.MASTER ? Dimension.Role.DETAIL : Dimension.Role.MASTER, false, 0));
                if (oppositeDimension != App.this.dimension && oppositeDimension != null) {
                    App.this.setDimension(oppositeDimension);
                    return;
                }
            }
            DesktopUtils.beep();
        }
    };
    private final BetterAction ACTION_SHOW_CUSTOM_TERRAIN_POPUP = new BetterAction("showCustomTerrainMenu", null, App.loadScaledIcon("plus")){
        {
            this.setShortDescription("Add a new Custom Terrain");
        }

        @Override
        protected void performAction(ActionEvent e) {
            if (App.this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            App.this.showCustomTerrainButtonPopup(e, -1);
        }
    };
    private final BetterAction ACTION_SHOW_HELP_PICKER = new BetterAction("showHelpPicker", "Help for control", App.loadScaledIcon("information")){
        {
            this.setShortDescription("Show help information for a specific control");
        }

        @Override
        protected void performAction(ActionEvent e) {
            App.this.showHelpPicker();
        }
    };
    private final BetterAction ACTION_ESCAPE = new BetterAction("exitDimension", "Leave the current operation"){
        {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(27, 0));
        }

        @Override
        protected void performAction(ActionEvent e) {
            App.this.escapePressed();
        }
    };
    private final ButtonGroup toolButtonGroup = new ButtonGroup();
    private final ButtonGroup brushButtonGroup = new ButtonGroup();
    private final ButtonGroup paintButtonGroup = new ButtonGroup();
    private final Map<Brush, JToggleButton> brushButtons = new HashMap<Brush, JToggleButton>();
    private final Map<Dimension.Anchor, UndoManager> undoManagers = new HashMap<Dimension.Anchor, UndoManager>();
    private final JToggleButton[] customMaterialButtons = new JToggleButton[96];
    private final ColourScheme[] colourSchemes;
    private final ColourScheme defaultColourScheme;
    private final List<Layer> layers = LayerManager.getInstance().getLayers();
    private final List<Operation> operations;
    private final BrushOptions brushOptions;
    private final CustomBiomeManager customBiomeManager = new CustomBiomeManager();
    private final Set<CustomLayer> layersWithNoButton = new HashSet<CustomLayer>();
    private final Map<Layer, JCheckBox> layerSoloCheckBoxes = new HashMap<Layer, JCheckBox>();
    private final PaletteManager paletteManager = new PaletteManager(this);
    private final Map<String, BufferedImage> callouts = new HashMap<String, BufferedImage>();
    private final ObservableBoolean selectionState = new ObservableBoolean(true);
    private final Map<Layer, LayerControls> layerControls = new HashMap<Layer, LayerControls>();
    private final boolean darkMode;
    private final MapSelectionController mapSelectionController;
    private World2 world;
    private long lastSavedState = -1L;
    private long lastAutosavedState = -1L;
    private long lastSaveTimestamp = -1L;
    private volatile long lastChangeTimestamp = -1L;
    private Dimension dimension;
    private Dimension backgroundDimension;
    private boolean showBackgroundStatus;
    private int backgroundZoom;
    private WorldPainter view;
    private Operation activeOperation;
    private File lastSelectedFile;
    private JLabel heightLabel;
    private JLabel slopeLabel;
    private JLabel locationLabel;
    private JLabel waterLabel;
    private JLabel materialLabel;
    private JLabel radiusLabel;
    private JLabel zoomLabel;
    private JLabel biomeLabel;
    private JLabel levelLabel;
    private JLabel brushRotationLabel;
    private int radius = 50;
    private Brush brush = SymmetricBrush.PLATEAU_CIRCLE;
    private Brush toolBrush = SymmetricBrush.COSINE_CIRCLE;
    private boolean programmaticChange;
    private UndoManager currentUndoManager;
    private JSlider levelSlider;
    private JSlider brushRotationSlider;
    private float level = 0.51f;
    private float toolLevel = 0.51f;
    private Set<Layer> hiddenLayers = new HashSet<Layer>();
    private int maxRadius = 300;
    private int brushRotation = 0;
    private int toolBrushRotation = 0;
    private int previousBrushRotation = 0;
    private GlassPane glassPane;
    private JComboBox<TerrainMode> terrainModeComboBox;
    private JCheckBox terrainSoloCheckBox;
    private JToggleButton setSpawnPointToggleButton;
    private JToggleButton eyedropperToggleButton;
    private JMenuItem addNetherMenuItem;
    private JMenuItem removeNetherMenuItem;
    private JMenuItem addEndMenuItem;
    private JMenuItem removeEndMenuItem;
    private JMenuItem addCeilingMenuItem;
    private JMenuItem removeCeilingMenuItem;
    private JMenuItem addMasterMenuItem;
    private JMenuItem removeMasterMenuItem;
    private JCheckBoxMenuItem viewSurfaceMenuItem;
    private JCheckBoxMenuItem viewNetherMenuItem;
    private JCheckBoxMenuItem viewEndMenuItem;
    private JCheckBoxMenuItem extendedBlockIdsMenuItem;
    private ColourScheme selectedColourScheme;
    private BiomeHelper biomeHelper;
    private SortedMap<String, BrushGroup> customBrushes;
    private ThreeDeeFrame threeDeeFrame;
    private BiomesViewerFrame biomesViewerFrame;
    private MapDragControl mapDragControl;
    private BiomesPanel biomesPanel;
    private DockableFrame biomesPanelFrame;
    private Filter filter;
    private Filter toolFilter;
    private Layer soloLayer;
    private DockingManager dockingManager;
    private boolean hideAbout;
    private boolean hidePreferences;
    private boolean hideExit;
    private Paint paint = PaintFactory.NULL_PAINT;
    private PaintUpdater paintUpdater = () -> {};
    private JMenu recentMenu;
    private JPanel toolSettingsPanel;
    private JPanel customTerrainPanel;
    private Timer autosaveTimer;
    private int pauseAutosave;
    private long autosaveInhibitedUntil;
    private InfoPanel infoPanel;
    private String outsideDimensionLabel;
    private TerrainMode terrainMode = TerrainMode.SHOW_TERRAIN;
    public static final Image ICON = IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/icons/shovel-icon.png");
    public static final int DEFAULT_MAX_RADIUS = 300;
    public static final String KEY_HELP_KEY = "org.pepsoft.worldpainter.helpKey";
    public static final String KEY_ICON = "org.pepsoft.worldpainter.icon";
    public static final String KEY_THUMBNAIL = "org.pepsoft.worldpainter.thumbnail";
    public static final String KEY_PAINT_ID = "org.pepsoft.worldpainter.paint.id";
    public static final Insets BUTTON_INSETS = new Insets(3, 5, 3, 5){

        @Override
        public void set(int top, int left, int bottom, int right) {
            throw new UnsupportedOperationException();
        }
    };
    public static final NumberFormat INT_NUMBER_FORMAT = NumberFormat.getIntegerInstance();
    public static final NumberFormat FLOAT_NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static Mode mode = Mode.WORLDPAINTER;
    private static final String ACTION_NAME_INCREASE_RADIUS = "increaseRadius";
    private static final String ACTION_NAME_INCREASE_RADIUS_BY_ONE = "increaseRadiusByOne";
    private static final String ACTION_NAME_DECREASE_RADIUS = "decreaseRadius";
    private static final String ACTION_NAME_DECREASE_RADIUS_BY_ONE = "decreaseRadiusByOne";
    private static final String ACTION_NAME_REDO = "redo";
    private static final String ACTION_NAME_ZOOM_IN = "zoomIn";
    private static final String ACTION_NAME_ZOOM_OUT = "zoomOut";
    private static final long ONE_MEGABYTE = 0x100000L;
    private static final Logger logger = LoggerFactory.getLogger(App.class);
    private static final Icon ICON_NEW_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/page_white.png");
    private static final Icon ICON_OPEN_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/folder_page_white.png");
    private static final Icon ICON_SAVE_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/disk.png");
    private static final Icon ICON_EXPORT_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/map_go.png");
    private static final Icon ICON_EXIT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/door_in.png");
    private static final Icon ICON_ZOOM_IN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier_zoom_in.png");
    private static final Icon ICON_ZOOM_RESET = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier.png");
    private static final Icon ICON_ZOOM_OUT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/magnifier_zoom_out.png");
    private static final Icon ICON_GRID = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/grid.png");
    private static final Icon ICON_CONTOURS = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/contours.png");
    private static final Icon ICON_OVERLAY = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/photo.png");
    private static final Icon ICON_UNDO = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_undo.png");
    private static final Icon ICON_REDO = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_redo.png");
    private static final Icon ICON_EDIT_TILES = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/plugin.png");
    private static final Icon ICON_CHANGE_HEIGHT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_up_down.png");
    private static final Icon ICON_ROTATE_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_rotate_anticlockwise.png");
    private static final Icon ICON_DIMENSION_PROPERTIES = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/application_form.png");
    private static final Icon ICON_VIEW_DISTANCE = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/eye.png");
    private static final Icon ICON_WALKING_DISTANCE = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/user_go.png");
    private static final Icon ICON_ROTATE_LIGHT_RIGHT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_rotate_lightbulb_clockwise.png");
    private static final Icon ICON_ROTATE_LIGHT_LEFT = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_rotate_lightbulb_anticlockwise.png");
    private static final Icon ICON_MOVE_TO_SPAWN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/spawn_red.png");
    private static final Icon ICON_MOVE_TO_ORIGIN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_in.png");
    private static final Icon ICON_UNKNOWN_PATTERN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/unknown_pattern.png");
    private static final Icon ICON_SHIFT_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_cross.png");
    private static final Icon ICON_SCALE_WORLD = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/arrow_out.png");
    private static final Icon ICON_SETTINGS = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/wrench.png");
    private static final Icon ICON_ANNOTATIONS = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/annotations.png");
    private static final Icon ICON_BIOMES = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/deciduous_trees_pattern.png");
    private static final Icon ICON_LAYERS = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/layers.png");
    private static final Icon ICON_NO_TERRAIN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/edit_selection.png");
    private static final int PLATFORM_COMMAND_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String COMMAND_KEY_NAME = PLATFORM_COMMAND_MASK == 256 ? "\u2318" : "Ctrl";
    private static final String CUSTOM_BRUSHES_DEFAULT_TITLE = "Custom Brushes";
    private static final int MAX_RECENT_FILES = 10;
    private static final String HELP_ROOT_URL = "https://www.worldpainter.net/help/";
    private static final ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");
    private static final String IMPORT_WARNING_KEY = "org.pepsoft.worldpainter.importWarning";
    private static final String EDITING_FLOOR_DIMENSION_KEY = "org.pepsoft.worldpainter.TunnelLayer.editingFloorDimension";
    static final String MERGE_WARNING_KEY = "org.pepsoft.worldpainter.mergeWarning";
    private static final long serialVersionUID = 1L;

    private App() {
        super(mode == Mode.WORLDPAINTER ? "WorldPainter" : "MinecraftMapEditor");
        if (MainFrame.getMainFrame() != null) {
            throw new IllegalArgumentException("Already instantiated");
        }
        this.setIconImage(ICON);
        this.colourSchemes = new ColourScheme[]{DynmapColourScheme.loadDynMapColourScheme((String)"default", (int)0), null, null, null, DynmapColourScheme.loadDynMapColourScheme((String)"dokudark", (int)0), DynmapColourScheme.loadDynMapColourScheme((String)"dokuhigh", (int)0), DynmapColourScheme.loadDynMapColourScheme((String)"dokulight", (int)0), DynmapColourScheme.loadDynMapColourScheme((String)"misa", (int)0), DynmapColourScheme.loadDynMapColourScheme((String)"sphax", (int)0)};
        this.defaultColourScheme = this.colourSchemes[0];
        final Configuration config = Configuration.getInstance();
        this.darkMode = !"true".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.safeMode")) && config.getLookAndFeel() == Configuration.LookAndFeel.DARK_METAL;
        String customColourSchemeLocation = System.getProperty("org.pepsoft.worldpainter.colourSchemeFile");
        if (customColourSchemeLocation != null) {
            throw new UnsupportedOperationException("The org.pepsoft.worldpainter.colourSchemeFileNo advanced setting is no longer supported (colour schemes are once again available from the View menu)");
        }
        this.selectedColourScheme = this.colourSchemes[config.getColourschemeIndex()] != null ? this.colourSchemes[config.getColourschemeIndex()] : this.defaultColourScheme;
        this.operations = OperationManager.getInstance().getOperations();
        this.setMaxRadius(config.getMaximumBrushSize());
        this.loadCustomBrushes();
        this.brushOptions = new BrushOptions();
        this.brushOptions.setColourScheme(this.selectedColourScheme);
        this.brushOptions.setCustomBiomeManager(this.customBiomeManager);
        this.brushOptions.setListener(this);
        this.brushOptions.setSelectionState(this.selectionState);
        if (SystemUtils.isMac()) {
            this.installMacCustomisations();
        }
        this.initComponents();
        this.getRootPane().putClientProperty(KEY_HELP_KEY, "Main");
        this.hiddenLayers.add((Layer)Biome.INSTANCE);
        this.view.setHiddenLayers(Collections.singleton(Biome.INSTANCE));
        this.customBiomeManager.addListener((CustomBiomeManager.CustomBiomeListener)this);
        String sizeStr = System.getProperty("org.pepsoft.worldpainter.size");
        if (sizeStr != null) {
            String[] dims = sizeStr.split("x");
            int width = Integer.parseInt(dims[0]);
            int height = Integer.parseInt(dims[1]);
            this.setSize(width, height);
            this.setLocationRelativeTo(null);
        } else if (config.getWindowBounds() != null) {
            this.setBounds(config.getWindowBounds());
        } else {
            this.setSize((int)(1024.0f * GUIUtils.getUIScale()), (int)(896.0f * GUIUtils.getUIScale()));
            this.setLocationRelativeTo(null);
        }
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                App.this.fixLabelSizes();
                App.this.maybePing();
                App.this.autosaveTimer = new Timer(config.getAutosaveDelay(), event -> App.this.maybeAutosave());
                App.this.autosaveTimer.setDelay(config.getAutosaveDelay() / 2);
                if (config.isAutosaveEnabled() && !config.isAutosaveInhibited()) {
                    App.this.autosaveTimer.start();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Configuration config2;
                if (App.this.getExtendedState() != 6 && (config2 = Configuration.getInstance()) != null) {
                    config2.setWindowBounds(App.this.getBounds());
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Configuration config2;
                if (App.this.getExtendedState() != 6 && (config2 = Configuration.getInstance()) != null) {
                    config2.setWindowBounds(App.this.getBounds());
                }
            }
        });
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Configuration config = Configuration.getInstance();
                if (config != null) {
                    config.setMaximised(App.this.getExtendedState() == 6);
                }
                App.this.exit();
            }
        };
        this.addWindowListener(windowAdapter);
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode displayMode = graphicsDevice.getDisplayMode();
        ImageCapabilities imageCapabilities = graphicsDevice.getDefaultConfiguration().getImageCapabilities();
        int availableAcceleratedMemory = graphicsDevice.getAvailableAcceleratedMemory();
        logger.info("Default graphics device, ID string: {}, available accelerated memory: {}, display mode: {}x{}, bit depth: {}, refresh rate: {}, reported dpi: {}, accelerated: {}, true volatile: {}", new Object[]{graphicsDevice.getIDstring(), availableAcceleratedMemory == -1 ? "unknown" : (0xFFFFFFFFL & (long)availableAcceleratedMemory) + " bytes", displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth() == -1 ? "multi" : Integer.valueOf(displayMode.getBitDepth()), displayMode.getRefreshRate() == 0 ? "unknown" : Integer.valueOf(displayMode.getRefreshRate()), Toolkit.getDefaultToolkit().getScreenResolution(), imageCapabilities.isAccelerated() ? "yes" : "no", imageCapabilities.isTrueVolatile() ? "yes" : "no"});
        if ((double)GUIUtils.getUIScale() != 1.0) {
            logger.info("High resolution display support enabled. Scale: {}", (Object)Float.valueOf(GUIUtils.getUIScale()));
        }
        MainFrame.setMainFrame(this);
        this.mapSelectionController = new MapSelectionController(this, this.view);
        PlantLayerEditor.loadIconsInBackground();
        this.setTransferHandler(new WPTransferHandler(this));
    }

    public World2 getWorld() {
        return this.world;
    }

    public void clearWorld() {
        if (this.world != null) {
            for (Dimension dimension : this.world.getDimensions()) {
                dimension.unregisterUndoManager();
            }
            this.world.removePropertyChangeListener((PropertyChangeListener)this);
            this.world = null;
            this.lastAutosavedState = -1L;
            this.lastSavedState = -1L;
            this.setDimension(null);
            if (this.currentUndoManager != null) {
                this.currentUndoManager.unregisterActions();
            }
            this.undoManagers.clear();
            this.ACTION_EXPORT_WORLD.setEnabled(false);
            this.ACTION_MERGE_WORLD.setEnabled(false);
            this.clearCustomTerrains();
            MixedMaterialManager.getInstance().clear();
        }
    }

    public void setWorld(World2 world, boolean markClean) {
        if (world == null) {
            throw new NullPointerException();
        }
        if (this.world != null && this.world != world) {
            throw new IllegalStateException(world + " != " + this.world);
        }
        if (world == this.world) {
            if (this.dimension != null) {
                this.setDimension(world.getDimension(this.dimension.getAnchor()));
            }
        } else {
            this.world = world;
            long now = System.currentTimeMillis();
            if (markClean) {
                this.lastSavedState = this.lastAutosavedState = world.getChangeNo();
            } else {
                this.lastAutosavedState = -1L;
                this.lastSavedState = -1L;
            }
            this.lastSaveTimestamp = now;
            this.lastChangeTimestamp = now;
            world.addPropertyChangeListener((PropertyChangeListener)this);
            this.loadCustomTerrains();
            this.extendedBlockIdsMenuItem.setSelected(world.isExtendedBlockIds());
            Dimension surfaceDimension = world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
            Dimension masterDimension = world.getDimension(Dimension.Anchor.NORMAL_MASTER);
            if (masterDimension != null && surfaceDimension.getTileCount() == 0) {
                this.setDimension(masterDimension);
                AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog(this, "You are now editing the Master Dimension. This will be exported\nat sixteen times the horizontal size.\n\nTo add details at 1:1 scale, switch to the Surface Dimension by\npressing " + COMMAND_KEY_NAME + "+M or using the View menu and then add tiles by\npressing " + COMMAND_KEY_NAME + "+T or using the Edit menu.", "Editing Master Dimension [ALPHA]", 1));
            } else {
                this.setDimension(surfaceDimension);
            }
            Configuration config = Configuration.getInstance();
            if (config.isDefaultViewDistanceEnabled() != this.view.isDrawViewDistance()) {
                this.ACTION_VIEW_DISTANCE.actionPerformed(null);
            }
            if (config.isDefaultWalkingDistanceEnabled() != this.view.isDrawWalkingDistance()) {
                this.ACTION_WALKING_DISTANCE.actionPerformed(null);
            }
            this.view.setLightOrigin(config.getDefaultLightOrigin());
            if (config.isEasyMode()) {
                boolean imported = world.getImportedFrom() != null;
                this.ACTION_EXPORT_WORLD.setEnabled(!imported);
                this.ACTION_MERGE_WORLD.setEnabled(imported);
            } else {
                this.ACTION_EXPORT_WORLD.setEnabled(true);
                this.ACTION_MERGE_WORLD.setEnabled(true);
            }
            if (!PlatformManager.getInstance().getAllPlatforms().contains(world.getPlatform())) {
                MessageUtils.beepAndShowWarning((Component)this, (String)("This world is set to a map format (\"" + world.getPlatform().displayName + "\") that is unknown and unsupported.\nIt cannot be Exported without first changing the format.\nIt is most likely supported by a plugin that is not installed or could not be loaded."), (String)"Unknown Map Format");
            }
        }
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimension(Dimension dimension) {
        Configuration config = Configuration.getInstance();
        if (this.dimension != null) {
            HashMap<String, byte[]> layoutData;
            this.dimension.removePropertyChangeListener((PropertyChangeListener)this);
            this.dimension.removeDimensionListener((Dimension.Listener)this);
            for (Tile tile : this.dimension.getTiles()) {
                tile.removeListener((Tile.Listener)this);
            }
            Point viewPosition = this.view.getViewCentreInWorldCoords();
            this.dimension.setLastViewPosition(viewPosition);
            if (this.world != null) {
                Dimension.Anchor anchor = this.dimension.getAnchor();
                Dimension oppositeDimension = this.world.getDimension(new Dimension.Anchor(anchor.dim, anchor.role, !anchor.invert, anchor.id));
                if (oppositeDimension != null) {
                    oppositeDimension.setLastViewPosition(viewPosition);
                }
                switch (anchor.role) {
                    case DETAIL: {
                        Dimension masterDimension = this.world.getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.MASTER, anchor.invert, 0));
                        if (masterDimension == null) break;
                        masterDimension.setLastViewPosition(new Point(viewPosition.x >> 4, viewPosition.y >> 4));
                        break;
                    }
                    case MASTER: {
                        Dimension detailDimension = this.world.getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, anchor.invert, 0));
                        if (detailDimension == null) break;
                        detailDimension.setLastViewPosition(new Point(viewPosition.x << 4, viewPosition.y << 4));
                        break;
                    }
                    case CAVE_FLOOR: {
                        Dimension detailDimension = this.world.getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, anchor.invert, 0));
                        detailDimension.setLastViewPosition(viewPosition);
                    }
                }
            }
            if (this.currentUndoManager != null) {
                this.currentUndoManager.unregisterActions();
                this.currentUndoManager = null;
            }
            if ((layoutData = config.getJideLayoutData()) == null) {
                layoutData = new HashMap<String, byte[]>();
            }
            layoutData.put(this.dimension.getId().toString(), this.dockingManager.getLayoutRawData());
            config.setJideLayoutData(layoutData);
            this.saveCustomLayers();
            if (!this.paletteManager.isEmpty()) {
                boolean visibleLayersChanged = false;
                HashSet<String> hiddenPalettes = new HashSet<String>();
                String soloedPalette = null;
                for (Palette palette : this.paletteManager.clear()) {
                    String paletteName = palette.getName();
                    if (!palette.isShow()) {
                        hiddenPalettes.add(paletteName);
                    }
                    if (palette.isSolo()) {
                        soloedPalette = paletteName;
                    }
                    palette.removePropertyChangeListener(this);
                    List<CustomLayer> paletteLayers = palette.getLayers();
                    for (Layer layer : paletteLayers) {
                        if (this.hiddenLayers.contains(layer)) {
                            this.hiddenLayers.remove(layer);
                            visibleLayersChanged = true;
                        }
                        if (!layer.equals((Object)this.soloLayer)) continue;
                        this.soloLayer = null;
                        visibleLayersChanged = true;
                    }
                    this.dockingManager.removeFrame(palette.getDockableFrame().getKey());
                }
                if (visibleLayersChanged) {
                    this.updateLayerVisibility();
                }
                this.layerSoloCheckBoxes.clear();
                this.dimension.setHiddenPalettes(hiddenPalettes.isEmpty() ? null : hiddenPalettes);
                this.dimension.setSoloedPalette(soloedPalette);
                if (this.paint instanceof LayerPaint && ((LayerPaint)this.paint).getLayer() instanceof CustomLayer) {
                    this.deselectPaint();
                }
            }
            this.layersWithNoButton.clear();
            this.saveCustomBiomes();
            this.mapSelectionController.cancelPaintSelection(true, false);
            this.eyedropperToggleButton.setSelected(false);
            this.view.setDimension(null);
        }
        this.dimension = dimension;
        if (dimension != null) {
            this.setTitle("WorldPainter - " + this.world.getName() + " - " + dimension.getName());
            Dimension.Anchor anchor = dimension.getAnchor();
            this.viewSurfaceMenuItem.setSelected(anchor.dim == 0);
            this.viewNetherMenuItem.setSelected(anchor.dim == 1);
            this.viewEndMenuItem.setSelected(anchor.dim == 2);
            this.ACTION_EDIT_TILES.setEnabled(anchor.role != Dimension.Role.CAVE_FLOOR);
            if (dimension.isFixOverlayCoords()) {
                MessageUtils.beepAndShowWarning((Component)this, (String)"This world was created in an older version of WorldPainter\nin which the overlay offsets were not stored correctly.\nYou may need to fix the position of your overlay.", (String)"Check Overlay Positioning");
                dimension.setFixOverlayCoords(false);
            }
            this.view.setDimension(dimension, false);
            this.outsideDimensionLabel = "Minecraft Generated";
            if (anchor.equals((Object)Dimension.Anchor.NORMAL_DETAIL)) {
                this.backgroundDimension = this.world.getDimension(new Dimension.Anchor(0, Dimension.Role.MASTER, false, 0));
                this.showBackgroundStatus = this.backgroundDimension != null;
                this.backgroundZoom = 4;
                this.view.setBackgroundDimension(this.backgroundDimension, this.backgroundZoom, WPTileProvider.Effect.FADE_TO_FIFTY_PERCENT);
            } else if (anchor.role == Dimension.Role.CAVE_FLOOR) {
                this.backgroundDimension = this.world.getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, anchor.invert, 0));
                this.showBackgroundStatus = false;
                this.backgroundZoom = 0;
                this.outsideDimensionLabel = "Outside Cave/Tunnel";
                this.view.setBackgroundDimension(this.backgroundDimension, this.backgroundZoom, WPTileProvider.Effect.FADE_TO_TWENTYFIVE_PERCENT);
            } else {
                this.backgroundDimension = null;
                this.showBackgroundStatus = false;
                this.view.setBackgroundDimension(null, -1, null);
            }
            this.view.moveTo(dimension.getLastViewPosition());
            this.configureForPlatform();
            this.currentUndoManager = this.undoManagers.get(anchor);
            if (this.currentUndoManager == null) {
                if (!"true".equals(System.getProperty("org.pepsoft.worldpainter.disableUndo")) && config.isUndoEnabled()) {
                    this.currentUndoManager = new UndoManager((Action)((Object)this.ACTION_UNDO), (Action)((Object)this.ACTION_REDO), Math.max(config.getUndoLevels() + 1, 2));
                } else {
                    this.currentUndoManager = new UndoManager(2);
                    this.ACTION_UNDO.setEnabled(false);
                    this.ACTION_REDO.setEnabled(false);
                }
                this.currentUndoManager.setStopAtClasses(new Class[]{PropertyChangeListener.class, Tile.Listener.class, Biome.class, BetterAction.class});
                this.undoManagers.put(anchor, this.currentUndoManager);
                dimension.registerUndoManager(this.currentUndoManager);
            } else if (!"true".equals(System.getProperty("org.pepsoft.worldpainter.disableUndo")) && config.isUndoEnabled()) {
                this.currentUndoManager.registerActions((Action)((Object)this.ACTION_UNDO), (Action)((Object)this.ACTION_REDO));
            }
            dimension.armSavePoint();
            if (this.threeDeeFrame != null) {
                this.threeDeeFrame.setDimension(dimension);
            }
            StringBuilder warnings = new StringBuilder();
            for (CustomLayer customLayer : dimension.getCustomLayers()) {
                if (customLayer.isHide()) {
                    this.layersWithNoButton.add(customLayer);
                } else {
                    this.registerCustomLayer(customLayer, false);
                }
                if (!(customLayer instanceof CombinedLayer)) continue;
                if (!((CombinedLayer)customLayer).restoreCustomTerrain()) {
                    if (warnings.length() == 0) {
                        warnings.append("The Custom Terrain for one or more Combined Layer could not be restored:\n\n");
                    }
                    warnings.append(customLayer.getName()).append('\n');
                    continue;
                }
                Terrain terrain = ((CombinedLayer)customLayer).getTerrain();
                if (terrain == null || !terrain.isCustom() || this.customMaterialButtons[terrain.getCustomTerrainIndex()] != null) continue;
                this.addButtonForNewCustomTerrain(terrain.getCustomTerrainIndex(), Terrain.getCustomMaterial((int)terrain.getCustomTerrainIndex()), false);
            }
            if (warnings.length() > 0) {
                warnings.append("\nThe Custom Terrain has been removed from the layer(s).");
                JOptionPane.showMessageDialog(this, warnings.toString(), "Custom Terrain(s) Not Restored", 0);
            }
            if (dimension.getSoloedPalette() != null) {
                this.paletteManager.getPalette(dimension.getSoloedPalette()).setSolo(true);
            }
            if (dimension.getHiddenPalettes() != null) {
                dimension.getHiddenPalettes().forEach(name -> {
                    Palette palette = this.paletteManager.getPalette((String)name);
                    if (palette != null) {
                        palette.setShow(false);
                    } else {
                        logger.error("dimension.hiddenPalettes contains non existent palette name {}", name);
                    }
                });
            }
            this.ACTION_GRID.setSelected(this.view.isPaintGrid());
            this.ACTION_CONTOURS.setSelected(this.view.isDrawContours());
            this.ACTION_OVERLAYS.setSelected(dimension.isOverlaysEnabled());
            List customBiomes = dimension.getCustomBiomes();
            if (customBiomes != null) {
                BiomeScheme biomeScheme = BiomeUtils.getBiomeScheme((Platform)this.world.getPlatform());
                customBiomes.removeIf(customBiome -> biomeScheme.isBiomePresent(customBiome.getId()));
                if (customBiomes.isEmpty()) {
                    customBiomes = null;
                }
            }
            this.programmaticChange = true;
            try {
                if (customBiomes != null) {
                    this.customBiomeManager.setCustomBiomes(customBiomes);
                } else {
                    this.customBiomeManager.clearCustomBiomes();
                }
            }
            finally {
                this.programmaticChange = false;
            }
            this.brushOptions.setMinHeight(dimension.getMinHeight());
            this.brushOptions.setMaxHeight(dimension.getMaxHeight());
            dimension.addPropertyChangeListener((PropertyChangeListener)this);
            dimension.addDimensionListener((Dimension.Listener)this);
            for (Tile tile : dimension.getTiles()) {
                tile.addListener((Tile.Listener)this);
            }
            this.updateZoomLabel();
            this.updateRadiusLabel();
            Map layoutData = config.getJideLayoutData();
            String key = dimension.getId().toString();
            if (layoutData != null && layoutData.containsKey(key)) {
                this.dockingManager.loadLayoutFrom((InputStream)new ByteArrayInputStream((byte[])layoutData.get(key)));
                this.view.componentResized(new ComponentEvent((Component)((Object)this.view), 101));
            }
            if (!this.refreshTerrainMode()) {
                this.view.refreshTiles();
            }
            if (dimension.getTileCount() == 0) {
                AwtUtils.doLaterOnEventThread(this::addRemoveTiles);
            }
        } else {
            this.view.setDimension(null);
            this.view.setBackgroundDimension(null, -1, null);
            this.setTitle("WorldPainter");
            this.ACTION_GRID.setSelected(false);
            this.ACTION_CONTOURS.setSelected(false);
            this.ACTION_OVERLAYS.setSelected(false);
            if (this.threeDeeFrame != null) {
                this.threeDeeFrame.dispose();
                this.threeDeeFrame = null;
            }
            this.locationLabel.setText(strings.getString("location-"));
            this.heightLabel.setText(" ");
            this.waterLabel.setText(" ");
            this.biomeLabel.setText(" ");
            this.materialLabel.setText(" ");
            if (this.activeOperation != null) {
                this.deselectTool();
            }
            this.programmaticChange = true;
            try {
                this.customBiomeManager.clearCustomBiomes();
            }
            finally {
                this.programmaticChange = false;
            }
            this.backgroundDimension = null;
        }
    }

    public void updateStatusBar(int x, int y) {
        Dimension dimension = this.dimension;
        if (dimension == null) {
            this.setTextIfDifferent(this.locationLabel, " ");
            this.setTextIfDifferent(this.heightLabel, " ");
            this.setTextIfDifferent(this.waterLabel, " ");
            this.setTextIfDifferent(this.materialLabel, " ");
            this.setTextIfDifferent(this.biomeLabel, " ");
            return;
        }
        float scale = dimension.getScale();
        this.setTextIfDifferent(this.locationLabel, MessageFormat.format(strings.getString("location.0.1"), INT_NUMBER_FORMAT.format(Math.round((float)x * scale)), INT_NUMBER_FORMAT.format(Math.round((float)y * scale))));
        Tile tile = dimension.getTile(x >> 7, y >> 7);
        int xInTile = x & 0x7F;
        int yInTile = y & 0x7F;
        if (this.showBackgroundStatus && (tile == null || tile.getBitLayerValue((Layer)NotPresent.INSTANCE, xInTile, yInTile) || tile.getBitLayerValue((Layer)NotPresentBlock.INSTANCE, xInTile, yInTile)) && this.backgroundDimension.isTilePresent(x >> 7 + this.backgroundZoom, y >> 7 + this.backgroundZoom)) {
            dimension = this.backgroundDimension;
            xInTile = (x >>= this.backgroundZoom) & 0x7F;
            yInTile = (y >>= this.backgroundZoom) & 0x7F;
            tile = dimension.getTile(x >> 7, y >> 7);
        }
        if (tile == null) {
            this.setTextIfDifferent(this.heightLabel, " ");
            this.setTextIfDifferent(this.slopeLabel, " ");
            this.setTextIfDifferent(this.waterLabel, " ");
            if (dimension.isBorderTile(x >> 7, y >> 7)) {
                this.setTextIfDifferent(this.materialLabel, "Border");
            } else {
                this.setTextIfDifferent(this.materialLabel, this.outsideDimensionLabel);
            }
            this.setTextIfDifferent(this.biomeLabel, " ");
            return;
        }
        if (tile.getBitLayerValue((Layer)NotPresent.INSTANCE, xInTile, yInTile) || tile.getBitLayerValue((Layer)NotPresentBlock.INSTANCE, xInTile, yInTile)) {
            this.setTextIfDifferent(this.heightLabel, " ");
            this.setTextIfDifferent(this.slopeLabel, " ");
            this.setTextIfDifferent(this.waterLabel, " ");
            this.setTextIfDifferent(this.materialLabel, this.outsideDimensionLabel);
            this.setTextIfDifferent(this.biomeLabel, " ");
            return;
        }
        int height = tile.getIntHeight(xInTile, yInTile);
        this.setTextIfDifferent(this.heightLabel, MessageFormat.format(strings.getString("height.0.of.1"), height, height >= 0 ? dimension.getMaxHeight() - 1 : dimension.getMinHeight()));
        this.setTextIfDifferent(this.slopeLabel, MessageFormat.format("Slope: {0}\u00b0", (int)Math.round(Math.atan(dimension.getSlope(x, y)) * 180.0 / Math.PI)));
        if (this.activeOperation instanceof PaintOperation && this.paint instanceof LayerPaint) {
            Layer layer = ((LayerPaint)this.paint).getLayer();
            Layer.DataSize dataSize = layer.getDataSize();
            switch (dataSize) {
                case BIT: 
                case BIT_PER_CHUNK: {
                    this.setTextIfDifferent(this.waterLabel, MessageFormat.format(strings.getString("layer.0.on.off"), layer.getName(), tile.getBitLayerValue(layer, xInTile, yInTile) ? 1 : 0));
                    break;
                }
                case NIBBLE: 
                case BYTE: {
                    if (!layer.equals((Object)Annotations.INSTANCE) && !layer.equals((Object)Biome.INSTANCE)) {
                        this.setTextIfDifferent(this.waterLabel, MessageFormat.format(strings.getString("layer.0.level.1"), layer.getName(), dataSize.toString(tile.getLayerValue(layer, xInTile, yInTile))));
                        break;
                    }
                    this.setTextIfDifferent(this.waterLabel, " ");
                    break;
                }
            }
        } else if (this.activeOperation instanceof GardenOfEdenOperation) {
            this.setTextIfDifferent(this.waterLabel, strings.getString("structure") + ": " + GardenCategory.getLabel((ResourceBundle)strings, (int)tile.getLayerValue((Layer)GardenCategory.INSTANCE, xInTile, yInTile)));
        } else {
            int waterLevel = tile.getWaterLevel(xInTile, yInTile);
            if (waterLevel > height) {
                this.setTextIfDifferent(this.waterLabel, MessageFormat.format(strings.getString("fluid.level.1.depth.2"), tile.getBitLayerValue((Layer)FloodWithLava.INSTANCE, xInTile, yInTile) ? 1 : 0, waterLevel, waterLevel - height));
            } else {
                this.setTextIfDifferent(this.waterLabel, " ");
            }
        }
        Terrain terrain = tile.getTerrain(xInTile, yInTile);
        if (terrain.isCustom()) {
            int index = terrain.getCustomTerrainIndex();
            this.setTextIfDifferent(this.materialLabel, MessageFormat.format(strings.getString("material.custom.1.0"), Terrain.getCustomMaterial((int)index), index + 1));
        } else {
            this.setTextIfDifferent(this.materialLabel, MessageFormat.format(strings.getString("material.0"), terrain.getName()));
        }
        if (this.biomeHelper != null) {
            int biome = tile.getLayerValue((Layer)Biome.INSTANCE, xInTile, yInTile);
            if (biome == 255) {
                biome = dimension.getAutoBiome(x, y);
                if (biome != -1) {
                    this.setTextIfDifferent(this.biomeLabel, "Auto biome: " + this.biomeHelper.getBiomeName(biome));
                }
            } else if (biome != -1) {
                this.setTextIfDifferent(this.biomeLabel, MessageFormat.format(strings.getString("biome.0"), this.biomeHelper.getBiomeName(biome)));
            }
        }
    }

    private void updateRadiusLabel() {
        if (this.dimension != null && this.activeOperation instanceof RadiusOperation) {
            float scale = this.dimension.getScale();
            this.setTextIfDifferent(this.radiusLabel, MessageFormat.format(strings.getString("radius.0"), Math.round((float)this.radius * scale)));
        } else {
            this.setTextIfDifferent(this.radiusLabel, " ");
        }
    }

    public Operation getActiveOperation() {
        return this.activeOperation;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public Set<Layer> getHiddenLayers() {
        return Collections.unmodifiableSet(this.hiddenLayers);
    }

    public float getLevel() {
        return this.level;
    }

    public int getRadius() {
        return this.radius;
    }

    public Brush getToolBrush() {
        return this.toolBrush;
    }

    public float getToolLevel() {
        return this.toolLevel;
    }

    public int getZoom() {
        return this.view.getZoom();
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(int maxRadius) {
        this.maxRadius = maxRadius;
        if (this.radius > maxRadius) {
            this.radius = maxRadius;
            if (this.activeOperation instanceof RadiusOperation) {
                ((RadiusOperation)this.activeOperation).setRadius(this.radius);
            }
            this.view.setRadius(this.radius);
            this.updateRadiusLabel();
        }
    }

    public void open(File file, boolean askForConfirmation) {
        int action;
        if (askForConfirmation && this.world != null && this.world.getChangeNo() != this.lastSavedState && ((action = JOptionPane.showConfirmDialog(this, strings.getString("there.are.unsaved.changes"))) == 0 ? !this.saveAs() : action != 1)) {
            return;
        }
        this.open(file);
    }

    public void open(File file) {
        Set warnings;
        logger.info("Loading world " + file.getAbsolutePath());
        this.clearWorld();
        boolean loadedFromAutosave = this.isAutosaveFile(file);
        final World2 newWorld = (World2)ProgressDialog.executeTask((Window)this, (ProgressTask)new LoadWorldTask(this, file), (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        if (newWorld == null) {
            return;
        }
        if (loadedFromAutosave) {
            newWorld.addHistoryEntry(23, new Serializable[0]);
        } else {
            newWorld.addHistoryEntry(7, new Serializable[]{file});
        }
        boolean loadedFromBackup = !loadedFromAutosave && this.isBackupFile(file);
        this.lastSelectedFile = !loadedFromBackup && !loadedFromAutosave ? file : null;
        Configuration config = Configuration.getInstance();
        EventVO event = new EventVO("action.openWorld").addTimestamp();
        event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_HEIGHT, (Serializable)Integer.valueOf(newWorld.getMaxHeight()));
        Dimension loadedDimension = newWorld.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        event.setAttribute(Constants.ATTRIBUTE_KEY_TILES, (Serializable)Integer.valueOf(loadedDimension.getTileCount()));
        this.logLayers(loadedDimension, event, "");
        loadedDimension = newWorld.getDimension(Dimension.Anchor.NETHER_DETAIL);
        if (loadedDimension != null) {
            event.setAttribute(Constants.ATTRIBUTE_KEY_NETHER_TILES, (Serializable)Integer.valueOf(loadedDimension.getTileCount()));
            this.logLayers(loadedDimension, event, "nether.");
        }
        if ((loadedDimension = newWorld.getDimension(Dimension.Anchor.END_DETAIL)) != null) {
            event.setAttribute(Constants.ATTRIBUTE_KEY_END_TILES, (Serializable)Integer.valueOf(loadedDimension.getTileCount()));
            this.logLayers(loadedDimension, event, "end.");
        }
        if (newWorld.getImportedFrom() != null) {
            event.setAttribute(Constants.ATTRIBUTE_KEY_IMPORTED_WORLD, (Serializable)Boolean.valueOf(true));
        }
        config.logEvent(event);
        if (Version.isSnapshot() && newWorld.getMetadata() != null && newWorld.getMetadata().containsKey("org.pepsoft.worldpainter.wp.version") && !((String)newWorld.getMetadata().get("org.pepsoft.worldpainter.wp.version")).contains("SNAPSHOT")) {
            MessageUtils.beepAndShowWarning((Component)this, (String)"You are running a snapshot version of WorldPainter.\nThis file was last saved by a regular version of WorldPainter.\nIf you save the file with this version, you may no longer be able to open it\nusing a regular version of WorldPainter!", (String)"Loading Non-snapshot World");
        }
        if ((warnings = newWorld.getWarnings()) != null && !warnings.isEmpty()) {
            DesktopUtils.beep();
            for (World2.Warning warning : warnings) {
                switch (warning) {
                    case AUTO_BIOMES_DISABLED: {
                        if (JOptionPane.showOptionDialog(this, "Automatic Biomes were previously enabled for this world but have been disabled.\nPress More Info for more information, including how to reenable it.", "Automatic Biomes Disabled", -1, 2, null, new Object[]{"More Info", "OK"}, "OK") != 0) break;
                        try {
                            DesktopUtils.open((URL)new URL("https://www.worldpainter.net/doc/legacy/newautomaticbiomes"));
                            break;
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case AUTO_BIOMES_ENABLED: {
                        if (JOptionPane.showOptionDialog(this, "Automatic Biomes were previously disabled for this world but have been enabled.\nPress More Info for more information, including how to disable it.", "Automatic Biomes Enabled", -1, 2, null, new Object[]{"More Info", "OK"}, "OK") != 0) break;
                        try {
                            DesktopUtils.open((URL)new URL("https://www.worldpainter.net/doc/legacy/newautomaticbiomes"));
                            break;
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case MISSING_CUSTOM_TERRAINS: {
                        MessageUtils.showWarning((Component)this, (String)"One or more Custom Terrain Types were missing. This can happen in rare\ncircumstances; for example by using Undo after removing a Custom Terrain\nType. The missing Custom Terrain Type(s) have been replaced with Magenta\nWool and will have to be reconfigured from the Custom Terrain panel.", (String)"Missing Custom Terrain Types");
                        break;
                    }
                    case SUPERFLAT_SETTINGS_RESET: {
                        MessageUtils.showWarning((Component)this, (String)"The Superflat preset from this world could not be parsed.\nIt has been reset to default values.", (String)"Superflat Preset Reset");
                        break;
                    }
                    case GAME_TYPE_RESET: {
                        MessageUtils.showWarning((Component)this, (String)"The Game Mode from this world was lost.\nIt has been reset to Surbial.", (String)"Game Mode Reset");
                    }
                }
            }
        }
        if (newWorld.isAskToConvertToAnvil() && newWorld.getMaxHeight() == 128 && newWorld.getImportedFrom() == null) {
            if (JOptionPane.showConfirmDialog(this, strings.getString("this.world.is.128.blocks.high"), strings.getString("convert.world.height"), 0) == 0) {
                ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

                    public String getName() {
                        return "Changing world height";
                    }

                    public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                        WorldUtils.resizeWorld((World2)newWorld, (HeightTransform)HeightTransform.IDENTITY, (int)0, (int)256, (boolean)true, (ProgressReceiver)progressReceiver);
                        return null;
                    }
                }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
                newWorld.addHistoryEntry(20, new Serializable[]{Integer.valueOf(256)});
                if (newWorld.getPlatform() != null) {
                    newWorld.setPlatform(DefaultPlugin.JAVA_ANVIL);
                }
                config.logEvent(new EventVO("action.migrateHeight").addTimestamp());
            }
            newWorld.setAskToConvertToAnvil(false);
        }
        if (newWorld.isAskToRotate() && newWorld.getUpIs() == Direction.WEST && newWorld.getImportedFrom() == null) {
            if (JOptionPane.showConfirmDialog(this, strings.getString("this.world.was.created.when.north.was.to.the.right"), strings.getString("rotate.world"), 0) == 0) {
                ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

                    public String getName() {
                        return strings.getString("rotating.world");
                    }

                    public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                        newWorld.transform(CoordinateTransform.ROTATE_CLOCKWISE_270_DEGREES, progressReceiver);
                        for (Dimension dimension : newWorld.getDimensions()) {
                            newWorld.addHistoryEntry(19, new Serializable[]{dimension.getName(), Integer.valueOf(270)});
                        }
                        return null;
                    }
                }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
                config.logEvent(new EventVO("action.migrateRotation").addTimestamp());
            }
            newWorld.setAskToRotate(false);
        }
        if (!loadedFromAutosave) {
            String worldName;
            File originalFile = loadedFromBackup ? this.getOriginalFile(file) : file;
            String name = originalFile.getName();
            if (name.toLowerCase().endsWith(".world")) {
                name = name.substring(0, name.length() - 6);
            }
            if ((worldName = newWorld.getName()).length() != name.length()) {
                newWorld.setName(name);
            } else {
                for (int i = 0; i < name.length(); ++i) {
                    if (name.charAt(i) == '_' || name.charAt(i) == worldName.charAt(i)) continue;
                    newWorld.setName(name);
                    break;
                }
            }
            this.addRecentlyUsedWorld(originalFile);
        }
        this.setWorld(newWorld, !loadedFromBackup && !loadedFromAutosave);
    }

    public void pauseAutosave() {
        ++this.pauseAutosave;
    }

    public void resumeAutosave() {
        this.autosaveInhibitedUntil = System.currentTimeMillis() + (long)Configuration.getInstance().getAutosaveDelay();
        this.pauseAutosave = Math.max(this.pauseAutosave - 1, 0);
    }

    public void selectPaint(String paintId) {
        if (paintId == null) {
            throw new NullPointerException();
        }
        Enumeration<AbstractButton> e = this.paintButtonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            String buttonPaintId = (String)button.getClientProperty(KEY_PAINT_ID);
            if (buttonPaintId == null || !buttonPaintId.equals(paintId)) continue;
            for (Container parent = button.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DockableFrame)) continue;
                if (parent.isShowing()) break;
                this.dockingManager.showFrame(((DockableFrame)parent).getKey());
                break;
            }
            if (!button.isSelected()) {
                button.setSelected(true);
            }
            return;
        }
        if (paintId.startsWith("Layer/Biome/")) {
            this.biomesPanel.selectBiome(Integer.parseInt(paintId.substring(12)));
            if (!this.biomesPanelFrame.isShowing()) {
                this.dockingManager.showFrame("biomes");
            }
            return;
        }
        throw new IllegalArgumentException("No button found for paint " + this.paint);
    }

    boolean changeWorldHeight(Window parent) {
        if (this.world == null || this.dimension == null) {
            DesktopUtils.beep();
            return false;
        }
        ChangeHeightDialog dialog = new ChangeHeightDialog(parent, this.world);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.view.refreshTiles();
            if (this.threeDeeFrame != null) {
                this.threeDeeFrame.refresh();
            }
            this.brushOptions.setMinHeight(this.dimension.getMinHeight());
            this.brushOptions.setMaxHeight(this.dimension.getMaxHeight());
            return true;
        }
        return false;
    }

    void shiftWorld(Window parent) {
        if (this.world == null || this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        if (this.world.getImportedFrom() != null && JOptionPane.showConfirmDialog(parent, "This world was imported from an existing map!\nIf you shift it you will no longer be able to merge it properly.\nAre you sure you want to shift the world?", strings.getString("imported"), 0, 2) != 0) {
            return;
        }
        this.view.setInhibitUpdates(true);
        try {
            ShiftWorldDialog dialog = new ShiftWorldDialog(parent, this.world, this.dimension.getAnchor());
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.currentUndoManager.armSavePoint();
                if (this.threeDeeFrame != null) {
                    this.threeDeeFrame.refresh();
                }
            }
        }
        finally {
            this.view.setInhibitUpdates(false);
        }
    }

    void rotateWorld(Window parent) {
        if (this.world == null || this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        if (this.world.getImportedFrom() != null && JOptionPane.showConfirmDialog(parent, strings.getString("this.world.was.imported.from.an.existing.map"), strings.getString("imported"), 0, 2) != 0) {
            return;
        }
        this.view.setInhibitUpdates(true);
        try {
            RotateWorldDialog dialog = new RotateWorldDialog(parent, this.world, this.dimension.getAnchor());
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.currentUndoManager.armSavePoint();
                if (this.threeDeeFrame != null) {
                    this.threeDeeFrame.refresh();
                }
            }
        }
        finally {
            this.view.setInhibitUpdates(false);
        }
    }

    void scaleWorld(Window parent) {
        if (this.world == null || this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        if (this.world.getImportedFrom() != null && JOptionPane.showConfirmDialog(parent, "This world was imported from an existing map!\nIf you scale it you will no longer be able to merge it properly.\nAre you sure you want to scale the world?", strings.getString("imported"), 0, 2) != 0) {
            return;
        }
        this.view.setInhibitUpdates(true);
        try {
            ScaleWorldDialog dialog = new ScaleWorldDialog(parent, this.world, this.dimension.getAnchor());
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.currentUndoManager.armSavePoint();
                if (this.threeDeeFrame != null) {
                    this.threeDeeFrame.refresh();
                }
            }
        }
        finally {
            this.view.setInhibitUpdates(false);
        }
    }

    private void addRecentlyUsedWorld(File file) {
        file = file.getAbsoluteFile();
        Configuration config = Configuration.getInstance();
        ArrayList<File> recentFiles = config.getRecentFiles();
        if (recentFiles == null) {
            recentFiles = new ArrayList<File>();
            config.setRecentFiles(recentFiles);
        }
        recentFiles.remove(file);
        recentFiles.add(0, file);
        while (recentFiles.size() > 10) {
            recentFiles.remove(recentFiles.size() - 1);
        }
        this.updateRecentMenu();
    }

    private void updateRecentMenu() {
        this.recentMenu.removeAll();
        Iterator i = Configuration.getInstance().getRecentFiles().iterator();
        while (i.hasNext()) {
            File recentFile = (File)i.next();
            if (recentFile.isFile() && recentFile.canRead()) {
                JMenuItem menuItem = new JMenuItem(recentFile.getName());
                menuItem.addActionListener(e -> {
                    if (recentFile.isFile()) {
                        this.open(recentFile, true);
                    } else {
                        JOptionPane.showMessageDialog(this, "The file " + recentFile.getName() + " no longer exists\nin " + recentFile.getParent(), "File Removed", 0);
                    }
                });
                this.recentMenu.add(menuItem);
                continue;
            }
            i.remove();
        }
        this.recentMenu.setEnabled(this.recentMenu.getMenuComponentCount() > 0);
    }

    public static Mode getMode() {
        return mode;
    }

    public static void setMode(Mode mode) {
        App.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.programmaticChange) {
            return;
        }
        this.programmaticChange = true;
        try {
            if (evt.getSource() == this.world) {
                this.lastChangeTimestamp = System.currentTimeMillis();
                if (evt.getPropertyName().equals("platform")) {
                    AwtUtils.doOnEventThread(this::configureForPlatform);
                }
            } else if (evt.getSource() instanceof Palette && (evt.getPropertyName().equals("show") || evt.getPropertyName().equals("solo"))) {
                if (evt.getPropertyName().equals("solo") && evt.getNewValue() == Boolean.TRUE) {
                    for (Palette palette : this.paletteManager.getPalettes()) {
                        if (palette == evt.getSource() || !palette.isSolo()) continue;
                        palette.setSolo(false);
                    }
                }
                this.updateLayerVisibility();
            }
        }
        finally {
            this.programmaticChange = false;
        }
    }

    public void tilesAdded(Dimension dimension, Set<Tile> tiles) {
        for (Tile tile : tiles) {
            tile.addListener((Tile.Listener)this);
        }
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void tilesRemoved(Dimension dimension, Set<Tile> tiles) {
        for (Tile tile : tiles) {
            tile.removeListener((Tile.Listener)this);
        }
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void overlayAdded(Dimension dimension, int index, Overlay overlay) {
    }

    public void overlayRemoved(Dimension dimension, int index, Overlay overlay) {
    }

    public void heightMapChanged(Tile tile) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void terrainChanged(Tile tile) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void waterLevelChanged(Tile tile) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void layerDataChanged(Tile tile, Set<Layer> changedLayers) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void allBitLayerDataChanged(Tile tile) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void allNonBitlayerDataChanged(Tile tile) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void seedsChanged(Tile tile) {
        this.lastChangeTimestamp = System.currentTimeMillis();
    }

    public void increaseRadius(int amount) {
        int oldRadius = this.radius;
        if (this.radius == 0) {
            this.radius = 1;
        } else {
            double factor = Math.pow(1.1, amount);
            this.radius = (int)((double)this.radius * factor);
            if (this.radius == oldRadius) {
                ++this.radius;
            }
            if (this.radius > this.maxRadius) {
                this.radius = this.maxRadius;
            }
            if (this.radius == oldRadius) {
                return;
            }
        }
        if (this.activeOperation instanceof RadiusOperation) {
            ((RadiusOperation)this.activeOperation).setRadius(this.radius);
        }
        this.view.setRadius(this.radius);
        this.updateRadiusLabel();
    }

    public void increaseRadiusByOne() {
        if (this.radius < this.maxRadius) {
            ++this.radius;
            if (this.activeOperation instanceof RadiusOperation) {
                ((RadiusOperation)this.activeOperation).setRadius(this.radius);
            }
            this.view.setRadius(this.radius);
            this.updateRadiusLabel();
        }
    }

    public void decreaseRadius(int amount) {
        if (this.radius > 0) {
            int oldRadius = this.radius;
            double factor = Math.pow(0.9, amount);
            this.radius = (int)((double)this.radius * factor);
            if (this.radius == oldRadius) {
                --this.radius;
            }
            if (this.radius < 0) {
                this.radius = 0;
            }
            if (this.radius == oldRadius) {
                return;
            }
            if (this.activeOperation instanceof RadiusOperation) {
                ((RadiusOperation)this.activeOperation).setRadius(this.radius);
            }
            this.view.setRadius(this.radius);
            this.updateRadiusLabel();
        }
    }

    public void decreaseRadiusByOne() {
        if (this.radius > 0) {
            --this.radius;
            if (this.activeOperation instanceof RadiusOperation) {
                ((RadiusOperation)this.activeOperation).setRadius(this.radius);
            }
            this.view.setRadius(this.radius);
            this.updateRadiusLabel();
        }
    }

    @Override
    public void setSeed(long seed, Generator generator) {
        if (this.world != null) {
            for (Dimension dimension : this.world.getDimensions()) {
                dimension.setMinecraftSeed(seed);
                if (!(dimension.getGenerator() instanceof SeededGenerator)) continue;
                ((SeededGenerator)dimension.getGenerator()).setSeed(seed);
            }
        }
    }

    public static App getInstance() {
        if (App.getInstanceIfExists() == null) {
            new App();
        }
        return App.getInstanceIfExists();
    }

    public static App getInstanceIfExists() {
        return (App)MainFrame.getMainFrame();
    }

    public boolean saveIfNecessary() {
        if (logger.isDebugEnabled()) {
            logger.debug("Last saved state: {}", (Object)this.lastSavedState);
        }
        this.pauseAutosave();
        try {
            if (this.world != null && this.world.getChangeNo() != this.lastSavedState) {
                int action = JOptionPane.showConfirmDialog(this, this.lastSelectedFile != null ? MessageFormat.format(strings.getString("there.are.unsaved.changes.do.you.want.to.save.the.world.to.0"), this.lastSelectedFile.getName()) : strings.getString("there.are.unsaved.changes"));
                if (action == 0) {
                    if (!this.save()) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (action != 1) {
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                this.rotateAutosaveFile();
            }
            catch (Error | RuntimeException e) {
                logger.error("An exception occurred while trying to rotate the autosave", e);
                MessageUtils.beepAndShowWarning((Component)this, (String)"An error occurred while trying to clear the autosave.\nWorldPainter may try to load the autosave on the next start.\nIf this keeps happening, please report it to the author.", (String)"Clearing Autosave Failed");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.resumeAutosave();
        }
    }

    public boolean editCustomMaterial(int customMaterialIndex) {
        CustomMaterialDialog dialog;
        MixedMaterial material = Terrain.getCustomMaterial((int)customMaterialIndex);
        if (material == null) {
            material = MixedMaterial.create((Platform)this.world.getPlatform(), (Material)Material.DIRT);
            dialog = new CustomMaterialDialog(this, this.world.getPlatform(), material, this.world.isExtendedBlockIds(), this.selectedColourScheme);
        } else {
            dialog = new CustomMaterialDialog(this, this.world.getPlatform(), material, this.world.isExtendedBlockIds(), this.selectedColourScheme);
        }
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            material = MixedMaterialManager.getInstance().register(material);
            Terrain.setCustomMaterial((int)customMaterialIndex, (MixedMaterial)material);
            this.customMaterialButtons[customMaterialIndex].setIcon(new ImageIcon(material.getIcon(this.selectedColourScheme)));
            this.customMaterialButtons[customMaterialIndex].setToolTipText(MessageFormat.format(strings.getString("customMaterial.0.right.click.to.change"), material));
            this.view.refreshTiles();
            if (this.threeDeeFrame != null) {
                this.threeDeeFrame.refresh();
            }
            return true;
        }
        return false;
    }

    public void deselectTool() {
        if (this.activeOperation != null) {
            this.activeOperation.interrupt();
        }
        this.toolButtonGroup.clearSelection();
    }

    public void deselectPaint() {
        this.paintButtonGroup.clearSelection();
        this.paint = PaintFactory.NULL_PAINT;
        this.paintChanged();
    }

    public List<Layer> getAllLayers() {
        ArrayList<Layer> allLayers = new ArrayList<Layer>(this.layers);
        allLayers.add((Layer)Populate.INSTANCE);
        if (this.layerControls.get(ReadOnly.INSTANCE).isEnabled()) {
            allLayers.add((Layer)ReadOnly.INSTANCE);
        }
        allLayers.addAll(this.getCustomLayers());
        return allLayers;
    }

    public List<CustomLayer> getCustomLayers() {
        ArrayList<CustomLayer> customLayers = new ArrayList<CustomLayer>(256);
        customLayers.addAll(this.paletteManager.getLayers());
        customLayers.addAll(this.layersWithNoButton);
        customLayers.sort(Comparator.comparing(Layer::getName));
        return customLayers;
    }

    public Map<String, Collection<CustomLayer>> getCustomLayersByPalette() {
        Map<String, Collection<CustomLayer>> customLayers = this.paletteManager.getLayersByPalette();
        if (!this.layersWithNoButton.isEmpty()) {
            customLayers.put(null, this.layersWithNoButton);
        }
        return customLayers;
    }

    public ColourScheme getColourScheme() {
        return this.selectedColourScheme;
    }

    public void setFilter(Filter filter) {
        if (this.activeOperation instanceof PaintOperation) {
            this.filter = filter;
        } else {
            this.toolFilter = filter;
        }
        if (this.activeOperation instanceof RadiusOperation) {
            ((RadiusOperation)this.activeOperation).setFilter(filter);
        }
    }

    public CustomBiomeManager getCustomBiomeManager() {
        return this.customBiomeManager;
    }

    public void showCustomTerrainButtonPopup(AWTEvent event, int customMaterialIndex) {
        MixedMaterial[] customMaterials;
        JMenuItem menuItem;
        MixedMaterial material;
        JToggleButton button;
        JToggleButton jToggleButton = button = customMaterialIndex >= 0 ? this.customMaterialButtons[customMaterialIndex] : null;
        if (button != null ? !button.isShowing() : event.getSource() instanceof Component && !((Component)event.getSource()).isShowing()) {
            DesktopUtils.beep();
            logger.warn("Event source {} not showing; not opening popup", event.getSource());
            return;
        }
        BetterJPopupMenu popupMenu = new BetterJPopupMenu();
        MixedMaterial mixedMaterial = material = customMaterialIndex >= 0 ? Terrain.getCustomMaterial((int)customMaterialIndex) : null;
        if (button == null) {
            menuItem = new JMenuItem(strings.getString("select.custom.material") + "...");
            menuItem.addActionListener(e -> {
                MixedMaterial newMaterial = MixedMaterial.create((Platform)this.world.getPlatform(), (Material)Material.DIRT);
                CustomMaterialDialog dialog = new CustomMaterialDialog(this, this.world.getPlatform(), newMaterial, this.world.isExtendedBlockIds(), this.selectedColourScheme);
                dialog.setVisible(true);
                if (!dialog.isCancelled()) {
                    newMaterial = MixedMaterialManager.getInstance().register(newMaterial);
                    int index = this.findNextCustomTerrainIndex();
                    this.addButtonForNewCustomTerrain(index, newMaterial, true);
                }
            });
            popupMenu.add(menuItem);
        }
        if ((customMaterials = MixedMaterialManager.getInstance().getMaterials()).length > 0) {
            JMenu existingMaterialsMenu = new JMenu("Select existing material");
            HashSet<MixedMaterial> customTerrainMaterials = new HashSet<MixedMaterial>();
            for (int i = 0; i < 96; ++i) {
                if (!Terrain.getCustomTerrain((int)i).isConfigured()) continue;
                customTerrainMaterials.add(Terrain.getCustomMaterial((int)i));
            }
            for (MixedMaterial customMaterial : customMaterials) {
                if (customTerrainMaterials.contains(customMaterial)) continue;
                menuItem = new JMenuItem(customMaterial.getName());
                menuItem.setIcon(new ImageIcon(customMaterial.getIcon(this.selectedColourScheme)));
                menuItem.addActionListener(e -> {
                    if (button != null) {
                        Terrain.setCustomMaterial((int)customMaterialIndex, (MixedMaterial)customMaterial);
                        button.setIcon(new ImageIcon(customMaterial.getIcon(this.selectedColourScheme)));
                        button.setToolTipText(MessageFormat.format(strings.getString("customMaterial.0.right.click.to.change"), customMaterial));
                        this.view.refreshTiles();
                    } else {
                        this.addButtonForNewCustomTerrain(this.findNextCustomTerrainIndex(), customMaterial, true);
                    }
                });
                existingMaterialsMenu.add(menuItem);
            }
            if (existingMaterialsMenu.getMenuComponentCount() > 0) {
                popupMenu.add(existingMaterialsMenu);
            }
        }
        if (button != null) {
            menuItem = new JMenuItem((material != null ? "Edit custom material" : strings.getString("select.custom.material")) + "...");
            menuItem.addActionListener(e -> {
                if (this.editCustomMaterial(customMaterialIndex)) {
                    button.setSelected(true);
                    this.paintUpdater = () -> {
                        this.paint = PaintFactory.createTerrainPaint(Terrain.getCustomTerrain((int)customMaterialIndex));
                        this.paintChanged();
                    };
                    this.paintUpdater.updatePaint();
                }
            });
            popupMenu.add(menuItem);
        }
        menuItem = new JMenuItem("Import from file...");
        menuItem.addActionListener(e -> {
            if (button != null) {
                if (this.importCustomMaterial(customMaterialIndex)) {
                    button.setSelected(true);
                    this.paintUpdater = () -> {
                        this.paint = PaintFactory.createTerrainPaint(Terrain.getCustomTerrain((int)customMaterialIndex));
                        this.paintChanged();
                    };
                    this.paintUpdater.updatePaint();
                }
            } else {
                MixedMaterial customMaterial = MixedMaterialHelper.load(this);
                if (customMaterial != null) {
                    this.addButtonForNewCustomTerrain(this.findNextCustomTerrainIndex(), customMaterial, true);
                }
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem("Import from another world...");
        menuItem.addActionListener(e -> this.importCustomItemsFromWorld(CustomItemsTreeModel.ItemType.TERRAIN, null));
        popupMenu.add(menuItem);
        if (button != null) {
            if (material != null) {
                menuItem = new JMenuItem("Remove...");
                menuItem.addActionListener(e -> this.removeCustomMaterial(customMaterialIndex));
                popupMenu.add(menuItem);
                menuItem = new JMenuItem("Export to file...");
                menuItem.addActionListener(e -> this.exportCustomMaterial(customMaterialIndex));
                popupMenu.add(menuItem);
            }
            popupMenu.show(button, button.getWidth(), 0);
        } else {
            Component invoker = (Component)event.getSource();
            popupMenu.show(invoker, invoker.getWidth(), 0);
        }
    }

    public void showHelp(Component component) {
        String helpKey = null;
        do {
            if (component instanceof AbstractButton && ((AbstractButton)component).getAction() != null && ((AbstractButton)component).getAction().getValue(KEY_HELP_KEY) != null) {
                helpKey = (String)((AbstractButton)component).getAction().getValue(KEY_HELP_KEY);
            } else if (component instanceof JComponent) {
                helpKey = (String)((JComponent)component).getClientProperty(KEY_HELP_KEY);
            } else if (component instanceof RootPaneContainer) {
                helpKey = (String)((RootPaneContainer)((Object)component)).getRootPane().getClientProperty(KEY_HELP_KEY);
            }
            component = component.getParent();
        } while (helpKey == null && component != null);
        if (helpKey == null) {
            throw new IllegalArgumentException("No help key found in hierarchy");
        }
        try {
            DesktopUtils.open((URL)new URL(HELP_ROOT_URL + this.encodeForURL(helpKey.toLowerCase())));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed help URL: https://www.worldpainter.net/help/" + this.encodeForURL(helpKey), e);
        }
    }

    public void selectPaintOnMap(Set<Eyedropper.PaintType> paintTypes, Eyedropper.SelectionListener selectionListener) {
        this.mapSelectionController.selectPaintOnMap(paintTypes, selectionListener);
    }

    @Override
    public void filterChanged(Filter newFilter) {
        this.setFilter(newFilter);
    }

    public void customBiomeAdded(CustomBiome customBiome) {
        if (!this.programmaticChange && this.dimension != null) {
            this.view.refreshTilesForLayer((Layer)Biome.INSTANCE, false);
        }
    }

    public void customBiomeChanged(CustomBiome customBiome) {
        if (!this.programmaticChange && this.dimension != null) {
            this.view.refreshTilesForLayer((Layer)Biome.INSTANCE, false);
        }
    }

    public void customBiomeRemoved(final CustomBiome customBiome) {
        if (!this.programmaticChange && this.dimension != null) {
            ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

                public String getName() {
                    return "Removing custom biome " + customBiome.getName();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void execute(ProgressReceiver progressReceiver) {
                    App.this.dimension.armSavePoint();
                    int customBiomeId = customBiome.getId();
                    boolean biomesChanged = false;
                    for (Tile tile : App.this.dimension.getTiles()) {
                        if (!tile.hasLayer((Layer)Biome.INSTANCE)) continue;
                        tile.inhibitEvents();
                        try {
                            boolean allCustomOrAuto = true;
                            for (int x = 0; x < 128; ++x) {
                                for (int y = 0; y < 128; ++y) {
                                    int layerValue = tile.getLayerValue((Layer)Biome.INSTANCE, x, y);
                                    if (layerValue == customBiomeId) {
                                        tile.setLayerValue((Layer)Biome.INSTANCE, x, y, 255);
                                        biomesChanged = true;
                                        continue;
                                    }
                                    if (layerValue == 255) continue;
                                    allCustomOrAuto = false;
                                }
                            }
                            if (!allCustomOrAuto) continue;
                            tile.clearLayerData((Layer)Biome.INSTANCE);
                        }
                        finally {
                            tile.releaseEvents();
                        }
                    }
                    if (biomesChanged) {
                        App.this.dimension.armSavePoint();
                    }
                    return null;
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        }
    }

    public DockingManager getDockingManager() {
        return this.dockingManager;
    }

    @Override
    public void setTitle(String title) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        if (Version.isSnapshot()) {
            sb.append(" [SNAPSHOT]");
        }
        if (Configuration.getInstance().isSafeMode()) {
            sb.append(" [SAFE MODE]");
        }
        super.setTitle(sb.toString());
    }

    void exit() {
        if (this.saveIfNecessary()) {
            System.exit(0);
        }
    }

    void setGlassPaneComponent(Component component) {
        this.glassPane.setPanelComponent(component);
    }

    void removeGlassPaneComponent() {
        this.glassPane.removePanelComponent();
    }

    private String encodeForURL(String str) {
        CharSequence[] parts = str.split("/");
        try {
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = URLEncoder.encode((String)parts[i], "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("VM does not support mandatory encoding UTF-8");
        }
        return String.join((CharSequence)"/", parts);
    }

    private int findNextCustomTerrainIndex() {
        for (int i = 0; i < 96; ++i) {
            if (Terrain.isCustomMaterialConfigured((int)i)) continue;
            return i;
        }
        return -1;
    }

    private void addButtonForNewCustomTerrain(int index, MixedMaterial customMaterial, boolean select) {
        JToggleButton newButton;
        Terrain.setCustomMaterial((int)index, (MixedMaterial)customMaterial);
        if (this.customTerrainPanel == null) {
            this.dockingManager.addFrame(new DockableFrameBuilder(this.createCustomTerrainPanel(), "Custom Terrain", 8, 3).withId("customTerrain").build());
        }
        this.customMaterialButtons[index] = newButton = this.createTerrainButton(Terrain.getCustomTerrain((int)index));
        newButton.setToolTipText(MessageFormat.format(strings.getString("customMaterial.0.right.click.to.change"), customMaterial));
        this.addMaterialSelectionTo(newButton, index);
        this.customTerrainPanel.add((Component)newButton, this.customTerrainPanel.getComponentCount() - 1);
        this.customTerrainPanel.validate();
        if (Terrain.getConfiguredCustomMaterialCount() == 96) {
            this.ACTION_SHOW_CUSTOM_TERRAIN_POPUP.setEnabled(false);
        }
        if (select) {
            newButton.setSelected(true);
            this.paintUpdater = () -> {
                this.paint = PaintFactory.createTerrainPaint(Terrain.getCustomTerrain((int)index));
                this.paintChanged();
            };
            this.paintUpdater.updatePaint();
            this.dockingManager.activateFrame("customTerrain");
        }
    }

    private void setTextIfDifferent(JLabel label, String text) {
        if (!label.getText().equals(text)) {
            label.setText(text);
        }
    }

    private void loadCustomBrushes() {
        this.customBrushes = new TreeMap<String, BrushGroup>();
        if (!Configuration.getInstance().isSafeMode()) {
            File brushesDir = new File(Configuration.getConfigDir(), "brushes");
            if (brushesDir.isDirectory()) {
                this.loadCustomBrushes(CUSTOM_BRUSHES_DEFAULT_TITLE, brushesDir);
            }
        } else {
            logger.info("[SAFE MODE] Not loading custom brushes");
        }
    }

    private void loadCustomBrushes(String category, File brushesDir) {
        File[] files = brushesDir.listFiles(new java.io.FileFilter(){
            private final String[] extensions = ImageIO.getReaderFileSuffixes();

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                String name = pathname.getName();
                for (String extension : this.extensions) {
                    if (!name.toLowerCase().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<Brush> brushes = new ArrayList<Brush>();
        BufferedImage icon = null;
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadCustomBrushes(file.getName(), file);
                continue;
            }
            if (file.isFile()) {
                if (file.getName().equalsIgnoreCase("icon.png")) {
                    try {
                        icon = ImageIO.read(file);
                    }
                    catch (Exception e) {
                        logger.error("There was an error loading the brush group icon file icon.png; skipping icon file", (Throwable)e);
                    }
                    continue;
                }
                try {
                    brushes.add(new BitmapBrush(file));
                }
                catch (RuntimeException e) {
                    logger.error("There was an error loading custom brush image file " + file.getName() + "; skipping file", (Throwable)e);
                }
                continue;
            }
            logger.warn("Skipping file " + file + "; it is neither a file nor a directory");
        }
        if (!brushes.isEmpty()) {
            this.customBrushes.put(category, new BrushGroup(category, icon, brushes));
        }
    }

    private void maybePing() {
        Configuration config = Configuration.getInstance();
        if (config.getPingAllowed() == null) {
            int rc = JOptionPane.showConfirmDialog(this, strings.getString("may.we.have.your.permission"), strings.getString("usage.statistics.permission"), 0);
            if (rc == 0) {
                config.setPingAllowed(Boolean.TRUE);
            } else if (rc == 1) {
                config.setPingAllowed(Boolean.FALSE);
            } else {
                return;
            }
        }
        if (config.getPingAllowed().booleanValue()) {
            this.ping();
        }
    }

    private void ping() {
        UsageVO usageVO = new UsageVO();
        Configuration config = Configuration.getInstance();
        usageVO.setInstall(config.getUuid());
        usageVO.setLaunchCount(config.getLaunchCount());
        List eventLog = config.getEventLog();
        if (eventLog != null && !eventLog.isEmpty()) {
            usageVO.setEvents(eventLog);
        }
        usageVO.setWPVersion(Version.VERSION);
        Main.privateContext.submitUsageData(usageVO, false);
    }

    private void newWorld() {
        if (!this.saveIfNecessary()) {
            return;
        }
        Configuration config = Configuration.getInstance();
        final NewWorldDialog dialog = new NewWorldDialog(this, this.selectedColourScheme, strings.getString("generated.world"), 27594263L, config.getDefaultPlatform(), Dimension.Anchor.NORMAL_DETAIL, config.getDefaultPlatform().minZ, config.getDefaultMaxHeight(), null);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.clearWorld();
            if (!dialog.checkMemoryRequirements(this)) {
                return;
            }
            World2 newWorld = (World2)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<World2>(){

                public String getName() {
                    return strings.getString("creating.new.world");
                }

                public World2 execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    return dialog.getSelectedWorld(progressReceiver);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (newWorld == null) {
                return;
            }
            EventVO event = new EventVO("action.newWorld").addTimestamp();
            event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_HEIGHT, (Serializable)Integer.valueOf(newWorld.getMaxHeight()));
            event.setAttribute(Constants.ATTRIBUTE_KEY_TILES, (Serializable)Integer.valueOf(newWorld.getDimension(Dimension.Anchor.NORMAL_DETAIL).getTileCount()));
            config.logEvent(event);
            this.setWorld(newWorld, true);
            this.lastSelectedFile = null;
        }
    }

    private void open() {
        if (!this.saveIfNecessary()) {
            return;
        }
        Configuration config = Configuration.getInstance();
        File dir = this.lastSelectedFile != null ? this.lastSelectedFile.getParentFile() : (config != null && config.getWorldDirectory() != null ? config.getWorldDirectory() : DesktopUtils.getDocumentsFolder());
        File selectedFile = FileUtils.selectFileForOpen(this, "Select a WorldPainter world", dir, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".world");
            }

            @Override
            public String getDescription() {
                return strings.getString("worldpainter.files.world");
            }

            @Override
            public String getExtensions() {
                return "*.world";
            }
        });
        if (selectedFile != null) {
            if (!selectedFile.isFile()) {
                if (logger.isDebugEnabled()) {
                    try {
                        logger.debug("Path not a file according to File.isFile(): \"" + selectedFile + "\" (directory: " + selectedFile.isDirectory() + "; length: " + selectedFile.length() + "; absolutePath: \"" + selectedFile.getAbsolutePath() + "\"; canonicalPath: \"" + selectedFile.getCanonicalPath() + "\")");
                    }
                    catch (IOException e) {
                        logger.debug("Path not a file according to File.isFile(): \"" + selectedFile + "\" (directory: " + selectedFile.isDirectory() + "; length: " + selectedFile.length() + "; absolutePath: \"" + selectedFile.getAbsolutePath() + "\")");
                        logger.warn("I/O error while trying to report canonical path of file: \"" + selectedFile + "\"", (Throwable)e);
                    }
                }
                JOptionPane.showMessageDialog(this, "The specified path does not exist or is not a file", "File Does Not Exist", 0);
                return;
            }
            if (!selectedFile.canRead()) {
                JOptionPane.showMessageDialog(this, "WorldPainter is not authorised to read the selected file", "Access Denied", 0);
                return;
            }
            this.open(selectedFile);
            if (config != null) {
                config.setWorldDirectory(selectedFile.getParentFile());
            }
        }
    }

    private boolean save() {
        if (this.lastSelectedFile == null) {
            return this.saveAs();
        }
        return this.save(this.lastSelectedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveAs() {
        if (this.world == null) {
            DesktopUtils.beep();
            return false;
        }
        this.pauseAutosave();
        try {
            Configuration config = Configuration.getInstance();
            File file = this.lastSelectedFile;
            if (file == null) {
                file = config != null && config.getWorldDirectory() != null ? new File(config.getWorldDirectory(), org.pepsoft.util.FileUtils.sanitiseName((String)(this.world.getName().trim() + ".world"))) : new File(DesktopUtils.getDocumentsFolder(), org.pepsoft.util.FileUtils.sanitiseName((String)(this.world.getName().trim() + ".world")));
            }
            if ((file = FileUtils.selectFileForSave(this, "Save as a WorldPainter world", file, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".world");
                }

                @Override
                public String getDescription() {
                    return strings.getString("worldpainter.files.world");
                }

                @Override
                public String getExtensions() {
                    return "*.world";
                }
            })) != null) {
                if (!file.getName().toLowerCase().endsWith(".world")) {
                    file = new File(file.getParentFile(), file.getName() + ".world");
                }
                if (file.exists() && JOptionPane.showConfirmDialog(this, strings.getString("do.you.want.to.overwrite.the.file"), strings.getString("file.exists"), 0) != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (this.save(file)) {
                    MessageUtils.showInfo((Component)this, (String)strings.getString("file.saved"), (String)strings.getString("success"));
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.resumeAutosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(File file) {
        if (this.world == null) {
            DesktopUtils.beep();
            return false;
        }
        this.pauseAutosave();
        try {
            String worldName;
            if (!file.getParentFile().isDirectory()) {
                JOptionPane.showMessageDialog(this, strings.getString("the.selected.path.does.not.exist"), strings.getString("non.existant.path"), 0);
                boolean bl = false;
                return bl;
            }
            if (!file.getParentFile().canWrite()) {
                JOptionPane.showMessageDialog(this, strings.getString("you.do.not.have.write.access"), strings.getString("access.denied"), 0);
                boolean bl = false;
                return bl;
            }
            String name = file.getName();
            name = (name = name.trim()).isEmpty() ? strings.getString("generated.world") + ".world" : org.pepsoft.util.FileUtils.sanitiseName((String)name);
            final File normalisedFile = new File(file.getParentFile(), name);
            final File tempFile = new File(normalisedFile.getParentFile(), normalisedFile.getName() + ".tmp");
            if (tempFile.exists()) {
                logger.error("Temporary save file {} already exists", (Object)tempFile);
                MessageUtils.beepAndShowError((Component)this, (String)("A previous save attempt has failed\nand left temporary save file " + tempFile.getName() + " behind.\nPlease remove or rename that file and try again."), (String)"Temporary Save File Exists");
                boolean bl = false;
                return bl;
            }
            int p = name.lastIndexOf(46);
            if (p != -1) {
                name = name.substring(0, p).trim();
            }
            if ((worldName = this.world.getName()).length() != name.length()) {
                this.world.setName(name);
                this.setTitle("WorldPainter - " + name + " - " + this.dimension.getName());
            } else {
                for (int i = 0; i < name.length(); ++i) {
                    if (name.charAt(i) == '_' || name.charAt(i) == worldName.charAt(i)) continue;
                    this.world.setName(name);
                    this.setTitle("WorldPainter - " + name + " - " + this.dimension.getName());
                    break;
                }
            }
            logger.info("Saving world " + this.world.getName() + " to " + file.getAbsolutePath());
            this.saveCustomMaterials();
            this.saveCustomBiomes();
            this.saveCustomLayers();
            if (this.dimension != null) {
                this.dimension.setLastViewPosition(this.view.getViewCentreInWorldCoords());
            }
            final Configuration config = Configuration.getInstance();
            ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

                public String getName() {
                    return strings.getString("saving.world");
                }

                public Void execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    if (tempFile.exists()) {
                        throw new RuntimeException("Temporary file " + tempFile.getName() + " already exists; delete it and try again");
                    }
                    try {
                        App.this.world.addHistoryEntry(8, new Serializable[]{normalisedFile});
                        WorldIO worldIO = new WorldIO(App.this.world);
                        worldIO.save((OutputStream)new FileOutputStream(tempFile));
                        if (normalisedFile.isFile()) {
                            if (config.getWorldFileBackups() > 0) {
                                progressReceiver.setMessage(strings.getString("creating.backup.s"));
                                for (int i = config.getWorldFileBackups(); i > 0; --i) {
                                    File nextBackupFile;
                                    File file = nextBackupFile = i > 1 ? BackupUtils.getBackupFile((File)normalisedFile, (int)(i - 1)) : normalisedFile;
                                    if (!nextBackupFile.isFile()) continue;
                                    File backupFile = BackupUtils.getBackupFile((File)normalisedFile, (int)i);
                                    if (backupFile.isFile() && !backupFile.delete()) {
                                        throw new IOException("Could not delete old backup file " + backupFile.getName());
                                    }
                                    if (nextBackupFile.renameTo(backupFile)) continue;
                                    throw new IOException("Could not move " + nextBackupFile.getName() + " to " + backupFile.getName());
                                }
                                progressReceiver.setMessage(null);
                            } else if (!normalisedFile.delete()) {
                                throw new IOException("Could not delete existing file " + normalisedFile.getName() + "; world is saved as " + tempFile.getName());
                            }
                        }
                        if (!tempFile.renameTo(normalisedFile)) {
                            throw new IOException("Could not move " + tempFile.getName() + " to " + normalisedFile.getName() + "; world is saved as " + tempFile.getName());
                        }
                        HashMap<String, byte[]> layoutData = config.getJideLayoutData();
                        if (layoutData == null) {
                            layoutData = new HashMap<String, byte[]>();
                        }
                        layoutData.put(App.this.dimension.getId().toString(), App.this.dockingManager.getLayoutRawData());
                        config.setJideLayoutData(layoutData);
                        return null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O error saving file (message: " + e.getMessage() + ")", e);
                    }
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
            EventVO event = new EventVO("action.saveWorld").addTimestamp();
            event.setAttribute(Constants.ATTRIBUTE_KEY_MAX_HEIGHT, (Serializable)Integer.valueOf(this.world.getMaxHeight()));
            Dimension loadedDimension = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
            event.setAttribute(Constants.ATTRIBUTE_KEY_TILES, (Serializable)Integer.valueOf(loadedDimension.getTileCount()));
            this.logLayers(loadedDimension, event, "");
            loadedDimension = this.world.getDimension(Dimension.Anchor.NETHER_DETAIL);
            if (loadedDimension != null) {
                event.setAttribute(Constants.ATTRIBUTE_KEY_NETHER_TILES, (Serializable)Integer.valueOf(loadedDimension.getTileCount()));
                this.logLayers(loadedDimension, event, "nether.");
            }
            if ((loadedDimension = this.world.getDimension(Dimension.Anchor.END_DETAIL)) != null) {
                event.setAttribute(Constants.ATTRIBUTE_KEY_END_TILES, (Serializable)Integer.valueOf(loadedDimension.getTileCount()));
                this.logLayers(loadedDimension, event, "end.");
            }
            if (this.world.getImportedFrom() != null) {
                event.setAttribute(Constants.ATTRIBUTE_KEY_IMPORTED_WORLD, (Serializable)Boolean.valueOf(true));
            }
            config.logEvent(event);
            if (this.currentUndoManager != null) {
                this.currentUndoManager.armSavePoint();
            }
            this.lastSaveTimestamp = this.lastChangeTimestamp = System.currentTimeMillis();
            this.lastAutosavedState = this.lastSavedState = this.world.getChangeNo();
            try {
                this.rotateAutosaveFile();
            }
            catch (Error | RuntimeException e) {
                logger.error("An exception occurred while trying to rotate the autosave", e);
                MessageUtils.beepAndShowWarning((Component)this, (String)"An error occurred while trying to clear the autosave.\nWorldPainter may try to load the autosave on the next start.\nIf this keeps happening, please report it to the author.", (String)"Clearing Autosave Failed");
            }
            this.lastSelectedFile = file;
            this.addRecentlyUsedWorld(file);
            config.setWorldDirectory(file.getParentFile());
            boolean bl = true;
            return bl;
        }
        finally {
            this.resumeAutosave();
        }
    }

    private void rotateAutosaveFile() {
        if (Configuration.getInstance().isAutosaveInhibited()) {
            return;
        }
        try {
            org.pepsoft.util.FileUtils.rotateFile((File)App.getAutosaveFile(), (String)"autosave.{0}.world", (int)0, (int)3);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while rotating autosave file", e);
        }
    }

    private void maybeAutosave() {
        Configuration config = Configuration.getInstance();
        long now = System.currentTimeMillis();
        if (config.isAutosaveEnabled() && !config.isAutosaveInhibited() && this.world != null && this.pauseAutosave == 0 && now >= this.autosaveInhibitedUntil) {
            if (this.world.getChangeNo() != this.lastAutosavedState) {
                long timeSinceLastChange = now - this.lastChangeTimestamp;
                if (timeSinceLastChange > (long)config.getAutosaveDelay()) {
                    long timeSinceLastSave = now - this.lastSaveTimestamp;
                    if (timeSinceLastSave > (long)config.getAutosaveInterval()) {
                        this.autosave();
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("[AUTOSAVE] World changed, but waiting for autosave interval to expire (since last save: " + timeSinceLastSave + " ms");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("[AUTOSAVE] World changed, but waiting for guard time to expire (time since last change: " + timeSinceLastChange + " ms)");
                }
            } else {
                logger.debug("[AUTOSAVE] World not changed since last save");
            }
        } else if (logger.isDebugEnabled()) {
            if (!config.isAutosaveEnabled()) {
                logger.debug("[AUTOSAVE] Autosave disabled in configuration");
            } else if (config.isAutosaveInhibited()) {
                logger.debug("[AUTOSAVE] Autosave inhibited (e.g. due to another instance of WorldPainter running)");
            } else if (this.world == null) {
                logger.debug("[AUTOSAVE] No world loaded");
            } else if (this.pauseAutosave != 0) {
                logger.debug("[AUTOSAVE] Autosave paused");
            } else {
                logger.debug("[AUTOSAVE] Autosave temporarily inhibited");
            }
        }
    }

    private void autosave() {
        try {
            if (this.activeOperation != null) {
                this.activeOperation.interrupt();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[AUTOSAVE] Autosaving");
            }
            this.saveCustomMaterials();
            this.saveCustomBiomes();
            this.saveCustomLayers();
            if (this.dimension != null) {
                this.dimension.setLastViewPosition(this.view.getViewCentreInWorldCoords());
            }
            ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Void>(){

                public String getName() {
                    return "Autosaving";
                }

                public Void execute(ProgressReceiver progressReceiver) {
                    try {
                        App.this.rotateAutosaveFile();
                        WorldIO worldIO = new WorldIO(App.this.world);
                        worldIO.save((OutputStream)new FileOutputStream(App.getAutosaveFile()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O error autosaving world (message: " + e.getMessage() + ")", e);
                    }
                    return null;
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE, ProgressDialog.NO_FOCUS_STEALING});
            this.lastSaveTimestamp = this.lastChangeTimestamp = System.currentTimeMillis();
            this.lastAutosavedState = this.world.getChangeNo();
        }
        catch (Error | RuntimeException e) {
            logger.error("An exception occurred while trying to autosave world", e);
            MessageUtils.beepAndShowWarning((Component)this, (String)"An error occurred while trying to autosave the world.\nOne possibility is that the disk is full; please make space.\nIt has not been autosaved. If this keeps happening,\nplease report it to the author.", (String)"Autosave Failed");
        }
    }

    private boolean isAutosaveFile(File file) {
        return file.equals(App.getAutosaveFile());
    }

    private boolean isBackupFile(File file) {
        int p;
        String filename = file.getName();
        if (filename.toLowerCase().endsWith(".world")) {
            filename = filename.substring(0, filename.length() - 6);
        }
        for (p = filename.length() - 1; p > 0 && Character.isDigit(filename.charAt(p)); --p) {
        }
        return p > 0 && p < filename.length() - 1 && filename.charAt(p) == '.';
    }

    private File getOriginalFile(File backupFile) {
        int p;
        String extension = "";
        String filename = backupFile.getName();
        if (filename.toLowerCase().endsWith(".world")) {
            extension = filename.substring(filename.length() - 6);
            filename = filename.substring(0, filename.length() - 6);
        }
        for (p = filename.length() - 1; p > 0 && Character.isDigit(filename.charAt(p)); --p) {
        }
        return new File(backupFile.getParentFile(), filename.substring(0, p) + extension);
    }

    private void addRemoveTiles() {
        TileEditor tileEditor = new TileEditor(this, this.dimension, this.selectedColourScheme, this.customBiomeManager, this.hiddenLayers, false, 10, this.view.getLightOrigin());
        tileEditor.moveTo(this.view.getViewLocation());
        tileEditor.setVisible(() -> {
            if (tileEditor.isTilesChanged()) {
                this.view.refreshTiles();
            }
        });
    }

    private void importWorld() {
        if (!this.saveIfNecessary()) {
            return;
        }
        if (!Configuration.getInstance().isMessageDisplayed(IMPORT_WARNING_KEY)) {
            MessageUtils.showInfo((Component)this, (String)strings.getString("the.import.functionality.only.imports.the.i.landscape"), (String)strings.getString("information"));
        }
        MapImportDialog dialog = new MapImportDialog(this);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            World2 importedWorld = dialog.getImportedWorld();
            this.setWorld(importedWorld, true);
            this.lastSelectedFile = null;
            Configuration config = Configuration.getInstance();
            config.setMessageDisplayed(IMPORT_WARNING_KEY);
        }
    }

    public void importHeightMap(File preselectedFile) {
        if (!this.saveIfNecessary()) {
            return;
        }
        ImportHeightMapDialog dialog = new ImportHeightMapDialog(this, this.selectedColourScheme, this.view.isDrawContours(), this.view.getContourSeparation(), this.view.getLightOrigin(), preselectedFile);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.clearWorld();
            World2 importedWorld = dialog.getImportedWorld();
            if (importedWorld != null) {
                this.setWorld(importedWorld, true);
                this.lastSelectedFile = null;
            }
        }
    }

    public void importHeightMapIntoCurrentDimension(File preselectedFile) {
        if (this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        ImportHeightMapDialog dialog = new ImportHeightMapDialog(this, this.dimension, this.selectedColourScheme, this.customBiomeManager, this.view.isDrawContours(), this.view.getContourSeparation(), this.view.getLightOrigin(), preselectedFile);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.view.refreshTiles();
        }
    }

    public void importMask(File preselectedFile) {
        if (this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        ArrayList<Layer> allLayers = new ArrayList<Layer>();
        allLayers.add((Layer)Biome.INSTANCE);
        allLayers.add((Layer)Annotations.INSTANCE);
        allLayers.addAll(this.getAllLayers());
        ImportMaskDialog dialog = new ImportMaskDialog(this, this.dimension, this.selectedColourScheme, allLayers, this.customBiomeManager, preselectedFile);
        dialog.setVisible(true);
    }

    private void merge() {
        this.pauseAutosave();
        try {
            if (this.world.getImportedFrom() != null && !this.world.isAllowMerging()) {
                JOptionPane.showMessageDialog(this, strings.getString("this.world.was.imported.before.the.great.coordinate.shift"), strings.getString("merge.not.allowed"), 0);
                return;
            }
            if (this.world.getImportedFrom() == null && this.world.getMergedWith() == null && JOptionPane.showConfirmDialog(this, strings.getString("this.world.was.not.imported"), strings.getString("not.imported"), 0, 2) != 0) {
                return;
            }
            Configuration config = Configuration.getInstance();
            if (!(config != null && config.isMessageDisplayed(MERGE_WARNING_KEY) || JOptionPane.showConfirmDialog(this, strings.getString("this.is.experimental.and.unfinished.functionality"), strings.getString("experimental.functionality"), 0, 2) == 0)) {
                return;
            }
            this.saveCustomBiomes();
            this.saveCustomLayers();
            MergeWorldDialog dialog = new MergeWorldDialog(this, this.world, this.selectedColourScheme, this.customBiomeManager, this.hiddenLayers, false, 10, this.view.getLightOrigin(), this.view);
            dialog.setVisible(true);
        }
        finally {
            this.resumeAutosave();
        }
    }

    private void updateZoomLabel() {
        double factor = Math.pow(2.0, this.view.getZoom());
        float scale = this.dimension != null ? this.dimension.getScale() : 1.0f;
        int zoomPercentage = (int)(100.0 * factor / (double)scale);
        this.zoomLabel.setText(MessageFormat.format(strings.getString("zoom.0"), zoomPercentage));
        this.glassPane.setScale((float)factor / scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponents() {
        this.view = new WorldPainter(this.selectedColourScheme, this.customBiomeManager);
        final Configuration config = Configuration.getInstance();
        if (config.getBackgroundColour() == -1) {
            this.view.setBackground(new Color(VoidRenderer.getColour()));
        } else {
            this.view.setBackground(new Color(config.getBackgroundColour()));
        }
        this.view.setDrawBorders(config.isShowBorders());
        this.view.setDrawBiomes(config.isShowBiomes());
        this.view.setViewDistance(config.getViewDistance());
        this.view.setBackgroundImageMode(config.getBackgroundImageMode());
        if (config.getBackgroundImage() != null) {
            if (!config.isSafeMode()) {
                new Thread("Background Image Loader"){

                    @Override
                    public void run() {
                        try {
                            BufferedImage image = ImageIO.read(config.getBackgroundImage());
                            SwingUtilities.invokeLater(() -> App.this.view.setBackgroundImage(image));
                        }
                        catch (IOException e) {
                            logger.error("I/O error loading background image; disabling background image", (Throwable)e);
                        }
                    }
                }.start();
            } else {
                logger.info("[SAFE MODE] Not loading background image");
            }
        }
        this.view.setRadius(this.radius);
        this.view.setBrushShape(this.brush.getBrushShape());
        this.glassPane = new GlassPane();
        BufferedImage cursorImage = IconUtils.loadUnscaledImage((String)"org/pepsoft/worldpainter/cursor.png");
        java.awt.Dimension bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(Math.round(32.0f * GUIUtils.getUIScale()), Math.round(32.0f * GUIUtils.getUIScale()));
        if (bestCursorSize.width != 0 && bestCursorSize.height == bestCursorSize.width) {
            int hotspot = 15;
            if (bestCursorSize.width != 32) {
                hotspot = Math.round(15.0f * ((float)bestCursorSize.width / 32.0f));
            }
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(hotspot, hotspot), "Custom Crosshair");
            this.glassPane.setCursor(cursor);
        }
        JRootPane privateRootPane = new JRootPane();
        privateRootPane.putClientProperty(KEY_HELP_KEY, "Editor");
        privateRootPane.setContentPane((Container)((Object)this.view));
        privateRootPane.setGlassPane(this.glassPane);
        this.glassPane.setVisible(true);
        TiledImageViewerContainer viewContainer = new TiledImageViewerContainer((Component)privateRootPane);
        JPanel contentContainer = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)contentContainer, "Center");
        this.dockingManager = new DefaultDockingManager((RootPaneContainer)this, (Container)contentContainer);
        if (SystemUtils.isLinux()) {
            this.dockingManager.setOutlineMode(1);
        }
        this.dockingManager.setGroupAllowedOnSidePane(false);
        this.dockingManager.setTabbedPaneCustomizer(tabbedPane -> tabbedPane.setTabPlacement(2));
        this.dockingManager.getMainContainer().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        Workspace workspace = this.dockingManager.getWorkspace();
        workspace.setLayout((LayoutManager)new BorderLayout());
        workspace.add((Component)viewContainer, (Object)"Center");
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)this.createStatusBar(), "South");
        final ScrollController scrollController = new ScrollController();
        scrollController.install();
        this.mapDragControl = new MapDragControl(){
            private boolean mapDraggingInhibited;

            public boolean isMapDraggingInhibited() {
                return this.mapDraggingInhibited;
            }

            public void setMapDraggingInhibited(boolean mapDraggingInhibited) {
                if (mapDraggingInhibited != this.mapDraggingInhibited) {
                    this.mapDraggingInhibited = mapDraggingInhibited;
                    if (mapDraggingInhibited) {
                        scrollController.uninstall();
                    } else {
                        scrollController.install();
                    }
                }
            }
        };
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createToolPanel(), "Tools", 8, 1).build());
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createToolSettingsPanel(), "Tool Settings", 8, 2).expand().build());
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createLayerPanel(), "Layers", 8, 3).build());
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createTerrainPanel(), "Terrain", 8, 3).build());
        this.biomesPanelFrame = new DockableFrameBuilder(this.createBiomesPanelContainer(), "Biomes", 8, 3).build();
        this.dockingManager.addFrame(this.biomesPanelFrame);
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createAnnotationsPanel(), "Annotations", 8, 3).build());
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createBrushPanel(), "Brushes", 4, 1).build());
        if (this.customBrushes.containsKey(CUSTOM_BRUSHES_DEFAULT_TITLE)) {
            this.dockingManager.addFrame(new DockableFrameBuilder(this.createCustomBrushPanel(CUSTOM_BRUSHES_DEFAULT_TITLE, (BrushGroup)this.customBrushes.get(CUSTOM_BRUSHES_DEFAULT_TITLE)), CUSTOM_BRUSHES_DEFAULT_TITLE, 4, 1).withId("customBrushesDefault").build());
        }
        for (Map.Entry<String, BrushGroup> entry : this.customBrushes.entrySet()) {
            if (entry.getKey().equals(CUSTOM_BRUSHES_DEFAULT_TITLE)) continue;
            this.dockingManager.addFrame(new DockableFrameBuilder(this.createCustomBrushPanel(entry.getKey(), entry.getValue()), entry.getKey(), 4, 1).withId("customBrushes." + entry.getKey()).build());
        }
        this.dockingManager.addFrame(new DockableFrameBuilder(this.createBrushSettingsPanel(), "Brush Settings", 4, 2).withId("brushSettings").build());
        this.infoPanel = this.createInfoPanel();
        this.dockingManager.addFrame(new DockableFrameBuilder(this.infoPanel, "Info", 4, 2).withId("infoPanel").expand().withIcon(App.loadScaledIcon("information")).build());
        if (config.getDefaultJideLayoutData() != null) {
            this.dockingManager.loadLayoutFrom((InputStream)new ByteArrayInputStream(config.getDefaultJideLayoutData()));
        } else {
            this.dockingManager.resetToDefault();
        }
        MouseAdapter viewListener = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point worldCoords = App.this.view.viewToWorld(e.getX(), e.getY());
                App.this.updateStatusBar(worldCoords.x, worldCoords.y);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                App.this.locationLabel.setText(strings.getString("location-"));
                App.this.heightLabel.setText(" ");
                App.this.waterLabel.setText(" ");
                App.this.biomeLabel.setText(" ");
                App.this.materialLabel.setText(" ");
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isControlDown()) {
                    int oldZoom = App.this.view.getZoom();
                    int zoom = e.getWheelRotation() < 0 ? Math.min(oldZoom - e.getWheelRotation(), 6) : Math.max(oldZoom - e.getWheelRotation(), -4);
                    if (zoom != oldZoom) {
                        App.this.view.setZoom(zoom, e.getX(), e.getY());
                        App.this.updateZoomLabel();
                        App.this.ACTION_ZOOM_IN.setEnabled(zoom < 6);
                        App.this.ACTION_ZOOM_OUT.setEnabled(zoom > -4);
                        App.this.ACTION_ZOOM_RESET.setEnabled(zoom != 0);
                    }
                } else if (e.isAltDown() || e.isAltGraphDown()) {
                    if (e.getWheelRotation() < 0) {
                        App.this.ACTION_ROTATE_BRUSH_LEFT.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                    } else {
                        App.this.ACTION_ROTATE_BRUSH_RIGHT.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                    }
                } else if (App.this.activeOperation instanceof RadiusOperation) {
                    if (e.isShiftDown()) {
                        if (e.getWheelRotation() < 0) {
                            App.this.decreaseRadiusByOne();
                        } else {
                            App.this.increaseRadiusByOne();
                        }
                    } else if (e.getWheelRotation() < 0) {
                        App.this.decreaseRadius(-e.getWheelRotation());
                    } else {
                        App.this.increaseRadius(e.getWheelRotation());
                    }
                }
            }
        };
        this.view.addMouseMotionListener(viewListener);
        this.view.addMouseListener(viewListener);
        this.view.addMouseWheelListener(viewListener);
        if (config.getShowCalloutCount() > 0) {
            BufferedImage callout = this.loadCallout("callout_1");
            this.view.addOverlay("callout_1", 0, (Component)this.dockingManager.getFrame("tools"), callout);
            callout = this.loadCallout("callout_2");
            this.view.addOverlay("callout_2", -callout.getWidth(), (Component)this.dockingManager.getFrame("brushes"), callout);
            callout = this.loadCallout("callout_3");
            this.view.addOverlay("callout_3", 0, (Component)this.dockingManager.getFrame("layers"), callout);
            config.setShowCalloutCount(config.getShowCalloutCount() - 1);
        }
        JRootPane rootPane = this.getRootPane();
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(ACTION_NAME_INCREASE_RADIUS, (Action)((Object)new BetterAction(ACTION_NAME_INCREASE_RADIUS, strings.getString("increase.radius")){
            private static final long serialVersionUID = 2011090601L;

            @Override
            public void performAction(ActionEvent e) {
                App.this.increaseRadius(1);
            }
        }));
        actionMap.put(ACTION_NAME_INCREASE_RADIUS_BY_ONE, (Action)((Object)new BetterAction(ACTION_NAME_INCREASE_RADIUS_BY_ONE, "Increase brush radius by one"){
            private static final long serialVersionUID = 2011090601L;

            @Override
            public void performAction(ActionEvent e) {
                App.this.increaseRadiusByOne();
            }
        }));
        actionMap.put(ACTION_NAME_DECREASE_RADIUS, (Action)((Object)new BetterAction(ACTION_NAME_DECREASE_RADIUS, strings.getString("decrease.radius")){
            private static final long serialVersionUID = 2011090601L;

            @Override
            public void performAction(ActionEvent e) {
                App.this.decreaseRadius(1);
            }
        }));
        actionMap.put(ACTION_NAME_DECREASE_RADIUS_BY_ONE, (Action)((Object)new BetterAction(ACTION_NAME_DECREASE_RADIUS_BY_ONE, "Decrease brush radius by one"){
            private static final long serialVersionUID = 2011090601L;

            @Override
            public void performAction(ActionEvent e) {
                App.this.decreaseRadiusByOne();
            }
        }));
        actionMap.put(ACTION_NAME_REDO, (Action)((Object)this.ACTION_REDO));
        actionMap.put(ACTION_NAME_ZOOM_IN, (Action)((Object)this.ACTION_ZOOM_IN));
        actionMap.put(ACTION_NAME_ZOOM_OUT, (Action)((Object)this.ACTION_ZOOM_OUT));
        actionMap.put(this.ACTION_ZOOM_RESET.getName(), (Action)((Object)this.ACTION_ZOOM_RESET));
        actionMap.put(this.ACTION_ROTATE_BRUSH_LEFT.getName(), (Action)((Object)this.ACTION_ROTATE_BRUSH_LEFT));
        actionMap.put(this.ACTION_ROTATE_BRUSH_RIGHT.getName(), (Action)((Object)this.ACTION_ROTATE_BRUSH_RIGHT));
        actionMap.put(this.ACTION_ROTATE_BRUSH_RESET.getName(), (Action)((Object)this.ACTION_ROTATE_BRUSH_RESET));
        actionMap.put(this.ACTION_ROTATE_BRUSH_RIGHT_30_DEGREES.getName(), (Action)((Object)this.ACTION_ROTATE_BRUSH_RIGHT_30_DEGREES));
        actionMap.put(this.ACTION_ROTATE_BRUSH_RIGHT_45_DEGREES.getName(), (Action)((Object)this.ACTION_ROTATE_BRUSH_RIGHT_45_DEGREES));
        actionMap.put(this.ACTION_ROTATE_BRUSH_RIGHT_90_DEGREES.getName(), (Action)((Object)this.ACTION_ROTATE_BRUSH_RIGHT_90_DEGREES));
        actionMap.put("rotateLightLeft", (Action)((Object)this.ACTION_ROTATE_LIGHT_LEFT));
        actionMap.put("rotateLightRight", (Action)((Object)this.ACTION_ROTATE_LIGHT_RIGHT));
        actionMap.put("intensity10", (Action)((Object)this.ACTION_INTENSITY_10_PERCENT));
        actionMap.put("intensity20", (Action)((Object)this.ACTION_INTENSITY_20_PERCENT));
        actionMap.put("intensity30", (Action)((Object)this.ACTION_INTENSITY_30_PERCENT));
        actionMap.put("intensity40", (Action)((Object)this.ACTION_INTENSITY_40_PERCENT));
        actionMap.put("intensity50", (Action)((Object)this.ACTION_INTENSITY_50_PERCENT));
        actionMap.put("intensity60", (Action)((Object)this.ACTION_INTENSITY_60_PERCENT));
        actionMap.put("intensity70", (Action)((Object)this.ACTION_INTENSITY_70_PERCENT));
        actionMap.put("intensity80", (Action)((Object)this.ACTION_INTENSITY_80_PERCENT));
        actionMap.put("intensity90", (Action)((Object)this.ACTION_INTENSITY_90_PERCENT));
        actionMap.put("intensity100", (Action)((Object)this.ACTION_INTENSITY_100_PERCENT));
        actionMap.put(this.ACTION_ESCAPE.getName(), (Action)((Object)this.ACTION_ESCAPE));
        int platformCommandMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(109, 0), ACTION_NAME_DECREASE_RADIUS);
        inputMap.put(KeyStroke.getKeyStroke(45, 0), ACTION_NAME_DECREASE_RADIUS);
        inputMap.put(KeyStroke.getKeyStroke(107, 0), ACTION_NAME_INCREASE_RADIUS);
        inputMap.put(KeyStroke.getKeyStroke(61, 64), ACTION_NAME_INCREASE_RADIUS);
        inputMap.put(KeyStroke.getKeyStroke(109, 64), ACTION_NAME_DECREASE_RADIUS_BY_ONE);
        inputMap.put(KeyStroke.getKeyStroke(45, 64), ACTION_NAME_DECREASE_RADIUS_BY_ONE);
        inputMap.put(KeyStroke.getKeyStroke(107, 64), ACTION_NAME_INCREASE_RADIUS_BY_ONE);
        inputMap.put(KeyStroke.getKeyStroke(90, platformCommandMask | 0x40), ACTION_NAME_REDO);
        inputMap.put(KeyStroke.getKeyStroke(45, platformCommandMask), ACTION_NAME_ZOOM_OUT);
        inputMap.put(KeyStroke.getKeyStroke(61, platformCommandMask | 0x40), ACTION_NAME_ZOOM_IN);
        inputMap.put(KeyStroke.getKeyStroke(96, platformCommandMask), this.ACTION_ZOOM_RESET.getName());
        inputMap.put(KeyStroke.getKeyStroke(109, 512), this.ACTION_ROTATE_BRUSH_LEFT.getName());
        inputMap.put(KeyStroke.getKeyStroke(45, 512), this.ACTION_ROTATE_BRUSH_LEFT.getName());
        inputMap.put(KeyStroke.getKeyStroke(107, 512), this.ACTION_ROTATE_BRUSH_RIGHT.getName());
        inputMap.put(KeyStroke.getKeyStroke(61, 576), this.ACTION_ROTATE_BRUSH_RIGHT.getName());
        inputMap.put(KeyStroke.getKeyStroke(48, 512), this.ACTION_ROTATE_BRUSH_RESET.getName());
        inputMap.put(KeyStroke.getKeyStroke(96, 512), this.ACTION_ROTATE_BRUSH_RESET.getName());
        inputMap.put(KeyStroke.getKeyStroke(51, 512), this.ACTION_ROTATE_BRUSH_RIGHT_30_DEGREES.getName());
        inputMap.put(KeyStroke.getKeyStroke(99, 512), this.ACTION_ROTATE_BRUSH_RIGHT_30_DEGREES.getName());
        inputMap.put(KeyStroke.getKeyStroke(52, 512), this.ACTION_ROTATE_BRUSH_RIGHT_45_DEGREES.getName());
        inputMap.put(KeyStroke.getKeyStroke(100, 512), this.ACTION_ROTATE_BRUSH_RIGHT_45_DEGREES.getName());
        inputMap.put(KeyStroke.getKeyStroke(57, 512), this.ACTION_ROTATE_BRUSH_RIGHT_90_DEGREES.getName());
        inputMap.put(KeyStroke.getKeyStroke(105, 512), this.ACTION_ROTATE_BRUSH_RIGHT_90_DEGREES.getName());
        inputMap.put(this.ACTION_ROTATE_LIGHT_LEFT.getAcceleratorKey(), "rotateLightLeft");
        inputMap.put(this.ACTION_ROTATE_LIGHT_RIGHT.getAcceleratorKey(), "rotateLightRight");
        inputMap.put(this.ACTION_INTENSITY_10_PERCENT.getAcceleratorKey(), "intensity10");
        inputMap.put(this.ACTION_INTENSITY_20_PERCENT.getAcceleratorKey(), "intensity20");
        inputMap.put(this.ACTION_INTENSITY_30_PERCENT.getAcceleratorKey(), "intensity30");
        inputMap.put(this.ACTION_INTENSITY_40_PERCENT.getAcceleratorKey(), "intensity40");
        inputMap.put(this.ACTION_INTENSITY_50_PERCENT.getAcceleratorKey(), "intensity50");
        inputMap.put(this.ACTION_INTENSITY_60_PERCENT.getAcceleratorKey(), "intensity60");
        inputMap.put(this.ACTION_INTENSITY_70_PERCENT.getAcceleratorKey(), "intensity70");
        inputMap.put(this.ACTION_INTENSITY_80_PERCENT.getAcceleratorKey(), "intensity80");
        inputMap.put(this.ACTION_INTENSITY_90_PERCENT.getAcceleratorKey(), "intensity90");
        inputMap.put(this.ACTION_INTENSITY_100_PERCENT.getAcceleratorKey(), "intensity100");
        inputMap.put(KeyStroke.getKeyStroke(97, 0), "intensity10");
        inputMap.put(KeyStroke.getKeyStroke(98, 0), "intensity20");
        inputMap.put(KeyStroke.getKeyStroke(99, 0), "intensity30");
        inputMap.put(KeyStroke.getKeyStroke(100, 0), "intensity40");
        inputMap.put(KeyStroke.getKeyStroke(101, 0), "intensity50");
        inputMap.put(KeyStroke.getKeyStroke(102, 0), "intensity60");
        inputMap.put(KeyStroke.getKeyStroke(103, 0), "intensity70");
        inputMap.put(KeyStroke.getKeyStroke(104, 0), "intensity80");
        inputMap.put(KeyStroke.getKeyStroke(105, 0), "intensity90");
        inputMap.put(KeyStroke.getKeyStroke(96, 0), "intensity100");
        inputMap.put(this.ACTION_ESCAPE.getAcceleratorKey(), this.ACTION_ESCAPE.getName());
        this.programmaticChange = true;
        try {
            this.selectBrushButton(this.brush);
            this.levelSlider.setValue((int)(this.level * 100.0f));
            this.brushRotationSlider.setValue(this.brushRotation);
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private InfoPanel createInfoPanel() {
        return new InfoPanel(this.view, this.customBiomeManager);
    }

    private BufferedImage loadCallout(String key) {
        try {
            BufferedImage callout = ImageIO.read(App.class.getResourceAsStream("/org/pepsoft/worldpainter/" + key + ".png"));
            this.callouts.put(key, callout);
            return callout;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading callout image from classpath", e);
        }
    }

    private boolean closeCallout(String key) {
        if (this.callouts.containsKey(key)) {
            this.view.removeOverlay(key);
            this.callouts.remove(key);
            return true;
        }
        return false;
    }

    private JPanel createStatusBar() {
        JPanel statusBar = new JPanel();
        statusBar.setLayout(new FlowLayout(3));
        StringBuilder warnings = new StringBuilder();
        Configuration config = Configuration.getInstance();
        if (config.isAutosaveEnabled() && config.isAutosaveInhibited()) {
            warnings.append("Autosave disabled");
        }
        if (config.isSafeMode()) {
            if (warnings.length() > 0) {
                warnings.append(": ");
            }
            warnings.append("Safe mode");
        }
        if (warnings.length() > 0) {
            JLabel warningsLabel = new JLabel(warnings.toString(), IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/error.png"), 10);
            warningsLabel.setBorder(new BevelBorder(1));
            statusBar.add(warningsLabel);
        }
        this.locationLabel = new JLabel(MessageFormat.format(strings.getString("location.0.1"), "-99,999", "-99,999"));
        this.locationLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.locationLabel);
        this.heightLabel = new JLabel(MessageFormat.format(strings.getString("height.0.of.1"), "-9,999", "9,999"));
        this.heightLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.heightLabel);
        this.slopeLabel = new JLabel("Slope: 90\u00b0");
        this.slopeLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.slopeLabel);
        this.materialLabel = new JLabel(MessageFormat.format(strings.getString("material.0"), Material.MOSSY_COBBLESTONE.toString()));
        this.materialLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.materialLabel);
        this.waterLabel = new JLabel(MessageFormat.format(strings.getString("fluid.level.1.depth.2"), 0, "-9,999", "9,999"));
        this.waterLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.waterLabel);
        this.biomeLabel = new JLabel("Auto biome: Mega Spruce Taiga Hills (ID 161)");
        this.biomeLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.biomeLabel);
        this.radiusLabel = new JLabel(MessageFormat.format(strings.getString("radius.0"), 15984));
        this.radiusLabel.setToolTipText(strings.getString("scroll.the.mouse.wheel"));
        this.radiusLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.radiusLabel);
        this.zoomLabel = new JLabel(MessageFormat.format(strings.getString("zoom.0"), 3200));
        this.zoomLabel.setBorder(new BevelBorder(1));
        statusBar.add(this.zoomLabel);
        final JProgressBar memoryBar = new JProgressBar();
        memoryBar.setBorder(new BevelBorder(1));
        java.awt.Dimension preferredSize = memoryBar.getPreferredSize();
        preferredSize.width = 100;
        memoryBar.setPreferredSize(preferredSize);
        memoryBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Forcing garbage collect");
                }
                System.gc();
            }
        });
        statusBar.add(memoryBar);
        new Timer(2500, new ActionListener(){
            private final Runtime runtime = Runtime.getRuntime();

            @Override
            public void actionPerformed(ActionEvent e) {
                long free = this.runtime.freeMemory();
                long total = this.runtime.totalMemory();
                long max = this.runtime.maxMemory();
                long inUse = total - free;
                memoryBar.setValue((int)(inUse * 100L / max));
                int inUseMB = (int)(inUse / 0x100000L);
                int maxMB = (int)(max / 0x100000L);
                memoryBar.setToolTipText(MessageFormat.format(strings.getString("memory.usage.0.mb.of.1.mb"), inUseMB, maxMB));
            }
        }).start();
        return statusBar;
    }

    private JPanel createToolPanel() {
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new GridLayout(0, 4));
        toolPanel.add(this.createButtonForOperation(new SprayPaint(this.view, this, this.mapDragControl), 'r'));
        toolPanel.add(this.createButtonForOperation(new Pencil(this.view, this, this.mapDragControl), 'p'));
        toolPanel.add(this.createButtonForOperation(new Fill(this.view), 'l'));
        toolPanel.add(this.createButtonForOperation(new Text(this.view), 'x'));
        toolPanel.add(this.createButtonForOperation(new Flood(this.view, false), 'f'));
        toolPanel.add(this.createButtonForOperation(new Flood(this.view, true)));
        toolPanel.add(this.createButtonForOperation(new Sponge(this.view, this, this.mapDragControl)));
        this.eyedropperToggleButton = new JToggleButton(App.loadScaledIcon("eyedropper"));
        this.eyedropperToggleButton.setMnemonic('y');
        this.eyedropperToggleButton.setMargin(BUTTON_INSETS);
        this.eyedropperToggleButton.addActionListener(e -> {
            if (!this.eyedropperToggleButton.isSelected()) {
                return;
            }
            if (this.dimension == null) {
                this.eyedropperToggleButton.setSelected(false);
                DesktopUtils.beep();
                return;
            }
            this.mapSelectionController.selectPaintOnMap(null, new Eyedropper.SelectionListener(){

                @Override
                public void terrainSelected(Terrain terrain) {
                    App.this.eyedropperToggleButton.setSelected(false);
                    App.getInstance().selectPaint(PaintFactory.createTerrainPaintId(terrain));
                }

                @Override
                public void layerSelected(Layer layer, int value) {
                    App.this.eyedropperToggleButton.setSelected(false);
                    if (layer.discrete) {
                        App.getInstance().selectPaint(PaintFactory.createDiscreteLayerPaintId(layer, value));
                    } else {
                        App.getInstance().selectPaint(PaintFactory.createLayerPaintId(layer));
                    }
                }

                @Override
                public void selectionCancelled(boolean byUser) {
                }
            });
        });
        this.eyedropperToggleButton.setToolTipText("Eyedropper: Select a paint from the map (Alt+y)");
        this.eyedropperToggleButton.putClientProperty(KEY_HELP_KEY, "Operation/Eyedropper");
        toolPanel.add(this.eyedropperToggleButton);
        toolPanel.add(this.createButtonForOperation(new Height(this.view, this, this.mapDragControl), 'h'));
        toolPanel.add(this.createButtonForOperation(new Flatten(this.view, this, this.mapDragControl), 'a'));
        toolPanel.add(this.createButtonForOperation(new Smooth(this.view, this, this.mapDragControl), 's'));
        toolPanel.add(this.createButtonForOperation(new RaiseMountain(this.view, this, this.mapDragControl), 'm'));
        toolPanel.add(this.createButtonForOperation(new SetSpawnPoint(this.view)));
        JButton button = new JButton(App.loadScaledIcon("globals"));
        button.setMargin(BUTTON_INSETS);
        button.addActionListener(e -> this.showGlobalOperations());
        button.setToolTipText(strings.getString("global.operations.fill.or.clear.the.world.with.a.terrain.biome.or.layer"));
        button.putClientProperty(KEY_HELP_KEY, "Operation/GlobalOperations");
        toolPanel.add(button);
        toolPanel.add(this.createButtonForOperation(new RaiseRotatedPyramid(this.view)));
        toolPanel.add(this.createButtonForOperation(new RaisePyramid(this.view)));
        JToggleButton copySelectionButton = this.createButtonForOperation(new CopySelectionOperation(this.view));
        copySelectionButton.setEnabled(this.selectionState.getValue());
        toolPanel.add(this.createButtonForOperation(new EditSelectionOperation(this.view, this, this.mapDragControl, this.selectionState)));
        toolPanel.add(copySelectionButton);
        JButton clearSelectionButton = new JButton(App.loadScaledIcon("clear_selection"));
        clearSelectionButton.setEnabled(this.selectionState.getValue());
        clearSelectionButton.setMargin(BUTTON_INSETS);
        clearSelectionButton.addActionListener(e -> {
            if (this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            if (this.dimension.containsOneOf(new Layer[]{SelectionChunk.INSTANCE, SelectionBlock.INSTANCE})) {
                this.dimension.setEventsInhibited(true);
                try {
                    new SelectionHelper(this.dimension).clearSelection();
                    this.dimension.armSavePoint();
                }
                finally {
                    this.dimension.setEventsInhibited(false);
                }
            } else {
                DesktopUtils.beep();
            }
            if (this.activeOperation instanceof CopySelectionOperation) {
                this.deselectTool();
            }
        });
        clearSelectionButton.setToolTipText("Clear the selection");
        this.selectionState.addObserver((o, selectionMayBePresent) -> {
            copySelectionButton.setEnabled((Boolean)selectionMayBePresent);
            clearSelectionButton.setEnabled((Boolean)selectionMayBePresent);
        });
        clearSelectionButton.putClientProperty(KEY_HELP_KEY, "Operation/ClearSelection");
        toolPanel.add(clearSelectionButton);
        for (Operation operation : this.operations) {
            operation.setView((WorldPainterView)this.view);
            toolPanel.add(this.createButtonForOperation(operation));
        }
        return toolPanel;
    }

    private JPanel createToolSettingsPanel() {
        this.toolSettingsPanel = new JPanel(new BorderLayout());
        return this.toolSettingsPanel;
    }

    private JPanel createLayerPanel() {
        JPanel layerPanel = new JPanel();
        layerPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, 1, 1);
        JideLabel label = new JideLabel("Show");
        label.setOrientation(1);
        label.setClockwise(false);
        label.setMinimumSize(label.getPreferredSize());
        constraints.anchor = 15;
        layerPanel.add((Component)label, constraints);
        label = new JideLabel("Solo");
        label.setOrientation(1);
        label.setClockwise(false);
        label.setMinimumSize(label.getPreferredSize());
        layerPanel.add((Component)label, constraints);
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        layerPanel.add((Component)new JLabel(), constraints);
        Configuration config = Configuration.getInstance();
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        List<Component> terrainComponents = this.createTerrainDropDown();
        this.terrainSoloCheckBox = (JCheckBox)terrainComponents.get(1);
        this.terrainModeComboBox = (JComboBox)terrainComponents.get(2);
        LayoutUtils.addRowOfComponents(layerPanel, constraints, terrainComponents);
        LayoutUtils.addRowOfComponents(layerPanel, constraints, this.createLayerButton(TileRenderer.FLUIDS_AS_LAYER, '\u0000', false, false));
        for (Layer layer : this.layers) {
            LayoutUtils.addRowOfComponents(layerPanel, constraints, this.createLayerButton(layer, layer.getMnemonic()));
        }
        if (!config.isEasyMode()) {
            LayoutUtils.addRowOfComponents(layerPanel, constraints, this.createLayerButton((Layer)Populate.INSTANCE, 'p'));
        }
        LayoutUtils.addRowOfComponents(layerPanel, constraints, this.createLayerButton((Layer)ReadOnly.INSTANCE, 'o'));
        JButton addLayerButton = new JButton(App.loadScaledIcon("plus"));
        addLayerButton.setToolTipText(strings.getString("add.a.custom.layer"));
        addLayerButton.setMargin(BUTTON_INSETS);
        addLayerButton.addActionListener(e -> {
            if (this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            if (layerPanel.isShowing()) {
                JPopupMenu customLayerMenu = this.createCustomLayerMenu(null);
                customLayerMenu.show(layerPanel, addLayerButton.getX() + addLayerButton.getWidth(), addLayerButton.getY());
            }
        });
        JPanel spacer = new JPanel();
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        layerPanel.add((Component)spacer, constraints);
        spacer = new JPanel();
        layerPanel.add((Component)spacer, constraints);
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        layerPanel.add((Component)addLayerButton, constraints);
        layerPanel.putClientProperty(KEY_ICON, ICON_LAYERS);
        return layerPanel;
    }

    private List<Component> createTerrainDropDown() {
        JComboBox<TerrainMode> comboBox = new JComboBox<TerrainMode>(TerrainMode.values());
        final ImageIcon terrainIcon = new ImageIcon(TileRenderer.TERRAIN_AS_LAYER.getIcon());
        final String terrainName = TileRenderer.TERRAIN_AS_LAYER.getName();
        final ImageIcon defaultColourRampIcon = new ImageIcon(new DefaultColourRamp(-64, 62, 320).getPreview((int)(80.0f * GUIUtils.getUIScale()), (int)(16.0f * GUIUtils.getUIScale()), -64.0f, 319.0f));
        final ImageIcon defaultGreyscaleRampIcon = new ImageIcon(new ColourGradient(0.0f, 0, 1.0f, 0xFFFFFF, ColourGradient.Transition.LINEAR).getPreview((int)(80.0f * GUIUtils.getUIScale()), (int)(16.0f * GUIUtils.getUIScale()), 0.0f, 1.0f));
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                switch ((TerrainMode)((Object)value)) {
                    case SHOW_TERRAIN: {
                        this.setIcon(terrainIcon);
                        this.setText(terrainName);
                        break;
                    }
                    case HIDE_TERRAIN: {
                        this.setIcon(ICON_NO_TERRAIN);
                        this.setText("Hide Terrain");
                        break;
                    }
                    case DEFAULT_COLOUR_RAMP: {
                        this.setIcon(defaultColourRampIcon);
                        this.setText(null);
                        break;
                    }
                    case DEFAULT_GREYSCALE_RAMP: {
                        this.setIcon(defaultGreyscaleRampIcon);
                        this.setText(null);
                    }
                }
                return this;
            }
        });
        comboBox.addActionListener(e -> {
            this.terrainMode = (TerrainMode)((Object)((Object)comboBox.getSelectedItem()));
            switch (this.terrainMode) {
                case SHOW_TERRAIN: {
                    this.hiddenLayers.remove(TileRenderer.TERRAIN_AS_LAYER);
                    break;
                }
                case HIDE_TERRAIN: {
                    this.hiddenLayers.add(TileRenderer.TERRAIN_AS_LAYER);
                    this.view.setColourRamp(null);
                    break;
                }
                case DEFAULT_COLOUR_RAMP: {
                    this.hiddenLayers.add(TileRenderer.TERRAIN_AS_LAYER);
                    if (this.dimension == null) break;
                    this.setDefaultColourRamp();
                    break;
                }
                case DEFAULT_GREYSCALE_RAMP: {
                    this.hiddenLayers.add(TileRenderer.TERRAIN_AS_LAYER);
                    if (this.dimension == null) break;
                    this.setDefaultGreyscaleRamp();
                }
            }
            this.updateLayerVisibility();
        });
        return this.createLayerRow(TileRenderer.TERRAIN_AS_LAYER, false, true, comboBox);
    }

    private boolean refreshTerrainMode() {
        switch (this.terrainMode) {
            case DEFAULT_COLOUR_RAMP: {
                return this.setDefaultColourRamp();
            }
            case DEFAULT_GREYSCALE_RAMP: {
                return this.setDefaultGreyscaleRamp();
            }
        }
        return false;
    }

    private boolean setDefaultColourRamp() {
        int waterLevel = this.dimension.getTileFactory() instanceof HeightMapTileFactory ? ((HeightMapTileFactory)this.dimension.getTileFactory()).getWaterHeight() : 62;
        return this.view.setColourRamp((ColourRamp)new DefaultColourRamp(this.dimension.getMinHeight(), waterLevel, this.dimension.getMaxHeight()));
    }

    private boolean setDefaultGreyscaleRamp() {
        return this.view.setColourRamp((ColourRamp)new ColourGradient((float)this.dimension.getMinHeight(), 0, (float)this.dimension.getMaxHeight(), 0xFFFFFF, ColourGradient.Transition.LINEAR));
    }

    private JPanel createBiomesPanelContainer() {
        JPanel biomesPanelContainer = new JPanel();
        biomesPanelContainer.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, 1, 1);
        Configuration config = Configuration.getInstance();
        constraints.anchor = 23;
        constraints.weightx = 0.0;
        JCheckBox checkBox = new JCheckBox("Show:");
        checkBox.setHorizontalTextPosition(10);
        checkBox.setToolTipText("Uncheck to hide biomes from view (it will still be exported)");
        checkBox.addActionListener(e -> {
            if (checkBox.isSelected()) {
                this.hiddenLayers.remove(Biome.INSTANCE);
            } else {
                this.hiddenLayers.add((Layer)Biome.INSTANCE);
            }
            this.updateLayerVisibility();
        });
        if (!config.isEasyMode()) {
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            biomesPanelContainer.add((Component)checkBox, constraints);
        }
        JCheckBox soloCheckBox = new JCheckBox("Solo:");
        soloCheckBox.setHorizontalTextPosition(10);
        soloCheckBox.setToolTipText("<html>Check to show <em>only</em> the biomes (the other layers are still exported)</html>");
        soloCheckBox.addActionListener(new SoloCheckboxHandler(soloCheckBox, (Layer)Biome.INSTANCE));
        this.layerSoloCheckBoxes.put((Layer)Biome.INSTANCE, soloCheckBox);
        if (!config.isEasyMode()) {
            constraints.gridwidth = 0;
            biomesPanelContainer.add((Component)soloCheckBox, constraints);
        }
        this.biomesPanel = new BiomesPanel(this.customBiomeManager, biomeId -> {
            this.paintUpdater = () -> {
                this.paint = PaintFactory.createDiscreteLayerPaint((Layer)Biome.INSTANCE, biomeId);
                this.paintChanged();
            };
            this.paintUpdater.updatePaint();
        }, this.paintButtonGroup);
        biomesPanelContainer.add((Component)this.biomesPanel, constraints);
        this.layerControls.put((Layer)Biome.INSTANCE, new LayerControls((Layer)Biome.INSTANCE, checkBox, soloCheckBox, null));
        biomesPanelContainer.putClientProperty(KEY_ICON, ICON_BIOMES);
        return biomesPanelContainer;
    }

    private JPanel createAnnotationsPanel() {
        JPanel layerPanel = new JPanel();
        layerPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, 1, 1);
        Configuration config = Configuration.getInstance();
        constraints.anchor = 23;
        constraints.weightx = 0.0;
        JCheckBox checkBox = new JCheckBox("Show:");
        checkBox.setHorizontalTextPosition(10);
        checkBox.setSelected(true);
        checkBox.setToolTipText("Uncheck to hide annotations from view");
        checkBox.addActionListener(e -> {
            if (checkBox.isSelected()) {
                this.hiddenLayers.remove(Annotations.INSTANCE);
            } else {
                this.hiddenLayers.add((Layer)Annotations.INSTANCE);
            }
            this.updateLayerVisibility();
        });
        if (!config.isEasyMode()) {
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            layerPanel.add((Component)checkBox, constraints);
        }
        JCheckBox soloCheckBox = new JCheckBox("Solo:");
        soloCheckBox.setHorizontalTextPosition(10);
        soloCheckBox.setToolTipText("<html>Check to show <em>only</em> the annotations (the other layers are still exported)</html>");
        soloCheckBox.addActionListener(new SoloCheckboxHandler(soloCheckBox, (Layer)Annotations.INSTANCE));
        this.layerSoloCheckBoxes.put((Layer)Annotations.INSTANCE, soloCheckBox);
        if (!config.isEasyMode()) {
            constraints.gridwidth = 0;
            layerPanel.add((Component)soloCheckBox, constraints);
        }
        JPanel colourGrid = new JPanel(new GridLayout(0, 4));
        for (int i = 1; i < 16; ++i) {
            int selectedColour = i;
            int dataValue = i - (i < 8 ? 1 : 0);
            JToggleButton button = new JToggleButton(IconUtils.createScaledColourIcon((int)this.selectedColourScheme.getColour(Material.WOOLS[dataValue])));
            button.setToolTipText(org.pepsoft.minecraft.Constants.COLOUR_NAMES[dataValue]);
            button.setMargin(BUTTON_INSETS);
            if (i == 1) {
                button.setSelected(true);
            }
            this.paintButtonGroup.add(button);
            button.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.paintUpdater = () -> {
                        this.paint = PaintFactory.createDiscreteLayerPaint((Layer)Annotations.INSTANCE, selectedColour);
                        this.paintChanged();
                    };
                    this.paintUpdater.updatePaint();
                }
            });
            button.putClientProperty(KEY_PAINT_ID, PaintFactory.createDiscreteLayerPaintId((Layer)Annotations.INSTANCE, selectedColour));
            colourGrid.add(button);
        }
        layerPanel.add((Component)colourGrid, constraints);
        this.layerControls.put((Layer)Annotations.INSTANCE, new LayerControls((Layer)Annotations.INSTANCE, checkBox, soloCheckBox));
        layerPanel.putClientProperty(KEY_ICON, ICON_ANNOTATIONS);
        return layerPanel;
    }

    private JPopupMenu createCustomLayerMenu(String paletteName) {
        BetterJPopupMenu customLayerMenu = new BetterJPopupMenu();
        JMenuItem menuItem = new JMenuItem(strings.getString("add.a.custom.object.layer") + "...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<Bo2Layer>> dialog = new EditLayerDialog<Class<Bo2Layer>>((Window)this, this.world.getPlatform(), Bo2Layer.class);
            dialog.setVisible(() -> {
                Bo2Layer layer = (Bo2Layer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("add.a.custom.ground.cover.layer") + "...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<GroundCoverLayer>> dialog = new EditLayerDialog<Class<GroundCoverLayer>>((Window)this, this.world.getPlatform(), GroundCoverLayer.class);
            dialog.setVisible(() -> {
                GroundCoverLayer layer = (GroundCoverLayer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        Dimension.Anchor anchor = this.dimension.getAnchor();
        menuItem = new JMenuItem(strings.getString("add.a.custom.underground.pockets.layer") + "...");
        menuItem.addActionListener(e -> {
            UndergroundPocketsDialog dialog = new UndergroundPocketsDialog((Window)this, this.world.getPlatform(), MixedMaterial.create((Platform)this.world.getPlatform(), (Material)Material.IRON_BLOCK), this.selectedColourScheme, this.dimension.getMinHeight(), this.dimension.getMaxHeight(), this.world.isExtendedBlockIds());
            dialog.setVisible(() -> {
                UndergroundPocketsLayer layer = dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        if (anchor.role == Dimension.Role.CAVE_FLOOR) {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a custom cave/tunnel layer...");
        menuItem.addActionListener(e -> {
            int waterLevel;
            int baseHeight;
            TunnelLayer layer = new TunnelLayer("Tunnels", 0);
            TileFactory tileFactory = this.dimension.getTileFactory();
            if (tileFactory instanceof HeightMapTileFactory) {
                baseHeight = (int)((HeightMapTileFactory)tileFactory).getBaseHeight();
                waterLevel = ((HeightMapTileFactory)tileFactory).getWaterHeight();
                layer.setFloodWithLava(((HeightMapTileFactory)tileFactory).isFloodWithLava());
            } else {
                baseHeight = 58;
                waterLevel = 62;
            }
            TunnelLayerDialog dialog = new TunnelLayerDialog(this, this.world.getPlatform(), layer, this.dimension, this.world.isExtendedBlockIds(), this.selectedColourScheme, this.customBiomeManager, this.dimension.getMinHeight(), this.dimension.getMaxHeight(), baseHeight, waterLevel);
            dialog.setVisible(() -> {
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        if (anchor.role == Dimension.Role.CAVE_FLOOR) {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a custom plants layer...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<PlantLayer>> dialog = new EditLayerDialog<Class<PlantLayer>>((Window)this, this.world.getPlatform(), PlantLayer.class);
            dialog.setVisible(() -> {
                PlantLayer layer = (PlantLayer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Add a combined layer...");
        menuItem.addActionListener(e -> {
            EditLayerDialog<Class<CombinedLayer>> dialog = new EditLayerDialog<Class<CombinedLayer>>((Window)this, this.world.getPlatform(), CombinedLayer.class);
            dialog.setVisible(() -> {
                CombinedLayer layer = (CombinedLayer)dialog.getLayer();
                if (paletteName != null) {
                    layer.setPalette(paletteName);
                }
                this.registerCustomLayer((CustomLayer)layer, true);
            });
        });
        customLayerMenu.add(menuItem);
        ArrayList allPluginLayers = new ArrayList();
        for (CustomLayerProvider layerProvider : WPPluginManager.getInstance().getPlugins(CustomLayerProvider.class)) {
            allPluginLayers.addAll(layerProvider.getCustomLayers());
        }
        if (!allPluginLayers.isEmpty()) {
            customLayerMenu.addSeparator();
            for (Class customLayerClass : allPluginLayers) {
                menuItem = new JMenuItem("Add a " + customLayerClass.getSimpleName() + " layer...");
                menuItem.addActionListener(e -> {
                    EditLayerDialog<Class> dialog = new EditLayerDialog<Class>((Window)this, this.world.getPlatform(), customLayerClass);
                    dialog.setVisible(() -> {
                        CustomLayer layer = (CustomLayer)dialog.getLayer();
                        if (paletteName != null) {
                            layer.setPalette(paletteName);
                        }
                        this.registerCustomLayer(layer, true);
                    });
                });
                customLayerMenu.add(menuItem);
            }
            customLayerMenu.addSeparator();
        }
        menuItem = new JMenu("Copy layer from another dimension");
        menuItem.setToolTipText("This will make a duplicate of the layer, with its own identity and separate settings");
        Function<Layer, Boolean> filter = this.getLayerFilterForCurrentDimension();
        List<JMenuItem> copyMenuItems = this.getCopyLayerMenuItems(paletteName != null ? paletteName : "Custom Layers", filter);
        if (!copyMenuItems.isEmpty()) {
            for (JMenuItem copyMenuItem : copyMenuItems) {
                ((JMenu)menuItem).add(copyMenuItem);
            }
        } else {
            menuItem.setEnabled(false);
        }
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Import custom layer(s) from file...");
        menuItem.addActionListener(e -> this.importLayers(paletteName, filter));
        customLayerMenu.add(menuItem);
        menuItem = new JMenuItem("Import custom layer(s) from another world...");
        menuItem.addActionListener(e -> this.importCustomItemsFromWorld(CustomItemsTreeModel.ItemType.LAYER, filter));
        customLayerMenu.add(menuItem);
        return customLayerMenu;
    }

    @Nullable
    private Function<Layer, Boolean> getLayerFilterForCurrentDimension() {
        if (this.dimension != null && this.dimension.getAnchor().role == Dimension.Role.CAVE_FLOOR) {
            return TunnelLayer::isLayerSupportedForFloorDimension;
        }
        return null;
    }

    private List<JMenuItem> getCopyLayerMenuItems(String targetPaletteName, Function<Layer, Boolean> filter) {
        if (targetPaletteName == null) {
            throw new NullPointerException("targetPaletteName");
        }
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        for (Dimension dimension : this.world.getDimensions()) {
            JMenu menuForDimension;
            if (dimension == this.dimension) continue;
            HashMap<String, JMenu> menusForDimension = new HashMap<String, JMenu>();
            for (CustomLayer layer : dimension.getCustomLayers()) {
                if (!layer.isExportable() || filter != null && !filter.apply((Layer)layer).booleanValue()) continue;
                String palette = layer.getPalette();
                JMenuItem menuForPalette = menusForDimension.computeIfAbsent(palette, k -> new JMenu(palette));
                JMenuItem menuItem = new JMenuItem(layer.getName(), new ImageIcon(layer.getIcon()));
                menuItem.addActionListener(event -> this.copyLayerToPalette(layer, targetPaletteName, true));
                menuForPalette.add(menuItem);
            }
            if (menusForDimension.size() == 1) {
                menuForDimension = (JMenu)menusForDimension.values().iterator().next();
                menuForDimension.setText(dimension.getName());
            } else {
                menuForDimension = new JMenu(dimension.getName());
                for (JMenu menu : menusForDimension.values()) {
                    menuForDimension.add(menu);
                }
            }
            if (menuForDimension.getItemCount() <= 0) continue;
            menuItems.add(menuForDimension);
        }
        if (menuItems.size() == 1) {
            return Lists.transform(Arrays.asList(((JMenu)menuItems.get(0)).getMenuComponents()), e -> (JMenuItem)e);
        }
        return menuItems;
    }

    private void copyLayerToPalette(CustomLayer layer, String paletteName, boolean activate) {
        CustomLayer copy = layer.clone();
        copy.setPalette(paletteName);
        this.registerCustomLayer(copy, activate);
    }

    private JPanel createTerrainPanel() {
        JPanel terrainPanel = new JPanel();
        terrainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(1, 1, 1, 1);
        Configuration config = Configuration.getInstance();
        constraints.anchor = 23;
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        if (!config.isEasyMode()) {
            RemoteJCheckBox checkBoxSoloTerrain = new RemoteJCheckBox(this.terrainSoloCheckBox, "Solo:");
            checkBoxSoloTerrain.setHorizontalTextPosition(10);
            checkBoxSoloTerrain.setToolTipText("<html>Check to show <em>only</em> the biomes (the other layers are still exported)</html>");
            terrainPanel.add((Component)checkBoxSoloTerrain, constraints);
        }
        JPanel buttonPanel = new JPanel(new GridLayout(0, 5));
        buttonPanel.add(this.createTerrainButton(Terrain.GRASS));
        buttonPanel.add(this.createTerrainButton(Terrain.PERMADIRT));
        buttonPanel.add(this.createTerrainButton(Terrain.SAND));
        buttonPanel.add(this.createTerrainButton(Terrain.GRASS_PATH));
        buttonPanel.add(this.createTerrainButton(Terrain.PODZOL));
        buttonPanel.add(this.createTerrainButton(Terrain.BARE_GRASS));
        buttonPanel.add(this.createTerrainButton(Terrain.MOSS));
        buttonPanel.add(this.createTerrainButton(Terrain.MUD));
        buttonPanel.add(this.createTerrainButton(Terrain.GRAVEL));
        buttonPanel.add(this.createTerrainButton(Terrain.CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.STONE_MIX));
        buttonPanel.add(this.createTerrainButton(Terrain.GRANITE));
        buttonPanel.add(this.createTerrainButton(Terrain.DIORITE));
        buttonPanel.add(this.createTerrainButton(Terrain.ANDESITE));
        buttonPanel.add(this.createTerrainButton(Terrain.CALCITE));
        buttonPanel.add(this.createTerrainButton(Terrain.COBBLESTONE));
        buttonPanel.add(this.createTerrainButton(Terrain.MOSSY_COBBLESTONE));
        buttonPanel.add(this.createTerrainButton(Terrain.STONE));
        buttonPanel.add(this.createTerrainButton(Terrain.DEEPSLATE));
        buttonPanel.add(this.createTerrainButton(Terrain.ROCK));
        buttonPanel.add(this.createTerrainButton(Terrain.TUFF));
        buttonPanel.add(this.createTerrainButton(Terrain.BEDROCK));
        buttonPanel.add(this.createTerrainButton(Terrain.MYCELIUM));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.createTerrainButton(Terrain.OBSIDIAN));
        buttonPanel.add(this.createTerrainButton(Terrain.MAGMA));
        buttonPanel.add(this.createTerrainButton(Terrain.LAVA));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.createTerrainButton(Terrain.DESERT));
        buttonPanel.add(this.createTerrainButton(Terrain.SANDSTONE));
        buttonPanel.add(this.createTerrainButton(Terrain.RED_SAND));
        buttonPanel.add(this.createTerrainButton(Terrain.RED_SANDSTONE));
        buttonPanel.add(this.createTerrainButton(Terrain.RED_DESERT));
        buttonPanel.add(this.createTerrainButton(Terrain.WHITE_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.ORANGE_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.MAGENTA_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.LIGHT_BLUE_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.YELLOW_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.LIME_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.PINK_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.GREY_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.LIGHT_GREY_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.CYAN_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.PURPLE_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.BLUE_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.BROWN_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.GREEN_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.RED_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.BLACK_STAINED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.HARDENED_CLAY));
        buttonPanel.add(this.createTerrainButton(Terrain.MESA));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.createTerrainButton(Terrain.BEACHES));
        buttonPanel.add(this.createTerrainButton(Terrain.WATER));
        buttonPanel.add(this.createTerrainButton(Terrain.DEEP_SNOW));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.createTerrainButton(Terrain.NETHERRACK));
        buttonPanel.add(this.createTerrainButton(Terrain.BASALT));
        buttonPanel.add(this.createTerrainButton(Terrain.BLACKSTONE));
        buttonPanel.add(this.createTerrainButton(Terrain.NETHERLIKE));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.createTerrainButton(Terrain.SOUL_SAND));
        buttonPanel.add(this.createTerrainButton(Terrain.SOUL_SOIL));
        buttonPanel.add(this.createTerrainButton(Terrain.WARPED_NYLIUM));
        buttonPanel.add(this.createTerrainButton(Terrain.CRIMSON_NYLIUM));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.createTerrainButton(Terrain.END_STONE));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createGlue());
        JButton addCustomTerrainButton = new JButton((Action)((Object)this.ACTION_SHOW_CUSTOM_TERRAIN_POPUP));
        addCustomTerrainButton.setMargin(BUTTON_INSETS);
        buttonPanel.add(addCustomTerrainButton);
        terrainPanel.add((Component)buttonPanel, constraints);
        return terrainPanel;
    }

    private JPanel createCustomTerrainPanel() {
        this.customTerrainPanel = new JPanel();
        this.customTerrainPanel.setLayout(new GridLayout(0, 4));
        JButton addCustomTerrainButton = new JButton((Action)((Object)this.ACTION_SHOW_CUSTOM_TERRAIN_POPUP));
        addCustomTerrainButton.setMargin(BUTTON_INSETS);
        this.customTerrainPanel.add(addCustomTerrainButton);
        return this.customTerrainPanel;
    }

    private JPanel createBrushPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        JPanel brushPanel = new JPanel(new GridLayout(0, 3));
        brushPanel.add(this.createBrushButton(SymmetricBrush.SPIKE_CIRCLE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.SPIKE_SQUARE));
        brushPanel.add(this.createBrushButton(new BitmapBrush(App.class.getResourceAsStream("resources/brush_noise.png"), strings.getString("noise"))));
        brushPanel.add(this.createBrushButton(SymmetricBrush.LINEAR_CIRCLE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.LINEAR_SQUARE));
        brushPanel.add(this.createBrushButton(new BitmapBrush(App.class.getResourceAsStream("resources/brush_cracked_earth.png"), strings.getString("cracks"))));
        brushPanel.add(this.createBrushButton(SymmetricBrush.COSINE_CIRCLE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.COSINE_SQUARE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.CONSTANT_CIRCLE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.PLATEAU_CIRCLE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.PLATEAU_SQUARE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.CONSTANT_SQUARE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.DOME_CIRCLE));
        brushPanel.add(this.createBrushButton(SymmetricBrush.DOME_SQUARE));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(1, 1, 1, 1);
        optionsPanel.add((Component)brushPanel, constraints);
        optionsPanel.putClientProperty(KEY_ICON, this.createBrushThumbnail(SymmetricBrush.COSINE_CIRCLE, Math.round(16.0f * GUIUtils.getUIScale())));
        return optionsPanel;
    }

    private JPanel createCustomBrushPanel(String title, BrushGroup brushGroup) {
        JPanel customBrushesPanel = new JPanel();
        customBrushesPanel.setLayout(new GridBagLayout());
        JPanel customBrushPanel = new JPanel(new GridLayout(0, 3));
        for (Brush customBrush : brushGroup.brushes) {
            customBrushPanel.add(this.createBrushButton(customBrush));
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(1, 1, 1, 1);
        customBrushesPanel.add((Component)customBrushPanel, constraints);
        if (brushGroup.icon != null) {
            customBrushesPanel.putClientProperty(KEY_ICON, new ImageIcon(IconUtils.scaleIcon((Image)brushGroup.icon, (int)16)));
        } else {
            customBrushesPanel.putClientProperty(KEY_ICON, IconUtils.createScaledLetterIcon((char)title.charAt(0), (Color)(this.darkMode ? Color.WHITE : Color.BLACK)));
        }
        return customBrushesPanel;
    }

    private JPanel createBrushSettingsPanel() {
        JPanel brushSettingsPanel = new JPanel();
        brushSettingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(1, 1, 1, 1);
        this.levelSlider = new JSlider(2, 100);
        this.levelSlider.setMajorTickSpacing(49);
        this.levelSlider.setMinorTickSpacing(7);
        this.levelSlider.setPaintTicks(true);
        this.levelSlider.setSnapToTicks(true);
        this.levelSlider.setPaintLabels(false);
        this.levelSlider.addChangeListener(e -> {
            int value = this.levelSlider.getValue();
            this.levelLabel.setText("Intensity: " + (value < 52 ? value - 1 : value) + " %");
            if (!this.programmaticChange && !this.levelSlider.getValueIsAdjusting()) {
                float newLevel = (float)value / 100.0f;
                if (this.activeOperation instanceof PaintOperation) {
                    this.level = newLevel;
                    ((MouseOrTabletOperation)this.activeOperation).setLevel(this.level);
                } else {
                    this.toolLevel = newLevel;
                    if (this.activeOperation instanceof MouseOrTabletOperation) {
                        ((MouseOrTabletOperation)this.activeOperation).setLevel(this.toolLevel);
                    }
                }
                this.brush.setLevel(newLevel);
            }
        });
        this.brushRotationSlider = new JSlider(-180, 180);
        this.brushRotationSlider.setMajorTickSpacing(45);
        this.brushRotationSlider.setMinorTickSpacing(15);
        this.brushRotationSlider.setPaintTicks(true);
        this.brushRotationSlider.setSnapToTicks(true);
        this.brushRotationSlider.setPaintLabels(false);
        this.brushRotationSlider.addChangeListener(e -> {
            int value = this.brushRotationSlider.getValue();
            this.brushRotationLabel.setText("Rotation: " + (value < 0 ? (value - 7) / 15 * 15 : (value + 7) / 15 * 15) + "\u00b0");
            if (!this.programmaticChange && !this.brushRotationSlider.getValueIsAdjusting()) {
                if (this.activeOperation instanceof PaintOperation) {
                    this.brushRotation = value;
                } else {
                    this.toolBrushRotation = value;
                }
                this.updateBrushRotation();
            }
        });
        constraints.insets = new Insets(3, 1, 1, 1);
        this.brushRotationLabel = new JLabel("Rotation: 0\u00b0");
        brushSettingsPanel.add((Component)this.brushRotationLabel, constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(1, 1, 1, 1);
        java.awt.Dimension preferredSize = this.brushRotationSlider.getPreferredSize();
        preferredSize.width = 1;
        this.brushRotationSlider.setPreferredSize(preferredSize);
        brushSettingsPanel.add((Component)this.brushRotationSlider, constraints);
        constraints.fill = 0;
        constraints.insets = new Insets(3, 1, 1, 1);
        this.levelLabel = new JLabel("Intensity: 50 %");
        brushSettingsPanel.add((Component)this.levelLabel, constraints);
        constraints.fill = 2;
        constraints.insets = new Insets(1, 1, 1, 1);
        preferredSize = this.levelSlider.getPreferredSize();
        preferredSize.width = 1;
        this.levelSlider.setPreferredSize(preferredSize);
        brushSettingsPanel.add((Component)this.levelSlider, constraints);
        constraints.fill = 0;
        constraints.insets = new Insets(3, 1, 1, 1);
        brushSettingsPanel.add((Component)new JLabel("Options"), constraints);
        constraints.insets = new Insets(1, 1, 1, 1);
        brushSettingsPanel.add((Component)this.brushOptions, constraints);
        brushSettingsPanel.putClientProperty(KEY_ICON, ICON_SETTINGS);
        return brushSettingsPanel;
    }

    private void updateBrushRotation() {
        int desiredBrushRotation;
        int n = desiredBrushRotation = this.activeOperation instanceof PaintOperation ? this.brushRotation : this.toolBrushRotation;
        if (desiredBrushRotation != this.previousBrushRotation) {
            if (this.activeOperation instanceof BrushOperation) {
                Brush brush;
                Brush brush2 = brush = this.activeOperation instanceof PaintOperation ? this.brush : this.toolBrush;
                if (desiredBrushRotation == 0) {
                    ((BrushOperation)this.activeOperation).setBrush(brush);
                } else {
                    Brush rotatedBrush = RotatedBrush.rotate(brush, desiredBrushRotation);
                    ((BrushOperation)this.activeOperation).setBrush(rotatedBrush);
                }
                this.updateBrushRotation(brush, this.brushButtons.get(brush));
            }
            this.view.setBrushRotation(desiredBrushRotation);
            this.previousBrushRotation = desiredBrushRotation;
        }
    }

    private void updateBrushRotation(Brush brush, JToggleButton button) {
        if (!(brush instanceof BitmapBrush)) {
            return;
        }
        int desiredBrushRotation = this.activeOperation instanceof PaintOperation ? this.brushRotation : this.toolBrushRotation;
        Icon thumbnail = (Icon)button.getClientProperty(KEY_THUMBNAIL);
        if (thumbnail != null) {
            if (desiredBrushRotation == 0 || !button.isSelected()) {
                button.setIcon(thumbnail);
            } else {
                button.setIcon(IconUtils.rotateIcon((Icon)thumbnail, (int)desiredBrushRotation));
            }
        }
    }

    private void registerCustomLayer(CustomLayer layer, boolean activate) {
        Palette palette = this.paletteManager.register(layer);
        if (palette != null) {
            this.dockingManager.addFrame(palette.getDockableFrame());
            this.dockingManager.dockFrame(palette.getDockableFrame().getKey(), 8, 3);
            if (activate) {
                this.dockingManager.activateFrame(palette.getDockableFrame().getKey());
            }
            palette.addPropertyChangeListener(this);
        } else {
            this.validate();
        }
        if (activate) {
            this.paletteManager.activate(layer);
        }
    }

    private void unregisterCustomLayer(CustomLayer layer) {
        Palette palette = this.paletteManager.unregister(layer);
        this.layerSoloCheckBoxes.remove(layer);
        if (palette.isEmpty()) {
            palette.removePropertyChangeListener(this);
            this.paletteManager.delete(palette);
            this.dockingManager.removeFrame(palette.getDockableFrame().getKey());
        }
    }

    @Override
    public List<Component> createCustomLayerButton(final CustomLayer layer) {
        List<Component> buttonComponents = this.createLayerButton((Layer)layer, '\u0000');
        final JToggleButton button = (JToggleButton)buttonComponents.get(2);
        button.setToolTipText(button.getToolTipText() + "; right-click for options");
        button.addMouseListener(new java.awt.event.MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            private void showPopup(MouseEvent e) {
                TunnelLayer tunnelLayer;
                Object floorDimensionId;
                BetterJPopupMenu popup = new BetterJPopupMenu();
                JMenuItem menuItem = new JMenuItem(strings.getString("edit") + "...");
                menuItem.addActionListener(e1 -> App.this.editCustomLayer(layer));
                popup.add(menuItem);
                if (layer instanceof TunnelLayer && (floorDimensionId = (tunnelLayer = (TunnelLayer)layer).getFloorDimensionId()) != null) {
                    menuItem = new JMenuItem("Edit floor dimension [ALPHA]");
                    if (App.this.dimension.containsOneOf(new Layer[]{layer})) {
                        menuItem.addActionListener(e1 -> {
                            Configuration config;
                            Point viewPosition = App.this.view.getViewCentreInWorldCoords();
                            Dimension floorDimension = tunnelLayer.updateFloorDimension(App.this.dimension, null);
                            App.this.setDimension(floorDimension);
                            App.this.view.moveTo(viewPosition);
                            int minX = Integer.MAX_VALUE;
                            int maxX = Integer.MIN_VALUE;
                            int minY = Integer.MAX_VALUE;
                            int maxY = Integer.MIN_VALUE;
                            Rectangle visibleArea = App.this.view.getVisibleArea();
                            boolean floorTileVisible = false;
                            for (Tile tile : floorDimension.getTiles()) {
                                if (visibleArea.contains(tile.getX() << 7, tile.getY() << 7) && visibleArea.contains((tile.getX() << 7) + 128 - 1, (tile.getY() << 7) + 128 - 1)) {
                                    floorTileVisible = true;
                                    break;
                                }
                                if (tile.getX() < minX) {
                                    minX = tile.getX();
                                }
                                if (tile.getX() > maxX) {
                                    maxX = tile.getX();
                                }
                                if (tile.getY() < minY) {
                                    minY = tile.getY();
                                }
                                if (tile.getY() <= maxY) continue;
                                maxY = tile.getY();
                            }
                            if (!floorTileVisible && minX != Integer.MAX_VALUE) {
                                App.this.view.moveTo(((maxX + minX) / 2 << 7) + 64, ((maxY + minY) / 2 << 7) + 64);
                            }
                            if (!(config = Configuration.getInstance()).isMessageDisplayedCountAtLeast(App.EDITING_FLOOR_DIMENSION_KEY, 3)) {
                                AwtUtils.doLaterOnEventThread(() -> JOptionPane.showMessageDialog(App.this, "Press Esc to finish editing the Custom Cave/Tunnel layer floor dimension,\nor select the Surface dimension from the View menu or by pressing " + COMMAND_KEY_NAME + "+U", "Editing Cave/Tunnel Floor", 1));
                                config.setMessageDisplayed(App.EDITING_FLOOR_DIMENSION_KEY);
                            }
                        });
                    } else {
                        menuItem.setEnabled(false);
                    }
                    popup.add(menuItem);
                }
                menuItem = new JMenuItem("Duplicate...");
                if (layer.isExportable()) {
                    menuItem.addActionListener(e1 -> this.duplicate());
                } else {
                    menuItem.setEnabled(false);
                    menuItem.setToolTipText("This layer cannot be duplicated.");
                }
                popup.add(menuItem);
                menuItem = new JMenuItem(strings.getString("remove") + "...");
                menuItem.addActionListener(e1 -> this.remove());
                popup.add(menuItem);
                menuItem = new JMenuItem("Export to file...");
                if (layer.isExportable()) {
                    menuItem.addActionListener(e1 -> App.this.exportLayer(layer));
                } else {
                    menuItem.setEnabled(false);
                    menuItem.setToolTipText("This layer cannot be exported to a file.");
                }
                popup.add(menuItem);
                JMenu paletteMenu = new JMenu("Move to palette");
                for (Palette palette : App.this.paletteManager.getPalettes()) {
                    menuItem = new JMenuItem(palette.getName());
                    menuItem.addActionListener(e1 -> App.this.moveLayerToPalette(layer, palette));
                    if (palette.contains((Layer)layer)) {
                        menuItem.setEnabled(false);
                    }
                    paletteMenu.add(menuItem);
                }
                menuItem = new JMenuItem("New palette...");
                menuItem.addActionListener(e1 -> App.this.createNewLayerPalette(layer));
                paletteMenu.add(menuItem);
                popup.add(paletteMenu);
                List actions = layer.getActions();
                if (actions != null) {
                    for (Action action : actions) {
                        action.putValue("org.pepsoft.worldpainter.dimension", App.this.dimension);
                        popup.add(new JMenuItem(action));
                    }
                }
                popup.show(button, e.getX(), e.getY());
            }

            private void duplicate() {
                CustomLayer duplicate = layer.clone();
                duplicate.setName("Copy of " + layer.getName());
                Color colour = new Color(layer.getColour());
                float[] hsb = Color.RGBtoHSB(colour.getRed(), colour.getGreen(), colour.getBlue(), null);
                hsb[0] = hsb[0] + 0.083333336f;
                if (hsb[0] > 1.0f) {
                    hsb[0] = hsb[0] - 1.0f;
                }
                colour = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
                duplicate.setColour(colour.getRGB());
                AbstractEditLayerDialog dialog = App.this.createEditLayerDialog(duplicate);
                dialog.setVisible(() -> App.this.registerCustomLayer((CustomLayer)dialog.getLayer(), true));
            }

            private void remove() {
                if (JOptionPane.showConfirmDialog(App.this, MessageFormat.format(strings.getString("are.you.sure.you.want.to.remove.the.0.layer"), layer.getName()), MessageFormat.format(strings.getString("confirm.0.removal"), layer.getName()), 0) == 0) {
                    App.this.deleteCustomLayer(layer);
                    App.this.validate();
                }
            }
        });
        return buttonComponents;
    }

    public void editCustomLayer(CustomLayer layer) {
        this.editCustomLayer(layer, null);
    }

    public void editCustomLayer(CustomLayer layer, Runnable callback) {
        int previousColour = layer.getColour();
        AbstractEditLayerDialog<CustomLayer> dialog = this.createEditLayerDialog(layer);
        dialog.setVisible(() -> {
            JComponent control;
            LayerControls layerControls = this.layerControls.get(layer);
            JComponent jComponent = control = layerControls != null ? layerControls.control : null;
            if (control != null) {
                if (control instanceof AbstractButton) {
                    ((AbstractButton)control).setText(layer.getName());
                }
                control.setToolTipText(layer.getName() + ": " + layer.getDescription() + "; right-click for options");
            }
            int newColour = layer.getColour();
            boolean viewRefreshed = false;
            if (newColour != previousColour) {
                if (control instanceof AbstractButton) {
                    ((AbstractButton)control).setIcon(new ImageIcon(layer.getIcon()));
                }
                this.view.refreshTilesForLayer((Layer)layer, false);
                viewRefreshed = true;
            }
            this.dimension.changed();
            if (layer instanceof CombinedLayer) {
                this.updateHiddenLayers();
            }
            if (layer instanceof TunnelLayer && !viewRefreshed) {
                this.view.refreshTilesForLayer((Layer)layer, false);
            }
            if (callback != null) {
                callback.run();
            }
        });
    }

    public void deleteCustomLayer(CustomLayer layer) {
        if (this.activeOperation instanceof PaintOperation && this.paint instanceof LayerPaint && ((LayerPaint)this.paint).getLayer() == layer) {
            this.deselectPaint();
        }
        this.dimension.setEventsInhibited(true);
        try {
            this.dimension.clearLayerData((Layer)layer);
            if (layer instanceof TunnelLayer && ((TunnelLayer)layer).getFloorDimensionId() != null) {
                Dimension.Anchor anchor = this.dimension.getAnchor();
                this.world.removeDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.CAVE_FLOOR, anchor.invert, ((TunnelLayer)layer).getFloorDimensionId().intValue()));
            }
            this.dimension.clearUndo();
        }
        finally {
            this.dimension.setEventsInhibited(false);
        }
        this.unregisterCustomLayer(layer);
        boolean visibleLayersChanged = false;
        if (this.hiddenLayers.contains(layer)) {
            this.hiddenLayers.remove(layer);
            visibleLayersChanged = true;
        }
        if (layer.equals((Object)this.soloLayer)) {
            this.soloLayer = null;
            visibleLayersChanged = true;
        }
        if (layer instanceof LayerContainer) {
            boolean layersUnhidden = false;
            for (Layer subLayer : ((LayerContainer)layer).getLayers()) {
                if (!(subLayer instanceof CustomLayer) || !((CustomLayer)subLayer).isHide()) continue;
                ((CustomLayer)subLayer).setHide(false);
                layersUnhidden = true;
            }
            if (layersUnhidden) {
                this.updateHiddenLayers();
                visibleLayersChanged = false;
            }
        }
        if (visibleLayersChanged) {
            this.updateLayerVisibility();
        }
    }

    @Override
    public List<Component> createPopupMenuButton(String paletteName) {
        JButton addLayerButton = new JButton(App.loadScaledIcon("plus"));
        ArrayList<Component> addLayerButtonPanel = new ArrayList<Component>(3);
        addLayerButton.setToolTipText(strings.getString("add.a.custom.layer"));
        addLayerButton.setMargin(new Insets(2, 2, 2, 2));
        addLayerButton.addActionListener(e -> {
            if (this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            JPopupMenu customLayerMenu = this.createCustomLayerMenu(paletteName);
            customLayerMenu.show(addLayerButton, addLayerButton.getWidth(), 0);
        });
        JPanel spacer = new JPanel();
        addLayerButtonPanel.add(spacer);
        spacer = new JPanel();
        addLayerButtonPanel.add(spacer);
        addLayerButtonPanel.add(addLayerButton);
        return addLayerButtonPanel;
    }

    @NotNull
    private <L extends CustomLayer> AbstractEditLayerDialog<L> createEditLayerDialog(L layer) {
        AbstractEditLayerDialog dialog;
        if (layer instanceof Bo2Layer || layer instanceof GroundCoverLayer || layer instanceof CombinedLayer || layer instanceof PlantLayer) {
            dialog = new EditLayerDialog<L>((Window)this, this.world.getPlatform(), layer);
        } else if (layer instanceof UndergroundPocketsLayer) {
            dialog = new UndergroundPocketsDialog((Window)this, this.world.getPlatform(), (UndergroundPocketsLayer)layer, this.selectedColourScheme, this.dimension.getMinHeight(), this.dimension.getMaxHeight(), this.world.isExtendedBlockIds());
        } else if (layer instanceof TunnelLayer) {
            int waterLevel;
            int baseHeight;
            TileFactory tileFactory = this.dimension.getTileFactory();
            if (tileFactory instanceof HeightMapTileFactory) {
                baseHeight = (int)((HeightMapTileFactory)tileFactory).getBaseHeight();
                waterLevel = ((HeightMapTileFactory)tileFactory).getWaterHeight();
            } else {
                baseHeight = 58;
                waterLevel = 62;
            }
            dialog = new TunnelLayerDialog(this, this.world.getPlatform(), (TunnelLayer)layer, this.dimension, this.world.isExtendedBlockIds(), this.selectedColourScheme, this.customBiomeManager, this.dimension.getMinHeight(), this.dimension.getMaxHeight(), baseHeight, waterLevel);
        } else {
            throw new IllegalArgumentException("Don't know how to create dialog for layer " + layer.getName());
        }
        return dialog;
    }

    private void updateHiddenLayers() {
        this.paletteManager.getLayers().stream().filter(CustomLayer::isHide).forEach(layer -> {
            if (this.activeOperation instanceof PaintOperation && this.paint instanceof LayerPaint && ((LayerPaint)this.paint).getLayer().equals(layer)) {
                this.deselectPaint();
            }
            this.unregisterCustomLayer((CustomLayer)layer);
            this.hiddenLayers.remove(layer);
            if (layer.equals((Object)this.soloLayer)) {
                this.soloLayer = null;
            }
            this.layersWithNoButton.add((CustomLayer)layer);
        });
        Iterator<CustomLayer> i = this.layersWithNoButton.iterator();
        while (i.hasNext()) {
            CustomLayer layer2 = i.next();
            if (layer2.isHide()) continue;
            i.remove();
            this.registerCustomLayer(layer2, false);
        }
        this.updateLayerVisibility();
    }

    private void createNewLayerPalette(CustomLayer layer) {
        String name = JOptionPane.showInputDialog(this, "Enter a unique name for the new palette:", "New Palette", 3);
        if (name != null) {
            if ((name = name.trim()).isEmpty()) {
                MessageUtils.beepAndShowError((Component)this, (String)"Palette name cannot be empty", (String)"Invalid Name");
                return;
            }
            if (this.paletteManager.getPalette(name) != null) {
                JOptionPane.showMessageDialog(this, "There is already a palette with that name!", "Duplicate Name", 0);
                return;
            }
            Palette destPalette = this.paletteManager.create(name);
            this.dockingManager.addFrame(destPalette.getDockableFrame());
            this.dockingManager.dockFrame(destPalette.getDockableFrame().getKey(), 8, 3);
            this.moveLayerToPalette(layer, destPalette);
            this.dockingManager.activateFrame(destPalette.getDockableFrame().getKey());
            destPalette.addPropertyChangeListener(this);
        }
    }

    private void moveLayerToPalette(CustomLayer layer, Palette destPalette) {
        Palette srcPalette = this.paletteManager.move(layer, destPalette);
        if (srcPalette.isEmpty()) {
            this.dockingManager.removeFrame(srcPalette.getDockableFrame().getKey());
            srcPalette.removePropertyChangeListener(this);
            this.paletteManager.delete(srcPalette);
        }
        this.validate();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createViewMenu());
        Configuration config = Configuration.getInstance();
        if (!config.isEasyMode()) {
            menuBar.add(this.createToolsMenu());
        }
        menuBar.add(this.createHelpMenu());
        this.addStatisticsTo(menuBar, "menu", (EventLogger)config);
        return menuBar;
    }

    private JMenu createFileMenu() {
        JMenuItem menuItem = new JMenuItem((Action)((Object)this.ACTION_NEW_WORLD));
        menuItem.setMnemonic('n');
        JMenu menu = new JMenu(strings.getString("file"));
        menu.setMnemonic('i');
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_OPEN_WORLD));
        menuItem.setMnemonic('o');
        menu.add(menuItem);
        Configuration config = Configuration.getInstance();
        this.recentMenu = new JMenu("Recently used Worlds");
        if (config.getRecentFiles() != null && !config.getRecentFiles().isEmpty()) {
            this.updateRecentMenu();
        } else {
            this.recentMenu.setEnabled(false);
        }
        menu.add(this.recentMenu);
        if (!config.isEasyMode()) {
            menuItem = new JMenuItem((Action)((Object)this.ACTION_IMPORT_MAP));
            menuItem.setMnemonic('m');
            menuItem.setText("From Minecraft map...");
            JMenu subMenu = new JMenu(strings.getString("import"));
            subMenu.setMnemonic('i');
            subMenu.add(menuItem);
            menuItem = new JMenuItem(strings.getString("height.map") + "...");
            menuItem.addActionListener(event -> this.importHeightMap(null));
            menuItem.setMnemonic('h');
            subMenu.add(menuItem);
            menu.add(subMenu);
        } else {
            menuItem = new JMenuItem((Action)((Object)this.ACTION_IMPORT_MAP));
            menuItem.setMnemonic('m');
            menu.add(menuItem);
        }
        menu.addSeparator();
        menuItem = new JMenuItem((Action)((Object)this.ACTION_SAVE_WORLD));
        menuItem.setMnemonic('s');
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_SAVE_WORLD_AS));
        menuItem.setMnemonic('a');
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_EXPORT_WORLD));
        menuItem.setMnemonic('m');
        if (config.isEasyMode()) {
            menu.add(menuItem);
        } else {
            JMenu exportMenu = new JMenu(strings.getString("export"));
            exportMenu.setMnemonic('e');
            exportMenu.add(menuItem);
            menuItem = new JMenuItem(strings.getString("export.as.image.file") + "...");
            menuItem.addActionListener(event -> this.exportImage());
            menuItem.setMnemonic('i');
            exportMenu.add(menuItem);
            menuItem = new JMenuItem(strings.getString("export.as.height.map") + "...");
            menuItem.addActionListener(event -> this.exportHeightMap(HeightMapExporter.Format.INTEGER_LOW_RESOLUTION));
            menuItem.setMnemonic('h');
            exportMenu.add(menuItem);
            menuItem = new JMenuItem("Export as 1:256 (high resolution) integer height map...");
            menuItem.addActionListener(event -> this.exportHeightMap(HeightMapExporter.Format.INTEGER_HIGH_RESOLUTION));
            exportMenu.add(menuItem);
            menu.add(exportMenu);
        }
        menuItem = new JMenuItem((Action)((Object)this.ACTION_MERGE_WORLD));
        menuItem.setMnemonic('m');
        menu.add(menuItem);
        if (!this.hideExit) {
            menu.addSeparator();
            menuItem = new JMenuItem((Action)((Object)this.ACTION_EXIT));
            menuItem.setMnemonic('x');
            menu.add(menuItem);
        }
        menu.putClientProperty(KEY_HELP_KEY, "Menu/File");
        return menu;
    }

    private JMenu createEditMenu() {
        JMenuItem menuItem = new JMenuItem((Action)((Object)this.ACTION_UNDO));
        menuItem.setMnemonic('u');
        JMenu menu = new JMenu(strings.getString("edit"));
        menu.setMnemonic('e');
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_REDO));
        menuItem.setMnemonic('r');
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Change Map Format...");
        menuItem.addActionListener(e -> this.changeWorldHeight(this));
        menu.add(menuItem);
        this.extendedBlockIdsMenuItem = new JCheckBoxMenuItem("Extended block IDs");
        this.extendedBlockIdsMenuItem.setToolTipText("Allow block IDs from 0 to 4095 (inclusive) as used by some mods");
        this.extendedBlockIdsMenuItem.setMnemonic('e');
        this.extendedBlockIdsMenuItem.addActionListener(e -> {
            if (this.world != null) {
                this.world.setExtendedBlockIds(this.extendedBlockIdsMenuItem.isSelected());
            }
        });
        menu.add(this.extendedBlockIdsMenuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_DIMENSION_PROPERTIES));
        menuItem.setMnemonic('p');
        menu.add(menuItem);
        JMenu dimensionsMenu = new JMenu("Dimensions");
        this.addMasterMenuItem = new JMenuItem("Add master dimension... [ALPHA]");
        this.addMasterMenuItem.addActionListener(e -> this.addMaster());
        dimensionsMenu.add(this.addMasterMenuItem);
        this.removeMasterMenuItem = new JMenuItem("Remove master dimension...");
        this.removeMasterMenuItem.addActionListener(e -> this.removeMaster());
        dimensionsMenu.add(this.removeMasterMenuItem);
        this.addCeilingMenuItem = new JMenuItem("Add ceiling dimension...");
        this.addCeilingMenuItem.addActionListener(e -> this.addCeiling());
        dimensionsMenu.add(this.addCeilingMenuItem);
        this.removeCeilingMenuItem = new JMenuItem("Remove ceiling dimension...");
        this.removeCeilingMenuItem.addActionListener(e -> this.removeCeiling());
        dimensionsMenu.add(this.removeCeilingMenuItem);
        this.addNetherMenuItem = new JMenuItem(strings.getString("add.nether") + "...");
        this.addNetherMenuItem.addActionListener(e -> this.addNether());
        this.addNetherMenuItem.setMnemonic('n');
        dimensionsMenu.add(this.addNetherMenuItem);
        this.removeNetherMenuItem = new JMenuItem("Remove Nether...");
        this.removeNetherMenuItem.addActionListener(e -> this.removeNether());
        dimensionsMenu.add(this.removeNetherMenuItem);
        this.addEndMenuItem = new JMenuItem(strings.getString("add.end") + "...");
        this.addEndMenuItem.addActionListener(e -> this.addEnd());
        this.addEndMenuItem.setMnemonic('d');
        dimensionsMenu.add(this.addEndMenuItem);
        this.removeEndMenuItem = new JMenuItem("Remove End...");
        this.removeEndMenuItem.addActionListener(e -> this.removeEnd());
        dimensionsMenu.add(this.removeEndMenuItem);
        menu.add(dimensionsMenu);
        JMenu importMenu = new JMenu("Import");
        menuItem = new JMenuItem("Custom items from existing world...");
        menuItem.setMnemonic('i');
        menuItem.addActionListener(e -> this.importCustomItemsFromWorld(CustomItemsTreeModel.ItemType.ALL, this.getLayerFilterForCurrentDimension()));
        importMenu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_IMPORT_LAYER));
        menuItem.setMnemonic('l');
        menuItem.setText("Custom Layer(s) from file(s)...");
        importMenu.add(menuItem);
        menuItem = new JMenuItem("Custom Terrain(s) from file(s)...");
        menuItem.setMnemonic('t');
        menuItem.addActionListener(e -> this.importCustomMaterials());
        importMenu.add(menuItem);
        menuItem = new JMenuItem("Height map into current dimension...");
        menuItem.addActionListener(e -> this.importHeightMapIntoCurrentDimension(null));
        importMenu.add(menuItem);
        menuItem = new JMenuItem("Mask as terrain or layer...");
        menuItem.addActionListener(e -> this.importMask(null));
        importMenu.add(menuItem);
        menu.add(importMenu);
        Configuration config = Configuration.getInstance();
        if (!config.isEasyMode()) {
            menuItem = new JMenuItem((Action)((Object)this.ACTION_CHANGE_HEIGHT));
            menuItem.setMnemonic('h');
            menu.add(menuItem);
            menuItem = new JMenuItem((Action)((Object)this.ACTION_ROTATE_WORLD));
            menuItem.setMnemonic('o');
            menu.add(menuItem);
            menuItem = new JMenuItem((Action)((Object)this.ACTION_SHIFT_WORLD));
            menuItem.setMnemonic('s');
            menu.add(menuItem);
            menuItem = new JMenuItem((Action)((Object)this.ACTION_SCALE_WORLD));
            menuItem.setMnemonic('c');
            menu.add(menuItem);
        }
        menuItem = new JMenuItem(strings.getString("global.operations") + "...");
        menuItem.addActionListener(event -> this.showGlobalOperations());
        menuItem.setMnemonic('g');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, PLATFORM_COMMAND_MASK));
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_EDIT_TILES));
        menuItem.setMnemonic('t');
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete unused layers...");
        menuItem.addActionListener(e -> this.deleteUnusedLayers());
        menu.add(menuItem);
        if (!config.isEasyMode() && !this.hidePreferences) {
            menu.addSeparator();
            menuItem = new JMenuItem(strings.getString("preferences") + "...");
            menuItem.addActionListener(e -> this.openPreferences());
            menuItem.setMnemonic('f');
            menu.add(menuItem);
        }
        menu.putClientProperty(KEY_HELP_KEY, "Menu/Edit");
        return menu;
    }

    private void openPreferences() {
        Configuration config = Configuration.getInstance();
        PreferencesDialog dialog = new PreferencesDialog((Frame)this, this.selectedColourScheme);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.setMaxRadius(config.getMaximumBrushSize());
            if (!config.isAutosaveInhibited()) {
                if (config.isAutosaveEnabled()) {
                    this.autosaveTimer.setInitialDelay(config.getAutosaveDelay());
                    this.autosaveTimer.setDelay(config.getAutosaveDelay() / 2);
                    if (!this.autosaveTimer.isRunning()) {
                        this.autosaveTimer.start();
                    }
                } else {
                    this.autosaveTimer.stop();
                    try {
                        this.rotateAutosaveFile();
                    }
                    catch (Error | RuntimeException e2) {
                        logger.error("An exception occurred while trying to rotate the autosave", e2);
                        MessageUtils.beepAndShowWarning((Component)this, (String)"An error occurred while trying to clear the autosave.\nWorldPainter may try to load the autosave on the next start.\nIf this keeps happening, please report it to the author.", (String)"Clearing Autosave Failed");
                    }
                }
            }
        }
    }

    private JMenu createViewMenu() {
        JMenuItem menuItem = new JMenuItem((Action)((Object)this.ACTION_ZOOM_IN));
        menuItem.setMnemonic('i');
        JMenu menu = new JMenu(strings.getString("view"));
        menu.setMnemonic('v');
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_ZOOM_OUT));
        menuItem.setMnemonic('o');
        menu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_ZOOM_RESET));
        menuItem.setMnemonic('r');
        menu.add(menuItem);
        menu.addSeparator();
        this.viewSurfaceMenuItem = new JCheckBoxMenuItem(strings.getString("view.surface"), true);
        this.viewSurfaceMenuItem.addActionListener(e -> this.viewDimension(Dimension.Anchor.NORMAL_DETAIL));
        this.viewSurfaceMenuItem.setMnemonic('s');
        this.viewSurfaceMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, PLATFORM_COMMAND_MASK));
        menu.add(this.viewSurfaceMenuItem);
        this.viewNetherMenuItem = new JCheckBoxMenuItem(strings.getString("view.nether"), false);
        this.viewNetherMenuItem.addActionListener(e -> this.viewDimension(Dimension.Anchor.NETHER_DETAIL));
        this.viewNetherMenuItem.setMnemonic('n');
        this.viewNetherMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, PLATFORM_COMMAND_MASK));
        this.viewNetherMenuItem.setEnabled(false);
        menu.add(this.viewNetherMenuItem);
        this.viewEndMenuItem = new JCheckBoxMenuItem(strings.getString("view.end"), false);
        this.viewEndMenuItem.addActionListener(e -> this.viewDimension(Dimension.Anchor.END_DETAIL));
        this.viewEndMenuItem.setMnemonic('e');
        this.viewEndMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, PLATFORM_COMMAND_MASK));
        this.viewEndMenuItem.setEnabled(false);
        menu.add(this.viewEndMenuItem);
        menu.add((Action)((Object)this.ACTION_SWITCH_TO_FROM_MASTER));
        menu.add((Action)((Object)this.ACTION_SWITCH_TO_FROM_CEILING));
        menu.addSeparator();
        JMenu colourSchemeMenu = new JMenu(strings.getString("change.colour.scheme"));
        String[] colourSchemeNames = new String[]{strings.getString("default"), null, null, null, "DokuDark", "DokuHigh", "DokuLight", "Misa", "Sphax"};
        ButtonGroup schemesButtonGroup = new ButtonGroup();
        Configuration config = Configuration.getInstance();
        for (int i = 0; i < colourSchemeNames.length; ++i) {
            int index = i;
            if (this.colourSchemes[index] == null) continue;
            JCheckBoxMenuItem schemeMenuItem = new JCheckBoxMenuItem(colourSchemeNames[index]);
            schemesButtonGroup.add(schemeMenuItem);
            if (config.getColourschemeIndex() == index) {
                schemeMenuItem.setSelected(true);
            }
            schemeMenuItem.addActionListener(e -> {
                this.selectedColourScheme = this.colourSchemes[index];
                this.view.setColourScheme(this.selectedColourScheme);
                config.setColourschemeIndex(index);
            });
            colourSchemeMenu.add(schemeMenuItem);
        }
        menu.add(colourSchemeMenu);
        menuItem = new JMenuItem(strings.getString("configure.view") + "...");
        menuItem.addActionListener(e -> {
            if (this.dimension == null) {
                DesktopUtils.beep();
                return;
            }
            ConfigureViewDialog dialog = new ConfigureViewDialog((Frame)this, this.dimension, this.view);
            dialog.setVisible(true);
            this.ACTION_GRID.setSelected(this.view.isPaintGrid());
            this.ACTION_CONTOURS.setSelected(this.view.isDrawContours());
            this.ACTION_OVERLAYS.setSelected(this.dimension.isOverlaysEnabled());
        });
        menuItem.setMnemonic('c');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, PLATFORM_COMMAND_MASK));
        menu.add(menuItem);
        menu.addSeparator();
        JMenu workspaceLayoutMenu = new JMenu("Workspace layout");
        menuItem = new JMenuItem((Action)((Object)this.ACTION_RESET_DOCKS));
        menuItem.setMnemonic('r');
        workspaceLayoutMenu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_RESET_ALL_DOCKS));
        menuItem.setMnemonic('a');
        workspaceLayoutMenu.add(menuItem);
        this.ACTION_LOAD_LAYOUT.setEnabled(config.getDefaultJideLayoutData() != null);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_LOAD_LAYOUT));
        menuItem.setMnemonic('l');
        workspaceLayoutMenu.add(menuItem);
        menuItem = new JMenuItem((Action)((Object)this.ACTION_SAVE_LAYOUT));
        menuItem.setMnemonic('s');
        workspaceLayoutMenu.add(menuItem);
        menu.add(workspaceLayoutMenu);
        menu.addSeparator();
        menuItem = new JMenuItem(strings.getString("show.3d.view") + "...");
        menuItem.addActionListener(e -> {
            Point focusPoint = this.view.getViewCentreInWorldCoords();
            if (this.threeDeeFrame != null) {
                this.threeDeeFrame.requestFocus();
                this.threeDeeFrame.moveTo(focusPoint);
            } else {
                logger.info("Opening 3D view");
                this.threeDeeFrame = new ThreeDeeFrame(this.dimension, this.view.getColourScheme(), this.customBiomeManager, focusPoint);
                this.threeDeeFrame.setDefaultCloseOperation(0);
                this.threeDeeFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (App.this.threeDeeFrame != null) {
                            App.this.threeDeeFrame.dispose();
                            App.this.threeDeeFrame = null;
                        }
                    }
                });
                this.threeDeeFrame.setLocationRelativeTo(this);
                this.threeDeeFrame.setVisible(true);
            }
        });
        menuItem.setMnemonic('3');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(51, PLATFORM_COMMAND_MASK));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("View world history...");
        menuItem.addActionListener(e -> {
            if (this.world != null) {
                WorldHistoryDialog dialog = new WorldHistoryDialog((Window)this, this.world);
                dialog.setVisible(true);
            }
        });
        menu.add(menuItem);
        menu.putClientProperty(KEY_HELP_KEY, "Menu/View");
        return menu;
    }

    private JMenu createToolsMenu() {
        JMenuItem menuItem = new JMenuItem(strings.getString("respawn.player") + "...");
        menuItem.addActionListener(e -> {
            RespawnPlayerDialog dialog = new RespawnPlayerDialog(this);
            dialog.setVisible(true);
        });
        menuItem.setMnemonic('r');
        JMenu menu = new JMenu(strings.getString("tools"));
        menu.setMnemonic('t');
        menu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("open.custom.brushes.folder"));
        menuItem.addActionListener(e -> {
            File brushesDir = new File(Configuration.getConfigDir(), "brushes");
            if (!brushesDir.exists() && !brushesDir.mkdirs()) {
                DesktopUtils.beep();
                return;
            }
            DesktopUtils.open((File)brushesDir);
        });
        menuItem.setMnemonic('c');
        menu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("open.plugins.folder"));
        menuItem.addActionListener(e -> {
            File pluginsDir = new File(Configuration.getConfigDir(), "plugins");
            if (!pluginsDir.exists() && !pluginsDir.mkdirs()) {
                DesktopUtils.beep();
                return;
            }
            DesktopUtils.open((File)pluginsDir);
        });
        menuItem.setMnemonic('p');
        menu.add(menuItem);
        menuItem = new JMenuItem("Open custom materials folder");
        menuItem.addActionListener(e -> {
            File customMaterialsDir = new File(Configuration.getConfigDir(), "materials");
            if (!customMaterialsDir.exists() && !customMaterialsDir.mkdirs()) {
                DesktopUtils.beep();
                return;
            }
            DesktopUtils.open((File)customMaterialsDir);
        });
        menuItem.setMnemonic('m');
        menu.add(menuItem);
        menuItem = new JMenuItem(strings.getString("biomes.viewer") + "...");
        menuItem.setEnabled(false);
        if (Configuration.getInstance().isSafeMode()) {
            menuItem.setToolTipText("Biomes viewer not available in safe mode");
        } else {
            menuItem.setToolTipText("Biomes subsystem initialising...");
            final JMenuItem biomesViewerMenuItem = menuItem;
            new Thread("Biomes Viewer Menu Item Initialiser"){

                @Override
                public void run() {
                    if (BiomeSchemeManager.getAvailableBiomeAlgorithms().isEmpty()) {
                        logger.info("No supported Minecraft installation found; disabling biomes preview and Biomes Viewer");
                        AwtUtils.doLaterOnEventThread(() -> biomesViewerMenuItem.setToolTipText("No supported Minecraft installation found"));
                    } else {
                        AwtUtils.doLaterOnEventThread(() -> {
                            biomesViewerMenuItem.setToolTipText(null);
                            biomesViewerMenuItem.setEnabled(true);
                        });
                    }
                }
            }.start();
            menuItem.addActionListener(event -> {
                if (this.biomesViewerFrame != null) {
                    this.biomesViewerFrame.requestFocus();
                } else {
                    int preferredAlgorithm = -1;
                    if (this.dimension != null && this.dimension.getAnchor().dim == 0 && this.dimension.getMaxHeight() == 256) {
                        preferredAlgorithm = this.dimension.getGenerator().getType() == Generator.LARGE_BIOMES ? 10 : 9;
                    }
                    logger.info("Opening biomes viewer");
                    this.biomesViewerFrame = new BiomesViewerFrame(this.dimension.getMinecraftSeed(), this.world.getSpawnPoint(), preferredAlgorithm, this.selectedColourScheme, this);
                    this.biomesViewerFrame.setDefaultCloseOperation(0);
                    this.biomesViewerFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            if (App.this.biomesViewerFrame != null) {
                                App.this.biomesViewerFrame.destroy();
                                App.this.biomesViewerFrame.dispose();
                                App.this.biomesViewerFrame = null;
                            }
                        }
                    });
                    this.biomesViewerFrame.setLocationRelativeTo(this);
                    this.biomesViewerFrame.setVisible(true);
                }
            });
        }
        menuItem.setMnemonic('b');
        menu.add(menuItem);
        menuItem = new JMenuItem("Run script...");
        menuItem.addActionListener(e -> {
            try {
                new ScriptRunner((Window)this, this.world, this.dimension, this.undoManagers.values()).setVisible(true);
            }
            catch (NoClassDefFoundError | UnsupportedClassVersionError exc) {
                logger.error("Could not open ScriptRunner", (Throwable)exc);
                MessageUtils.beepAndShowError((Component)this, (String)"JavaScript support requires Java 11 or later.\nPlease install a newer version of Java and try again.\nSee www.worldpainter.net for links.", (String)"Newer Java Required");
            }
        });
        menuItem.setMnemonic('s');
        menu.add(menuItem);
        menu.putClientProperty(KEY_HELP_KEY, "Menu/Tools");
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenuItem menuItem = new JMenuItem((Action)((Object)this.ACTION_OPEN_DOCUMENTATION));
        menuItem.setMnemonic('d');
        JMenu menu = new JMenu(strings.getString("help"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Frequently Asked Questions");
        menuItem.setMnemonic('f');
        menuItem.addActionListener(e -> {
            try {
                DesktopUtils.open((URL)new URL("https://www.worldpainter.net/doc/faq"));
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Troubleshooting");
        menuItem.setMnemonic('t');
        menuItem.addActionListener(e -> {
            try {
                DesktopUtils.open((URL)new URL("https://www.worldpainter.net/trac/wiki/Troubleshooting"));
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Donate");
        menuItem.setMnemonic('d');
        menuItem.addActionListener(e -> {
            try {
                DesktopUtils.open((URL)new URL("https://www.worldpainter.net/donate/paypal"));
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Merch store");
        menuItem.setMnemonic('m');
        menuItem.addActionListener(e -> {
            try {
                DesktopUtils.open((URL)new URL("https://www.worldpainter.store/"));
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        });
        menu.add(menuItem);
        if (!this.hideAbout) {
            menuItem = new JMenuItem(strings.getString("about"));
            menuItem.setMnemonic('a');
            menuItem.addActionListener(e -> {
                AboutDialog dialog = new AboutDialog((Window)this, this.world, this.view, this.currentUndoManager);
                dialog.setVisible(true);
            });
            menu.add(menuItem);
        }
        menu.putClientProperty(KEY_HELP_KEY, "Menu/Help");
        return menu;
    }

    private void addCeiling() {
        Dimension.Anchor currentAnchor = this.dimension.getAnchor();
        if (currentAnchor.invert) {
            throw new IllegalStateException("Current dimension is already a ceiling");
        }
        if (currentAnchor.id != 0) {
            throw new UnsupportedOperationException("Layers other than 0 not yet supported");
        }
        Dimension.Anchor newAnchor = new Dimension.Anchor(currentAnchor.dim, currentAnchor.role, true, currentAnchor.id);
        if (this.world.isDimensionPresent(newAnchor)) {
            throw new IllegalStateException("Ceiling dimension already exists");
        }
        final NewWorldDialog dialog = new NewWorldDialog(this, this.selectedColourScheme, this.world.getName(), this.dimension.getSeed() + (long)newAnchor.hashCode(), this.world.getPlatform(), newAnchor, this.dimension.getMinHeight(), this.dimension.getMaxHeight(), this.dimension, this.dimension.getTileCoords());
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            if (!dialog.checkMemoryRequirements(this)) {
                return;
            }
            Dimension ceiling = (Dimension)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Dimension>(){

                public String getName() {
                    return "Creating ceiling dimension";
                }

                public Dimension execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    return dialog.getSelectedDimension(App.this.world, progressReceiver);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (ceiling == null) {
                return;
            }
            this.world.addDimension(ceiling);
            this.setDimension(ceiling);
        }
    }

    private void removeCeiling() {
        Dimension.Anchor currentAnchor = this.dimension.getAnchor();
        if (currentAnchor.id != 0) {
            throw new UnsupportedOperationException("Layers other than 0 not yet supported");
        }
        Dimension.Anchor ceilingAnchor = new Dimension.Anchor(currentAnchor.dim, currentAnchor.role, true, currentAnchor.id);
        if (!this.world.isDimensionPresent(ceilingAnchor)) {
            throw new IllegalStateException("There is no ceiling dimension");
        }
        Dimension ceiling = this.world.getDimension(ceilingAnchor);
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to completely remove the " + ceiling.getName() + " dimension?\nThis action cannot be undone!", "Confirm " + ceiling.getName() + " Deletion", 0) == 0) {
            this.world.removeDimension(ceilingAnchor);
            if (this.dimension != null && this.dimension.getAnchor().equals((Object)ceilingAnchor)) {
                this.viewDimension(new Dimension.Anchor(ceilingAnchor.dim, ceilingAnchor.role, false, ceilingAnchor.id));
            } else {
                this.configureForPlatform();
                if (this.dimension.getAnchor().dim == ceilingAnchor.dim) {
                    this.view.refreshTiles();
                }
            }
            MessageUtils.showInfo((Component)this, (String)("The " + ceiling.getName() + " was successfully deleted"), (String)"Success");
        }
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.add((Action)((Object)this.ACTION_NEW_WORLD));
        toolBar.add((Action)((Object)this.ACTION_OPEN_WORLD));
        toolBar.add((Action)((Object)this.ACTION_SAVE_WORLD));
        toolBar.add((Action)((Object)this.ACTION_EXPORT_WORLD));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)this.ACTION_UNDO));
        toolBar.add((Action)((Object)this.ACTION_REDO));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)this.ACTION_ZOOM_OUT));
        toolBar.add((Action)((Object)this.ACTION_ZOOM_RESET));
        toolBar.add((Action)((Object)this.ACTION_ZOOM_IN));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)this.ACTION_DIMENSION_PROPERTIES));
        if (!Configuration.getInstance().isEasyMode()) {
            toolBar.add((Action)((Object)this.ACTION_CHANGE_HEIGHT));
            toolBar.add((Action)((Object)this.ACTION_ROTATE_WORLD));
            toolBar.add((Action)((Object)this.ACTION_SHIFT_WORLD));
            toolBar.add((Action)((Object)this.ACTION_SCALE_WORLD));
        }
        toolBar.add((Action)((Object)this.ACTION_EDIT_TILES));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)this.ACTION_MOVE_TO_SPAWN));
        toolBar.add((Action)((Object)this.ACTION_MOVE_TO_ORIGIN));
        toolBar.addSeparator();
        JToggleButton button = new JToggleButton((Action)((Object)this.ACTION_GRID));
        button.setHideActionText(true);
        toolBar.add(button);
        button = new JToggleButton((Action)((Object)this.ACTION_CONTOURS));
        button.setHideActionText(true);
        toolBar.add(button);
        button = new JToggleButton((Action)((Object)this.ACTION_OVERLAYS));
        button.setHideActionText(true);
        toolBar.add(button);
        button = new JToggleButton((Action)((Object)this.ACTION_VIEW_DISTANCE));
        button.setHideActionText(true);
        toolBar.add(button);
        button = new JToggleButton((Action)((Object)this.ACTION_WALKING_DISTANCE));
        button.setHideActionText(true);
        toolBar.add(button);
        toolBar.add((Action)((Object)this.ACTION_ROTATE_LIGHT_LEFT));
        toolBar.add((Action)((Object)this.ACTION_ROTATE_LIGHT_RIGHT));
        return toolBar;
    }

    private void addStatisticsTo(MenuElement menuElement, @NonNls String key, EventLogger eventLogger) {
        JMenuItem menuItem;
        if (!(!(menuElement instanceof JMenuItem) || menuElement instanceof JMenu || (menuItem = (JMenuItem)menuElement).getAction() instanceof BetterAction && ((BetterAction)((Object)menuItem.getAction())).isLogEvent() || menuItem.getText().equals("Existing Minecraft map...") || menuItem.getText().equals("Merge World..."))) {
            if (key.startsWith("menu.File.RecentlyusedWorlds.")) {
                menuItem.addActionListener(e -> eventLogger.logEvent(new EventVO("menu.File.RecentlyusedWorlds").addTimestamp()));
            } else {
                menuItem.addActionListener(e -> eventLogger.logEvent(new EventVO(key).addTimestamp()));
            }
        }
        for (MenuElement subElement : menuElement.getSubElements()) {
            if (subElement instanceof JPopupMenu) {
                this.addStatisticsTo(subElement, key, eventLogger);
                continue;
            }
            if (!(subElement instanceof JMenuItem)) continue;
            this.addStatisticsTo(subElement, key + "." + ((JMenuItem)subElement).getText().replaceAll("[ \\t\\n\\x0B\\f\\r.]", ""), eventLogger);
        }
    }

    private void addNether() {
        Dimension surface = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        final NewWorldDialog dialog = new NewWorldDialog(this, this.selectedColourScheme, this.world.getName(), surface.getSeed() + 1L, this.world.getPlatform(), Dimension.Anchor.NETHER_DETAIL, Math.max(this.world.getMinHeight(), 0), Math.min(this.world.getMaxHeight(), 256), surface);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            if (!dialog.checkMemoryRequirements(this)) {
                return;
            }
            Dimension nether = (Dimension)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Dimension>(){

                public String getName() {
                    return "Creating Nether";
                }

                public Dimension execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    return dialog.getSelectedDimension(App.this.world, progressReceiver);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (nether == null) {
                return;
            }
            this.world.addDimension(nether);
            this.setDimension(nether);
            DimensionPropertiesDialog propertiesDialog = new DimensionPropertiesDialog((Window)this, nether, this.selectedColourScheme);
            propertiesDialog.setVisible(true);
        }
    }

    private void removeNether() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to completely remove the Nether dimension?\nThis action cannot be undone!", "Confirm Nether Deletion", 0) == 0) {
            this.world.removeDimension(Dimension.Anchor.NETHER_DETAIL);
            if (this.world.isDimensionPresent(Dimension.Anchor.NETHER_DETAIL_CEILING)) {
                this.world.removeDimension(Dimension.Anchor.NETHER_DETAIL_CEILING);
            }
            if (this.dimension != null && this.dimension.getAnchor().dim == 1) {
                this.viewDimension(Dimension.Anchor.NORMAL_DETAIL);
            } else {
                this.configureForPlatform();
            }
            MessageUtils.showInfo((Component)this, (String)"The Nether dimension was successfully deleted", (String)"Success");
        }
    }

    private void addEnd() {
        Dimension surface = this.world.getDimension(Dimension.Anchor.NORMAL_DETAIL);
        final NewWorldDialog dialog = new NewWorldDialog(this, this.selectedColourScheme, this.world.getName(), surface.getSeed() + 2L, this.world.getPlatform(), Dimension.Anchor.END_DETAIL, Math.max(this.world.getMinHeight(), 0), Math.min(this.world.getMaxHeight(), 256), surface);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            if (!dialog.checkMemoryRequirements(this)) {
                return;
            }
            Dimension end = (Dimension)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Dimension>(){

                public String getName() {
                    return "Creating End";
                }

                public Dimension execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    return dialog.getSelectedDimension(App.this.world, progressReceiver);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (end == null) {
                return;
            }
            this.world.addDimension(end);
            this.setDimension(end);
        }
    }

    private void removeEnd() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to completely remove the End dimension?\nThis action cannot be undone!", "Confirm End Deletion", 0) == 0) {
            this.world.removeDimension(Dimension.Anchor.END_DETAIL);
            if (this.world.isDimensionPresent(Dimension.Anchor.END_DETAIL_CEILING)) {
                this.world.removeDimension(Dimension.Anchor.END_DETAIL_CEILING);
            }
            if (this.dimension != null && this.dimension.getAnchor().dim == 2) {
                this.viewDimension(Dimension.Anchor.NORMAL_DETAIL);
            } else {
                this.configureForPlatform();
            }
            MessageUtils.showInfo((Component)this, (String)"The End dimension was successfully deleted", (String)"Success");
        }
    }

    private void addMaster() {
        Dimension.Anchor currentAnchor = this.dimension.getAnchor();
        if (currentAnchor.role == Dimension.Role.MASTER) {
            throw new IllegalStateException("Current dimension is already a master");
        }
        if (currentAnchor.id != 0) {
            throw new UnsupportedOperationException("Layers other than 0 not yet supported");
        }
        Dimension.Anchor newAnchor = new Dimension.Anchor(currentAnchor.dim, Dimension.Role.MASTER, false, currentAnchor.id);
        if (this.world.isDimensionPresent(newAnchor)) {
            throw new IllegalStateException("Master dimension already exists");
        }
        final NewWorldDialog dialog = new NewWorldDialog(this, this.selectedColourScheme, this.world.getName(), this.dimension.getSeed(), this.world.getPlatform(), newAnchor, this.dimension.getMinHeight(), this.dimension.getMaxHeight(), this.dimension);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            if (!dialog.checkMemoryRequirements(this)) {
                return;
            }
            Dimension master = (Dimension)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Dimension>(){

                public String getName() {
                    return "Creating master dimension";
                }

                public Dimension execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    return dialog.getSelectedDimension(App.this.world, progressReceiver);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]);
            if (master == null) {
                return;
            }
            this.world.addDimension(master);
            this.setDimension(master);
        }
    }

    private void removeMaster() {
        Dimension.Anchor currentAnchor = this.dimension.getAnchor();
        if (currentAnchor.id != 0) {
            throw new UnsupportedOperationException("Layers other than 0 not yet supported");
        }
        Dimension.Anchor masterAnchor = new Dimension.Anchor(currentAnchor.dim, Dimension.Role.MASTER, false, currentAnchor.id);
        if (!this.world.isDimensionPresent(masterAnchor)) {
            throw new IllegalStateException("There is no master dimension");
        }
        Dimension master = this.world.getDimension(masterAnchor);
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to completely remove the " + master.getName() + " dimension?\nThis action cannot be undone!", "Confirm " + master.getName() + " Deletion", 0) == 0) {
            this.world.removeDimension(masterAnchor);
            if (this.dimension != null && this.dimension.getAnchor().equals((Object)masterAnchor)) {
                this.viewDimension(new Dimension.Anchor(masterAnchor.dim, Dimension.Role.DETAIL, false, masterAnchor.id));
            } else {
                if (this.backgroundDimension == master) {
                    this.showBackgroundStatus = false;
                    this.view.setBackgroundDimension(null, 0, null);
                    this.backgroundDimension = null;
                }
                this.configureForPlatform();
            }
            MessageUtils.showInfo((Component)this, (String)("The " + master.getName() + " was successfully deleted"), (String)"Success");
        }
    }

    private void viewDimension(Dimension.Anchor anchor) {
        if (!anchor.equals((Object)this.dimension.getAnchor())) {
            this.setDimension(this.world.getDimension(anchor));
        }
    }

    private void fixLabelSizes() {
        this.locationLabel.setMinimumSize(this.locationLabel.getSize());
        this.locationLabel.setPreferredSize(this.locationLabel.getSize());
        this.locationLabel.setMaximumSize(this.locationLabel.getSize());
        this.heightLabel.setMinimumSize(this.heightLabel.getSize());
        this.heightLabel.setPreferredSize(this.heightLabel.getSize());
        this.heightLabel.setMaximumSize(this.heightLabel.getSize());
        this.slopeLabel.setMinimumSize(this.slopeLabel.getSize());
        this.slopeLabel.setPreferredSize(this.slopeLabel.getSize());
        this.slopeLabel.setMaximumSize(this.slopeLabel.getSize());
        this.materialLabel.setMinimumSize(this.materialLabel.getSize());
        this.materialLabel.setPreferredSize(this.materialLabel.getSize());
        this.materialLabel.setMaximumSize(this.materialLabel.getSize());
        this.waterLabel.setMinimumSize(this.waterLabel.getSize());
        this.waterLabel.setPreferredSize(this.waterLabel.getSize());
        this.waterLabel.setMaximumSize(this.waterLabel.getSize());
        this.biomeLabel.setMinimumSize(this.biomeLabel.getSize());
        this.biomeLabel.setPreferredSize(this.biomeLabel.getSize());
        this.biomeLabel.setMaximumSize(this.biomeLabel.getSize());
        this.radiusLabel.setMinimumSize(this.radiusLabel.getSize());
        this.radiusLabel.setPreferredSize(this.radiusLabel.getSize());
        this.radiusLabel.setMaximumSize(this.radiusLabel.getSize());
        this.zoomLabel.setMinimumSize(this.zoomLabel.getSize());
        this.zoomLabel.setPreferredSize(this.zoomLabel.getSize());
        this.zoomLabel.setMaximumSize(this.zoomLabel.getSize());
        this.locationLabel.setText(strings.getString("location-"));
        this.heightLabel.setText(" ");
        this.slopeLabel.setText(" ");
        this.waterLabel.setText(" ");
        this.biomeLabel.setText(" ");
        this.materialLabel.setText(" ");
        this.radiusLabel.setText(MessageFormat.format(strings.getString("radius.0"), this.radius));
        this.updateZoomLabel();
    }

    private JToggleButton createButtonForOperation(Operation operation) {
        return this.createButtonForOperation(operation, '\u0000');
    }

    private JToggleButton createButtonForOperation(Operation operation, char mnemonic) {
        BufferedImage icon = operation.getIcon();
        JToggleButton button = new JToggleButton();
        if (operation instanceof SetSpawnPoint) {
            this.setSpawnPointToggleButton = button;
        }
        button.setMargin(BUTTON_INSETS);
        if (icon != null) {
            button.setIcon(new ImageIcon(icon));
        }
        StringBuilder tooltip = new StringBuilder();
        tooltip.append(operation.getName());
        String description = operation.getDescription();
        if (description != null && !operation.getName().equalsIgnoreCase(description)) {
            tooltip.append(": ").append(description);
        }
        if (mnemonic != '\u0000') {
            button.setMnemonic(mnemonic);
            tooltip.append(" (Alt+").append(mnemonic).append(')');
        }
        button.setToolTipText(tooltip.toString());
        button.addItemListener(event -> {
            boolean refreshOptionsPanel = false;
            if (event.getStateChange() == 2) {
                if (operation instanceof RadiusOperation) {
                    this.view.setDrawBrush(false);
                }
                try {
                    operation.setActive(false);
                }
                catch (PropertyVetoException e) {
                    logger.error("Property veto exception while deactivating operation " + operation, (Throwable)e);
                }
                this.activeOperation = null;
                if (this.toolSettingsPanel.getComponentCount() > 0) {
                    this.toolSettingsPanel.removeAll();
                    refreshOptionsPanel = true;
                }
            } else {
                JPanel optionsPanel;
                this.mapSelectionController.cancelPaintSelection(true, false);
                if (operation instanceof PaintOperation) {
                    this.programmaticChange = true;
                    try {
                        if (operation instanceof MouseOrTabletOperation) {
                            ((MouseOrTabletOperation)operation).setLevel(this.level);
                            if (operation instanceof RadiusOperation) {
                                ((RadiusOperation)operation).setFilter(this.filter);
                            }
                            if (operation instanceof BrushOperation) {
                                ((BrushOperation)operation).setBrush(this.brushRotation == 0 ? this.brush : RotatedBrush.rotate(this.brush, this.brushRotation));
                                this.selectBrushButton(this.brush);
                                this.view.setBrushShape(this.brush.getBrushShape());
                                this.view.setBrushRotation(this.brushRotation);
                            }
                        }
                        this.levelSlider.setValue((int)(this.level * 100.0f));
                        this.brushRotationSlider.setValue(this.brushRotation);
                    }
                    finally {
                        this.programmaticChange = false;
                    }
                    if (this.filter instanceof DefaultFilter) {
                        this.brushOptions.setFilter((DefaultFilter)this.filter);
                    } else {
                        this.brushOptions.setFilter(null);
                    }
                    ((PaintOperation)operation).setPaint(this.paint);
                } else {
                    this.programmaticChange = true;
                    try {
                        if (operation instanceof MouseOrTabletOperation) {
                            ((MouseOrTabletOperation)operation).setLevel(this.toolLevel);
                            if (operation instanceof RadiusOperation) {
                                ((RadiusOperation)operation).setFilter(this.toolFilter);
                            }
                            if (operation instanceof BrushOperation) {
                                ((BrushOperation)operation).setBrush(this.toolBrushRotation == 0 ? this.toolBrush : RotatedBrush.rotate(this.toolBrush, this.toolBrushRotation));
                                this.selectBrushButton(this.toolBrush);
                                this.view.setBrushShape(this.toolBrush.getBrushShape());
                                this.view.setBrushRotation(this.toolBrushRotation);
                            }
                        }
                        this.levelSlider.setValue((int)(this.toolLevel * 100.0f));
                        this.brushRotationSlider.setValue(this.toolBrushRotation);
                    }
                    finally {
                        this.programmaticChange = false;
                    }
                    if (this.toolFilter instanceof DefaultFilter) {
                        this.brushOptions.setFilter((DefaultFilter)this.toolFilter);
                    } else {
                        this.brushOptions.setFilter(null);
                    }
                }
                if (operation instanceof RadiusOperation) {
                    this.view.setDrawBrush(true);
                    this.view.setRadius(this.radius);
                    ((RadiusOperation)operation).setRadius(this.radius);
                }
                this.activeOperation = operation;
                this.updateLayerVisibility();
                this.updateBrushRotation();
                try {
                    operation.setActive(true);
                }
                catch (PropertyVetoException e) {
                    this.deselectTool();
                    DesktopUtils.beep();
                    return;
                }
                if (this.closeCallout("callout_1")) {
                    if (!(operation instanceof RadiusOperation)) {
                        this.closeCallout("callout_2");
                    }
                    if (!(operation instanceof PaintOperation)) {
                        this.closeCallout("callout_3");
                    }
                }
                if ((optionsPanel = operation.getOptionsPanel()) != null) {
                    this.toolSettingsPanel.add((Component)optionsPanel, "Center");
                    refreshOptionsPanel = true;
                }
            }
            if (refreshOptionsPanel) {
                this.toolSettingsPanel.revalidate();
                this.toolSettingsPanel.repaint();
            }
        });
        button.putClientProperty(KEY_HELP_KEY, "Operation/" + operation.getClass().getSimpleName());
        this.toolButtonGroup.add(button);
        return button;
    }

    private List<Component> createLayerButton(Layer layer, char mnemonic) {
        return this.createLayerButton(layer, mnemonic, true, true);
    }

    private List<Component> createLayerButton(Layer layer, char mnemonic, boolean createSoloCheckbox, boolean createButton) {
        if (createButton) {
            JToggleButton button = new JToggleButton();
            button.setMargin(new Insets(2, 2, 2, 2));
            if (layer.getIcon() != null) {
                button.setIcon(new ImageIcon(layer.getIcon()));
            }
            button.setToolTipText(layer.getName() + ": " + layer.getDescription());
            button.addItemListener(event -> {
                if (event.getStateChange() == 1) {
                    this.paintUpdater = () -> {
                        this.paint = PaintFactory.createLayerPaint(layer);
                        this.paintChanged();
                    };
                    this.paintUpdater.updatePaint();
                }
            });
            this.paintButtonGroup.add(button);
            button.setText(layer.getName());
            button.putClientProperty(KEY_HELP_KEY, "Layer/" + layer.getId());
            button.putClientProperty(KEY_PAINT_ID, PaintFactory.createLayerPaintId(layer));
            return this.createLayerRow(layer, true, createSoloCheckbox, button);
        }
        JLabel label = new JLabel(layer.getName(), new ImageIcon(layer.getIcon()), 10);
        label.putClientProperty(KEY_HELP_KEY, "Layer/" + layer.getId());
        return this.createLayerRow(layer, true, createSoloCheckbox, label);
    }

    private List<Component> createLayerRow(Layer layer, boolean createShowCheckbox, boolean createSoloCheckbox, JComponent layerComponent) {
        JCheckBox soloCheckBox;
        JCheckBox checkBox;
        ArrayList<Component> components = new ArrayList<Component>(3);
        if (createShowCheckbox) {
            checkBox = new JCheckBox();
            checkBox.setToolTipText(strings.getString("whether.or.not.to.display.this.layer"));
            checkBox.setSelected(true);
            checkBox.addChangeListener(e -> {
                if (checkBox.isSelected()) {
                    this.hiddenLayers.remove(layer);
                } else {
                    this.hiddenLayers.add(layer);
                }
                this.updateLayerVisibility();
            });
            components.add(checkBox);
        } else {
            checkBox = null;
            components.add(Box.createGlue());
        }
        if (createSoloCheckbox) {
            soloCheckBox = new JCheckBox();
            this.layerSoloCheckBoxes.put(layer, soloCheckBox);
            soloCheckBox.setToolTipText("<html>Check to show <em>only</em> this layer (the other layers are still exported)</html>");
            soloCheckBox.addActionListener(new SoloCheckboxHandler(soloCheckBox, layer));
            components.add(soloCheckBox);
        } else {
            soloCheckBox = null;
            components.add(Box.createGlue());
        }
        components.add(layerComponent);
        this.layerControls.put(layer, new LayerControls(layer, checkBox, soloCheckBox, layerComponent));
        return components;
    }

    private JToggleButton createTerrainButton(final Terrain terrain) {
        JToggleButton button = new JToggleButton();
        button.putClientProperty(KEY_PAINT_ID, PaintFactory.createTerrainPaintId(terrain));
        button.setMargin(BUTTON_INSETS);
        button.setIcon(new ImageIcon(terrain.getScaledIcon(16, this.selectedColourScheme)));
        button.setToolTipText(terrain.getName() + ": " + terrain.getDescription());
        button.addItemListener(event -> {
            if (event.getStateChange() == 1 && terrain.isConfigured()) {
                this.paintUpdater = () -> {
                    this.paint = PaintFactory.createTerrainPaint(terrain);
                    this.paintChanged();
                };
                this.paintUpdater.updatePaint();
            }
        });
        if (terrain.isCustom()) {
            button.addMouseListener(new java.awt.event.MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!terrain.isConfigured()) {
                        App.this.showCustomTerrainButtonPopup(e, terrain.getCustomTerrainIndex());
                    }
                }
            });
        }
        this.paintButtonGroup.add(button);
        return button;
    }

    private void paintChanged() {
        if (this.activeOperation instanceof PaintOperation) {
            ((PaintOperation)this.activeOperation).setPaint(this.paint);
        }
        this.updateLayerVisibility();
        this.closeCallout("callout_3");
        this.mapSelectionController.cancelPaintSelection(true, false);
        this.eyedropperToggleButton.setSelected(false);
    }

    private void updateLayerVisibility() {
        HashSet<Layer> targetHiddenLayers = new HashSet<Layer>();
        targetHiddenLayers.add((Layer)FloodWithLava.INSTANCE);
        if (this.soloLayer != null) {
            targetHiddenLayers.addAll(this.dimension != null ? this.dimension.getAllLayers(true) : new HashSet<Layer>(this.layers));
            targetHiddenLayers.addAll(this.hiddenLayers);
            if (this.soloLayer != TileRenderer.TERRAIN_AS_LAYER) {
                targetHiddenLayers.remove(this.soloLayer);
            }
        } else {
            Palette soloPalette = null;
            for (Palette palette : this.paletteManager.getPalettes()) {
                if (!palette.isSolo()) continue;
                soloPalette = palette;
                break;
            }
            if (soloPalette != null) {
                targetHiddenLayers.addAll(this.dimension != null ? this.dimension.getAllLayers(true) : new HashSet<Layer>(this.layers));
                soloPalette.getLayers().forEach(targetHiddenLayers::remove);
                targetHiddenLayers.addAll(this.hiddenLayers);
            } else {
                targetHiddenLayers.addAll(this.hiddenLayers);
                for (Palette palette : this.paletteManager.getPalettes()) {
                    if (palette.isShow()) continue;
                    targetHiddenLayers.addAll(palette.getLayers());
                }
            }
        }
        if (this.activeOperation instanceof PaintOperation) {
            if (this.paint instanceof LayerPaint) {
                targetHiddenLayers.remove(((LayerPaint)this.paint).getLayer());
            } else if (this.paint instanceof TerrainPaint) {
                targetHiddenLayers.remove(TileRenderer.TERRAIN_AS_LAYER);
            }
        } else if (this.activeOperation instanceof Flood || this.activeOperation instanceof FloodWithLava) {
            targetHiddenLayers.remove(TileRenderer.FLUIDS_AS_LAYER);
        }
        targetHiddenLayers.remove(SelectionBlock.INSTANCE);
        targetHiddenLayers.remove(SelectionChunk.INSTANCE);
        this.view.setHiddenLayers(targetHiddenLayers);
        this.glassPane.setHiddenLayers(this.hiddenLayers);
        this.glassPane.setSoloLayer(this.soloLayer);
    }

    private void selectBrushButton(Brush selectedBrush) {
        if (!this.brushButtons.get(selectedBrush).isSelected()) {
            for (Map.Entry<Brush, JToggleButton> entry : this.brushButtons.entrySet()) {
                JToggleButton button = entry.getValue();
                if (!button.isSelected()) continue;
                button.setSelected(false);
                this.updateBrushRotation(entry.getKey(), button);
                break;
            }
            this.brushButtons.get(selectedBrush).setSelected(true);
        }
    }

    private JComponent createBrushButton(Brush brush) {
        LazyLoadingIconToggleButton button = new LazyLoadingIconToggleButton((int)(32.0f * GUIUtils.getUIScale()), () -> this.setBrushThumbnail(brush));
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setToolTipText(brush.getName());
        button.addItemListener(e -> {
            if (!this.programmaticChange) {
                this.updateBrushRotation(brush, button);
                if (e.getStateChange() == 1) {
                    int effectiveRotation;
                    if (this.activeOperation instanceof PaintOperation) {
                        this.brush = brush;
                        effectiveRotation = this.brushRotation;
                    } else {
                        this.toolBrush = brush;
                        effectiveRotation = this.toolBrushRotation;
                    }
                    if (this.activeOperation instanceof BrushOperation) {
                        ((BrushOperation)this.activeOperation).setBrush(effectiveRotation == 0 ? brush : RotatedBrush.rotate(brush, effectiveRotation));
                    }
                    this.view.setBrushShape(brush.getBrushShape());
                }
            }
        });
        button.addMouseListener(new java.awt.event.MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                App.this.closeCallout("callout_2");
            }
        });
        this.brushButtonGroup.add(button);
        this.brushButtons.put(brush, button);
        return button;
    }

    private Icon setBrushThumbnail(Brush brush) {
        Icon thumbnail = this.createBrushThumbnail(brush.clone(), Math.round(32.0f * GUIUtils.getUIScale()));
        JToggleButton button = this.brushButtons.get(brush);
        button.putClientProperty(KEY_THUMBNAIL, thumbnail);
        this.updateBrushRotation(brush, button);
        return thumbnail;
    }

    private Icon createBrushThumbnail(Brush brush, int size) {
        int radius = size / 2;
        brush.setRadius(radius - 1);
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(size, size, 3);
        for (int dx = -radius + 1; dx < radius; ++dx) {
            for (int dy = -radius + 1; dy < radius; ++dy) {
                float strength = brush.getFullStrength(dx, dy);
                int alpha = Math.round(strength * 255.0f);
                image.setRGB(dx + radius - 1, dy + radius - 1, alpha << 24 | (this.darkMode ? 0xD0D0D0 : 0));
            }
        }
        return new ImageIcon(image);
    }

    private static Icon loadScaledIcon(@NonNls String name) {
        return IconUtils.loadScaledIcon((String)("org/pepsoft/worldpainter/icons/" + name + ".png"));
    }

    private void configureForPlatform() {
        Platform platform = this.world.getPlatform();
        boolean nether = this.world.isDimensionPresent(Dimension.Anchor.NETHER_DETAIL);
        boolean end = this.world.isDimensionPresent(Dimension.Anchor.END_DETAIL);
        Dimension.Anchor anchor = this.dimension.getAnchor();
        this.biomeHelper = new BiomeHelper(this.selectedColourScheme, this.customBiomeManager, platform);
        this.setEnabled(this.addNetherMenuItem, platform.supportedDimensions.contains(1) && !nether);
        this.setEnabled(this.removeNetherMenuItem, nether);
        this.setEnabled(this.addEndMenuItem, platform.supportedDimensions.contains(2) && !end);
        this.setEnabled(this.removeEndMenuItem, end);
        this.setEnabled(this.viewNetherMenuItem, nether);
        this.setEnabled(this.viewEndMenuItem, end);
        this.setEnabled((Action)((Object)this.ACTION_SWITCH_TO_FROM_MASTER), this.world.isDimensionPresent(new Dimension.Anchor(anchor.dim, anchor.role == Dimension.Role.MASTER ? Dimension.Role.DETAIL : Dimension.Role.MASTER, false, 0)));
        this.setEnabled((Action)((Object)this.ACTION_SWITCH_TO_FROM_CEILING), this.world.isDimensionPresent(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, true, 0)));
        this.setEnabled(this.addMasterMenuItem, anchor.role == Dimension.Role.DETAIL && anchor.id == 0 && !this.world.isDimensionPresent(new Dimension.Anchor(anchor.dim, Dimension.Role.MASTER, false, 0)));
        this.setEnabled(this.removeMasterMenuItem, anchor.role == Dimension.Role.MASTER || this.world.isDimensionPresent(new Dimension.Anchor(anchor.dim, Dimension.Role.MASTER, false, 0)));
        this.setEnabled(this.addCeilingMenuItem, anchor.role == Dimension.Role.DETAIL && anchor.id == 0 && !anchor.invert && !this.world.isDimensionPresent(new Dimension.Anchor(anchor.dim, anchor.role, true, 0)));
        this.setEnabled(this.removeCeilingMenuItem, anchor.invert || this.world.isDimensionPresent(new Dimension.Anchor(anchor.dim, anchor.role, true, 0)));
        boolean biomesSupported = !anchor.invert && platform.capabilities.contains(Platform.Capability.BIOMES) || platform.capabilities.contains(Platform.Capability.BIOMES_3D) || platform.capabilities.contains(Platform.Capability.NAMED_BIOMES);
        this.setEnabled((Layer)Biome.INSTANCE, biomesSupported, "Biomes not supported by format " + platform);
        this.setEnabled((Component)this.biomesPanelFrame, biomesSupported);
        if (anchor.equals((Object)Dimension.Anchor.NORMAL_DETAIL)) {
            this.setEnabled(this.setSpawnPointToggleButton, platform.capabilities.contains(Platform.Capability.SET_SPAWN_POINT));
            this.setEnabled((Action)((Object)this.ACTION_MOVE_TO_SPAWN), platform.capabilities.contains(Platform.Capability.SET_SPAWN_POINT));
        } else {
            if (this.activeOperation instanceof SetSpawnPoint) {
                this.deselectTool();
            }
            this.setEnabled(this.setSpawnPointToggleButton, false);
            this.setEnabled((Action)((Object)this.ACTION_MOVE_TO_SPAWN), false);
        }
        this.setEnabled((Layer)Populate.INSTANCE, anchor.role != Dimension.Role.CAVE_FLOOR && !anchor.invert && platform.capabilities.contains(Platform.Capability.POPULATE), "Automatic population not supported or not applicable");
        this.biomesPanel.loadBiomes(platform, this.selectedColourScheme);
        this.setEnabled(this.extendedBlockIdsMenuItem, !platform.capabilities.contains(Platform.Capability.NAME_BASED) && platform != DefaultPlugin.JAVA_MCREGION);
        this.brushOptions.setPlatform(platform);
        this.infoPanel.setPlatform(platform);
        this.setEnabled((Layer)Caves.INSTANCE, anchor.role != Dimension.Role.CAVE_FLOOR, "Caves not supported in Custom Cave/Tunnel floor dimensions");
        this.setEnabled((Layer)Caverns.INSTANCE, anchor.role != Dimension.Role.CAVE_FLOOR, "Caverns not supported in Custom Cave/Tunnel floor dimensions");
        this.setEnabled((Layer)Chasms.INSTANCE, anchor.role != Dimension.Role.CAVE_FLOOR, "Chasms not supported in Custom Cave/Tunnel floor dimensions");
        this.setEnabled((Layer)Resources.INSTANCE, anchor.role != Dimension.Role.CAVE_FLOOR, "Resources not supported in Custom Cave/Tunnel floor dimensions");
        this.setEnabled((Layer)ReadOnly.INSTANCE, anchor.equals((Object)Dimension.Anchor.NORMAL_DETAIL), "Read Only layer not applicable");
    }

    private void setEnabled(Layer layer, boolean enabled, String toolTipText) {
        LayerControls layerControls = this.layerControls.get(layer);
        if (enabled && !layerControls.isEnabled()) {
            layerControls.setEnabled(true);
        } else if (!enabled && layerControls.isEnabled()) {
            if (this.paint instanceof LayerPaint && ((LayerPaint)this.paint).getLayer().equals((Object)layer)) {
                this.deselectPaint();
            }
            layerControls.disable(toolTipText);
        }
    }

    private void setEnabled(Component component, boolean enabled) {
        if (enabled != component.isEnabled()) {
            component.setEnabled(enabled);
        }
    }

    private void setEnabled(Action action, boolean enabled) {
        if (enabled != action.isEnabled()) {
            action.setEnabled(enabled);
        }
    }

    private void addMaterialSelectionTo(JToggleButton button, final int customMaterialIndex) {
        button.addMouseListener(new java.awt.event.MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            private void showPopup(AWTEvent event) {
                App.this.showCustomTerrainButtonPopup(event, customMaterialIndex);
            }
        });
    }

    private boolean importCustomMaterial(int customMaterialIndex) {
        MixedMaterial customMaterial = MixedMaterialHelper.load(this);
        if (customMaterial != null) {
            customMaterial = MixedMaterialManager.getInstance().register(customMaterial);
            Terrain.setCustomMaterial((int)customMaterialIndex, (MixedMaterial)customMaterial);
            this.customMaterialButtons[customMaterialIndex].setIcon(new ImageIcon(customMaterial.getIcon(this.selectedColourScheme)));
            this.customMaterialButtons[customMaterialIndex].setToolTipText(MessageFormat.format(strings.getString("customMaterial.0.right.click.to.change"), customMaterial));
            return true;
        }
        return false;
    }

    private boolean importCustomMaterials() {
        if (this.dimension == null) {
            DesktopUtils.beep();
            return false;
        }
        if (Terrain.getConfiguredCustomMaterialCount() == 96) {
            JOptionPane.showMessageDialog(this, "All Custom Terrain slots are already in use.", "No Free Slots", 0);
            return false;
        }
        MixedMaterial[] customMaterials = MixedMaterialHelper.loadMultiple(this);
        if (customMaterials != null) {
            if (Terrain.getConfiguredCustomMaterialCount() + customMaterials.length > 96) {
                MessageUtils.showWarning((Component)this, (String)("Not enough unused Custom Terrain slots available;\nselect " + (96 - Terrain.getConfiguredCustomMaterialCount()) + " Custom Terrains or fewer."), (String)"Too Many Custom Terrains");
                return false;
            }
            int nextIndex = 0;
            for (MixedMaterial customMaterial : customMaterials) {
                while (Terrain.getCustomMaterial((int)nextIndex) != null) {
                    ++nextIndex;
                }
                customMaterial = MixedMaterialManager.getInstance().register(customMaterial);
                this.addButtonForNewCustomTerrain(nextIndex, customMaterial, false);
            }
            this.view.refreshTiles();
            return true;
        }
        return false;
    }

    private void exportCustomMaterial(int customMaterialIndex) {
        MixedMaterialHelper.save(this, Terrain.getCustomMaterial((int)customMaterialIndex));
    }

    private void removeCustomMaterial(int index) {
        Terrain customTerrain = Terrain.getCustomTerrain((int)index);
        MixedMaterial mixedMaterial = Terrain.getCustomMaterial((int)index);
        String name = mixedMaterial.getName();
        Set allTerrains = (Set)ProgressDialog.executeTask((Window)this, (String)"Checking whether terrain is in use", () -> ((Stream)this.world.getDimensions().stream().parallel()).flatMap(dim -> dim.getAllTerrains().parallelStream()).collect(Collectors.toSet()), (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
        if (allTerrains.contains(customTerrain)) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Custom terrain \"" + name + "\" is still in use on the world.\nUse the Global Operations tool to replace it.", "Terrain In Use", 0);
            return;
        }
        HashSet<CustomLayer> allLayers = new HashSet<CustomLayer>(this.getCustomLayers());
        for (Dimension dimension : this.world.getDimensions()) {
            if (dimension == this.dimension) continue;
            allLayers.addAll(dimension.getCustomLayers());
        }
        for (CustomLayer layer : allLayers) {
            if (!(layer instanceof CombinedLayer) || ((CombinedLayer)layer).getTerrain() != customTerrain) continue;
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Custom terrain \"" + name + "\" is still in use in Combined Layer \"" + layer.getName() + "\".\nRemove it from that layer, or delete the layer.", "Terrain In Use", 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete custom terrain \"" + name + "\"?\nThis operation cannot be undone.", "Confirm Deletion", 0) == 0) {
            this.undoManagers.values().forEach(UndoManager::clear);
            MixedMaterialManager.getInstance().clear(mixedMaterial);
            Terrain.setCustomMaterial((int)index, null);
            if (this.customMaterialButtons[index].isSelected()) {
                this.deselectPaint();
            }
            this.customTerrainPanel.remove(this.customMaterialButtons[index]);
            this.customMaterialButtons[index] = null;
            if (Terrain.getConfiguredCustomMaterialCount() == 0) {
                this.dockingManager.removeFrame("customTerrain");
                this.customTerrainPanel = null;
            } else {
                this.customTerrainPanel.validate();
            }
            MessageUtils.showInfo((Component)this, (String)("Custom terrain \"" + name + "\" was successfully deleted."), (String)"Custom Terrain Deleted");
        }
    }

    private void clearCustomTerrains() {
        for (int index = 0; index < 96; ++index) {
            if (Terrain.getCustomMaterial((int)index) != null) {
                Terrain.setCustomMaterial((int)index, null);
            }
            if (this.customMaterialButtons[index] == null) continue;
            if (this.customMaterialButtons[index].isSelected()) {
                this.deselectPaint();
            }
            this.customMaterialButtons[index] = null;
        }
        if (this.customTerrainPanel != null) {
            while (this.customTerrainPanel.getComponentCount() > 1) {
                this.customTerrainPanel.remove(0);
            }
            this.dockingManager.removeFrame("customTerrain");
            this.customTerrainPanel = null;
        }
    }

    private void loadCustomTerrains() {
        boolean customTerrainsChanged = false;
        for (int i = 0; i < 96; ++i) {
            MixedMaterial material = this.world.getMixedMaterial(i);
            Terrain.setCustomMaterial((int)i, (MixedMaterial)material);
            if (material == null) continue;
            this.addButtonForNewCustomTerrain(i, material, false);
            customTerrainsChanged = true;
        }
        if (customTerrainsChanged) {
            this.customTerrainPanel.validate();
        }
    }

    private void saveCustomLayers() {
        if (this.dimension != null) {
            if (!this.paletteManager.isEmpty()) {
                ArrayList<CustomLayer> customLayers = new ArrayList<CustomLayer>();
                for (Palette palette : this.paletteManager.getPalettes()) {
                    customLayers.addAll(palette.getLayers());
                }
                this.dimension.setCustomLayers(customLayers);
            } else {
                this.dimension.setCustomLayers(Collections.emptyList());
            }
        }
    }

    private void saveCustomMaterials() {
        for (int i = 0; i < 96; ++i) {
            this.world.setMixedMaterial(i, Terrain.getCustomMaterial((int)i));
        }
    }

    private void saveCustomBiomes() {
        if (this.dimension != null) {
            this.dimension.setCustomBiomes(this.customBiomeManager.getCustomBiomes());
        }
    }

    private void installMacCustomisations() {
        this.hideExit = MacUtils.installQuitHandler(() -> {
            this.exit();
            return false;
        });
        this.hideAbout = MacUtils.installAboutHandler(() -> {
            AboutDialog dialog = new AboutDialog((Window)this, this.world, this.view, this.currentUndoManager);
            dialog.setVisible(true);
        });
        MacUtils.installOpenFilesHandler(files -> {
            if (files.size() > 0) {
                this.open((File)files.get(0), true);
            }
        });
        this.hidePreferences = MacUtils.installPreferencesHandler(this::openPreferences);
    }

    private void showGlobalOperations() {
        if (this.world == null || this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        List<Layer> allLayers = this.getAllLayers();
        List allBiomes = BiomeUtils.getAllBiomes((Platform)this.world.getPlatform(), (CustomBiomeManager)this.customBiomeManager);
        FillDialog dialog = new FillDialog(this, this.dimension, allLayers.toArray(new Layer[allLayers.size()]), this.selectedColourScheme, allBiomes.toArray(new Integer[allBiomes.size()]), this.customBiomeManager, this.view, this.selectionState);
        dialog.setVisible();
    }

    private void exportImage() {
        if (this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        if (!this.imageFitsInJavaArray(this.dimension)) {
            MessageUtils.beepAndShowError((Component)this, (String)("The dimension is too large to export to an image.\nThe area (width x height) may not be more than " + INT_NUMBER_FORMAT.format(Integer.MAX_VALUE)), (String)"Dimension Too Large");
            return;
        }
        final HashSet<String> extensions = new HashSet<String>(Arrays.asList(ImageIO.getReaderFileSuffixes()));
        StringBuilder sb = new StringBuilder(strings.getString("supported.image.formats"));
        sb.append(" (");
        boolean first = true;
        for (String extension : extensions) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("*.");
            sb.append(extension);
        }
        sb.append(')');
        final String description = sb.toString();
        String defaultname = this.world.getName().replaceAll("\\s", "").toLowerCase() + (this.dimension.getAnchor().dim == 0 ? "" : "_" + this.dimension.getName().toLowerCase()) + ".png";
        File selectedFile = FileUtils.selectFileForSave(this, "Export as image file", new File(defaultname), new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName();
                int p = filename.lastIndexOf(46);
                if (p != -1) {
                    String extension = filename.substring(p + 1).toLowerCase();
                    return extensions.contains(extension);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String getExtensions() {
                return String.join((CharSequence)";", extensions);
            }
        });
        if (selectedFile != null) {
            String type;
            int p = selectedFile.getName().lastIndexOf(46);
            if (p != -1) {
                type = selectedFile.getName().substring(p + 1).toUpperCase();
            } else {
                type = "PNG";
                selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".png");
            }
            if (selectedFile.exists() && JOptionPane.showConfirmDialog(this, strings.getString("the.file.already.exists"), strings.getString("overwrite.file"), 0) != 0) {
                return;
            }
            final File file = selectedFile;
            if (!((Boolean)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Boolean>(){

                public String getName() {
                    return strings.getString("exporting.image");
                }

                public Boolean execute(ProgressReceiver progressReceiver) {
                    try {
                        return ImageIO.write((RenderedImage)App.this.view.getImage(), type, file);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O error while exporting image", e);
                    }
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE})).booleanValue()) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(strings.getString("format.0.not.supported"), type));
            }
        }
    }

    private void exportHeightMap(HeightMapExporter.Format format) {
        File defaultFile;
        File selectedFile;
        if (this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        if (!this.imageFitsInJavaArray(this.dimension)) {
            MessageUtils.beepAndShowError((Component)this, (String)("The dimension is too large to export to a height map.\nThe area (width x height) may not be more than " + INT_NUMBER_FORMAT.format(Integer.MAX_VALUE)), (String)"Dimension Too Large");
            return;
        }
        final HeightMapExporter heightMapExporter = new HeightMapExporter(this.dimension, format);
        final List extensions = heightMapExporter.getSupportedFileExtensions();
        StringBuilder sb = new StringBuilder(strings.getString("supported.image.formats"));
        sb.append(" (");
        boolean first = true;
        for (String extension : extensions) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("*.");
            sb.append(extension);
        }
        sb.append(')');
        final String description = sb.toString();
        Configuration config = Configuration.getInstance();
        File dir = config.getHeightMapsDirectory();
        if (dir == null || !dir.isDirectory()) {
            dir = DesktopUtils.getPicturesFolder();
        }
        if ((selectedFile = FileUtils.selectFileForSave(this, format == HeightMapExporter.Format.INTEGER_HIGH_RESOLUTION ? "Export as high resolution height map image file" : "Export as height map image file", defaultFile = new File(dir, heightMapExporter.getDefaultFilename()), new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName();
                int p = filename.lastIndexOf(46);
                if (p != -1) {
                    String extension = filename.substring(p + 1).toLowerCase();
                    return extensions.contains(extension);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public String getExtensions() {
                return String.join((CharSequence)";", extensions);
            }
        })) != null) {
            int p = selectedFile.getName().lastIndexOf(46);
            if (p == -1) {
                MessageUtils.beepAndShowError((Component)this, (String)"No filename extension specified.", (String)"Missing Extension");
                return;
            }
            String type = selectedFile.getName().substring(p + 1).toUpperCase();
            if (selectedFile.exists() && JOptionPane.showConfirmDialog(this, strings.getString("the.file.already.exists"), strings.getString("overwrite.file"), 0) != 0) {
                return;
            }
            if (!ImageIO.getImageWritersBySuffix(type).hasNext()) {
                MessageUtils.beepAndShowError((Component)this, (String)("Filename extension " + type + " is not a supported image type."), (String)"Unsupported Format");
                return;
            }
            config.setHeightMapsDirectory(selectedFile.getParentFile());
            final File file = selectedFile;
            if (((Boolean)ProgressDialog.executeTask((Window)this, (ProgressTask)new ProgressTask<Boolean>(){

                public String getName() {
                    return strings.getString("exporting.height.map");
                }

                public Boolean execute(ProgressReceiver progressReceiver) {
                    return heightMapExporter.exportToFile(file);
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE})).booleanValue()) {
                MessageUtils.showInfo((Component)this, (String)("Dimension exported to " + selectedFile.getName() + "\n" + heightMapExporter.getFormatDescription()), (String)"Export Succeeded");
            } else {
                MessageUtils.beepAndShowError((Component)this, (String)MessageFormat.format(strings.getString("format.0.not.supported"), type), (String)"Unsupported Format");
            }
        }
    }

    private boolean imageFitsInJavaArray(Dimension dimension) {
        long areaInTiles = (long)dimension.getWidth() * (long)dimension.getHeight();
        return areaInTiles >= 0L && areaInTiles <= 131071L;
    }

    private void importLayers(String paletteName, Function<Layer, Boolean> filter) {
        File[] selectedFiles;
        if (this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        Configuration config = Configuration.getInstance();
        File layerDirectory = config.getLayerDirectory();
        if (layerDirectory == null || !layerDirectory.isDirectory()) {
            layerDirectory = DesktopUtils.getDocumentsFolder();
        }
        if ((selectedFiles = FileUtils.selectFilesForOpen(this, "Select WorldPainter layer file(s)", layerDirectory, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".layer");
            }

            @Override
            public String getDescription() {
                return "WorldPainter Custom Layers (*.layer)";
            }

            @Override
            public String getExtensions() {
                return "*.layer";
            }
        })) != null) {
            boolean updateCustomTerrainButtons = false;
            for (File selectedFile : selectedFiles) {
                try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(selectedFile))));){
                    CustomLayer layer = (CustomLayer)in.readObject();
                    for (Layer layer2 : this.getCustomLayers()) {
                        if (!layer.equals((Object)layer2)) continue;
                        MessageUtils.beepAndShowError((Component)this, (String)"That layer is already present in the dimension.\nThe layer has not been added.", (String)"Layer Already Present");
                        return;
                    }
                    if (filter != null && !filter.apply((Layer)layer).booleanValue()) {
                        MessageUtils.beepAndShowError((Component)this, (String)"That layer or layer type is not supported for the current dimension.\nThe layer has not been added.", (String)"Inapplicable Layer Type");
                        return;
                    }
                    if (!layer.isExportable()) {
                        MessageUtils.beepAndShowError((Component)this, (String)"That layer is not importable.\nThe layer has not been added.", (String)"Unimportable Layer");
                        return;
                    }
                    if (paletteName != null) {
                        layer.setPalette(paletteName);
                    }
                    updateCustomTerrainButtons = this.importCustomLayer(layer) || updateCustomTerrainButtons;
                    config.setLayerDirectory(selectedFile.getParentFile());
                }
                catch (FileNotFoundException e) {
                    logger.error("File not found while loading file " + selectedFile, (Throwable)e);
                    MessageUtils.beepAndShowError((Component)this, (String)"The specified path does not exist or is not a file", (String)"Nonexistent File");
                    return;
                }
                catch (IOException e) {
                    logger.error("I/O error while loading file " + selectedFile, (Throwable)e);
                    MessageUtils.beepAndShowError((Component)this, (String)"I/O error occurred while reading the specified file,\nor is not a (valid) WorldPainter layer file", (String)"I/O Error Or Invalid File");
                    return;
                }
                catch (ClassNotFoundException e) {
                    logger.error("Class not found exception while loading file " + selectedFile, (Throwable)e);
                    MessageUtils.beepAndShowError((Component)this, (String)"The specified file is not a (valid) WorldPainter layer file", (String)"Invalid File");
                    return;
                }
                catch (ClassCastException e) {
                    logger.error("Class cast exception while loading file " + selectedFile, (Throwable)e);
                    MessageUtils.beepAndShowError((Component)this, (String)"The specified file is not a (valid) WorldPainter layer file", (String)"Invalid File");
                    return;
                }
            }
            if (updateCustomTerrainButtons) {
                this.updateCustomTerrainButtons();
            }
        }
    }

    private boolean importCustomLayer(CustomLayer layer) {
        boolean customTerrainButtonsAdded = false;
        layer.setIndex(null);
        this.registerCustomLayer(layer, true);
        if (layer instanceof CombinedLayer) {
            CombinedLayer combinedLayer = (CombinedLayer)layer;
            this.importLayersFromCombinedLayer(combinedLayer);
            if (!combinedLayer.restoreCustomTerrain()) {
                MessageUtils.showWarning((Component)this, (String)"The layer contained a Custom Terrain which could not be restored. The terrain has been reset.", (String)"Custom Terrain Not Restored");
            } else {
                Terrain terrain = combinedLayer.getTerrain();
                if (terrain != null && terrain.isCustom() && this.customMaterialButtons[terrain.getCustomTerrainIndex()] == null) {
                    customTerrainButtonsAdded = true;
                    this.addButtonForNewCustomTerrain(terrain.getCustomTerrainIndex(), Terrain.getCustomMaterial((int)terrain.getCustomTerrainIndex()), false);
                }
            }
        }
        return customTerrainButtonsAdded;
    }

    private void updateCustomTerrainButtons() {
        for (int i = 0; i < 96; ++i) {
            if (this.customMaterialButtons[i] == null) continue;
            MixedMaterial material = Terrain.getCustomMaterial((int)i);
            this.customMaterialButtons[i].setIcon(new ImageIcon(material.getIcon(this.selectedColourScheme)));
            this.customMaterialButtons[i].setToolTipText(MessageFormat.format(strings.getString("customMaterial.0.right.click.to.change"), material));
        }
    }

    private void importLayersFromCombinedLayer(CombinedLayer combinedLayer) {
        combinedLayer.getLayers().stream().filter(layer -> layer instanceof CustomLayer && !this.paletteManager.contains((Layer)layer) && !this.layersWithNoButton.contains(layer)).forEach(layer -> {
            CustomLayer customLayer = (CustomLayer)layer;
            customLayer.setIndex(null);
            if (customLayer.isHide()) {
                this.layersWithNoButton.add(customLayer);
            } else {
                this.registerCustomLayer(customLayer, false);
            }
            if (layer instanceof CombinedLayer) {
                this.importLayersFromCombinedLayer((CombinedLayer)customLayer);
            }
        });
    }

    private void exportLayer(CustomLayer layer) {
        File selectedFile;
        Configuration config = Configuration.getInstance();
        File layerDirectory = config.getLayerDirectory();
        if (layerDirectory == null || !layerDirectory.isDirectory()) {
            layerDirectory = DesktopUtils.getDocumentsFolder();
        }
        if ((selectedFile = FileUtils.selectFileForSave(this, "Export WorldPainter layer file", new File(layerDirectory, org.pepsoft.util.FileUtils.sanitiseName((String)layer.getName()) + ".layer"), new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".layer");
            }

            @Override
            public String getDescription() {
                return "WorldPainter Custom Layers (*.layer)";
            }

            @Override
            public String getExtensions() {
                return "*.layer";
            }
        })) != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".layer")) {
                selectedFile = new File(selectedFile.getPath() + ".layer");
            }
            if (selectedFile.isFile() && JOptionPane.showConfirmDialog(this, "The file " + selectedFile.getName() + " already exists.\nDo you want to overwrite it?", "Overwrite File", 0) == 1) {
                return;
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(selectedFile))));){
                out.writeObject(layer);
            }
            catch (IOException e) {
                throw new RuntimeException("I/O error while trying to write " + selectedFile, e);
            }
            config.setLayerDirectory(selectedFile.getParentFile());
            MessageUtils.showInfo((Component)this, (String)("Layer " + layer.getName() + " exported successfully"), (String)"Success");
        }
    }

    private void logLayers(Dimension dimension, EventVO event, @NonNls String prefix) {
        StringBuilder sb = new StringBuilder();
        for (Layer layer : dimension.getAllLayers(false)) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(layer.getName());
        }
        if (sb.length() > 0) {
            event.setAttribute(new AttributeKeyVO(prefix + "layers"), (Serializable)((Object)sb.toString()));
        }
    }

    private void importCustomItemsFromWorld(CustomItemsTreeModel.ItemType itemType, Function<Layer, Boolean> filter) {
        Configuration config = Configuration.getInstance();
        File dir = this.lastSelectedFile != null ? this.lastSelectedFile.getParentFile() : (config != null && config.getWorldDirectory() != null ? config.getWorldDirectory() : DesktopUtils.getDocumentsFolder());
        File selectedFile = FileUtils.selectFileForOpen(this, "Select a WorldPainter world", dir, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".world");
            }

            @Override
            public String getDescription() {
                return strings.getString("worldpainter.files.world");
            }

            @Override
            public String getExtensions() {
                return "*.world";
            }
        });
        if (selectedFile != null) {
            if (!selectedFile.isFile()) {
                if (logger.isDebugEnabled()) {
                    try {
                        logger.debug("Path not a file according to File.isFile(): \"" + selectedFile + "\" (directory: " + selectedFile.isDirectory() + "; length: " + selectedFile.length() + "; absolutePath: \"" + selectedFile.getAbsolutePath() + "\"; canonicalPath: \"" + selectedFile.getCanonicalPath() + "\")");
                    }
                    catch (IOException e) {
                        logger.debug("Path not a file according to File.isFile(): \"" + selectedFile + "\" (directory: " + selectedFile.isDirectory() + "; length: " + selectedFile.length() + "; absolutePath: \"" + selectedFile.getAbsolutePath() + "\")");
                        logger.warn("I/O error while trying to report canonical path of file: \"" + selectedFile + "\"", (Throwable)e);
                    }
                }
                JOptionPane.showMessageDialog(this, "The specified path does not exist or is not a file", "File Does Not Exist", 0);
                return;
            }
            if (!selectedFile.canRead()) {
                JOptionPane.showMessageDialog(this, "WorldPainter is not authorised to read the selected file", "Access Denied", 0);
                return;
            }
            World2 selectedWorld = (World2)ProgressDialog.executeTask((Window)this, (ProgressTask)new LoadWorldTask(this, selectedFile), (ProgressDialog.Option[])new ProgressDialog.Option[]{ProgressDialog.NOT_CANCELABLE});
            if (selectedWorld == null) {
                return;
            }
            if (CustomItemsTreeModel.hasCustomItems(selectedWorld, itemType)) {
                ImportCustomItemsDialog dialog = new ImportCustomItemsDialog((Window)this, selectedWorld, this.selectedColourScheme, itemType);
                dialog.setVisible(true);
                if (!dialog.isCancelled()) {
                    StringBuilder errors = new StringBuilder();
                    List<CustomLayer> existingCustomLayers = null;
                    boolean refreshView = false;
                    boolean showError = false;
                    boolean updateCustomTerrainButtons = false;
                    for (Object selectedItem : dialog.getSelectedItems()) {
                        if (selectedItem instanceof CustomLayer) {
                            if (existingCustomLayers == null) {
                                existingCustomLayers = this.getCustomLayers();
                            }
                            if (existingCustomLayers.contains(selectedItem)) {
                                errors.append("Layer \"" + ((CustomLayer)selectedItem).getName() + "\" already exists\n");
                                continue;
                            }
                            if (filter != null && !filter.apply((Layer)((CustomLayer)selectedItem)).booleanValue()) {
                                errors.append("Layer \"" + ((CustomLayer)selectedItem).getName() + "\" or layer type not supported for current dimension\n");
                                showError = true;
                                continue;
                            }
                            updateCustomTerrainButtons = this.importCustomLayer((CustomLayer)selectedItem) || updateCustomTerrainButtons;
                            continue;
                        }
                        if (selectedItem instanceof MixedMaterial) {
                            MixedMaterial customMaterial = (MixedMaterial)selectedItem;
                            int index = this.findNextCustomTerrainIndex();
                            if (index == -1) {
                                errors.append("No free slots for Custom Terrain \"" + customMaterial.getName() + "\"\n");
                                showError = true;
                                continue;
                            }
                            customMaterial = MixedMaterialManager.getInstance().register(customMaterial);
                            this.addButtonForNewCustomTerrain(index, customMaterial, false);
                            continue;
                        }
                        if (selectedItem instanceof CustomBiome) {
                            CustomBiome customBiome = (CustomBiome)selectedItem;
                            if (!this.customBiomeManager.addCustomBiome(null, customBiome)) {
                                errors.append("ID already in use for Custom Biome " + customBiome.getId() + " (\"" + customBiome + "\")\n");
                                showError = true;
                                continue;
                            }
                            refreshView = true;
                            continue;
                        }
                        throw new InternalError("Unsupported custom item type " + selectedItem.getClass() + " encountered");
                    }
                    if (refreshView) {
                        this.view.refreshTiles();
                    }
                    if (updateCustomTerrainButtons) {
                        this.updateCustomTerrainButtons();
                    }
                    if (errors.length() > 0) {
                        JOptionPane.showMessageDialog(this, "Not all items have been imported:\n\n" + errors, "Not All Items Imported", showError ? 0 : 2);
                    }
                }
            } else {
                String what;
                switch (itemType) {
                    case ALL: {
                        what = "layers, terrains or biomes";
                        break;
                    }
                    case BIOME: {
                        what = "biomes";
                        break;
                    }
                    case LAYER: {
                        what = "layers";
                        break;
                    }
                    case TERRAIN: {
                        what = "terrains";
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                MessageUtils.showWarning((Component)this, (String)("The selected world has no, or no importable, custom " + what + "."), (String)"No Custom Items To Import");
            }
        }
    }

    private void deleteUnusedLayers() {
        if (this.dimension == null) {
            DesktopUtils.beep();
            return;
        }
        List<CustomLayer> unusedLayers = this.getCustomLayers();
        Set layersInUse = this.dimension.getAllLayers(true);
        unusedLayers.removeAll(layersInUse);
        if (unusedLayers.isEmpty()) {
            MessageUtils.showInfo((Component)this, (String)"There are no unused layers in this dimension.", (String)"No Unused Layers");
        } else {
            DeleteLayersDialog dialog = new DeleteLayersDialog((Window)this, unusedLayers);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                MessageUtils.showInfo((Component)this, (String)"The selected layers have been deleted.", (String)"Layers Deleted");
            }
        }
    }

    private void showHelpPicker() {
        final Component glassPane = this.getGlassPane();
        java.awt.event.MouseAdapter mouseListener = new java.awt.event.MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                glassPane.setVisible(false);
                glassPane.removeMouseListener(this);
                glassPane.setCursor(null);
                App.this.showHelp(SwingUtilities.getDeepestComponentAt(App.this.getRootPane(), e.getX(), e.getY()));
            }
        };
        glassPane.setCursor(Cursor.getPredefinedCursor(12));
        glassPane.addMouseListener(mouseListener);
        glassPane.setVisible(true);
    }

    private void escapePressed() {
        if (this.mapSelectionController.isSelectionActive()) {
            this.mapSelectionController.cancelPaintSelection(true, true);
            this.eyedropperToggleButton.setSelected(false);
        } else {
            this.exitDimension();
        }
    }

    private void exitDimension() {
        if (this.dimension != null && this.dimension.getAnchor().role == Dimension.Role.CAVE_FLOOR) {
            Dimension.Anchor anchor = this.dimension.getAnchor();
            this.setDimension(this.world.getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.DETAIL, anchor.invert, 0)));
        } else {
            DesktopUtils.beep();
        }
    }

    static Icon findIcon(Container container) {
        Icon icon;
        if (container instanceof JComponent && (icon = (Icon)((JComponent)container).getClientProperty(KEY_ICON)) != null) {
            return icon;
        }
        for (Component component : container.getComponents()) {
            Icon icon2;
            if (component instanceof AbstractButton && ((AbstractButton)component).getIcon() != null) {
                return ((AbstractButton)component).getIcon();
            }
            if (!(component instanceof Container) || (icon2 = App.findIcon((Container)component)) == null) continue;
            return icon2;
        }
        return null;
    }

    static File getAutosaveFile() {
        return new File(Configuration.getConfigDir(), "autosave.world");
    }

    public static enum TerrainMode {
        SHOW_TERRAIN,
        HIDE_TERRAIN,
        DEFAULT_COLOUR_RAMP,
        DEFAULT_GREYSCALE_RAMP;

    }

    class BrushGroup {
        final String name;
        final BufferedImage icon;
        final List<Brush> brushes;

        BrushGroup(String name, BufferedImage icon, List<Brush> brushes) {
            this.name = name;
            this.icon = icon;
            this.brushes = brushes;
        }
    }

    public static enum Mode {
        WORLDPAINTER,
        MINECRAFTMAPEDITOR;

    }

    class LayerControls {
        protected final Layer layer;
        protected final JCheckBox checkBox;
        protected final JCheckBox soloCheckBox;
        protected final JComponent control;
        protected final String defaultCheckBoxToolTip;
        protected final String defaultSoloCheckBoxToolTip;
        protected final String defaultButtonToolTip;

        LayerControls(Layer layer, JCheckBox checkBox, JCheckBox soloCheckBox) {
            this(layer, checkBox, soloCheckBox, null);
        }

        LayerControls(Layer layer, JCheckBox checkBox, JCheckBox soloCheckBox, JComponent control) {
            this.layer = layer;
            this.checkBox = checkBox;
            this.soloCheckBox = soloCheckBox;
            this.control = control;
            this.defaultCheckBoxToolTip = checkBox != null ? checkBox.getToolTipText() : null;
            this.defaultSoloCheckBoxToolTip = soloCheckBox != null ? soloCheckBox.getToolTipText() : null;
            this.defaultButtonToolTip = control != null ? control.getToolTipText() : null;
        }

        boolean isEnabled() {
            return this.checkBox == null || this.checkBox.isEnabled();
        }

        void setEnabled(boolean enabled) {
            AwtUtils.doOnEventThread(() -> {
                if (!enabled) {
                    if (App.this.paint instanceof LayerPaint && ((LayerPaint)App.this.paint).getLayer().equals((Object)this.layer)) {
                        App.this.deselectPaint();
                    }
                    if (this.soloCheckBox != null && this.soloCheckBox.isSelected()) {
                        this.soloCheckBox.setSelected(false);
                        App.this.soloLayer = null;
                        App.this.updateLayerVisibility();
                    }
                }
                if (this.checkBox != null) {
                    this.checkBox.setEnabled(enabled);
                    if (enabled) {
                        this.checkBox.setToolTipText(this.defaultCheckBoxToolTip);
                    }
                }
                if (this.soloCheckBox != null) {
                    this.soloCheckBox.setEnabled(enabled);
                    if (enabled) {
                        this.soloCheckBox.setToolTipText(this.defaultSoloCheckBoxToolTip);
                    }
                }
                if (this.control != null) {
                    this.control.setEnabled(enabled);
                    if (enabled) {
                        this.control.setToolTipText(this.defaultButtonToolTip);
                    }
                }
            });
        }

        void disable(String toolTipText) {
            if (this.isEnabled()) {
                this.setEnabled(false);
                if (this.checkBox != null) {
                    this.checkBox.setToolTipText(toolTipText);
                }
                if (this.soloCheckBox != null) {
                    this.soloCheckBox.setToolTipText(toolTipText);
                }
                if (this.control != null) {
                    this.control.setToolTipText(toolTipText);
                }
            }
        }

        boolean isSolo() {
            return this.soloCheckBox != null && this.soloCheckBox.isSelected();
        }

        void setSolo(boolean solo) {
            if (this.soloCheckBox == null) {
                throw new IllegalArgumentException("Layer " + this.layer + " has no solo control");
            }
            this.soloCheckBox.setSelected(solo);
        }
    }

    class SoloCheckboxHandler
    implements ActionListener {
        private final JCheckBox checkBox;
        private final Layer layer;

        public SoloCheckboxHandler(JCheckBox checkBox, Layer layer) {
            this.checkBox = checkBox;
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.checkBox.isSelected()) {
                App.this.layerSoloCheckBoxes.values().stream().filter(otherSoloCheckBox -> otherSoloCheckBox != this.checkBox).forEach(otherSoloCheckBox -> otherSoloCheckBox.setSelected(false));
                App.this.soloLayer = this.layer;
            } else {
                App.this.soloLayer = null;
            }
            App.this.updateLayerVisibility();
        }
    }

    static interface PaintUpdater {
        public void updatePaint();
    }

    class ScrollController
    extends MouseAdapter
    implements KeyEventDispatcher {
        private Point previousLocation;
        private boolean mouseDragging;
        private boolean keyDragging;
        private Cursor previousCursor;
        private long lastReleased;
        private final Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollController.this.keyDragging = false;
                if (!ScrollController.this.mouseDragging) {
                    App.this.glassPane.setCursor(ScrollController.this.previousCursor);
                }
            }
        });
        private static final int KEY_REPEAT_GUARD_TIME = 10;

        ScrollController() {
            this.timer.setRepeats(false);
        }

        void install() {
            App.this.view.addMouseListener(this);
            App.this.view.addMouseMotionListener(this);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }

        void uninstall() {
            if (this.keyDragging || this.mouseDragging) {
                App.this.glassPane.setCursor(this.previousCursor);
            }
            this.mouseDragging = false;
            this.keyDragging = false;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            App.this.view.removeMouseMotionListener(this);
            App.this.view.removeMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 2 && !this.mouseDragging) {
                if (!this.keyDragging) {
                    Point viewLocOnScreen = App.this.view.getLocationOnScreen();
                    e.translatePoint(viewLocOnScreen.x, viewLocOnScreen.y);
                    this.previousLocation = e.getPoint();
                    this.previousCursor = App.this.glassPane.getCursor();
                    App.this.glassPane.setCursor(Cursor.getPredefinedCursor(13));
                }
                this.mouseDragging = true;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.mouseDragging || this.keyDragging) {
                Point viewLocOnScreen = App.this.view.getLocationOnScreen();
                e.translatePoint(viewLocOnScreen.x, viewLocOnScreen.y);
                Point location = e.getPoint();
                if (this.previousLocation != null) {
                    int dx = location.x - this.previousLocation.x;
                    int dy = location.y - this.previousLocation.y;
                    App.this.view.moveBy(-dx, -dy);
                }
                this.previousLocation = location;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mouseDragging || this.keyDragging) {
                Point viewLocOnScreen = App.this.view.getLocationOnScreen();
                e.translatePoint(viewLocOnScreen.x, viewLocOnScreen.y);
                Point location = e.getPoint();
                if (this.previousLocation != null) {
                    int dx = location.x - this.previousLocation.x;
                    int dy = location.y - this.previousLocation.y;
                    App.this.view.moveBy(-dx, -dy);
                }
                this.previousLocation = location;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 2 && this.mouseDragging) {
                this.mouseDragging = false;
                if (!this.keyDragging) {
                    App.this.glassPane.setCursor(this.previousCursor);
                }
            }
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 32 && App.this.isFocused()) {
                if (e.getID() == 401) {
                    if (e.getWhen() - this.lastReleased < 10L) {
                        this.timer.stop();
                        return true;
                    }
                    if (!this.keyDragging) {
                        Point mouseLocOnScreen = MouseInfo.getPointerInfo().getLocation();
                        Point scrollPaneLocOnScreen = App.this.view.getLocationOnScreen();
                        Rectangle viewBoundsOnScreen = App.this.view.getBounds();
                        viewBoundsOnScreen.translate(scrollPaneLocOnScreen.x, scrollPaneLocOnScreen.y);
                        if (!viewBoundsOnScreen.contains(mouseLocOnScreen)) {
                            return false;
                        }
                        if (!this.mouseDragging) {
                            this.previousLocation = mouseLocOnScreen;
                            this.previousCursor = App.this.glassPane.getCursor();
                            App.this.glassPane.setCursor(Cursor.getPredefinedCursor(13));
                        }
                        this.keyDragging = true;
                        return true;
                    }
                } else if (e.getID() == 402 && this.keyDragging) {
                    this.lastReleased = e.getWhen();
                    this.timer.start();
                    return true;
                }
            }
            return false;
        }
    }

    public class IntensityAction
    extends BetterAction {
        private final int percentage;
        private static final long serialVersionUID = 1L;

        public IntensityAction(int percentage, int keyCode) {
            super("intensity" + percentage, MessageFormat.format(strings.getString("set.intensity.to.0"), percentage));
            this.percentage = percentage;
            this.setAcceleratorKey(KeyStroke.getKeyStroke(keyCode, 0));
        }

        @Override
        public void performAction(ActionEvent e) {
            App.this.levelSlider.setValue(this.percentage);
        }
    }

    static class DockableFrameBuilder {
        String id;
        String title;
        boolean expand;
        Icon icon;
        int side;
        int index;
        int margin = 2;
        Component component;

        DockableFrameBuilder(Component component, String title, int side, int index) {
            this.component = component;
            this.title = title;
            this.side = side;
            this.index = index;
            this.id = (Character.toLowerCase(title.charAt(0)) + title.substring(1)).replaceAll("\\s", "");
        }

        DockableFrameBuilder withId(String id) {
            this.id = id;
            return this;
        }

        DockableFrameBuilder expand() {
            this.expand = true;
            return this;
        }

        DockableFrameBuilder withIcon(Icon icon) {
            this.icon = icon;
            return this;
        }

        DockableFrameBuilder withMargin(int margin) {
            this.margin = margin;
            return this;
        }

        DockableFrame build() {
            DockableFrame dockableFrame = new DockableFrame(this.id);
            JPanel panel = new JPanel(new GridBagLayout());
            if (this.margin > 0) {
                panel.setBorder(new EmptyBorder(this.margin, this.margin, this.margin, this.margin));
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            if (this.expand) {
                constraints.fill = 1;
                constraints.weighty = 1.0;
                panel.add(this.component, constraints);
            } else {
                constraints.fill = 2;
                panel.add(this.component, constraints);
                constraints.weighty = 1.0;
                panel.add((Component)new JPanel(), constraints);
            }
            dockableFrame.add((Component)panel, (Object)"Center");
            dockableFrame.setTitle(this.title);
            dockableFrame.setSideTitle(this.title);
            dockableFrame.setTabTitle(this.title);
            dockableFrame.setToolTipText(this.title);
            if (this.icon == null && this.component instanceof Container) {
                this.icon = App.findIcon((Container)this.component);
                if (this.icon != null) {
                    int desiredSize = Math.round(16.0f * GUIUtils.getUIScale());
                    if ((this.icon.getIconHeight() > desiredSize || this.icon.getIconWidth() > desiredSize) && this.icon instanceof ImageIcon && ((ImageIcon)this.icon).getImage() instanceof BufferedImage) {
                        float s = this.icon.getIconWidth() > this.icon.getIconHeight() ? (float)desiredSize / (float)this.icon.getIconWidth() : (float)desiredSize / (float)this.icon.getIconHeight();
                        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(s, s), 3);
                        BufferedImage iconImage = op.filter((BufferedImage)((ImageIcon)this.icon).getImage(), null);
                        this.icon = new ImageIcon(iconImage);
                    }
                }
            }
            dockableFrame.setFrameIcon(this.icon != null ? this.icon : ICON_UNKNOWN_PATTERN);
            java.awt.Dimension preferredSize = this.component.getPreferredSize();
            dockableFrame.setAutohideWidth(preferredSize.width);
            dockableFrame.setDockedWidth(preferredSize.width);
            dockableFrame.setDockedHeight(preferredSize.height);
            dockableFrame.setUndockedBounds(new Rectangle(-1, -1, preferredSize.width, preferredSize.height));
            dockableFrame.setHidable(true);
            dockableFrame.setAvailableButtons(14);
            dockableFrame.setShowContextMenu(false);
            dockableFrame.setInitMode(4);
            dockableFrame.setInitSide(this.side);
            dockableFrame.setInitIndex(this.index);
            dockableFrame.setAutohideWhenActive(true);
            dockableFrame.setMaximizable(false);
            dockableFrame.putClientProperty((Object)App.KEY_HELP_KEY, (Object)("Panel/" + this.id));
            return dockableFrame;
        }
    }
}

