/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo.inspect;

import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import jpen.demo.StatusReport;
import jpen.demo.inspect.Inspector;

public class InspectorThread
implements Runnable {
    static final Logger L = Logger.getLogger(InspectorThread.class.getName());
    final Inspector inspector;
    final long period;
    final long times;

    InspectorThread(Inspector inspector, long period, long times) {
        if (period <= 0L) {
            throw new IllegalArgumentException("period must be greater than 0");
        }
        this.inspector = inspector;
        this.period = period;
        this.times = times;
        Thread t = new Thread((Runnable)this, "JPen-Inspector");
        t.setPriority(10);
        t.start();
    }

    public synchronized void run() {
        try {
            long totalTime = this.times * this.period / 1000L;
            L.warning("JPen Demo will automatically shut down in " + totalTime + " seconds");
            this.logInfo(0);
            int i = 1;
            while ((long)i <= this.times) {
                this.wait(this.period);
                this.logInfo(i);
                this.inspector.fileHandler.flush();
                ++i;
            }
            this.inspector.fileHandler.close();
            L.info("shutting down...");
            System.exit(0);
        }
        catch (InterruptedException ex) {
            L.warning("interrupted!");
            ex.printStackTrace();
        }
    }

    private void logInfo(int count) {
        L.info("collecting info " + count + "/" + this.times);
        L.fine(new StatusReport(this.inspector.penManager).toString());
        L.fine(this.evalThreadsDump(count));
        this.inspector.fileHandler.flush();
        L.info("info collected");
    }

    private String evalThreadsDump(int count) {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> threadToStackTraces = Thread.getAllStackTraces();
        sb.append("=== (" + count + ") Stack Traces " + new Date() + " ===\n");
        for (Map.Entry<Thread, StackTraceElement[]> threadToStackTracesE : threadToStackTraces.entrySet()) {
            Thread thread = threadToStackTracesE.getKey();
            sb.append(thread + ", state=" + (Object)((Object)thread.getState()) + ", isAlive=" + thread.isAlive());
            sb.append("\n");
            for (StackTraceElement stackTraceElement : threadToStackTracesE.getValue()) {
                sb.append("\t");
                sb.append(stackTraceElement);
                sb.append("\n");
            }
        }
        sb.append("=== === ===");
        return sb.toString();
    }
}

