/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.context.LauncherType;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractNameAndIdConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Element;

public class LauncherConfig
extends AbstractNameAndIdConfig {
    private String file = "";
    private LauncherType type;
    private boolean excludeFromMenu;
    private boolean uninstaller;
    private String menuName = "";
    private String plistContent = "";
    private List<String> additionalStartFileEntries = new ArrayList<String>();
    private List<String> staticallyHandledActions = new ArrayList<String>();

    public String getFile() {
        return this.file;
    }

    public LauncherType getType() {
        return this.type;
    }

    public boolean isExcludeFromMenu() {
        return this.excludeFromMenu;
    }

    public String getMenuName() {
        return InstallerVariables.replaceVariables(this.menuName);
    }

    public String getPlistContent() {
        return this.plistContent;
    }

    public List<String> getAdditionalStartFileEntries() {
        return this.additionalStartFileEntries;
    }

    public List<String> getStaticallyHandledActions() {
        return this.staticallyHandledActions;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.menuName = LauncherConfig.readAttribute(element, "menuName", (String)null);
        if (this.menuName == null) {
            this.menuName = LauncherConfig.readAttribute(element, "name", (String)null);
        }
        this.file = LauncherConfig.readFileAttribute(element, "file");
        this.excludeFromMenu = LauncherConfig.readAttribute(element, "excludeFromMenu", this.excludeFromMenu);
        this.uninstaller = LauncherConfig.readAttribute(element, "uninstaller", this.uninstaller);
        this.plistContent = LauncherConfig.readAttribute(element, "plistContent", this.plistContent);
        this.plistContent = LauncherConfig.readAttribute(element, "plistContent", this.plistContent);
        this.readStringList(element, "staticallyHandledActions", this.staticallyHandledActions);
        this.readStringList(element, "startFileEntries", this.additionalStartFileEntries);
        String typeId = LauncherConfig.readAttribute(element, "type", "");
        if (Objects.equals(typeId, "console")) {
            this.type = LauncherType.CONSOLE;
        } else if (Objects.equals(typeId, "gui")) {
            this.type = LauncherType.GUI;
        } else if (Objects.equals(typeId, "service")) {
            this.type = LauncherType.SERVICE;
        } else if (Objects.equals(typeId, "external")) {
            this.type = LauncherType.EXTERNAL;
        } else if (Objects.equals(typeId, "installerApplication")) {
            this.type = LauncherType.INSTALLER_APPLICATION;
        }
    }

    public boolean isUninstaller() {
        return this.uninstaller;
    }
}

