/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractNameAndIdConfig;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.util.Objects;
import java.util.WeakHashMap;
import org.w3c.dom.Element;

public abstract class ComponentNodeConfig
extends AbstractNameAndIdConfig {
    private ComponentNodeConfig parent;
    private boolean selected = true;
    private String description = "";
    private boolean displayDescription;
    private boolean hideHelpButton = true;
    private boolean hidden;
    private transient WeakHashMap<ComponentChangeListener, Object> listeners = new WeakHashMap();
    private transient Boolean initialDisplayDescription;

    protected ComponentNodeConfig(ComponentNodeConfig parent) {
        this.parent = parent;
        this.displayDescription = this.getDefaultDisplayDescriptionValue();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        if (oldSelected != selected) {
            this.fireSelectionChanged();
        }
    }

    public String getDescription() {
        return InstallerVariables.replaceVariables(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(boolean displayDescription) {
        this.displayDescription = displayDescription;
        if (this.initialDisplayDescription == null) {
            this.initialDisplayDescription = displayDescription;
        }
    }

    public boolean isHideHelpButton() {
        return this.hideHelpButton;
    }

    public void setHideHelpButton(boolean hideHelpButton) {
        this.hideHelpButton = hideHelpButton;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        boolean oldHidden = this.hidden;
        this.hidden = hidden;
        if (hidden != oldHidden) {
            this.fireHiddenChanged();
        }
    }

    public boolean isIncluded() {
        return this.isSelected() || this.parent != null && this.parent.isIncluded();
    }

    protected boolean getDefaultDisplayDescriptionValue() {
        return false;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.selected = ComponentNodeConfig.readAttribute(element, "selected", this.selected);
        this.displayDescription = ComponentNodeConfig.readAttribute(element, "displayDescription", this.displayDescription);
        this.initialDisplayDescription = this.displayDescription;
        this.hideHelpButton = ComponentNodeConfig.readAttribute(element, "hideHelpButton", this.hideHelpButton);
        this.hidden = ComponentNodeConfig.readAttribute(element, "hidden", this.hidden);
        for (Element childElement : ComponentNodeConfig.childElements(element)) {
            String elementName = childElement.getTagName();
            if (!Objects.equals(elementName, "description")) continue;
            this.description = XmlHelper.getTextValue(childElement);
        }
    }

    public void addComponentChangeListener(ComponentChangeListener changeListener) {
        this.listeners.put(changeListener, null);
    }

    protected void fireSelectionChanged() {
        for (ComponentChangeListener listener : this.listeners.keySet()) {
            if (listener == null) continue;
            listener.selectionChanged(this);
        }
    }

    protected void fireChangeableChanged() {
        for (ComponentChangeListener listener : this.listeners.keySet()) {
            if (listener == null) continue;
            listener.changeableChanged(this);
        }
    }

    protected void fireHiddenChanged() {
        for (ComponentChangeListener listener : this.listeners.keySet()) {
            if (listener == null) continue;
            listener.hiddenChanged(this);
        }
    }

    public boolean isInitialDisplayDescription() {
        if (this.initialDisplayDescription == null) {
            return this.getDefaultDisplayDescriptionValue();
        }
        return this.initialDisplayDescription;
    }

    public static interface ComponentChangeListener {
        public void selectionChanged(ComponentNodeConfig var1);

        public void changeableChanged(ComponentNodeConfig var1);

        public void hiddenChanged(ComponentNodeConfig var1);
    }
}

