/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.dynmap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dynmap.ColorScheme;
import org.dynmap.renderer.DynmapBlockState;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.dynmap.DynmapBlockStateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynmapColourScheme
implements ColourScheme {
    private final ColorScheme dynmapColorScheme;
    private final int step;
    private final Map<Material, Integer> cache = new ConcurrentHashMap<Material, Integer>();
    private static final Logger logger = LoggerFactory.getLogger(DynmapColourScheme.class);

    private DynmapColourScheme(ColorScheme dynmapColorScheme, int step) {
        this.dynmapColorScheme = dynmapColorScheme;
        this.step = step;
    }

    public int getColour(Material material) {
        return this.cache.computeIfAbsent(material, k -> {
            if (material.isNamed("minecraft:water")) {
                return Material.WATER.colour;
            }
            DynmapBlockState blockState = DynmapBlockStateHelper.getDynmapBlockState(material);
            if (blockState != null) {
                if (blockState.globalStateIndex < this.dynmapColorScheme.colors.length) {
                    if (this.dynmapColorScheme.colors[blockState.globalStateIndex] != null) {
                        return this.dynmapColorScheme.colors[blockState.globalStateIndex][this.step].getARGB();
                    }
                    logger.warn("Colour table contains null for global state index {}\nMaterial: {}\nDynmapBlockState: {}", new Object[]{blockState.globalStateIndex, material.toFullString(), blockState});
                } else {
                    logger.warn("Global state index {} exceeds colour table bounds\nMaterial: {}\nDynmapBlockState: {}", new Object[]{blockState.globalStateIndex, material.toFullString(), blockState});
                }
            } else {
                logger.warn("DynmapBlockState missing for material: {}", (Object)material.toFullString());
            }
            return material.colour;
        });
    }

    public static DynmapColourScheme loadDynMapColourScheme(String name, int step) {
        DynmapBlockStateHelper.initialise();
        ColorScheme colorScheme = ColorScheme.getScheme(null, name);
        return new DynmapColourScheme(colorScheme, step);
    }
}

