/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class HandlerRouter
extends AbstractHandler {
    PathMap<HandlerOrServlet> pathMap = new PathMap();

    public void addHandler(String path, Handler handler) {
        this.pathMap.put(path, (Object)new HandlerOrServlet(handler));
    }

    public void addServlet(String path, Servlet servlet) {
        this.pathMap.put(path, (Object)new HandlerOrServlet(servlet));
    }

    public void clear() {
        this.pathMap.clear();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        PathMap.MappedEntry e = this.pathMap.getMatch(pathInfo);
        String mappedPath = e.getMapped();
        String childPathInfo = pathInfo;
        if (mappedPath != null) {
            int i;
            for (i = 0; i < mappedPath.length() && mappedPath.charAt(i) == pathInfo.charAt(i); ++i) {
            }
            childPathInfo = childPathInfo.substring(i);
        }
        Request r = (Request)request;
        r.setPathInfo(childPathInfo);
        HandlerOrServlet o = (HandlerOrServlet)e.getValue();
        if (o.handler != null) {
            o.handler.handle(target, baseRequest, request, response);
        } else if (o.servlet != null) {
            o.servlet.service((ServletRequest)request, (ServletResponse)response);
        }
        r.setPathInfo(pathInfo);
    }

    private static class HandlerOrServlet {
        Servlet servlet;
        Handler handler;

        HandlerOrServlet(Servlet s) {
            this.servlet = s;
            this.handler = null;
        }

        HandlerOrServlet(Handler h) {
            this.servlet = null;
            this.handler = h;
        }
    }
}

