/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.renderer.DynmapBlockState;

public class BlockStateParser {
    private HashMap<DynmapBlockState, BitSet> basestates;
    private ArrayList<String> badtokens;
    private String modid;
    private int linenum;
    private boolean filtered;

    public boolean processLine(String modid, String line, int linenum, Map<String, Integer> varMap) {
        String args;
        String fieldid;
        int idx;
        boolean success = true;
        String[] tokens = line.split(",");
        this.basestates = new HashMap();
        this.badtokens = new ArrayList();
        this.modid = modid;
        this.linenum = linenum;
        this.filtered = false;
        for (String token : tokens) {
            idx = token.indexOf("=");
            if (idx < 0) continue;
            fieldid = token.substring(0, idx);
            args = token.substring(idx + 1);
            if (!fieldid.equals("id") || this.handleBlockName(args)) continue;
            this.badtokens.add(token);
            success = false;
        }
        for (String token : tokens) {
            idx = token.indexOf("=");
            if (idx < 0) continue;
            fieldid = token.substring(0, idx);
            args = token.substring(idx + 1);
            if (fieldid.equals("data")) {
                if (this.handleBlockData(args, varMap)) continue;
                this.badtokens.add(token);
                success = false;
                continue;
            }
            if (!fieldid.equals("state") || this.handleBlockState(args)) continue;
            this.badtokens.add(token);
            success = false;
        }
        if (!this.filtered) {
            for (DynmapBlockState bs : this.basestates.keySet()) {
                int cnt = bs.getStateCount();
                BitSet bits = this.basestates.get(bs);
                for (idx = 0; idx < cnt; ++idx) {
                    bits.set(bs.getState((int)idx).stateIndex);
                }
            }
        }
        return success;
    }

    public Map<DynmapBlockState, BitSet> getMatchingStates() {
        return this.basestates;
    }

    public List<String> getBadTokens() {
        return this.badtokens;
    }

    private boolean handleBlockName(String blockname) {
        char c = blockname.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            DynmapBlockState bs;
            String orig = blockname;
            if (c == '%' || c == '&') {
                blockname = blockname.substring(1);
            }
            if (blockname.indexOf(58) < 0) {
                blockname = this.modid + ":" + blockname;
            }
            if ((bs = DynmapBlockState.getBaseStateByName((String)blockname)) == null) {
                Log.warning(String.format("id=%s on line %d does not match valid blockName", orig, this.linenum));
                return false;
            }
            this.basestates.put(bs, new BitSet());
            return true;
        }
        Log.warning(String.format("id=%s on line %d invalid format (numbers not supported anymore)", blockname, this.linenum));
        return false;
    }

    private boolean handleBlockData(String data, Map<String, Integer> varMap) {
        try {
            if (data.equals("*")) {
                this.filtered = false;
            } else {
                int m1;
                int m0;
                int split = data.indexOf(45);
                if (split > 0) {
                    String start = data.substring(0, split);
                    String end = data.substring(split + 1);
                    m0 = BlockStateParser.getIntValue(varMap, start);
                    m1 = BlockStateParser.getIntValue(varMap, end);
                } else {
                    m0 = m1 = BlockStateParser.getIntValue(varMap, data).intValue();
                }
                this.filtered = true;
                for (DynmapBlockState bs : this.basestates.keySet()) {
                    int cnt = bs.getStateCount();
                    BitSet bits = this.basestates.get(bs);
                    for (int idx = m0; idx <= m1 && idx < cnt; ++idx) {
                        bits.set(bs.getState((int)idx).stateIndex);
                    }
                    if (m1 < cnt && m0 < cnt) continue;
                    Log.warning(String.format("data=%s on line %d exceeds state count for %s", data, this.linenum, bs.blockName));
                }
            }
            return true;
        }
        catch (NumberFormatException x) {
            return false;
        }
    }

    private boolean handleBlockState(String data) {
        boolean success = true;
        if (data.equals("*")) {
            this.filtered = false;
        } else {
            String[] split = data.split("/");
            String[] attribs = new String[split.length];
            String[] vals = new String[split.length];
            for (int i = 0; i < split.length; ++i) {
                String[] av = split[i].split(":");
                if (av.length == 2) {
                    attribs[i] = av[0];
                    vals[i] = av[1];
                    continue;
                }
                success = false;
            }
            this.filtered = true;
            if (success) {
                for (DynmapBlockState bs : this.basestates.keySet()) {
                    int cnt = bs.getStateCount();
                    BitSet bits = this.basestates.get(bs);
                    for (int idx = 0; idx < cnt; ++idx) {
                        DynmapBlockState s = bs.getState(idx);
                        boolean match = true;
                        for (int i = 0; match && i < attribs.length; ++i) {
                            if (s.isStateMatch(attribs[i], vals[i])) continue;
                            match = false;
                        }
                        if (!match) continue;
                        bits.set(idx);
                    }
                }
            }
        }
        if (!success) {
            Log.warning(String.format("Bad block state %s for line %s", data, this.linenum));
        }
        return success;
    }

    private static Integer getIntValue(Map<String, Integer> vars, String val) throws NumberFormatException {
        char c = val.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            Integer v;
            int off = val.indexOf(43);
            int offset = 0;
            if (off > 0) {
                offset = Integer.valueOf(val.substring(off + 1));
                val = val.substring(0, off);
            }
            if ((v = vars.get(val)) == null) {
                if (c == '%' || c == '&') {
                    vars.put(val, 0);
                    v = 0;
                } else {
                    throw new NumberFormatException("invalid ID - " + val);
                }
            }
            if (offset != 0 && v > 0) {
                v = v + offset;
            }
            return v;
        }
        return Integer.valueOf(val);
    }
}

