/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RotatedPatchRenderer
extends CustomRenderer {
    private RenderPatch[] basemodel;
    private RenderPatch[][] models;
    private int maxTextureIndex = 0;
    private String idx_attrib = null;
    private String[] tileEntityAttribs = null;

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        int i;
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        ArrayList<RenderPatch> patches = new ArrayList<RenderPatch>();
        ArrayList<int[]> rotations = new ArrayList<int[]>();
        this.idx_attrib = custparm.get("index");
        for (String k : custparm.keySet()) {
            int id;
            String v = custparm.get(k);
            if (k.startsWith("patch")) {
                try {
                    id = Integer.parseInt(k.substring(5));
                    RenderPatch p = rpf.getNamedPatch(custparm.get(k), id);
                    if (p == null) {
                        Log.warning("Invalid patch definition: " + v);
                        return false;
                    }
                    if (p.getTextureIndex() > this.maxTextureIndex) {
                        this.maxTextureIndex = p.getTextureIndex();
                    }
                    while (patches.size() <= id) {
                        patches.add(null);
                    }
                    patches.set(id, p);
                    continue;
                }
                catch (NumberFormatException nfx) {
                    Log.warning("Invalid index for parameter: " + k);
                    return false;
                }
            }
            if (!k.startsWith("rot")) continue;
            try {
                id = Integer.parseInt(k.substring(3));
            }
            catch (NumberFormatException nfx) {
                Log.warning("Invalid index for parameter: " + k);
                return false;
            }
            int[] rot = new int[3];
            String[] rotvals = v.split("/");
            try {
                if (rotvals.length >= 3) {
                    rot[0] = Integer.parseInt(rotvals[0]);
                    rot[1] = Integer.parseInt(rotvals[1]);
                    rot[2] = Integer.parseInt(rotvals[2]);
                } else {
                    rot[1] = Integer.parseInt(rotvals[0]);
                }
                while (rotations.size() <= id) {
                    rotations.add(null);
                }
                rotations.set(id, rot);
            }
            catch (NumberFormatException nfx) {
                Log.warning("Invalid rotation value: " + v);
                return false;
            }
        }
        for (i = 0; i < patches.size(); ++i) {
            if (patches.get(i) != null) continue;
            patches.remove(i);
            --i;
        }
        this.basemodel = patches.toArray(new RenderPatch[patches.size()]);
        this.models = new RenderPatch[rotations.size()][];
        for (i = 0; i < rotations.size(); ++i) {
            int[] rots = (int[])rotations.get(i);
            if (rots == null) continue;
            this.models[i] = new RenderPatch[this.basemodel.length];
            for (int j = 0; j < this.basemodel.length; ++j) {
                this.models[i][j] = rpf.getRotatedPatch(this.basemodel[j], rots[0], rots[1], rots[2], this.basemodel[j].getTextureIndex());
            }
        }
        if (this.idx_attrib != null) {
            this.tileEntityAttribs = new String[1];
            this.tileEntityAttribs[0] = this.idx_attrib;
        } else {
            this.tileEntityAttribs = null;
        }
        return true;
    }

    public int getMaximumTextureCount() {
        return this.maxTextureIndex + 1;
    }

    public String[] getTileEntityFieldsNeeded() {
        return this.tileEntityAttribs;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int rotIdx = 0;
        if (this.idx_attrib != null) {
            Object idxv = ctx.getBlockTileEntityField(this.idx_attrib);
            if (idxv instanceof Number) {
                rotIdx = ((Number)idxv).intValue();
            }
        } else {
            rotIdx = ctx.getBlockType().stateIndex;
        }
        if (rotIdx >= 0 && rotIdx < this.models.length && this.models[rotIdx] != null) {
            return this.models[rotIdx];
        }
        return this.basemodel;
    }

    public boolean isOnlyBlockStateSensitive() {
        return this.idx_attrib == null;
    }
}

