/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.BitSet;
import java.util.Map;
import org.dynmap.hdmap.HDBlockStateTextureMap;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class PaneRenderer
extends CustomRenderer {
    private static final int TEXTURE_FACE = 0;
    private static final int TEXTURE_EDGE = 1;
    protected static final int SIDE_XP = 4;
    protected static final int SIDE_XN = 1;
    protected static final int SIDE_ZP = 8;
    protected static final int SIDE_ZN = 2;
    protected RenderPatch[][] meshes = new RenderPatch[16][];

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.buildPatches(rpf);
        return true;
    }

    private void buildPatches(RenderPatchFactory rpf) {
        RenderPatch VertX05 = rpf.getPatch(0.5, 0.0, 1.0, 0.5, 0.0, 0.0, 0.5, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch VertX05_90 = rpf.getRotatedPatch(VertX05, 0, 90, 0, 0);
        RenderPatch VertX05_180 = rpf.getRotatedPatch(VertX05, 0, 180, 0, 0);
        RenderPatch VertX05_270 = rpf.getRotatedPatch(VertX05, 0, 270, 0, 0);
        RenderPatch VertX05Left = rpf.getPatch(0.5, 0.0, 1.0, 0.5, 0.0, 0.0, 0.5, 1.0, 1.0, 0.0, 0.5, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch VertX05Left_90 = rpf.getRotatedPatch(VertX05Left, 0, 90, 0, 0);
        RenderPatch VertX05Left_180 = rpf.getRotatedPatch(VertX05Left, 0, 180, 0, 0);
        RenderPatch VertX05Left_270 = rpf.getRotatedPatch(VertX05Left, 0, 270, 0, 0);
        RenderPatch VertX05Strip = rpf.getPatch(0.5, 0.0, 1.0, 0.5, 0.0, 0.0, 0.5, 1.0, 1.0, 0.4375, 0.5625, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 1);
        RenderPatch VertX05Strip_90 = rpf.getRotatedPatch(VertX05Strip, 0, 90, 0, 1);
        RenderPatch VertX05Strip_180 = rpf.getRotatedPatch(VertX05Strip, 0, 180, 0, 1);
        RenderPatch VertX05Strip_270 = rpf.getRotatedPatch(VertX05Strip, 0, 270, 0, 1);
        RenderPatch HorizY100ZTopStrip = rpf.getPatch(0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.4375, 0.5625, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 1);
        RenderPatch HorizY100ZTopStrip_90 = rpf.getRotatedPatch(HorizY100ZTopStrip, 0, 90, 0, 1);
        RenderPatch HorizY100ZTopStrip_180 = rpf.getRotatedPatch(HorizY100ZTopStrip, 0, 180, 0, 1);
        RenderPatch HorizY100ZTopStrip_270 = rpf.getRotatedPatch(HorizY100ZTopStrip, 0, 270, 0, 1);
        RenderPatch HorizY100ZTopStripTop = rpf.getPatch(0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.4375, 0.5625, 0.5, 1.0, RenderPatchFactory.SideVisible.BOTH, 1);
        RenderPatch HorizY100ZTopStripTop_90 = rpf.getRotatedPatch(HorizY100ZTopStripTop, 0, 90, 0, 1);
        RenderPatch HorizY100ZTopStripTop_180 = rpf.getRotatedPatch(HorizY100ZTopStripTop, 0, 180, 0, 1);
        RenderPatch HorizY100ZTopStripTop_270 = rpf.getRotatedPatch(HorizY100ZTopStripTop, 0, 270, 0, 1);
        this.meshes[0] = new RenderPatch[]{VertX05Strip, VertX05Strip_90, VertX05Strip_180, VertX05Strip_270};
        this.meshes[1] = new RenderPatch[]{VertX05Left_90, HorizY100ZTopStripTop_90, VertX05Strip};
        this.meshes[2] = new RenderPatch[]{VertX05Left_180, HorizY100ZTopStripTop_180, VertX05Strip_90};
        this.meshes[3] = new RenderPatch[]{VertX05Left_90, HorizY100ZTopStripTop_90, VertX05Left_180, HorizY100ZTopStripTop_180};
        this.meshes[4] = new RenderPatch[]{VertX05Left_270, HorizY100ZTopStripTop_270, VertX05Strip_180};
        this.meshes[5] = new RenderPatch[]{VertX05_90, HorizY100ZTopStrip_90};
        this.meshes[6] = new RenderPatch[]{VertX05Left_180, HorizY100ZTopStripTop_180, VertX05Left_270, HorizY100ZTopStripTop_270};
        this.meshes[7] = new RenderPatch[]{VertX05_90, HorizY100ZTopStrip_90, VertX05Left_180, HorizY100ZTopStripTop_180};
        this.meshes[8] = new RenderPatch[]{VertX05Left, HorizY100ZTopStripTop, VertX05Strip_270};
        this.meshes[9] = new RenderPatch[]{VertX05Left, HorizY100ZTopStripTop, VertX05Left_90, HorizY100ZTopStripTop_90};
        this.meshes[10] = new RenderPatch[]{VertX05, HorizY100ZTopStrip};
        this.meshes[11] = new RenderPatch[]{VertX05, HorizY100ZTopStrip, VertX05Left_90, HorizY100ZTopStripTop_90};
        this.meshes[12] = new RenderPatch[]{VertX05Left_270, HorizY100ZTopStripTop_270, VertX05Left, HorizY100ZTopStripTop};
        this.meshes[13] = new RenderPatch[]{VertX05_270, HorizY100ZTopStrip_270, VertX05Left, HorizY100ZTopStripTop};
        this.meshes[14] = new RenderPatch[]{VertX05_180, HorizY100ZTopStrip_180, VertX05Left_270, HorizY100ZTopStripTop_270};
        this.meshes[15] = new RenderPatch[]{VertX05, VertX05_90, HorizY100ZTopStrip, HorizY100ZTopStrip_90};
    }

    public int getMaximumTextureCount() {
        return 2;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int blockdata = 0;
        DynmapBlockState type = ctx.getBlockType();
        DynmapBlockState t = ctx.getBlockTypeAt(-1, 0, 0);
        if (t == type || t.is(DynmapBlockState.GLASS_BLOCK) || HDBlockStateTextureMap.getTransparency(t) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 1;
        }
        if ((t = ctx.getBlockTypeAt(0, 0, -1)) == type || t.is(DynmapBlockState.GLASS_BLOCK) || HDBlockStateTextureMap.getTransparency(t) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 2;
        }
        if ((t = ctx.getBlockTypeAt(1, 0, 0)) == type || t.is(DynmapBlockState.GLASS_BLOCK) || HDBlockStateTextureMap.getTransparency(t) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 4;
        }
        if ((t = ctx.getBlockTypeAt(0, 0, 1)) == type || t.is(DynmapBlockState.GLASS_BLOCK) || HDBlockStateTextureMap.getTransparency(t) == TexturePack.BlockTransparency.OPAQUE) {
            blockdata |= 8;
        }
        return this.meshes[blockdata];
    }
}

