/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class GlowLichenStateRenderer
extends CustomRenderer {
    protected RenderPatch[][] meshes = new RenderPatch[64][];

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.buildPatches(rpf);
        return true;
    }

    private void buildPatches(RenderPatchFactory rpf) {
        RenderPatch Top = rpf.getPatch(0.0, 0.95, 0.0, 1.0, 0.95, 0.0, 0.0, 0.95, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch Bottom = rpf.getPatch(0.0, 0.05, 0.0, 1.0, 0.05, 0.0, 0.0, 0.05, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch West = rpf.getPatch(0.05, 0.0, 0.0, 0.05, 0.0, 1.0, 0.05, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch East = rpf.getPatch(0.95, 0.0, 0.0, 0.95, 0.0, 1.0, 0.95, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch North = rpf.getPatch(0.0, 0.0, 0.05, 1.0, 0.0, 0.05, 0.0, 1.0, 0.05, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        RenderPatch South = rpf.getPatch(0.0, 0.0, 0.95, 1.0, 0.0, 0.95, 0.0, 1.0, 0.95, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 0);
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int i = 0; i < 64; ++i) {
            list.clear();
            if ((i & 0x20) == 0) {
                list.add(Bottom);
            }
            if ((i & 0x10) == 0) {
                list.add(East);
            }
            if ((i & 8) == 0) {
                list.add(North);
            }
            if ((i & 4) == 0) {
                list.add(South);
            }
            if ((i & 2) == 0) {
                list.add(Top);
            }
            if ((i & 1) == 0) {
                list.add(West);
            }
            this.meshes[i] = list.toArray(new RenderPatch[list.size()]);
        }
    }

    public int getMaximumTextureCount() {
        return 2;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int idx = ((ctx.getBlockType().stateIndex & 0x7C) >> 1) + (ctx.getBlockType().stateIndex & 1);
        return this.meshes[idx];
    }

    public boolean isOnlyBlockStateSensitive() {
        return true;
    }
}

