/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.ArrayList;
import java.util.List;
import org.dynmap.Client;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapTile;
import org.dynmap.MapType;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMapTile;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.hdmap.HDShader;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.storage.MapStorageTileEnumCB;
import org.dynmap.utils.TileFlags;
import org.json.simple.JSONObject;

public class HDMap
extends MapType {
    private String name;
    private String prefix;
    private HDPerspective perspective;
    private HDShader shader;
    private HDLighting lighting;
    private int mapzoomout;
    private String imgfmtstring;
    private MapType.ImageFormat imgformat;
    private int bgcolornight;
    private int bgcolorday;
    private int tilescale;
    private String title;
    private String icon;
    private String bg_cfg;
    private String bg_day_cfg;
    private String bg_night_cfg;
    private String append_to_world;
    private int mapzoomin;
    private int boostzoom;
    public DynmapCore core;
    public static final String IMGFORMAT_PNG = "png";
    public static final String IMGFORMAT_JPG = "jpg";
    private static final MapType.ImageVariant[] dayVariant = new MapType.ImageVariant[]{MapType.ImageVariant.STANDARD, MapType.ImageVariant.DAY};

    public HDMap(DynmapCore core, ConfigurationNode configuration) {
        String c;
        this.core = core;
        this.name = configuration.getString("name", null);
        if (this.name == null) {
            Log.severe("HDMap missing required attribute 'name' - disabled");
            return;
        }
        String perspectiveid = configuration.getString("perspective", "default");
        this.perspective = MapManager.mapman.hdmapman.perspectives.get(perspectiveid);
        if (this.perspective == null) {
            this.perspective = MapManager.mapman.hdmapman.perspectives.get("default");
            if (this.perspective == null) {
                Log.severe("HDMap '" + this.name + "' loaded invalid perspective '" + perspectiveid + "' - map disabled");
                this.name = null;
                return;
            }
            Log.severe("HDMap '" + this.name + "' loaded invalid perspective '" + perspectiveid + "' - using 'default' perspective");
        }
        String shaderid = configuration.getString("shader", "default");
        this.shader = MapManager.mapman.hdmapman.shaders.get(shaderid);
        if (this.shader == null) {
            this.shader = MapManager.mapman.hdmapman.shaders.get("default");
            if (this.shader == null) {
                Log.severe("HDMap '" + this.name + "' loading invalid shader '" + shaderid + "' - map disabled");
                this.name = null;
                return;
            }
            Log.severe("HDMap '" + this.name + "' loading invalid shader '" + shaderid + "' - using 'default' shader");
        }
        String lightingid = configuration.getString("lighting", "default");
        this.lighting = MapManager.mapman.hdmapman.lightings.get(lightingid);
        if (this.lighting == null) {
            this.lighting = MapManager.mapman.hdmapman.lightings.get("default");
            if (this.lighting == null) {
                Log.severe("HDMap '" + this.name + "' loading invalid lighting '" + this.lighting + "' - map disabled");
                this.name = null;
                return;
            }
            Log.severe("HDMap '" + this.name + "' loading invalid lighting '" + this.lighting + "' - using 'default' lighting");
        }
        this.prefix = configuration.getString("prefix", this.name);
        this.mapzoomout = 0;
        for (double scale = this.perspective.getScale(); scale >= 1.0; scale /= 2.0) {
            ++this.mapzoomout;
        }
        this.imgfmtstring = configuration.getString("image-format", "default");
        this.imgformat = this.imgfmtstring.equals("default") ? MapType.ImageFormat.fromID(core.getDefImageFormat()) : MapType.ImageFormat.fromID(this.imgfmtstring);
        if (this.imgformat == null) {
            Log.severe("HDMap '" + this.name + "' set invalid image-format: " + this.imgfmtstring);
            this.imgformat = MapType.ImageFormat.FORMAT_PNG;
        }
        if ((c = configuration.getString("background")) != null) {
            this.bgcolorday = this.bgcolornight = HDMap.parseColor(c);
        }
        if ((c = configuration.getString("backgroundday")) != null) {
            this.bgcolorday = HDMap.parseColor(c);
        }
        if ((c = configuration.getString("backgroundnight")) != null) {
            this.bgcolornight = HDMap.parseColor(c);
        }
        if (this.imgformat != MapType.ImageFormat.FORMAT_PNG) {
            this.bgcolorday |= 0xFF000000;
            this.bgcolornight |= 0xFF000000;
        }
        this.title = configuration.getString("title", this.name);
        this.icon = configuration.getString("icon");
        this.bg_cfg = configuration.getString("background");
        this.bg_day_cfg = configuration.getString("backgroundday");
        this.bg_night_cfg = configuration.getString("backgroundnight");
        this.mapzoomin = configuration.getInteger("mapzoomin", 2);
        this.mapzoomout = configuration.getInteger("mapzoomout", this.mapzoomout);
        this.boostzoom = configuration.getInteger("boostzoom", 0);
        this.tilescale = configuration.getInteger("tilescale", core.getMapManager().getDefaultTileScale());
        if (this.tilescale <= 0) {
            this.tilescale = 0;
        }
        if (this.tilescale >= 4) {
            this.tilescale = 4;
        }
        if (this.boostzoom < 0) {
            this.boostzoom = 0;
        }
        if (this.boostzoom > 3) {
            this.boostzoom = 3;
        }
        if (this.boostzoom > this.mapzoomin) {
            this.mapzoomin = this.boostzoom;
        }
        this.append_to_world = configuration.getString("append_to_world", "");
        this.setProtected(configuration.getBoolean("protected", false));
        this.setTileUpdateDelay(configuration.getInteger("tileupdatedelay", -1));
    }

    @Override
    public ConfigurationNode saveConfiguration() {
        ConfigurationNode cn = super.saveConfiguration();
        cn.put("title", (Object)this.title);
        if (this.icon != null) {
            cn.put("icon", (Object)this.icon);
        }
        cn.put("prefix", (Object)this.prefix);
        if (this.perspective != null) {
            cn.put("perspective", (Object)this.perspective.getName());
        }
        if (this.shader != null) {
            cn.put("shader", (Object)this.shader.getName());
        }
        if (this.lighting != null) {
            cn.put("lighting", (Object)this.lighting.getName());
        }
        cn.put("image-format", (Object)this.imgfmtstring);
        cn.put("mapzoomin", (Object)this.mapzoomin);
        cn.put("mapzoomout", (Object)this.mapzoomout);
        cn.put("boostzoom", (Object)this.boostzoom);
        cn.put("tilescale", (Object)this.tilescale);
        if (this.bg_cfg != null) {
            cn.put("background", (Object)this.bg_cfg);
        }
        if (this.bg_day_cfg != null) {
            cn.put("backgroundday", (Object)this.bg_day_cfg);
        }
        if (this.bg_night_cfg != null) {
            cn.put("backgroundnight", (Object)this.bg_night_cfg);
        }
        cn.put("append_to_world", (Object)this.append_to_world);
        cn.put("protected", (Object)this.isProtected());
        if (this.tileupdatedelay > 0) {
            cn.put("tileupdatedelay", (Object)this.tileupdatedelay);
        }
        return cn;
    }

    public final HDShader getShader() {
        return this.shader;
    }

    public final HDPerspective getPerspective() {
        return this.perspective;
    }

    public final HDLighting getLighting() {
        return this.lighting;
    }

    public final int getBoostZoom() {
        return this.boostzoom;
    }

    @Override
    public final int getTileSize() {
        return 128 << this.tilescale;
    }

    public final int getTileScale() {
        return this.tilescale;
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld w, int x, int y, int z) {
        return this.perspective.getTileCoords(w, x, y, z, this.tilescale);
    }

    @Override
    public List<TileFlags.TileCoord> getTileCoords(DynmapWorld w, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        return this.perspective.getTileCoords(w, minx, miny, minz, maxx, maxy, maxz, this.tilescale);
    }

    @Override
    public MapTile[] getAdjecentTiles(MapTile tile) {
        return this.perspective.getAdjecentTiles(tile);
    }

    @Override
    public List<DynmapChunk> getRequiredChunks(MapTile tile) {
        return this.perspective.getRequiredChunks(tile);
    }

    @Override
    public int getMapZoomOutLevels() {
        return this.mapzoomout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public List<MapType> getMapsSharingRender(DynmapWorld w) {
        ArrayList<MapType> maps = new ArrayList<MapType>();
        for (MapType mt : w.maps) {
            if (!(mt instanceof HDMap)) continue;
            HDMap hdmt = (HDMap)mt;
            if (hdmt.perspective != this.perspective || hdmt.boostzoom != this.boostzoom) continue;
            maps.add(hdmt);
        }
        return maps;
    }

    @Override
    public List<String> getMapNamesSharingRender(DynmapWorld w) {
        ArrayList<String> lst = new ArrayList<String>();
        for (MapType mt : w.maps) {
            if (!(mt instanceof HDMap)) continue;
            HDMap hdmt = (HDMap)mt;
            if (hdmt.perspective != this.perspective || hdmt.boostzoom != this.boostzoom) continue;
            if (hdmt.lighting.isNightAndDayEnabled()) {
                lst.add(hdmt.getName() + "(night/day)");
                continue;
            }
            lst.add(hdmt.getName());
        }
        return lst;
    }

    @Override
    public MapType.ImageFormat getImageFormat() {
        return this.imgformat;
    }

    @Override
    public void buildClientConfiguration(JSONObject worldObject, DynmapWorld world) {
        JSONObject o = new JSONObject();
        JSONUtils.s(o, "type", "HDMapType");
        JSONUtils.s(o, "name", this.name);
        JSONUtils.s(o, "title", this.title);
        JSONUtils.s(o, "icon", this.icon);
        JSONUtils.s(o, "prefix", this.prefix);
        JSONUtils.s(o, "background", this.bg_cfg);
        JSONUtils.s(o, "backgroundday", this.bg_day_cfg);
        JSONUtils.s(o, "backgroundnight", this.bg_night_cfg);
        JSONUtils.s(o, "bigmap", true);
        JSONUtils.s(o, "mapzoomout", world.getExtraZoomOutLevels() + this.mapzoomout);
        JSONUtils.s(o, "mapzoomin", this.mapzoomin);
        JSONUtils.s(o, "boostzoom", this.boostzoom);
        JSONUtils.s(o, "tilescale", this.tilescale);
        JSONUtils.s(o, "protected", this.isProtected());
        JSONUtils.s(o, "image-format", this.imgformat.getFileExt());
        if (this.append_to_world.length() > 0) {
            JSONUtils.s(o, "append_to_world", this.append_to_world);
        }
        this.perspective.addClientConfiguration(o);
        this.shader.addClientConfiguration(o);
        this.lighting.addClientConfiguration(o);
        JSONUtils.a(worldObject, "maps", o);
    }

    private static int parseColor(String c) {
        int v = 0;
        if (c.startsWith("#")) {
            if ((c = c.substring(1)).length() == 3) {
                try {
                    v = Integer.valueOf(c, 16);
                }
                catch (NumberFormatException nfx) {
                    return 0;
                }
                v = 0xFF000000 | (v & 0xF00) << 12 | (v & 0xF0) << 8 | (v & 0xF) << 4;
            } else if (c.length() == 6) {
                try {
                    v = Integer.valueOf(c, 16);
                }
                catch (NumberFormatException nfx) {
                    return 0;
                }
                v = 0xFF000000 | v & 0xFFFFFF;
            }
        }
        return v;
    }

    @Override
    public int getBackgroundARGBDay() {
        return this.bgcolorday;
    }

    @Override
    public int getBackgroundARGBNight() {
        return this.bgcolornight;
    }

    @Override
    public void purgeOldTiles(final DynmapWorld world, final TileFlags rendered) {
        MapStorage ms = world.getMapStorage();
        ms.enumMapTiles(world, this, new MapStorageTileEnumCB(){

            @Override
            public void tileFound(MapStorageTile tile, MapType.ImageEncoding fmt) {
                if (fmt != HDMap.this.getImageFormat().getEncoding()) {
                    tile.delete();
                } else if (tile.zoom == 1) {
                    if (rendered.getFlag(tile.x, tile.y) || rendered.getFlag(tile.x + 1, tile.y) || rendered.getFlag(tile.x, tile.y - 1) || rendered.getFlag(tile.x + 1, tile.y - 1)) {
                        return;
                    }
                    tile.enqueueZoomOutUpdate();
                } else if (tile.zoom == 0) {
                    if (rendered.getFlag(tile.x, tile.y)) {
                        return;
                    }
                    tile.delete();
                    MapManager.mapman.pushUpdate(world, (Client.Update)new Client.Tile(tile.getURI()));
                    tile.enqueueZoomOutUpdate();
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public int getMapZoomIn() {
        return this.mapzoomin;
    }

    public String getIcon() {
        return this.icon == null ? "" : this.icon;
    }

    public boolean setPrefix(String s) {
        if (!s.equals(this.prefix)) {
            this.prefix = s;
            return true;
        }
        return false;
    }

    public boolean setTitle(String s) {
        if (!s.equals(this.title)) {
            this.title = s;
            return true;
        }
        return false;
    }

    public boolean setAppendToWorld(String s) {
        if (!s.equals(this.append_to_world)) {
            this.append_to_world = s;
            return true;
        }
        return false;
    }

    public String getAppendToWorld() {
        return this.append_to_world;
    }

    public boolean setMapZoomIn(int mzi) {
        if (mzi != this.mapzoomin) {
            this.mapzoomin = mzi;
            return true;
        }
        return false;
    }

    public boolean setMapZoomOut(int mzi) {
        if (mzi != this.mapzoomout) {
            this.mapzoomout = mzi;
            return true;
        }
        return false;
    }

    public boolean setBoostZoom(int mzi) {
        if (mzi != this.boostzoom) {
            this.boostzoom = mzi;
            return true;
        }
        return false;
    }

    public boolean setTileScale(int mzi) {
        if (mzi != this.tilescale) {
            this.tilescale = mzi;
            return true;
        }
        return false;
    }

    public boolean setPerspective(HDPerspective p) {
        if (this.perspective != p) {
            this.perspective = p;
            return true;
        }
        return false;
    }

    public boolean setShader(HDShader p) {
        if (this.shader != p) {
            this.shader = p;
            return true;
        }
        return false;
    }

    public boolean setLighting(HDLighting p) {
        if (this.lighting != p) {
            this.lighting = p;
            return true;
        }
        return false;
    }

    public boolean setImageFormatSetting(String f) {
        MapType.ImageFormat newfmt;
        if (!this.imgfmtstring.equals(f) && (newfmt = f.equals("default") ? MapType.ImageFormat.fromID(this.core.getDefImageFormat()) : MapType.ImageFormat.fromID(f)) != null) {
            this.imgformat = newfmt;
            this.imgfmtstring = f;
            return true;
        }
        return false;
    }

    public String getImageFormatSetting() {
        return this.imgfmtstring;
    }

    public boolean setIcon(String v) {
        if ("".equals(v)) {
            v = null;
        }
        this.icon = v;
        return true;
    }

    @Override
    public void addMapTiles(List<MapTile> list, DynmapWorld w, int tx, int ty) {
        list.add(new HDMapTile(w, this.perspective, tx, ty, this.boostzoom, this.tilescale));
    }

    @Override
    public MapType.ImageVariant[] getVariants() {
        if (this.lighting.isNightAndDayEnabled()) {
            return dayVariant;
        }
        return super.getVariants();
    }
}

