/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import org.pepsoft.worldpainter.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    public static final long REQUIRED_MEMORY_PER_JOB = 250000000L;
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);
    private static volatile Integer mostRecentThreadCount;

    private ThreadUtils() {
    }

    public static int chooseThreadCount(String operation, int jobCount) {
        int threadCount;
        Integer configProp;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long memoryInUse = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        long maxMemoryAvailable = maxMemory - memoryInUse;
        String sysProp = System.getProperty("org.pepsoft.worldpainter.threads");
        Integer n = configProp = Configuration.getInstance() != null ? Configuration.getInstance().getMaxThreadCount() : null;
        if (sysProp != null) {
            threadCount = Math.max(Math.min(Integer.parseInt(sysProp), jobCount), 1);
            logger.info("Using " + threadCount + " thread(s) for " + operation + " (max. thread count source: org.pepsoft.worldpainter.threads advanced setting set to " + sysProp + ")");
        } else if (configProp != null) {
            threadCount = Math.max(Math.min(configProp, jobCount), 1);
            logger.info("Using " + threadCount + " thread(s) for " + operation + " (max. thread count source: max. thread count in preferences set to " + configProp + ")");
        } else {
            int maxThreadsByMem = (int)(maxMemoryAvailable / 250000000L);
            threadCount = Math.max(Math.min(Math.min(maxThreadsByMem, runtime.availableProcessors()), jobCount), 1);
            logger.info("Using " + threadCount + " thread(s) for " + operation + " (max. thread count source: logical processors: " + runtime.availableProcessors() + ", available memory: " + maxMemoryAvailable / 0x100000L + " MB)");
        }
        mostRecentThreadCount = threadCount;
        return threadCount;
    }

    public static Integer getMostRecentThreadCount() {
        return mostRecentThreadCount;
    }
}

