/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.worldpainter.util.MinecraftJarProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftUtil {
    private static final Logger logger = LoggerFactory.getLogger(MinecraftUtil.class);

    private MinecraftUtil() {
    }

    public static File findMinecraftDir() {
        File candidate;
        String env = System.getProperty("org.pepsoft.worldpainter.minecraftDir");
        if (env != null) {
            File candidate2 = new File(env);
            if (candidate2.isDirectory()) {
                return candidate2;
            }
            logger.error("Minecraft directory from system property does not exist: {}; continuing without Minecraft installation", (Object)env);
            return null;
        }
        if (SystemUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            if (appData != null && (candidate = new File(appData, ".minecraft")).isDirectory()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Using Minecraft installation in {}", (Object)candidate);
                }
                return candidate;
            }
        } else if (SystemUtils.isMac() && (candidate = new File(System.getProperty("user.home"), "Library/Application Support/minecraft")).isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using Minecraft installation in {}", (Object)candidate);
            }
            return candidate;
        }
        if ((candidate = new File(System.getProperty("user.home"), ".minecraft")).isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Using Minecraft installation in {}", (Object)candidate);
            }
            return candidate;
        }
        return null;
    }

    public static File findMinecraftJar(MinecraftJarProvider minecraftJarProvider) {
        File candidate;
        for (int i = 10; i >= 1; --i) {
            candidate = minecraftJarProvider.getMinecraftJar(i);
            if (candidate == null || !candidate.isFile() || !candidate.canRead()) continue;
            return candidate;
        }
        File minecraftDir = MinecraftUtil.findMinecraftDir();
        if (minecraftDir != null && (candidate = new File(minecraftDir, "bin/minecraft.jar")).isFile() && candidate.canRead()) {
            return candidate;
        }
        return null;
    }

    @NotNull
    public static File getRegionDir(File worldDir, int dimension) {
        File regionDir;
        switch (dimension) {
            case 0: {
                regionDir = new File(worldDir, "region");
                break;
            }
            case 1: {
                regionDir = new File(worldDir, "DIM-1/region");
                break;
            }
            case 2: {
                regionDir = new File(worldDir, "DIM1/region");
                break;
            }
            default: {
                throw new IllegalArgumentException("Dimension " + dimension + " not supported");
            }
        }
        return regionDir;
    }

    public static String blocksToWalkingTime(int blocks) {
        int hours;
        int mins = Math.round((float)blocks / 256.0f);
        if (mins < 60) {
            return mins + " min.";
        }
        if ((mins -= 60 * (hours = mins / 60)) == 0) {
            return hours + "hr.";
        }
        return hours + "hr., " + mins + " min.";
    }
}

