/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldIO;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;
import org.pepsoft.worldpainter.util.BackupUtils;

public class SaveWorldOp
extends AbstractOperation<Void> {
    private final World2 world;
    private String fileName;

    public SaveWorldOp(ScriptingContext context, World2 world) throws ScriptException {
        super(context);
        if (world == null) {
            throw new ScriptException("world may not be null");
        }
        this.world = world;
    }

    public SaveWorldOp toFile(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Override
    public Void go() throws ScriptException {
        this.goCalled();
        File file = new File(this.fileName);
        File dir = file.getAbsoluteFile().getParentFile();
        if (!dir.isDirectory()) {
            throw new ScriptException("Destination directory " + dir + " does not exist or is not a directory");
        }
        if (!dir.canWrite()) {
            throw new ScriptException("Access denied to destination directory " + dir);
        }
        try {
            Configuration config = Configuration.getInstance();
            if (config.getWorldFileBackups() > 0 && file.isFile()) {
                for (int i = config.getWorldFileBackups(); i > 0; --i) {
                    File nextBackupFile;
                    File file2 = nextBackupFile = i > 1 ? BackupUtils.getBackupFile(file, i - 1) : file;
                    if (!nextBackupFile.isFile()) continue;
                    File backupFile = BackupUtils.getBackupFile(file, i);
                    if (backupFile.isFile() && !backupFile.delete()) {
                        throw new ScriptException("Could not delete old backup file " + backupFile);
                    }
                    if (nextBackupFile.renameTo(backupFile)) continue;
                    throw new ScriptException("Could not move " + nextBackupFile + " to " + backupFile);
                }
            }
            WorldIO worldIO = new WorldIO(this.world);
            worldIO.save(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new ScriptException("I/O error saving file (message: " + e.getMessage() + ")", e);
        }
        return null;
    }
}

