/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.SecureRandom;
import java.util.zip.GZIPInputStream;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.JavaWorldExporter;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;

public class Timings {
    public static void main(String[] args) throws IOException, ProgressReceiver.OperationCancelled, ClassNotFoundException {
        World2 world;
        SecureRandom random = new SecureRandom();
        try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(args[0])));){
            world = (World2)in.readObject();
        }
        long totalDuration = 0L;
        for (int i = 0; i < 5; ++i) {
            world.getDimension(Dimension.Anchor.NORMAL_DETAIL).getTileFactory().setSeed(random.nextLong());
            JavaWorldExporter exporter = new JavaWorldExporter(world, WorldExportSettings.EXPORT_EVERYTHING);
            System.out.println("Starting export of world " + world.getName() + " " + i + " (seed: " + world.getDimension(Dimension.Anchor.NORMAL_DETAIL).getSeed() + ")");
            File baseDir = new File(System.getProperty("user.dir"));
            String name = world.getName() + ' ' + i;
            File worldDir = new File(baseDir, FileUtils.sanitiseName((String)name));
            if (worldDir.isDirectory()) {
                FileUtils.deleteDir((File)worldDir);
            }
            long start = System.currentTimeMillis();
            exporter.export(baseDir, name, null, null);
            long duration = System.currentTimeMillis() - start;
            System.out.println("Exporting world took " + (float)duration / 1000.0f + " s");
            totalDuration += duration;
        }
        System.out.println("Average duration: " + (float)totalDuration / 5000.0f + " s");
    }
}

