/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.PlatformManager;

public class Statistics
extends AbstractTool {
    public static void main(String[] args) throws IOException {
        Statistics.initialisePlatform();
        File worldDir = new File(args[0]);
        int dim = Integer.parseInt(args[1]);
        File levelDatFile = new File(worldDir, "level.dat");
        JavaLevel level = JavaLevel.load(levelDatFile);
        if (level.getVersion() != 19132 && level.getVersion() != 19133) {
            throw new UnsupportedOperationException("Level format version " + level.getVersion() + " not supported");
        }
        int maxHeight = level.getMaxHeight();
        int minY = level.getMinHeight();
        int maxY = maxHeight - 1;
        System.out.println("Scanning " + worldDir);
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(worldDir);
        Map[] blockTypeCounts = new Map[maxHeight - minY >> 4];
        for (int i2 = 0; i2 < blockTypeCounts.length; ++i2) {
            blockTypeCounts[i2] = new HashMap();
        }
        ChunkStore chunkStore = platformManager.getChunkStore(platform, worldDir, dim);
        chunkStore.visitChunks(chunk -> {
            for (int xx = 0; xx < 16; ++xx) {
                for (int zz = 0; zz < 16; ++zz) {
                    for (int y = maxY; y >= minY; --y) {
                        String material = chunk.getMaterial((int)xx, (int)y, (int)zz).name;
                        blockTypeCounts[y - minY >> 4].computeIfAbsent(material, i -> new AtomicInteger()).incrementAndGet();
                    }
                }
            }
            return true;
        });
        switch (dim) {
            case 0: {
                System.out.println("\tGranite\tDiorite\tAndesiteTuff\tDirt\tGravel\tStone\tDeepslateCoal\tCopper\tLapis\tIron\tGold\tRedstoneDiamond\tEmerald\tWater*\tLava*");
                for (int y = 0; y < maxHeight - minY >> 4; ++y) {
                    int total = blockTypeCounts[y].values().stream().map(AtomicInteger::get).reduce(0, Integer::sum);
                    int stoneLikeTotal = blockTypeCounts[y].computeIfAbsent("minecraft:stone", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:granite", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:diorite", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:andesite", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:tuff", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:dirt", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:gravel", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:bedrock", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:coal_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:copper_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:lapis_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:iron_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:gold_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:redstone_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:diamond_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:emerald_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_coal_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_copper_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_lapis_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_iron_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_gold_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_redstone_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_diamond_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:deepslate_emerald_ore", i -> new AtomicInteger()).get();
                    System.out.print((y << 4) + minY + "\t");
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:granite")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:diorite")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:andesite")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:tuff")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:dirt")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:gravel")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:stone")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:coal_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_coal_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:copper_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_copper_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:lapis_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_lapis_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:iron_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_iron_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:gold_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_gold_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:redstone_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_redstone_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:diamond_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_diamond_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)(((AtomicInteger)blockTypeCounts[y].get("minecraft:emerald_ore")).get() + ((AtomicInteger)blockTypeCounts[y].get("minecraft:deepslate_emerald_ore")).get()) / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)blockTypeCounts[y].computeIfAbsent("minecraft:water", k -> new AtomicInteger()).get() / (float)total * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)blockTypeCounts[y].computeIfAbsent("minecraft:lava", k -> new AtomicInteger()).get() / (float)total * 1000.0f));
                    System.out.println("(* Water and Lava are \u2030 of ALL blocks)");
                }
                break;
            }
            case 1: {
                System.out.println("\tNetherrackBasaltBedrock\tBlackstoneGlowstoneGravelMagma\tSand\tSoil\tGold\tQuarz\tDebris");
                for (int y = 0; y < maxHeight - minY >> 4; ++y) {
                    int stoneLikeTotal = blockTypeCounts[y].computeIfAbsent("minecraft:netherrack", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:basalt", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:bedrock", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:blackstone", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:glowstone", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:gravel", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:magma_block", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:soul_sand", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:soul_soil", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:nether_gold_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:nether_quartz_ore", i -> new AtomicInteger()).get() + blockTypeCounts[y].computeIfAbsent("minecraft:ancient_debris", i -> new AtomicInteger()).get();
                    System.out.print((y << 4) + minY + "\t");
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:netherrack")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:basalt")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:bedrock")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:blackstone")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:glowstone")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:gravel")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:magma_block")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:soul_sand")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:soul_soil")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:nether_gold_ore")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:nether_quartz_ore")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.printf("%6.2f\u2030\t", Float.valueOf((float)((AtomicInteger)blockTypeCounts[y].get("minecraft:ancient_debris")).get() / (float)stoneLikeTotal * 1000.0f));
                    System.out.println();
                }
                break;
            }
        }
    }
}

