/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.util.WPCustomObjectInputStream;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.InstanceKeeper;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldIO;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverWorld {
    private static final Logger logger = LoggerFactory.getLogger(RecoverWorld.class);

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        File file;
        HashMap tiles;
        ArrayList worlds;
        int defaultMaxHeight;
        int defaultMinHeight;
        block71: {
            Configuration config;
            defaultMinHeight = Integer.parseInt(args[1]);
            defaultMaxHeight = Integer.parseInt(args[2]);
            try {
                config = Configuration.load();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (config == null) {
                if (!logger.isDebugEnabled()) {
                    logger.info("Creating new configuration");
                }
                config = new Configuration();
            }
            Configuration.setInstance(config);
            logger.info("Installation ID: " + config.getUuid());
            X509Certificate trustedCert = null;
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                trustedCert = (X509Certificate)certificateFactory.generateCertificate(RecoverWorld.class.getResourceAsStream("/wproot.pem"));
            }
            catch (CertificateException e) {
                logger.error("Certificate exception while loading trusted root certificate", (Throwable)e);
            }
            if (trustedCert != null) {
                PluginManager.loadPlugins((File)new File(Configuration.getConfigDir(), "plugins"), (PublicKey)trustedCert.getPublicKey(), (String)"org.pepsoft.worldpainter.plugins", (org.pepsoft.util.Version)Version.VERSION_OBJ, (boolean)false);
            } else {
                logger.error("Trusted root certificate not available; not loading plugins");
            }
            WPPluginManager.initialise(config.getUuid());
            worlds = new ArrayList();
            tiles = new HashMap();
            List[] tileListHolder = new List[1];
            InstanceKeeper.setInstantiationListener(World2.class, worlds::add);
            InstanceKeeper.setInstantiationListener(Dimension.class, dimension -> {
                ArrayList tileList = new ArrayList();
                tiles.put(dimension, tileList);
                tileListHolder[0] = tileList;
            });
            InstanceKeeper.setInstantiationListener(Tile.class, tile -> tileListHolder[0].add(tile));
            file = new File(args[0]);
            try {
                WPCustomObjectInputStream wrappedIn = new WPCustomObjectInputStream((InputStream)new GZIPInputStream(new FileInputStream(file)), PluginManager.getPluginClassLoader(), new Class[]{AbstractObject.class});
                Object object = null;
                try {
                    Object var11_15 = null;
                    Object object2 = wrappedIn.readObject();
                    if (object2 instanceof Map) {
                        Map map = (Map)object2;
                        object2 = wrappedIn.readObject();
                    }
                    if (object2 instanceof World2) {
                        void var11_17;
                        World2 world = (World2)object2;
                        if (var11_17 != null) {
                            world.setMetadata((Map<String, Object>)var11_17);
                        }
                        break block71;
                    }
                    if (object2 instanceof World) {
                        throw new RuntimeException("Old worlds (pre-0.2) not supported");
                    }
                    throw new RuntimeException("Object of unexpected type " + object2.getClass() + " encountered");
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (wrappedIn != null) {
                        if (object != null) {
                            try {
                                wrappedIn.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            wrappedIn.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Warning: I/O error while reading world; world most likely corrupted! (Type: " + e.getClass().getSimpleName() + ", message: " + e.getMessage() + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning: class not found while reading world; world most likely corrupted! (Type: " + e.getClass().getSimpleName() + ", message: " + e.getMessage() + ")");
            }
        }
        System.out.println(worlds.size() + " worlds read");
        System.out.println(tiles.size() + " dimensions read");
        World2 newWorld = null;
        for (Map.Entry entry : tiles.entrySet()) {
            TileFactory tileFactory;
            Dimension dimension2 = (Dimension)entry.getKey();
            List tileList = (List)entry.getValue();
            System.out.println(tileList.size() + " tiles read for dimension " + dimension2.getName());
            int minHeight = dimension2.getMinHeight() != 0 ? dimension2.getMinHeight() : defaultMinHeight;
            int maxHeight = dimension2.getMaxHeight() != 0 ? dimension2.getMaxHeight() : defaultMaxHeight;
            if (newWorld == null) {
                if (worlds.size() > 0) {
                    World2 world = (World2)worlds.get(0);
                    newWorld = world.getPlatform() != null ? new World2(world.getPlatform(), minHeight, maxHeight) : (maxHeight == 256 ? new World2(DefaultPlugin.JAVA_ANVIL, minHeight, maxHeight) : new World2(DefaultPlugin.JAVA_MCREGION, minHeight, maxHeight));
                    if (world.getName() != null) {
                        newWorld.setName(((World2)worlds.get(0)).getName() + " (recovered)");
                    }
                    newWorld.setCreateGoodiesChest(world.isCreateGoodiesChest());
                    try {
                        for (int i = 0; i < 96; ++i) {
                            newWorld.setMixedMaterial(i, world.getMixedMaterial(i));
                        }
                    }
                    catch (NullPointerException e) {
                        System.err.println("Custom material settings lost");
                    }
                    newWorld.setGameType(world.getGameType());
                    newWorld.setImportedFrom(world.getImportedFrom());
                    newWorld.setMapFeatures(world.isMapFeatures());
                    if (world.getSpawnPoint() != null) {
                        newWorld.setSpawnPoint(world.getSpawnPoint());
                    } else {
                        System.err.println("Spawn point setting lost; resetting to 0,0");
                    }
                    if (world.getUpIs() != null) {
                        newWorld.setUpIs(world.getUpIs());
                    } else {
                        System.err.println("North direction setting lost; resetting to north is up");
                    }
                } else {
                    System.err.println("No world recovered; all world settings lost");
                    newWorld = maxHeight == 256 ? new World2(DefaultPlugin.JAVA_ANVIL, minHeight, maxHeight) : new World2(DefaultPlugin.JAVA_MCREGION, minHeight, maxHeight);
                }
                newWorld.addHistoryEntry(6, new Serializable[0]);
                if (newWorld.getName() == null) {
                    String worldName = file.getName();
                    if (worldName.toLowerCase().endsWith(".world")) {
                        worldName = worldName.substring(0, worldName.length() - 6);
                    }
                    newWorld.setName(worldName + " (recovered)");
                }
            }
            if ((tileFactory = dimension2.getTileFactory()) == null) {
                System.err.println("Dimension " + dimension2.getName() + " tile factory lost; creating default tile factory");
                tileFactory = TileFactoryFactory.createNoiseTileFactory(dimension2.getSeed(), Terrain.GRASS, minHeight, maxHeight, 58, 62, false, true, 20.0f, 1.0);
            }
            Dimension.Anchor anchor = dimension2.getAnchor();
            Dimension newDimension = new Dimension(newWorld, anchor.getDefaultName(), dimension2.getMinecraftSeed(), tileFactory, anchor);
            try {
                for (Map.Entry<Layer, ExporterSettings> settingsEntry : dimension2.getAllLayerSettings().entrySet()) {
                    if (settingsEntry.getValue() != null) {
                        newDimension.setLayerSettings(settingsEntry.getKey(), settingsEntry.getValue());
                        continue;
                    }
                    System.err.println("Layer settings for layer " + settingsEntry.getKey().getName() + " lost for dimension " + dimension2.getName());
                }
            }
            catch (NullPointerException e) {
                System.err.println("Layer settings lost for dimension " + dimension2.getName());
            }
            newDimension.setWallType(dimension2.getWallType());
            if (dimension2.getBorderLevel() > 0 && dimension2.getBorderSize() > 0) {
                newDimension.setBorder(dimension2.getBorder());
                newDimension.setBorderLevel(dimension2.getBorderLevel());
                newDimension.setBorderSize(dimension2.getBorderSize());
            } else {
                System.err.println("Border settings lost for dimension " + dimension2.getName());
            }
            if (dimension2.getContourSeparation() > 0) {
                newDimension.setContoursEnabled(dimension2.isContoursEnabled());
                newDimension.setContourSeparation(dimension2.getContourSeparation());
            } else {
                System.err.println("Contour settings lost for dimension " + dimension2.getName());
            }
            newDimension.setRoofType(dimension2.getRoofType());
            if (dimension2.getGridSize() > 0) {
                newDimension.setGridEnabled(dimension2.isGridEnabled());
                newDimension.setGridSize(dimension2.getGridSize());
            } else {
                System.err.println("Grid settings lost for dimension " + dimension2.getName());
            }
            newDimension.setMinecraftSeed(dimension2.getMinecraftSeed());
            for (Overlay overlay : dimension2.getOverlays()) {
                newDimension.addOverlay(overlay);
            }
            newDimension.setPopulate(dimension2.isPopulate());
            if (dimension2.getSubsurfaceMaterial() != null) {
                newDimension.setSubsurfaceMaterial(dimension2.getSubsurfaceMaterial());
            } else {
                System.err.println("Sub surface material lost for dimension " + dimension2.getName() + "; resetting to STONE_MIX");
                newDimension.setSubsurfaceMaterial(Terrain.STONE_MIX);
            }
            if (dimension2.getGenerator() != null) {
                newDimension.setGenerator(dimension2.getGenerator());
            } else {
                System.err.println("Landscape generator setting lost for dimension " + dimension2.getName() + "; resetting to DEFAULT");
                newDimension.setGenerator(new SeededGenerator(Generator.DEFAULT, newDimension.getMinecraftSeed()));
            }
            newWorld.addDimension(newDimension);
            for (Tile tile2 : tileList) {
                tile2.repair(minHeight, maxHeight, System.err);
                newDimension.addTile(tile2);
            }
        }
        String filename = file.getName();
        if (filename.toLowerCase().endsWith(".world")) {
            filename = filename.substring(0, filename.length() - 6);
        }
        filename = filename + ".recovered.world";
        WorldIO worldIO = new WorldIO(newWorld);
        File outFile = new File(file.getParentFile(), filename);
        try (FileOutputStream out = new FileOutputStream(outFile);){
            worldIO.save(out);
        }
        System.out.println("Recovered world written to " + outFile);
    }
}

