/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.IOException;
import org.pepsoft.minecraft.Block;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.exporting.JavaMinecraftWorld;

public class DumpWater {
    private static final int CACHE_SIZE = 100;

    public static final void main(String[] args) throws IOException {
        File levelDatFile = new File(args[0]);
        int x = Integer.parseInt(args[1]);
        int y = Integer.parseInt(args[2]);
        int z = Integer.parseInt(args[3]);
        JavaLevel level = JavaLevel.load(levelDatFile);
        JavaMinecraftWorld world = new JavaMinecraftWorld(levelDatFile.getParentFile(), 0, level.getMinHeight(), level.getMaxHeight(), level.getVersion() == 19132 ? DefaultPlugin.JAVA_MCREGION : DefaultPlugin.JAVA_ANVIL, true, 100);
        for (int dy = 16; dy >= -16; --dy) {
            for (int dx = -16; dx <= 16; ++dx) {
                int blockX = x + dx;
                int blockZ = z;
                int blockType = world.getBlockTypeAt(blockX, blockZ, y + dy);
                System.out.print('[');
                System.out.print(blockType != 0 ? Block.BLOCK_TYPE_NAMES[blockType].substring(0, 3).toUpperCase() : "   ");
                System.out.print(';');
                int data = world.getDataAt(blockX, blockZ, y + dy);
                if (data > 0) {
                    if (data < 10) {
                        System.out.print('0');
                    }
                    System.out.print(data);
                } else {
                    System.out.print("  ");
                }
                System.out.print(']');
            }
            System.out.println();
        }
    }
}

