/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DumpImageInfo {
    public static void main(String[] args) throws IOException {
        File[] files;
        File dir = new File(args[0]);
        for (File file : files = dir.listFiles()) {
            if (!file.isFile() || !file.canRead()) continue;
            DumpImageInfo.dumpInfo(file);
        }
    }

    private static void dumpInfo(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        if (image != null) {
            System.out.println(file.getPath());
            DumpImageInfo.dumpInfo(image);
            System.out.println();
        }
    }

    private static void dumpInfo(BufferedImage image) throws IOException {
        int i;
        System.out.print("  Image type: ");
        switch (image.getType()) {
            case 5: {
                System.out.println("3BYTE_BGR");
                break;
            }
            case 6: {
                System.out.println("4BYTE_ABGR");
                break;
            }
            case 7: {
                System.out.println("4BYTE_ABGR_PRE");
                break;
            }
            case 12: {
                System.out.println("BYTE_BINARY");
                break;
            }
            case 10: {
                System.out.println("BYTE_GRAY");
                break;
            }
            case 13: {
                System.out.println("BYTE_INDEXED");
                break;
            }
            case 0: {
                System.out.println("CUSTOM");
                break;
            }
            case 2: {
                System.out.println("INT_ARGB");
                break;
            }
            case 3: {
                System.out.println("INT_ARGB_PRE");
                break;
            }
            case 4: {
                System.out.println("INT_BGR");
                break;
            }
            case 1: {
                System.out.println("INT_RGB");
                break;
            }
            case 9: {
                System.out.println("USHORT_555_RGB");
                break;
            }
            case 8: {
                System.out.println("USHORT_565_RGB");
                break;
            }
            case 11: {
                System.out.println("USHORT_GRAY");
                break;
            }
            default: {
                System.out.println("unknown (" + image.getType() + ")");
            }
        }
        System.out.println("  Width: " + image.getWidth());
        System.out.println("  Height: " + image.getWidth());
        SampleModel sampleModel = image.getSampleModel();
        System.out.print("  Sample model data type: ");
        switch (sampleModel.getDataType()) {
            case 0: {
                System.out.println("byte");
                break;
            }
            case 5: {
                System.out.println("double");
                break;
            }
            case 4: {
                System.out.println("float");
                break;
            }
            case 3: {
                System.out.println("int");
                break;
            }
            case 2: {
                System.out.println("short");
                break;
            }
            case 32: {
                System.out.println("undefined");
                break;
            }
            case 1: {
                System.out.println("unsigned short");
                break;
            }
            default: {
                System.out.println("unknown (" + sampleModel.getDataType() + ")");
            }
        }
        System.out.println("  Sample model number of bands: " + sampleModel.getNumBands());
        for (int i2 = 0; i2 < sampleModel.getNumBands(); ++i2) {
            System.out.println("    Band " + i2 + ": " + sampleModel.getSampleSize(i2) + " bits");
        }
        ColorModel colorModel = image.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            System.out.println("  Color model is indexed");
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            System.out.println("    Palette size: " + indexColorModel.getMapSize());
            System.out.println("    Palette:");
            for (i = 0; i < indexColorModel.getMapSize(); ++i) {
                System.out.printf("      Index %2d: 0x%8x%n", i, indexColorModel.getRGB(i));
            }
        } else {
            System.out.println("  Color model is not indexed");
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        System.out.print("  Color space type: ");
        switch (colorSpace.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                System.out.println("generic");
                break;
            }
            case 11: {
                System.out.println("CMY");
                break;
            }
            case 9: {
                System.out.println("CMYK");
                break;
            }
            case 6: {
                System.out.println("grayscale");
                break;
            }
            case 8: {
                System.out.println("HLS");
                break;
            }
            case 7: {
                System.out.println("HSV");
                break;
            }
            case 1: {
                System.out.println("Lab");
                break;
            }
            case 2: {
                System.out.println("Luv");
                break;
            }
            case 5: {
                System.out.println("RGB");
                break;
            }
            case 0: {
                System.out.println("XYZ");
                break;
            }
            case 3: {
                System.out.println("YCbCr");
                break;
            }
            case 4: {
                System.out.println("Yxy");
                break;
            }
            default: {
                System.out.println("unknown (" + colorSpace.getType() + ")");
            }
        }
        System.out.println("  Color space components: " + colorSpace.getNumComponents());
        for (i = 0; i < colorSpace.getNumComponents(); ++i) {
            System.out.println("    Component " + i + ": " + colorSpace.getName(i));
            System.out.println("      Minimum value: " + colorSpace.getMinValue(i));
            System.out.println("      Maximum value: " + colorSpace.getMaxValue(i));
        }
        System.out.println("  Color model components: " + colorModel.getNumComponents());
        for (i = 0; i < colorModel.getNumComponents(); ++i) {
            System.out.println("    Component " + i + ": " + colorModel.getComponentSize(i) + " bits");
        }
        System.out.println("  Color model pixel size: " + colorModel.getPixelSize() + " bits");
        System.out.print("  Color model transparency: ");
        switch (colorModel.getTransparency()) {
            case 2: {
                System.out.println("bitmask");
                break;
            }
            case 1: {
                System.out.println("opaque");
                break;
            }
            case 3: {
                System.out.println("translucent");
                break;
            }
            default: {
                System.out.println("unknown (" + colorModel.getTransparency() + ")");
            }
        }
        System.out.println("  Color model has alpha: " + colorModel.hasAlpha());
        if (colorModel.hasAlpha()) {
            System.out.println("    Premultiplied: " + colorModel.isAlphaPremultiplied());
        }
        System.out.println("[ R][ G][ B][ A][smpl]");
        for (int x = 0; x < 16; ++x) {
            int rgba = image.getRGB(x, 0);
            System.out.printf("[%2x][%2x][%2x][%2x][%4x]%n", rgba & 0xFF, (rgba & 0xFF00) >> 8, (rgba & 0xFF0000) >> 16, (rgba & 0xFF000000) >>> 24, image.getRaster().getSample(x, 0, 0));
        }
    }
}

