/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.PlatformManager;

public class DumpBlockData
extends AbstractTool {
    public static void main(String[] args) {
        DumpBlockData.initialisePlatform();
        Set allMaterials = Collections.synchronizedSet(new HashSet());
        Map<String, Map> allProperties = Collections.synchronizedMap(new HashMap());
        File worldDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(worldDir);
        ChunkStore chunkStore = platformManager.getChunkStore(platform, worldDir, 0);
        chunkStore.visitChunks(chunk -> {
            for (int y = 0; y < 256; ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Material material = chunk.getMaterial(x, y, z);
                        allMaterials.add(material);
                        Map matProps = allProperties.computeIfAbsent(material.name, key -> new HashMap());
                        if (material.getProperties() == null) continue;
                        for (Map.Entry<String, String> entry : material.getProperties().entrySet()) {
                            Map map = matProps;
                            synchronized (map) {
                                matProps.computeIfAbsent(entry.getKey(), key -> new HashSet()).add(entry.getValue());
                            }
                        }
                    }
                }
            }
            return true;
        });
        System.out.println("All blocks, properties and values encountered:");
        allProperties.forEach((name, matProps) -> {
            System.out.println((String)name);
            matProps.forEach((propName, values) -> {
                System.out.println("   " + propName);
                System.out.println("       " + values);
            });
        });
    }
}

