/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.fancy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3i;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.gardenofeden.Garden;
import org.pepsoft.worldpainter.gardenofeden.PathNode;
import org.pepsoft.worldpainter.util.GeometryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiverNode
extends PathNode {
    private int crossSectionalArea;
    private RiverNode child;
    private static final Logger logger = LoggerFactory.getLogger(RiverNode.class);
    private static final long serialVersionUID = 1L;

    public RiverNode(Garden garden, Point3i location, int crossSectionalArea) {
        super(garden, 0L, null, location, 1, 5);
        this.crossSectionalArea = crossSectionalArea;
    }

    public RiverNode(Garden garden, RiverNode parent, Point3i location) {
        super(garden, 0L, parent, location, 1, 5);
        parent.child = this;
        this.crossSectionalArea = parent.crossSectionalArea;
    }

    public RiverNode(Garden garden, RiverNode parent, Point3i location, RiverNode child) {
        super(garden, 0L, parent, location, 1, 5);
        parent.child = this;
        this.child = child;
        this.crossSectionalArea = parent.crossSectionalArea;
    }

    @Override
    protected boolean sprout() {
        boolean endRiver;
        boolean bl = endRiver = this.child != null;
        if (this.garden.isWater(this.location.x, this.location.y)) {
            endRiver = true;
        }
        if (this.parent != null) {
            this.drawLine(this.parent.location, this.location, (int)Math.round(Math.sqrt(this.crossSectionalArea)), false, this.category);
        }
        if (endRiver) {
            return this.parent != null;
        }
        boolean[] lowerPointFound = new boolean[1];
        int[] lowestHeightCoords = new int[2];
        int radius = 0;
        for (int r = 3; !lowerPointFound[0] && r <= 9; r += 2) {
            radius = r;
            float[] lowestHeight = new float[]{this.garden.getHeight(this.location.x, this.location.y)};
            GeometryUtil.visitCircle(r, (dx, dy, d) -> {
                float height = this.garden.getHeight(this.location.x + dx, this.location.y + dy);
                if (height < lowestHeight[0]) {
                    lowestHeight[0] = height;
                    lowestHeightCoords[0] = this.location.x + dx;
                    lowestHeightCoords[1] = this.location.y + dy;
                    lowerPointFound[0] = true;
                }
                return true;
            });
        }
        if (lowerPointFound[0]) {
            List<RiverNode> nearbyNodes = this.garden.findSeeds(RiverNode.class, lowestHeightCoords[0], lowestHeightCoords[1], radius);
            int ownNodesEncountered = 0;
            for (RiverNode riverNode : nearbyNodes) {
                if (riverNode.getOrigin() == this.getOrigin()) {
                    if (++ownNodesEncountered < 2) continue;
                    return true;
                }
                if (riverNode.child != null) {
                    this.garden.plantSeed(new RiverNode(this.garden, this, riverNode.location, riverNode.child));
                    this.addCrossSectionalArea(riverNode.child, this.crossSectionalArea);
                } else {
                    this.garden.plantSeed(new RiverNode(this.garden, this, riverNode.location));
                }
                return true;
            }
            this.garden.plantSeed(new RiverNode(this.garden, this, new Point3i(lowestHeightCoords[0], lowestHeightCoords[1], -1)));
            return true;
        }
        return this.parent != null;
    }

    public RiverNode getOrigin() {
        if (this.parent != null) {
            return ((RiverNode)this.parent).getOrigin();
        }
        return this;
    }

    public void apply(Dimension dimension, Dimension dimensionSnapshot, Set<RiverNode> processedNodes) {
        if (processedNodes.contains(this)) {
            logger.error("Loop in river!");
            return;
        }
        processedNodes.add(this);
        if (this.parent != null) {
            int d = (int)Math.round(Math.sqrt(this.crossSectionalArea));
            int r = d / 2;
            boolean eastWest = Math.abs(this.location.x - this.parent.location.x) > Math.abs(this.location.y - this.parent.location.y);
            this.doAlongLine(this.parent.location.x, this.parent.location.y, this.location.x, this.location.y, (x, y) -> {
                if (d == 1) {
                    if (eastWest) {
                        int lowestSurroundingDryHeight = this.getLowestSurroundingDryHeight(dimensionSnapshot, x, y);
                        dimension.setHeightAt(x, y, lowestSurroundingDryHeight - 1);
                        dimension.setWaterLevelAt(x, y, Math.max(dimension.getWaterLevelAt(x, y), lowestSurroundingDryHeight));
                        lowestSurroundingDryHeight = this.getLowestSurroundingDryHeight(dimensionSnapshot, x + 1, y);
                        dimension.setHeightAt(x + 1, y, lowestSurroundingDryHeight - 1);
                        dimension.setWaterLevelAt(x + 1, y, Math.max(dimension.getWaterLevelAt(x + 1, y), lowestSurroundingDryHeight));
                    } else {
                        int lowestSurroundingDryHeight = this.getLowestSurroundingDryHeight(dimensionSnapshot, x, y);
                        dimension.setHeightAt(x, y, lowestSurroundingDryHeight - 1);
                        dimension.setWaterLevelAt(x, y, Math.max(dimension.getWaterLevelAt(x, y), lowestSurroundingDryHeight));
                        lowestSurroundingDryHeight = this.getLowestSurroundingDryHeight(dimensionSnapshot, x, y + 1);
                        dimension.setHeightAt(x, y + 1, lowestSurroundingDryHeight - 1);
                        dimension.setWaterLevelAt(x, y + 1, Math.max(dimension.getWaterLevelAt(x, y + 1), lowestSurroundingDryHeight));
                    }
                } else if (d == 2) {
                    for (int dx2 = 0; dx2 < 2; ++dx2) {
                        for (int dy2 = 0; dy2 < 2; ++dy2) {
                            int lowestSurroundingDryHeight = this.getLowestSurroundingDryHeight(dimensionSnapshot, x + dx2, y + dy2);
                            dimension.setHeightAt(x + dx2, y + dy2, lowestSurroundingDryHeight - 1);
                            dimension.setWaterLevelAt(x + dx2, y + dy2, Math.max(dimension.getWaterLevelAt(x + dx2, y + dy2), lowestSurroundingDryHeight));
                        }
                    }
                } else {
                    GeometryUtil.visitFilledCircle(r - 1, (dx, dy, d1) -> {
                        int lowestSurroundingDryHeight = this.getLowestSurroundingDryHeight(dimensionSnapshot, x + dx, y + dy);
                        dimension.setHeightAt(x + dx, y + dy, lowestSurroundingDryHeight - 1);
                        dimension.setWaterLevelAt(x + dx, y + dy, Math.max(dimension.getWaterLevelAt(x + dx, y + dy), lowestSurroundingDryHeight));
                        return true;
                    });
                }
                return true;
            });
        }
        if (this.child != null) {
            this.child.apply(dimension, dimensionSnapshot, processedNodes);
        }
        this.garden.removeSeed(this);
    }

    public int getSlope(int x, int y) {
        int slope1 = Math.abs(this.garden.getIntHeight(x - 1, y) - this.garden.getIntHeight(x + 1, y));
        int slope2 = Math.abs(this.garden.getIntHeight(x - 1, y - 1) - this.garden.getIntHeight(x + 1, y + 1));
        int slope3 = Math.abs(this.garden.getIntHeight(x, y - 1) - this.garden.getIntHeight(x, y + 1));
        int slope4 = Math.abs(this.garden.getIntHeight(x + 1, y - 1) - this.garden.getIntHeight(x - 1, y + 1));
        return Math.max(Math.max(slope1, slope2), Math.max(slope3, slope4));
    }

    private void addCrossSectionalArea(RiverNode node, int crossSectionalArea) {
        HashSet<RiverNode> processedNodes = new HashSet<RiverNode>();
        while (node != null) {
            if (processedNodes.contains(node)) {
                logger.error("Loop in river!");
                return;
            }
            processedNodes.add(node);
            node.crossSectionalArea += crossSectionalArea;
            this.drawLine(node.parent.location, node.location, (int)Math.round(Math.sqrt(node.crossSectionalArea)), false, this.category);
            node = node.child;
        }
    }

    private int getLowestSurroundingDryHeight(Dimension snapshot, int x, int y) {
        int minHeight = snapshot.getMinHeight();
        int lowestSurroundingDryHeight = Integer.MAX_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int height;
                if (dx == 0 && dy == 0 || (height = snapshot.getIntHeightAt(x + dx, y + dy)) < snapshot.getWaterLevelAt(x + dx, y + dy) || height >= lowestSurroundingDryHeight) continue;
                if (height == minHeight) {
                    return minHeight;
                }
                lowestSurroundingDryHeight = height;
            }
        }
        return lowestSurroundingDryHeight;
    }
}

