/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.fancy;

import java.util.Random;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.heightMaps.SumHeightMap;
import org.pepsoft.worldpainter.layers.DeciduousForest;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Jungle;
import org.pepsoft.worldpainter.layers.PineForest;
import org.pepsoft.worldpainter.layers.SwampLand;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.themes.Theme;

public class FancyTheme
implements Theme,
Cloneable {
    protected GroundCoverLayer snowLayer = new GroundCoverLayer("Mountain Snow", MixedMaterial.create("Deep Snow", Material.SNOW_BLOCK), 0xFFFFFF);
    protected Terrain terrainDirtAndGravel = Terrain.CUSTOM_1;
    protected Terrain terrainStoneAndGravel = Terrain.CUSTOM_2;
    private int minHeight;
    private int maxHeight;
    private int waterHeight;
    private int desertMaxHeight;
    private HeightMap humidityMap;
    private HeightMap temperatureMap;
    private HeightMap heightMap;
    private float rockySlope = 1.5f;
    private HeightMap forestMap;
    private Terrain baseTerrain;
    private final HeightMap randomNoiseMap = new SumHeightMap(new ConstantHeightMap(-5.0), new NoiseHeightMap(10.0, 1.0, 3));
    private static final long serialVersionUID = 1L;

    public FancyTheme(int minHeight, int maxHeight, int waterHeight, HeightMap heightMap, Terrain baseTerrain) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.setWaterHeight(waterHeight);
        this.setHeightMap(heightMap);
        this.setDesertMaxHeight(waterHeight + 20);
        Random random = heightMap != null ? new Random(heightMap.getSeed()) : new Random();
        this.setTemperatureMap(new SumHeightMap(new NoiseHeightMap(60.0, 10.0, 2, random.nextLong()), new ConstantHeightMap(-20.0)));
        this.setHumidityMap(new NoiseHeightMap(100.0, 10.0, 2, random.nextLong()));
        this.setForestMap(new NoiseHeightMap(1.0, 1.0, 3, random.nextLong()));
        this.setBaseTerrain(baseTerrain);
        this.snowLayer.setThickness(5);
        this.snowLayer.setEdgeWidth(15);
        this.snowLayer.setEdgeShape(GroundCoverLayer.EdgeShape.SMOOTH);
    }

    @Override
    public void apply(Tile tile, int x, int y) {
        int worldX = tile.getX() << 7 | x;
        int worldY = tile.getY() << 7 | y;
        double temperature = this.temperatureMap.getHeight(worldX, worldY);
        float height = tile.getHeight(x, y);
        temperature = temperature - (double)(Math.max(height - (float)this.waterHeight, 0.0f) / 2.0f) + this.randomNoiseMap.getHeight(worldX, worldY);
        double humidity = this.humidityMap.getHeight(worldX, worldY) + this.randomNoiseMap.getHeight(worldX, worldY);
        float slopeNOSO = Math.abs(this.getHeight(worldX, worldY - 1) - this.getHeight(worldX, worldY + 1));
        float slopeNWSE = Math.abs(this.getHeight(worldX + 1, worldY - 1) - this.getHeight(worldX - 1, worldY + 1));
        float slopeEAWE = Math.abs(this.getHeight(worldX + 1, worldY) - this.getHeight(worldX - 1, worldY));
        float slopeSENW = Math.abs(this.getHeight(worldX + 1, worldY + 1) - this.getHeight(worldX - 1, worldY - 1));
        float slope = Math.max(Math.max(slopeNOSO, slopeNWSE), Math.max(slopeEAWE, slopeSENW));
        if (slope > 2.0f) {
            tile.setTerrain(x, y, this.terrainStoneAndGravel);
        } else {
            if (slope > 1.5f) {
                tile.setTerrain(x, y, this.terrainDirtAndGravel);
            } else if (height < (float)(this.waterHeight - 4)) {
                tile.setTerrain(x, y, Terrain.BEACHES);
            } else if (height < (float)(this.waterHeight + 2) && this.isWaterNear(worldX, worldY)) {
                tile.setTerrain(x, y, Terrain.BEACHES);
                if (temperature > 20.0 && humidity > 55.0 && slope < 0.75f && height < (float)this.desertMaxHeight && this.forestMap.getHeight(worldX, worldY) > (double)0.35f) {
                    tile.setLayerValue(Jungle.INSTANCE, x, y, 8);
                }
            } else if (temperature < -5.0) {
                tile.setTerrain(x, y, Terrain.BARE_GRASS);
            } else if (humidity < 40.0) {
                if (slope < 0.75f && height < (float)this.desertMaxHeight) {
                    tile.setTerrain(x, y, Terrain.DESERT);
                } else {
                    tile.setTerrain(x, y, Terrain.SANDSTONE);
                }
            } else {
                tile.setTerrain(x, y, this.baseTerrain);
            }
            if (height > (float)(this.waterHeight - 4) && this.forestMap.getHeight(worldX, worldY) > (double)0.35f) {
                if (temperature > 20.0) {
                    if (humidity > 55.0) {
                        if (height < (float)(this.waterHeight + 2)) {
                            tile.setLayerValue(SwampLand.INSTANCE, x, y, 8);
                        } else {
                            tile.setLayerValue(Jungle.INSTANCE, x, y, 8);
                        }
                    } else if (humidity > 40.0) {
                        tile.setLayerValue(DeciduousForest.INSTANCE, x, y, 8);
                    }
                } else if (temperature > 10.0) {
                    if (humidity > 50.0) {
                        tile.setLayerValue(DeciduousForest.INSTANCE, x, y, 8);
                    }
                } else if (temperature > -20.0 && humidity > 50.0) {
                    tile.setLayerValue(PineForest.INSTANCE, x, y, 8);
                }
            }
        }
        if (temperature < 0.0) {
            tile.setBitLayerValue(Frost.INSTANCE, x, y, true);
            if (temperature < -10.0 && humidity > 50.0 && height > (float)this.waterHeight && slope < 1.5f) {
                tile.setBitLayerValue(this.snowLayer, x, y, true);
            }
        }
    }

    @Override
    public final int getWaterHeight() {
        return this.waterHeight;
    }

    @Override
    public final void setWaterHeight(int waterLevel) {
        this.waterHeight = waterLevel;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public final int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public final void setMinMaxHeight(int minHeight, int maxHeight, HeightTransform transform) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    public final long getSeed() {
        return this.humidityMap.getSeed();
    }

    @Override
    public final void setSeed(long seed) {
        this.humidityMap.setSeed(seed);
        this.temperatureMap.setSeed(seed);
    }

    public final HeightMap getHumidityMap() {
        return this.humidityMap;
    }

    public final void setHumidityMap(HeightMap humidityMap) {
        this.humidityMap = humidityMap;
    }

    public final HeightMap getTemperatureMap() {
        return this.temperatureMap;
    }

    public final void setTemperatureMap(HeightMap temperatureMap) {
        this.temperatureMap = temperatureMap;
    }

    public final HeightMap getHeightMap() {
        return this.heightMap;
    }

    public final void setHeightMap(HeightMap heightMap) {
        this.heightMap = heightMap;
    }

    public final float getRockySlope() {
        return this.rockySlope;
    }

    public final void setRockySlope(float rockySlope) {
        this.rockySlope = rockySlope;
    }

    public final int getDesertMaxHeight() {
        return this.desertMaxHeight;
    }

    public final void setDesertMaxHeight(int desertMaxHeight) {
        this.desertMaxHeight = desertMaxHeight;
    }

    public final HeightMap getForestMap() {
        return this.forestMap;
    }

    public final void setForestMap(HeightMap forestMap) {
        this.forestMap = forestMap;
    }

    public final Terrain getBaseTerrain() {
        return this.baseTerrain;
    }

    public final void setBaseTerrain(Terrain baseTerrain) {
        this.baseTerrain = baseTerrain;
    }

    @Override
    public FancyTheme clone() {
        try {
            FancyTheme clone = (FancyTheme)super.clone();
            clone.forestMap = this.forestMap.clone();
            if (this.heightMap != null) {
                clone.heightMap = this.heightMap.clone();
            }
            clone.humidityMap = this.humidityMap.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected float getHeight(int x, int y) {
        return (float)this.heightMap.getHeight(x, y);
    }

    private boolean isWaterNear(int x, int y) {
        if (this.getHeight(x, y) < (float)this.waterHeight) {
            return true;
        }
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                if (!(this.getHeight(x + dx, y + dy) < (float)this.waterHeight)) continue;
                return true;
            }
        }
        return false;
    }
}

