/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.ramps;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.pepsoft.worldpainter.ramps.ColourGradient;
import org.pepsoft.worldpainter.ramps.ColourRamp;

public class DefaultColourRamp
implements ColourRamp {
    final int waterLevel;
    final NavigableMap<Float, ColourGradient> waterRamp = new TreeMap<Float, ColourGradient>();
    final NavigableMap<Float, ColourGradient> landRamp = new TreeMap<Float, ColourGradient>();

    public DefaultColourRamp(int minHeight, int waterLevel, int maxHeight) {
        this.waterLevel = waterLevel;
        if (minHeight < 0) {
            this.waterRamp.put(Float.valueOf(-3.4028235E38f), new ColourGradient(minHeight, 0, 0.0f, 255));
        }
        if (waterLevel > 0) {
            this.waterRamp.put(Float.valueOf(this.waterRamp.isEmpty() ? -3.4028235E38f : 0.0f), new ColourGradient(0.0f, 255, waterLevel, 65535));
        }
        if (waterLevel < 255) {
            float step = (float)(255 - waterLevel) / 5.0f;
            int colour = 32512;
            for (int i = 0; i < 5; ++i) {
                int nextColour;
                switch (i) {
                    case 0: {
                        nextColour = 65280;
                        break;
                    }
                    case 1: {
                        nextColour = 0xFFFF00;
                        break;
                    }
                    case 2: {
                        nextColour = 0xFF8000;
                        break;
                    }
                    case 3: {
                        nextColour = 0xFF0000;
                        break;
                    }
                    case 4: {
                        nextColour = 0xFFFFFF;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                this.landRamp.put(Float.valueOf(i > 0 ? (float)waterLevel + (float)i * step : -3.4028235E38f), new ColourGradient((float)waterLevel + (float)i * step, colour, i < 4 ? (float)waterLevel + (float)(i + 1) * step : 255.0f, nextColour));
                colour = nextColour;
            }
        }
        if (maxHeight > 256) {
            this.landRamp.put(Float.valueOf(this.landRamp.isEmpty() ? -3.4028235E38f : 255.0f), new ColourGradient(Math.max(255, waterLevel), 0xFFFFFF, maxHeight, 0x8000FF));
        }
    }

    @Override
    public int getColour(float n) {
        if (Math.round(n) < this.waterLevel) {
            return this.waterRamp.floorEntry(Float.valueOf(n)).getValue().getColour(n);
        }
        return this.landRamp.floorEntry(Float.valueOf(n)).getValue().getColour(n);
    }
}

