/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.plugins;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.AbstractProviderManager;
import org.pepsoft.worldpainter.plugins.CustomObjectProvider;

public class CustomObjectManager
extends AbstractProviderManager<String, CustomObjectProvider> {
    private final Map<String, CustomObjectProvider> providersByExtension;
    private static final CustomObjectManager INSTANCE = new CustomObjectManager();

    public CustomObjectManager() {
        super(CustomObjectProvider.class);
        HashMap tmpMap = new HashMap();
        this.getImplementations().forEach(provider -> {
            for (String extension : provider.getSupportedExtensions()) {
                tmpMap.put(extension.trim().toLowerCase(), provider);
            }
        });
        this.providersByExtension = ImmutableMap.copyOf(tmpMap);
    }

    public List<String> getAllSupportedExtensions() {
        return this.getImplementations().stream().flatMap(provider -> provider.getSupportedExtensions().stream()).collect(Collectors.toList());
    }

    public WPObject loadObject(File file) throws IOException {
        String name = file.getName().toLowerCase();
        int p = name.lastIndexOf(46);
        String extension = p != -1 ? name.substring(p + 1).trim() : name.trim();
        CustomObjectProvider provider = this.providersByExtension.get(extension);
        if (provider == null) {
            throw new IllegalArgumentException("Extension " + extension + " not supported");
        }
        return provider.loadObject(file);
    }

    public UniversalFileFilter getFileFilter() {
        List<String> extensions = this.getAllSupportedExtensions();
        final HashSet<String> extensionSet = new HashSet<String>(extensions);
        final String description = "Custom Object Files(" + extensions.stream().map(extension -> "*." + extension).collect(Collectors.joining(", ")) + ")";
        return new UniversalFileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int p = name.lastIndexOf(46);
                String extension = p != -1 ? name.substring(p + 1).toLowerCase() : name.toLowerCase();
                return extensionSet.contains(extension);
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public boolean accept(File dir, String name) {
                int p = name.lastIndexOf(46);
                String extension = p != -1 ? name.substring(p + 1).toLowerCase() : name.toLowerCase();
                return extensionSet.contains(extension);
            }
        };
    }

    public static CustomObjectManager getInstance() {
        return INSTANCE;
    }

    public abstract class UniversalFileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter,
    FilenameFilter {
    }
}

