/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import java.awt.Point;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.jnbt.CompoundTag;
import org.jnbt.IntTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC118AnvilChunk;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.NBTChunk;
import org.pepsoft.worldpainter.platforms.AbstractJavaPlatformProviderImpl;

abstract class AnvilPlatformProvider
extends AbstractJavaPlatformProviderImpl {
    private static final Pattern REGION_FILE_PATTERN = Pattern.compile("r\\.-?\\d+\\.-?\\d+\\.mca");

    AnvilPlatformProvider() {
    }

    @Override
    final NBTChunk createChunk(Map<DataType, Tag> tags, int minHeight, int maxHeight, boolean readOnly) {
        Tag dataVersionTag = ((CompoundTag)tags.get((Object)DataType.REGION)).getTag("DataVersion");
        if (dataVersionTag == null) {
            if (minHeight != 0) {
                throw new IllegalArgumentException("minHeight " + minHeight);
            }
            return new MC12AnvilChunk((CompoundTag)tags.get((Object)DataType.REGION), maxHeight, readOnly);
        }
        int dataVersion = ((IntTag)dataVersionTag).getValue();
        if (dataVersion <= 1343) {
            if (minHeight != 0) {
                throw new IllegalArgumentException("minHeight " + minHeight);
            }
            return new MC12AnvilChunk((CompoundTag)tags.get((Object)DataType.REGION), maxHeight, readOnly);
        }
        if (dataVersion <= 2730) {
            if (minHeight != 0 && !readOnly) {
                throw new IllegalArgumentException("minHeight " + minHeight);
            }
            return new MC115AnvilChunk((CompoundTag)tags.get((Object)DataType.REGION), maxHeight, readOnly);
        }
        return new MC118AnvilChunk(tags, minHeight, maxHeight, readOnly);
    }

    @Override
    final File[] getRegionFiles(File regionDir, DataType dataType) {
        return this.getRegionDir(regionDir.getParentFile(), dataType).listFiles((dir, name) -> REGION_FILE_PATTERN.matcher(name).matches());
    }

    @Override
    final File getRegionFileFile(File regionDir, DataType dataType, Point coords) {
        return new File(this.getRegionDir(regionDir.getParentFile(), dataType), "r." + coords.x + "." + coords.y + ".mca");
    }

    private File getRegionDir(File baseDir, DataType dataType) {
        switch (dataType) {
            case REGION: 
            case ENTITIES: 
            case POI: {
                return new File(baseDir, dataType.name().toLowerCase());
            }
        }
        throw new InternalError();
    }
}

