/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3i;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Dimension;

public interface WPObject
extends Serializable,
Cloneable {
    public static final int COLLISION_MODE_ALL = 1;
    public static final int COLLISION_MODE_SOLID = 2;
    public static final int COLLISION_MODE_NONE = 3;
    public static final int LEAF_DECAY_NO_CHANGE = 1;
    public static final int LEAF_DECAY_ON = 2;
    public static final int LEAF_DECAY_OFF = 3;
    public static final int HEIGHT_MODE_TERRAIN = 1;
    public static final int HEIGHT_MODE_FIXED = 2;
    public static final AttributeKey<File> ATTRIBUTE_FILE = new AttributeKey("WPObject.file");
    public static final AttributeKey<Point3i> ATTRIBUTE_OFFSET = new AttributeKey("WPObject.offset", (Object)new Point3i());
    public static final AttributeKey<Boolean> ATTRIBUTE_RANDOM_ROTATION = new AttributeKey("WPObject.randomRotation", (Object)true);
    public static final AttributeKey<Boolean> ATTRIBUTE_NEEDS_FOUNDATION = new AttributeKey("WPObject.needsFoundation", (Object)true);
    public static final AttributeKey<Boolean> ATTRIBUTE_SPAWN_IN_WATER = new AttributeKey("WPObject.spawnInWater", (Object)false);
    public static final AttributeKey<Boolean> ATTRIBUTE_SPAWN_IN_LAVA = new AttributeKey("WPObject.spawnInLava", (Object)false);
    public static final AttributeKey<Boolean> ATTRIBUTE_SPAWN_ON_LAND = new AttributeKey("WPObject.spawnOnLand", (Object)true);
    public static final AttributeKey<Boolean> ATTRIBUTE_SPAWN_ON_WATER = new AttributeKey("WPObject.spawnOnWater", (Object)false);
    public static final AttributeKey<Boolean> ATTRIBUTE_SPAWN_ON_LAVA = new AttributeKey("WPObject.spawnOnLava", (Object)false);
    public static final AttributeKey<Integer> ATTRIBUTE_FREQUENCY = new AttributeKey("WPObject.frequency", (Object)100);
    public static final AttributeKey<Boolean> ATTRIBUTE_SPAWN_ON_WATER_NO_COLLIDE = new AttributeKey("WPObject.spawnOnWater.noCollide", (Object)false);
    public static final AttributeKey<Integer> ATTRIBUTE_COLLISION_MODE = new AttributeKey("WPObject.collisionMode", (Object)2);
    public static final AttributeKey<Integer> ATTRIBUTE_UNDERGROUND_MODE = new AttributeKey("WPObject.undergroundMode", (Object)1);
    public static final AttributeKey<Integer> ATTRIBUTE_LEAF_DECAY_MODE = new AttributeKey("WPObject.leafDecay", (Object)1);
    @Deprecated
    public static final AttributeKey<int[]> ATTRIBUTE_REPLACE_WITH_AIR = new AttributeKey("WPObject.replaceWithAir");
    public static final AttributeKey<Material> ATTRIBUTE_REPLACE_WITH_AIR_MATERIAL = new AttributeKey("WPObject.replaceWithAirMaterial");
    public static final AttributeKey<Boolean> ATTRIBUTE_EXTEND_FOUNDATION = new AttributeKey("WPObject.extendFoundation", (Object)false);
    public static final AttributeKey<Boolean> ATTRIBUTE_RANDOM_ROTATION_ONLY = new AttributeKey("WPObject.randomRotationOnly", (Object)false);
    public static final AttributeKey<Boolean> ATTRIBUTE_RANDOM_MIRRORING_ONLY = new AttributeKey("WPObject.randomMirroringOnly", (Object)false);
    public static final AttributeKey<Integer> ATTRIBUTE_HEIGHT_MODE = new AttributeKey("WPObject.heightMode", (Object)1);
    public static final AttributeKey<Integer> ATTRIBUTE_VERTICAL_OFFSET = new AttributeKey("WPObject.verticalOffset", (Object)0);
    public static final AttributeKey<Integer> ATTRIBUTE_Y_VARIATION = new AttributeKey("WPObject.yVariation", (Object)0);

    public String getName();

    public void setName(String var1);

    public Point3i getDimensions();

    public Point3i getOffset();

    public Material getMaterial(int var1, int var2, int var3);

    default public Set<Material> getAllMaterials() {
        HashSet<Material> allMaterials = new HashSet<Material>();
        this.visitBlocks((object, x, y, z, material) -> allMaterials.add(material));
        return allMaterials;
    }

    public boolean getMask(int var1, int var2, int var3);

    public List<Entity> getEntities();

    public List<TileEntity> getTileEntities();

    public void prepareForExport(Dimension var1);

    public Map<String, Serializable> getAttributes();

    default public boolean hasAttribute(AttributeKey<?> attributeKey) {
        Map<String, Serializable> attributes = this.getAttributes();
        return attributes != null && attributes.containsKey(attributeKey.key);
    }

    default public <T extends Serializable> T getAttribute(AttributeKey<T> key) {
        return (T)((Serializable)key.get(this.getAttributes()));
    }

    public void setAttributes(Map<String, Serializable> var1);

    public <T extends Serializable> void setAttribute(AttributeKey<T> var1, T var2);

    public WPObject clone();

    default public Point3i guestimateOffset() {
        Point3i dims = this.getDimensions();
        int offsetZ = Integer.MIN_VALUE;
        int lowestX = 0;
        int highestX = 0;
        int lowestY = 0;
        int highestY = 0;
        for (int z = 0; z < dims.z && offsetZ == Integer.MIN_VALUE; ++z) {
            for (int x = 0; x < dims.x; ++x) {
                for (int y = 0; y < dims.y; ++y) {
                    if (!this.getMask(x, y, z)) continue;
                    if (offsetZ == Integer.MIN_VALUE) {
                        offsetZ = z;
                        lowestX = highestX = x;
                        lowestY = highestY = y;
                        continue;
                    }
                    if (x < lowestX) {
                        lowestX = x;
                    } else if (x > highestX) {
                        highestX = x;
                    }
                    if (y < lowestY) {
                        lowestY = y;
                        continue;
                    }
                    if (y <= highestY) continue;
                    highestY = y;
                }
            }
        }
        return offsetZ > Integer.MIN_VALUE ? new Point3i(-(lowestX + highestX) / 2, -(lowestY + highestY) / 2, -offsetZ) : null;
    }

    default public boolean visitBlocks(BlockVisitor visitor) {
        Point3i dim = this.getDimensions();
        for (int z = 0; z < dim.z; ++z) {
            for (int x = 0; x < dim.x; ++x) {
                for (int y = 0; y < dim.y; ++y) {
                    if (!this.getMask(x, y, z) || visitor.visitBlock(this, x, y, z, this.getMaterial(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    default public void dump() {
        Point3i dim = this.getDimensions();
        HashMap<Point3i, List> entities = new HashMap<Point3i, List>();
        if (this.getEntities() != null) {
            for (Entity entity : this.getEntities()) {
                Point3i pos = new Point3i((int)Math.floor(entity.getRelPos()[0]), (int)Math.floor(entity.getRelPos()[2]), (int)Math.floor(entity.getRelPos()[1]));
                entities.computeIfAbsent(pos, k -> new ArrayList()).add(entity);
            }
        }
        for (int z = 0; z < dim.z; ++z) {
            ArrayList<Entity> entitiesEncountered = new ArrayList<Entity>(entities.size());
            System.out.println("X-->");
            for (int y = 0; y < dim.y; ++y) {
                for (int row = 0; row < 4; ++row) {
                    switch (row) {
                        case 0: {
                            int x;
                            for (x = 0; x < dim.x; ++x) {
                                System.out.print("+------");
                            }
                            System.out.print('+');
                            break;
                        }
                        case 1: {
                            int x;
                            for (x = 0; x < dim.x; ++x) {
                                if (this.getMask(x, y, z)) {
                                    System.out.printf("|%6.6s", this.getMaterial((int)x, (int)y, (int)z).simpleName);
                                    continue;
                                }
                                System.out.print("|      ");
                            }
                            System.out.print('|');
                            break;
                        }
                        case 2: {
                            String id;
                            Entity entity;
                            Point3i pos;
                            int x;
                            for (x = 0; x < dim.x; ++x) {
                                pos = new Point3i(x, y, z);
                                if (entities.containsKey(pos)) {
                                    entity = (Entity)((List)entities.get(pos)).get(0);
                                    entitiesEncountered.add(entity);
                                    id = entity.getId();
                                    System.out.printf("|%d:%4.4s", entitiesEncountered.size(), id.substring(id.indexOf(58) + 1));
                                    continue;
                                }
                                System.out.print("|      ");
                            }
                            System.out.print('|');
                            break;
                        }
                        case 3: {
                            String id;
                            Entity entity;
                            Point3i pos;
                            int x;
                            for (x = 0; x < dim.x; ++x) {
                                pos = new Point3i(x, y, z);
                                if (entities.containsKey(pos) && ((List)entities.get(pos)).size() > 1) {
                                    entity = (Entity)((List)entities.get(pos)).get(1);
                                    entitiesEncountered.add(entity);
                                    id = entity.getId();
                                    System.out.printf("|%d:%4.4s", entitiesEncountered.size(), id.substring(id.indexOf(58) + 1));
                                    continue;
                                }
                                System.out.print("|      ");
                            }
                            System.out.print('|');
                        }
                    }
                    if (y * 4 + row == 0) {
                        System.out.print(" Y");
                    } else if (y * 4 + row == 1) {
                        System.out.print(" |");
                    } else if (y * 4 + row == 2) {
                        System.out.print(" v");
                    }
                    System.out.println();
                }
            }
            for (int x = 0; x < dim.x; ++x) {
                System.out.print("+------");
            }
            System.out.println("+ Z: " + z);
            for (int i = 0; i < entitiesEncountered.size(); ++i) {
                Entity entity = (Entity)entitiesEncountered.get(i);
                StringBuilder sb = new StringBuilder();
                sb.append(entity.getId());
                sb.append(", relPos: ");
                sb.append(Arrays.toString(entity.getRelPos()));
                CompoundTag nbt = entity.toNBT();
                if (nbt.containsTag("facing")) {
                    sb.append(", facing: ");
                    sb.append(((ByteTag)nbt.getTag("facing")).getValue());
                }
                if (nbt.containsTag("Facing")) {
                    sb.append(", Facing: ");
                    sb.append(((ByteTag)nbt.getTag("Facing")).getValue());
                }
                System.out.println("*" + (i + 1) + ": " + sb);
            }
            System.out.println();
        }
    }

    @FunctionalInterface
    public static interface BlockVisitor {
        public boolean visitBlock(WPObject var1, int var2, int var3, int var4, Material var5);
    }
}

