/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.objects.AbstractObject;

public abstract class NamedObjectWithAttributes
extends AbstractObject {
    private String name;
    private Map<String, Serializable> attributes;
    private static final long serialVersionUID = 1L;

    protected NamedObjectWithAttributes() {
    }

    protected NamedObjectWithAttributes(String name) {
        this.name = name;
    }

    protected NamedObjectWithAttributes(String name, Map<String, Serializable> attributes) {
        this.name = name;
        this.attributes = attributes != null && !attributes.isEmpty() ? new HashMap<String, Serializable>(attributes) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes != null && !attributes.isEmpty() ? new HashMap<String, Serializable>(attributes) : null;
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        if (value == null ? key.defaultValue == null : value.equals(key.defaultValue)) {
            if (this.attributes != null) {
                this.attributes.remove(key.key);
                if (this.attributes.isEmpty()) {
                    this.attributes = null;
                }
            }
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(key.key, value);
        }
    }
}

